/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.util.IOrientable;
import appeng.block.AEBaseBlock;
import appeng.block.networking.CableBusBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.AEBaseInvBlockEntity;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_47;
import net.minecraft.class_4970;
import net.minecraft.class_5558;

public abstract class AEBaseEntityBlock<T extends AEBaseBlockEntity>
extends AEBaseBlock
implements class_2343 {
    private Class<T> blockEntityClass;
    private class_2591<T> blockEntityType;
    @Nullable
    private class_5558<T> serverTicker;
    @Nullable
    private class_5558<T> clientTicker;

    public AEBaseEntityBlock(class_4970.class_2251 props) {
        super(props);
    }

    public void setBlockEntity(Class<T> blockEntityClass, class_2591<T> blockEntityType, class_5558<T> clientTicker, class_5558<T> serverTicker) {
        this.blockEntityClass = blockEntityClass;
        this.blockEntityType = blockEntityType;
        this.serverTicker = serverTicker;
        this.clientTicker = clientTicker;
        this.setInventory(AEBaseInvBlockEntity.class.isAssignableFrom(blockEntityClass));
    }

    @Nullable
    public T getBlockEntity(class_1922 level, int x, int y, int z) {
        return this.getBlockEntity(level, new class_2338(x, y, z));
    }

    @Nullable
    public T getBlockEntity(class_1922 level, class_2338 pos) {
        class_2586 te = level.method_8321(pos);
        if (this.blockEntityClass != null && this.blockEntityClass.isInstance(te)) {
            return (T)((AEBaseBlockEntity)this.blockEntityClass.cast(te));
        }
        return null;
    }

    public class_2591<T> getBlockEntityType() {
        return this.blockEntityType;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return this.blockEntityType.method_11032(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 blockState, class_2591<T> type) {
        return level.method_8608() ? this.clientTicker : this.serverTicker;
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (newState.method_26204() == state.method_26204()) {
            return;
        }
        T te = this.getBlockEntity((class_1922)level, pos);
        if (te != null) {
            ArrayList<class_1799> drops = new ArrayList<class_1799>();
            ((AEBaseBlockEntity)te).addAdditionalDrops(level, pos, drops);
            Platform.spawnDrops(level, pos, drops);
        }
        super.method_9536(state, level, pos, newState, isMoving);
    }

    @Override
    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        AEBaseInvBlockEntity invBlockEntity;
        T te = this.getBlockEntity((class_1922)level, pos);
        if (te instanceof AEBaseInvBlockEntity && (invBlockEntity = (AEBaseInvBlockEntity)te).getInternalInventory().size() > 0) {
            return invBlockEntity.getInternalInventory().getRedstoneSignal();
        }
        return 0;
    }

    public boolean method_9592(class_2680 state, class_1937 level, class_2338 pos, int eventID, int eventParam) {
        super.method_9592(state, level, pos, eventID, eventParam);
        class_2586 blockEntity = level.method_8321(pos);
        return blockEntity != null ? blockEntity.method_11004(eventID, eventParam) : false;
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, class_1309 placer, class_1799 is) {
        T blockEntity = this.getBlockEntity((class_1922)level, pos);
        if (blockEntity == null) {
            return;
        }
        class_2561 hoverName = is.method_7964();
        if (hoverName instanceof class_2585) {
            class_2585 text = (class_2585)hoverName;
            ((AEBaseBlockEntity)blockEntity).setName(text.method_10993());
        }
        if (is.method_7985()) {
            class_1657 player = null;
            if (placer instanceof class_1657) {
                player = (class_1657)placer;
            }
            ((AEBaseBlockEntity)blockEntity).importSettings(SettingsFrom.DISMANTLE_ITEM, is.method_7969(), player);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 heldItem;
        class_1792 class_17922;
        if (player != null && !player.method_5998(hand).method_7960() && (class_17922 = (heldItem = player.method_5998(hand)).method_7909()) instanceof IMemoryCard) {
            IMemoryCard memoryCard = (IMemoryCard)class_17922;
            if (!(this instanceof CableBusBlock)) {
                T blockEntity = this.getBlockEntity((class_1922)level, pos);
                if (blockEntity == null) {
                    return class_1269.field_5814;
                }
                String name = this.method_9539();
                if (InteractionUtil.isInAlternateUseMode(player)) {
                    class_2487 data = new class_2487();
                    ((AEBaseBlockEntity)blockEntity).exportSettings(SettingsFrom.MEMORY_CARD, data, player);
                    if (!data.method_33133()) {
                        memoryCard.setMemoryCardContents(heldItem, name, data);
                        memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
                    }
                } else {
                    String savedName = memoryCard.getSettingsName(heldItem);
                    class_2487 data = memoryCard.getData(heldItem);
                    if (this.method_9539().equals(savedName)) {
                        ((AEBaseBlockEntity)blockEntity).importSettings(SettingsFrom.MEMORY_CARD, data, player);
                        memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                    } else {
                        memoryCard.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
                    }
                }
                return class_1269.method_29236((boolean)level.method_8608());
            }
        }
        return this.onActivated(level, pos, player, hand, player.method_5998(hand), hit);
    }

    public class_1269 onActivated(class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, @Nullable class_1799 heldItem, class_3965 hit) {
        return class_1269.field_5811;
    }

    @Override
    public IOrientable getOrientable(class_1922 level, class_2338 pos) {
        return this.getBlockEntity(level, pos);
    }

    public final class_2680 getBlockEntityBlockState(class_2680 current, class_2586 te) {
        if (current.method_26204() != this || !this.blockEntityClass.isInstance(te)) {
            return current;
        }
        return this.updateBlockStateFromBlockEntity(current, (AEBaseBlockEntity)this.blockEntityClass.cast(te));
    }

    protected class_2680 updateBlockStateFromBlockEntity(class_2680 currentState, T be) {
        return currentState;
    }

    public List<class_1799> method_9560(class_2680 state, class_47.class_48 builder) {
        List drops = super.method_9560(state, builder);
        for (class_1799 drop : drops) {
            class_1747 blockItem;
            class_1792 class_17922 = drop.method_7909();
            if (!(class_17922 instanceof class_1747) || (blockItem = (class_1747)class_17922).method_7711() != this) continue;
            class_47 lootContext = builder.method_312(class_181.field_1224, (Object)state).method_309(class_173.field_1172);
            class_2586 be = (class_2586)lootContext.method_296(class_181.field_1228);
            if (!(be instanceof AEBaseBlockEntity)) break;
            AEBaseBlockEntity aeBaseBlockEntity = (AEBaseBlockEntity)be;
            class_1297 looter = (class_1297)lootContext.method_296(class_181.field_1226);
            class_1657 player = null;
            if (looter instanceof class_1657) {
                player = (class_1657)looter;
            }
            if (drop.method_7985()) {
                aeBaseBlockEntity.exportSettings(SettingsFrom.DISMANTLE_ITEM, drop.method_7969(), player);
                break;
            }
            class_2487 tag = new class_2487();
            aeBaseBlockEntity.exportSettings(SettingsFrom.DISMANTLE_ITEM, tag, player);
            if (tag.method_33133()) break;
            drop.method_7980(tag);
            break;
        }
        return drops;
    }
}

