/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.crafting;

import appeng.block.crafting.AbstractCraftingUnitBlock;
import appeng.client.render.BasicUnbakedModel;
import appeng.client.render.crafting.LightBakedModel;
import appeng.client.render.crafting.MonitorBakedModel;
import appeng.client.render.crafting.UnitBakedModel;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import org.jetbrains.annotations.Nullable;

public class CraftingCubeModel
implements BasicUnbakedModel {
    private static final class_4730 RING_CORNER = CraftingCubeModel.texture("ring_corner");
    private static final class_4730 RING_SIDE_HOR = CraftingCubeModel.texture("ring_side_hor");
    private static final class_4730 RING_SIDE_VER = CraftingCubeModel.texture("ring_side_ver");
    private static final class_4730 UNIT_BASE = CraftingCubeModel.texture("unit_base");
    private static final class_4730 LIGHT_BASE = CraftingCubeModel.texture("light_base");
    private static final class_4730 ACCELERATOR_LIGHT = CraftingCubeModel.texture("accelerator_light");
    private static final class_4730 STORAGE_1K_LIGHT = CraftingCubeModel.texture("1k_storage_light");
    private static final class_4730 STORAGE_4K_LIGHT = CraftingCubeModel.texture("4k_storage_light");
    private static final class_4730 STORAGE_16K_LIGHT = CraftingCubeModel.texture("16k_storage_light");
    private static final class_4730 STORAGE_64K_LIGHT = CraftingCubeModel.texture("64k_storage_light");
    private static final class_4730 MONITOR_BASE = CraftingCubeModel.texture("monitor_base");
    private static final class_4730 MONITOR_LIGHT_DARK = CraftingCubeModel.texture("monitor_light_dark");
    private static final class_4730 MONITOR_LIGHT_MEDIUM = CraftingCubeModel.texture("monitor_light_medium");
    private static final class_4730 MONITOR_LIGHT_BRIGHT = CraftingCubeModel.texture("monitor_light_bright");
    private final AbstractCraftingUnitBlock.CraftingUnitType type;

    public CraftingCubeModel(AbstractCraftingUnitBlock.CraftingUnitType type) {
        this.type = type;
    }

    @Override
    public Stream<class_4730> getAdditionalTextures() {
        return Stream.of(RING_CORNER, RING_SIDE_HOR, RING_SIDE_VER, UNIT_BASE, LIGHT_BASE, ACCELERATOR_LIGHT, STORAGE_1K_LIGHT, STORAGE_4K_LIGHT, STORAGE_16K_LIGHT, STORAGE_64K_LIGHT, MONITOR_BASE, MONITOR_LIGHT_DARK, MONITOR_LIGHT_MEDIUM, MONITOR_LIGHT_BRIGHT);
    }

    @Nullable
    public class_1087 method_4753(class_1088 loader, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, class_2960 modelId) {
        class_1058 ringCorner = spriteGetter.apply(RING_CORNER);
        class_1058 ringSideHor = spriteGetter.apply(RING_SIDE_HOR);
        class_1058 ringSideVer = spriteGetter.apply(RING_SIDE_VER);
        return switch (this.type) {
            case AbstractCraftingUnitBlock.CraftingUnitType.UNIT -> new UnitBakedModel(ringCorner, ringSideHor, ringSideVer, spriteGetter.apply(UNIT_BASE));
            case AbstractCraftingUnitBlock.CraftingUnitType.ACCELERATOR, AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_1K, AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_4K, AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_16K, AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_64K -> new LightBakedModel(ringCorner, ringSideHor, ringSideVer, spriteGetter.apply(LIGHT_BASE), CraftingCubeModel.getLightTexture(spriteGetter, this.type));
            case AbstractCraftingUnitBlock.CraftingUnitType.MONITOR -> new MonitorBakedModel(ringCorner, ringSideHor, ringSideVer, spriteGetter.apply(UNIT_BASE), spriteGetter.apply(MONITOR_BASE), spriteGetter.apply(MONITOR_LIGHT_DARK), spriteGetter.apply(MONITOR_LIGHT_MEDIUM), spriteGetter.apply(MONITOR_LIGHT_BRIGHT));
            default -> throw new IllegalArgumentException("Unsupported crafting unit type: " + this.type);
        };
    }

    private static class_1058 getLightTexture(Function<class_4730, class_1058> textureGetter, AbstractCraftingUnitBlock.CraftingUnitType type) {
        return switch (type) {
            case AbstractCraftingUnitBlock.CraftingUnitType.ACCELERATOR -> textureGetter.apply(ACCELERATOR_LIGHT);
            case AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_1K -> textureGetter.apply(STORAGE_1K_LIGHT);
            case AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_4K -> textureGetter.apply(STORAGE_4K_LIGHT);
            case AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_16K -> textureGetter.apply(STORAGE_16K_LIGHT);
            case AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_64K -> textureGetter.apply(STORAGE_64K_LIGHT);
            default -> throw new IllegalArgumentException("Crafting unit type " + type + " does not use a light texture.");
        };
    }

    private static class_4730 texture(String name) {
        return new class_4730(class_1059.field_5275, new class_2960("ae2", "block/crafting/" + name));
    }
}

