/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.stacks.GenericStack;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

final class AEPatternHelper {
    private static final Comparator<GenericStack> COMPARE_BY_STACKSIZE = (left, right) -> Long.compare(right.amount(), left.amount());

    private AEPatternHelper() {
    }

    public static GenericStack[] condenseStacks(GenericStack[] sparseInput) {
        ImmutableList merged = (ImmutableList)Arrays.stream(sparseInput).filter(Objects::nonNull).collect(Collectors.toMap(GenericStack::what, Function.identity(), GenericStack::sum)).values().stream().sorted(COMPARE_BY_STACKSIZE).collect(ImmutableList.toImmutableList());
        if (merged.isEmpty()) {
            throw new IllegalStateException("No pattern here!");
        }
        return (GenericStack[])merged.toArray((Object[])new GenericStack[0]);
    }
}

