/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.config.CondenserOutput;
import appeng.api.integrations.rei.IngredientConverter;
import appeng.api.integrations.rei.IngredientConverters;
import appeng.api.stacks.GenericStack;
import appeng.api.util.AEColor;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.implementations.InscriberScreen;
import appeng.core.AEConfig;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.ItemDefinition;
import appeng.core.localization.GuiText;
import appeng.integration.abstraction.REIFacade;
import appeng.integration.modules.jei.CondenserCategory;
import appeng.integration.modules.jei.CondenserOutputDisplay;
import appeng.integration.modules.jei.FacadeRecipeCategory;
import appeng.integration.modules.jei.FacadeRegistryGenerator;
import appeng.integration.modules.jei.FluidIngredientConverter;
import appeng.integration.modules.jei.GhostIngredientHandler;
import appeng.integration.modules.jei.InscriberRecipeCategory;
import appeng.integration.modules.jei.InscriberRecipeWrapper;
import appeng.integration.modules.jei.ItemIngredientConverter;
import appeng.integration.modules.jei.ReiRuntimeAdapter;
import appeng.integration.modules.jei.throwinginwater.ThrowingInWaterCategory;
import appeng.integration.modules.jei.throwinginwater.ThrowingInWaterDisplay;
import appeng.integration.modules.jei.transfer.EncodePatternTransferHandler;
import appeng.integration.modules.jei.transfer.UseCraftingRecipeTransfer;
import appeng.menu.me.items.CraftingTermMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.recipes.handlers.InscriberRecipe;
import com.google.common.collect.ImmutableList;
import dev.architectury.event.CompoundEventResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.ButtonArea;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.DynamicDisplayGenerator;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.DefaultInformationDisplay;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_768;

public class ReiPlugin
implements REIClientPlugin {
    private List<Predicate<class_1799>> developerItems;
    private List<Predicate<class_1799>> coloredCables;

    public ReiPlugin() {
        IngredientConverters.register(new ItemIngredientConverter());
        IngredientConverters.register(new FluidIngredientConverter());
        REIFacade.setInstance(new ReiRuntimeAdapter());
    }

    public String getPluginProviderName() {
        return "AE2";
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new ThrowingInWaterCategory());
        registry.add((DisplayCategory)new CondenserCategory());
        registry.add((DisplayCategory)new InscriberRecipeCategory());
        registry.add((DisplayCategory)new FacadeRecipeCategory());
        registry.removePlusButton(ThrowingInWaterCategory.ID);
        registry.removePlusButton(InscriberRecipeCategory.ID);
        registry.removePlusButton(CondenserCategory.ID);
        this.registerWorkingStations(registry);
    }

    public void registerDisplays(DisplayRegistry registry) {
        registry.registerRecipeFiller(InscriberRecipe.class, InscriberRecipe.TYPE, InscriberRecipeWrapper::new);
        registry.add((Display)new CondenserOutputDisplay(CondenserOutput.MATTER_BALLS));
        registry.add((Display)new CondenserOutputDisplay(CondenserOutput.SINGULARITY));
        this.registerDescriptions(registry);
        registry.registerGlobalDisplayGenerator((DynamicDisplayGenerator)new FacadeRegistryGenerator());
        if (AEConfig.instance().isInWorldCrystalGrowthEnabled()) {
            registry.add((Display)new ThrowingInWaterDisplay(List.of(class_1856.method_8091((class_1935[])new class_1935[]{AEItems.CERTUS_CRYSTAL_SEED})), AEItems.CERTUS_QUARTZ_CRYSTAL.stack(), true));
            registry.add((Display)new ThrowingInWaterDisplay(List.of(class_1856.method_8091((class_1935[])new class_1935[]{AEItems.FLUIX_CRYSTAL_SEED})), AEItems.FLUIX_CRYSTAL.stack(), true));
        }
        if (AEConfig.instance().isInWorldFluixEnabled()) {
            registry.add((Display)new ThrowingInWaterDisplay(List.of(class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8725}), class_1856.method_8091((class_1935[])new class_1935[]{AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED}), class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8155})), AEItems.FLUIX_DUST.stack(2), false));
        }
    }

    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register(new EncodePatternTransferHandler<PatternEncodingTermMenu>(PatternEncodingTermMenu.class));
        registry.register(new UseCraftingRecipeTransfer<CraftingTermMenu>(CraftingTermMenu.class));
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerDraggableStackVisitor((DraggableStackVisitor)new GhostIngredientHandler());
        registry.registerFocusedStack((screen, mouse) -> {
            AEBaseScreen aeScreen;
            GenericStack stack;
            if (screen instanceof AEBaseScreen && (stack = (aeScreen = (AEBaseScreen)screen).getStackUnderMouse(mouse.x, mouse.y)) != null) {
                for (IngredientConverter<?> converter : IngredientConverters.getConverters()) {
                    EntryStack<?> entryStack = converter.getIngredientFromStack(stack);
                    if (entryStack == null) continue;
                    return CompoundEventResult.interruptTrue(entryStack);
                }
            }
            return CompoundEventResult.pass();
        });
        registry.registerContainerClickArea(new Rectangle(82, 39, 26, 16), InscriberScreen.class, new CategoryIdentifier[]{InscriberRecipeCategory.ID});
    }

    public void registerEntries(EntryRegistry registry) {
        this.developerItems = ImmutableList.of(AEBlocks.DEBUG_CUBE_GEN::isSameAs, AEBlocks.DEBUG_CHUNK_LOADER::isSameAs, AEBlocks.DEBUG_ENERGY_GEN::isSameAs, AEBlocks.DEBUG_ITEM_GEN::isSameAs, AEBlocks.DEBUG_PHANTOM_NODE::isSameAs, AEItems.DEBUG_CARD::isSameAs, AEItems.DEBUG_ERASER::isSameAs, AEItems.DEBUG_METEORITE_PLACER::isSameAs, AEItems.DEBUG_REPLICATOR_CARD::isSameAs);
        ArrayList<Predicate<class_1799>> predicates = new ArrayList<Predicate<class_1799>>();
        for (AEColor color : AEColor.values()) {
            if (color == AEColor.TRANSPARENT) continue;
            predicates.add(stack -> stack.method_7909() == AEParts.COVERED_CABLE.item(color));
            predicates.add(stack -> stack.method_7909() == AEParts.COVERED_DENSE_CABLE.item(color));
            predicates.add(stack -> stack.method_7909() == AEParts.GLASS_CABLE.item(color));
            predicates.add(stack -> stack.method_7909() == AEParts.SMART_CABLE.item(color));
            predicates.add(stack -> stack.method_7909() == AEParts.SMART_DENSE_CABLE.item(color));
        }
        this.coloredCables = ImmutableList.copyOf(predicates);
        registry.removeEntryIf(this::shouldEntryBeHidden);
    }

    public void registerExclusionZones(ExclusionZones zones) {
        zones.register(AEBaseScreen.class, screen -> screen != null ? ReiPlugin.mapRects(screen.getExclusionZones()) : Collections.emptyList());
    }

    private static List<Rectangle> mapRects(List<class_768> exclusionZones) {
        return exclusionZones.stream().map(ez -> new Rectangle(ez.method_3321(), ez.method_3322(), ez.method_3319(), ez.method_3320())).collect(Collectors.toList());
    }

    private void registerWorkingStations(CategoryRegistry registry) {
        class_1799 condenser = AEBlocks.CONDENSER.stack();
        registry.addWorkstations(CondenserCategory.ID, new EntryStack[]{EntryStacks.of((class_1799)condenser)});
        class_1799 inscriber = AEBlocks.INSCRIBER.stack();
        registry.addWorkstations(InscriberRecipeCategory.ID, new EntryStack[]{EntryStacks.of((class_1799)inscriber)});
        registry.setPlusButtonArea(InscriberRecipeCategory.ID, ButtonArea.defaultArea());
        class_1799 craftingTerminal = AEParts.CRAFTING_TERMINAL.stack();
        registry.addWorkstations(BuiltinPlugin.CRAFTING, new EntryStack[]{EntryStacks.of((class_1799)craftingTerminal)});
        class_1799 wirelessCraftingTerminal = AEItems.WIRELESS_CRAFTING_TERMINAL.stack();
        registry.addWorkstations(BuiltinPlugin.CRAFTING, new EntryStack[]{EntryStacks.of((class_1799)wirelessCraftingTerminal)});
    }

    private void registerDescriptions(DisplayRegistry registry) {
        if (AEConfig.instance().isGenerateQuartzOre()) {
            ReiPlugin.addDescription(registry, AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED, GuiText.ChargedQuartz.getTranslationKey());
        }
        if (AEConfig.instance().isSpawnPressesInMeteoritesEnabled()) {
            ReiPlugin.addDescription(registry, AEItems.LOGIC_PROCESSOR_PRESS, GuiText.inWorldCraftingPresses.getTranslationKey());
            ReiPlugin.addDescription(registry, AEItems.CALCULATION_PROCESSOR_PRESS, GuiText.inWorldCraftingPresses.getTranslationKey());
            ReiPlugin.addDescription(registry, AEItems.ENGINEERING_PROCESSOR_PRESS, GuiText.inWorldCraftingPresses.getTranslationKey());
            ReiPlugin.addDescription(registry, AEItems.SILICON_PRESS, GuiText.inWorldCraftingPresses.getTranslationKey());
        }
        if (AEConfig.instance().isInWorldSingularityEnabled()) {
            ReiPlugin.addDescription(registry, AEItems.QUANTUM_ENTANGLED_SINGULARITY, GuiText.inWorldSingularity.getTranslationKey());
        }
    }

    private static void addDescription(DisplayRegistry registry, ItemDefinition<?> itemDefinition, String ... message) {
        DefaultInformationDisplay info = DefaultInformationDisplay.createFromEntry((EntryStack)EntryStacks.of(itemDefinition), (class_2561)itemDefinition.method_8389().method_7848());
        info.lines((Collection)Arrays.stream(message).map(class_2588::new).collect(Collectors.toList()));
        registry.add((Display)info);
    }

    private boolean shouldEntryBeHidden(EntryStack<?> entryStack) {
        if (entryStack.getType() != VanillaEntryTypes.ITEM) {
            return false;
        }
        class_1799 stack = (class_1799)entryStack.castValue();
        if (AEItems.WRAPPED_GENERIC_STACK.isSameAs(stack) || AEItems.FACADE.isSameAs(stack) || AEBlocks.CABLE_BUS.isSameAs(stack) || AEBlocks.MATRIX_FRAME.isSameAs(stack) || AEBlocks.PAINT.isSameAs(stack)) {
            return true;
        }
        if (!AEConfig.instance().isDebugToolsEnabled()) {
            for (Predicate<class_1799> developerItem : this.developerItems) {
                if (!developerItem.test(stack)) continue;
                return true;
            }
        }
        if (AEConfig.instance().isDisableColoredCableRecipesInJEI()) {
            for (Predicate<class_1799> predicate : this.coloredCables) {
                if (!predicate.test(stack)) continue;
                return true;
            }
        }
        return false;
    }
}

