/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei.transfer;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.menu.AEBaseMenu;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.MEStorageMenu;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTransferHandler<T extends AEBaseMenu>
implements TransferHandler {
    protected static final int CRAFTING_GRID_WIDTH = 3;
    protected static final int CRAFTING_GRID_HEIGHT = 3;
    private static final CategoryIdentifier<?> CRAFTING = CategoryIdentifier.of((String)"minecraft", (String)"plugins/crafting");
    private final Class<T> containerClass;

    AbstractTransferHandler(Class<T> containerClass) {
        this.containerClass = containerClass;
    }

    protected abstract TransferHandler.Result transferRecipe(T var1, @Nullable class_1860<?> var2, Display var3, boolean var4);

    public final TransferHandler.Result handle(TransferHandler.Context context) {
        if (!this.containerClass.isInstance(context.getMenu())) {
            return TransferHandler.Result.createNotApplicable();
        }
        Display display = context.getDisplay();
        AEBaseMenu menu = (AEBaseMenu)((Object)this.containerClass.cast(context.getMenu()));
        class_1860<?> recipe = this.getRecipe(display);
        return this.transferRecipe(menu, recipe, display, context.isActuallyCrafting());
    }

    @Nullable
    private class_1860<?> getRecipe(Display display) {
        class_1860 recipe;
        Object origin = DisplayRegistry.getInstance().getDisplayOrigin(display);
        return origin instanceof class_1860 ? (recipe = (class_1860)origin) : null;
    }

    protected final boolean isCraftingRecipe(class_1860<?> recipe, Display display) {
        return recipe != null && recipe.method_17716() == class_3956.field_17545 || display.getCategoryIdentifier().equals(CRAFTING);
    }

    protected final boolean fitsIn3x3Grid(class_1860<?> recipe, Display display) {
        if (recipe != null) {
            return recipe.method_8113(3, 3);
        }
        if (display instanceof SimpleGridMenuDisplay) {
            SimpleGridMenuDisplay gridDisplay = (SimpleGridMenuDisplay)display;
            return gridDisplay.getWidth() <= 3 && gridDisplay.getHeight() <= 3;
        }
        return true;
    }

    protected final Map<AEKey, Integer> getIngredientPriorities(MEStorageMenu menu, Comparator<GridInventoryEntry> comparator) {
        List<AEKey> orderedEntries = menu.getClientRepo().getAllEntries().stream().sorted(comparator).map(GridInventoryEntry::getWhat).toList();
        HashMap<AEKey, Integer> result = new HashMap<AEKey, Integer>(orderedEntries.size());
        for (int i = 0; i < orderedEntries.size(); ++i) {
            result.put(orderedEntries.get(i), i);
        }
        for (class_1799 item : menu.getPlayerInventory().field_7547) {
            AEItemKey key = AEItemKey.of(item);
            if (key == null) continue;
            result.putIfAbsent(key, -1);
        }
        return result;
    }
}

