/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.tile;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.SelectedPart;
import appeng.block.networking.CableBusBlock;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.integration.modules.waila.part.ChannelDataProvider;
import appeng.integration.modules.waila.part.GridNodeStateProvider;
import appeng.integration.modules.waila.part.IPartDataProvider;
import appeng.integration.modules.waila.part.P2PStateDataProvider;
import appeng.integration.modules.waila.part.StorageMonitorDataProvider;
import appeng.integration.modules.waila.tile.DebugDataProvider;
import appeng.util.Platform;
import java.util.List;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.TooltipPosition;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public final class CableBusDataProvider {
    private static final List<IPartDataProvider> PROVIDERS = List.of(new ChannelDataProvider(), new StorageMonitorDataProvider(), new GridNodeStateProvider(), new P2PStateDataProvider(), new DebugDataProvider());

    private CableBusDataProvider() {
    }

    public static void register(IRegistrar registrar) {
        registrar.addDisplayItem((IBlockComponentProvider)new IconProvider(), CableBusBlock.class);
        registrar.registerComponentProvider((IComponentProvider)new NameProvider(), TooltipPosition.HEAD, CableBusBlock.class);
        registrar.registerComponentProvider((IComponentProvider)new TooltipAdapter(), TooltipPosition.BODY, CableBusBlock.class);
        registrar.registerBlockDataProvider((IServerDataProvider)new ServerDataAdapter(), CableBusBlockEntity.class);
    }

    private static String getPartDataName(@Nullable class_2350 location) {
        return "cableBusPart" + (location == null ? "center" : location.name());
    }

    private static SelectedPart getPart(class_2586 blockEntity, class_239 hitResult) {
        if (blockEntity instanceof IPartHost) {
            IPartHost host = (IPartHost)blockEntity;
            return host.selectPartWorld(hitResult.method_17784());
        }
        return new SelectedPart();
    }

    private static class IconProvider
    implements IComponentProvider {
        private IconProvider() {
        }

        public class_1799 getDisplayItem(IBlockAccessor accessor, IPluginConfig config) {
            class_2586 blockEntity = accessor.getBlockEntity();
            class_239 hitResult = accessor.getHitResult();
            SelectedPart selected = CableBusDataProvider.getPart(blockEntity, hitResult);
            if (selected.facade != null) {
                return selected.facade.getItemStack();
            }
            if (selected.part != null) {
                IPartItem<?> item = selected.part.getPartItem();
                return new class_1799(item);
            }
            return class_1799.field_8037;
        }
    }

    private static class NameProvider
    implements IComponentProvider {
        private NameProvider() {
        }

        public void appendHead(List<class_2561> tooltip, IBlockAccessor accessor, IPluginConfig config) {
            class_2586 blockEntity = accessor.getBlockEntity();
            class_239 hitResult = accessor.getHitResult();
            SelectedPart selected = CableBusDataProvider.getPart(blockEntity, hitResult);
            class_2561 name = null;
            if (selected.facade != null) {
                name = selected.facade.getItemStack().method_7964();
            } else if (selected.part != null) {
                name = selected.part.getPartItem().method_8389().method_7848();
            }
            if (name != null) {
                tooltip.clear();
                tooltip.add((class_2561)name.method_27661().method_27694(style -> {
                    if (style.method_10973() == null) {
                        return style.method_10977(class_124.field_1068);
                    }
                    return style;
                }));
            }
        }
    }

    private static class TooltipAdapter
    implements IComponentProvider {
        private TooltipAdapter() {
        }

        public void appendBody(List<class_2561> tooltip, IBlockAccessor accessor, IPluginConfig config) {
            SelectedPart selected = CableBusDataProvider.getPart(accessor.getBlockEntity(), accessor.getHitResult());
            if (selected.part != null) {
                class_2487 partTag = accessor.getServerData().method_10562(CableBusDataProvider.getPartDataName(selected.side));
                for (IPartDataProvider provider : PROVIDERS) {
                    provider.appendBody(selected.part, partTag, tooltip);
                }
            }
        }
    }

    private static class ServerDataAdapter
    implements IServerDataProvider<class_2586> {
        private ServerDataAdapter() {
        }

        public void appendServerData(class_2487 serverData, class_3222 serverPlayer, class_1937 level, class_2586 blockEntity) {
            if (!(blockEntity instanceof CableBusBlockEntity)) {
                return;
            }
            CableBusBlockEntity cableBus = (CableBusBlockEntity)blockEntity;
            class_2487 partTag = new class_2487();
            for (class_2350 location : Platform.DIRECTIONS_WITH_NULL) {
                IPart part = cableBus.getPart(location);
                if (part == null) continue;
                for (IPartDataProvider provider : PROVIDERS) {
                    provider.appendServerData(serverPlayer, part, partTag);
                }
                if (partTag.method_33133()) continue;
                serverData.method_10566(CableBusDataProvider.getPartDataName(location), (class_2520)partTag);
                partTag = new class_2487();
            }
        }
    }
}

