/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.tile;

import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.parts.IPart;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.core.definitions.AEItems;
import appeng.integration.modules.waila.BaseDataProvider;
import appeng.integration.modules.waila.part.IPartDataProvider;
import appeng.me.InWorldGridNode;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.me.service.TickManagerService;
import appeng.parts.AEBasePart;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class DebugDataProvider
extends BaseDataProvider
implements IPartDataProvider {
    private static final String TAG_MAIN_NODE = "debugMainNode";
    private static final String TAG_EXTERNAL_NODE = "debugExposedNode";
    private static final String TAG_TICK_TIME = "tickTime";
    private static final String TAG_TICK_SLEEPING = "tickSleeping";
    private static final String TAG_TICK_ALERTABLE = "tickAlertable";
    private static final String TAG_TICK_AWAKE = "tickAwake";
    private static final String TAG_TICK_QUEUED = "tickQueued";
    private static final String TAG_TICK_CURRENT_RATE = "tickCurrentRate";
    private static final String TAG_TICK_LAST_TICK = "tickLastTick";
    private static final String TAG_NODE_EXPOSED = "exposedSides";

    @Override
    public void appendBody(IPart part, class_2487 partTag, List<class_2561> tooltip) {
        DebugDataProvider.addToTooltip(partTag, tooltip);
    }

    @Override
    public void appendBody(List<class_2561> tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (!DebugDataProvider.isVisible(accessor.getPlayer())) {
            return;
        }
        DebugDataProvider.addBlockEntityRotation(tooltip, accessor);
        DebugDataProvider.addToTooltip(accessor.getServerData(), tooltip);
    }

    private static void addBlockEntityRotation(List<class_2561> tooltip, IBlockAccessor accessor) {
        AEBaseBlockEntity be;
        class_2586 class_25862 = accessor.getBlockEntity();
        if (class_25862 instanceof AEBaseBlockEntity && (be = (AEBaseBlockEntity)class_25862).canBeRotated()) {
            class_2350 up = be.getUp();
            class_2350 forward = be.getForward();
            tooltip.add((class_2561)new class_2585("").method_10852((class_2561)new class_2585("Up: ").method_27692(class_124.field_1068)).method_10852((class_2561)new class_2585(up.name())).method_10852((class_2561)new class_2585(" Forward: ").method_27692(class_124.field_1068)).method_10852((class_2561)new class_2585(forward.name())));
        }
    }

    private static void addToTooltip(class_2487 serverData, List<class_2561> tooltip) {
        boolean hasMainNode = serverData.method_10573(TAG_MAIN_NODE, 10);
        boolean hasExternalNode = serverData.method_10573(TAG_EXTERNAL_NODE, 10);
        if (hasMainNode) {
            if (hasExternalNode) {
                tooltip.add((class_2561)new class_2585("Main Node").method_27692(class_124.field_1056));
            }
            DebugDataProvider.addNodeToTooltip(serverData.method_10562(TAG_MAIN_NODE), tooltip);
        }
        if (hasExternalNode) {
            if (hasMainNode) {
                tooltip.add((class_2561)new class_2585("External Node").method_27692(class_124.field_1056));
            }
            DebugDataProvider.addNodeToTooltip(serverData.method_10562(TAG_EXTERNAL_NODE), tooltip);
        }
    }

    private static void addNodeToTooltip(class_2487 tag, List<class_2561> tooltip) {
        long[] tickTimes;
        if (tag.method_10573(TAG_TICK_TIME, 12) && (tickTimes = tag.method_10565(TAG_TICK_TIME)).length == 3) {
            long avg = tickTimes[0];
            long max = tickTimes[1];
            long sum = tickTimes[2];
            tooltip.add((class_2561)new class_2585("").method_10852((class_2561)new class_2585("Tick Time: ").method_27692(class_124.field_1068)).method_10852((class_2561)new class_2585("Avg: ").method_27692(class_124.field_1056)).method_10852((class_2561)new class_2585(Platform.formatTimeMeasurement(avg)).method_27692(class_124.field_1068)).method_10852((class_2561)new class_2585(" Max: ").method_27692(class_124.field_1056)).method_10852((class_2561)new class_2585(Platform.formatTimeMeasurement(max)).method_27692(class_124.field_1068)).method_10852((class_2561)new class_2585(" Sum: ").method_27692(class_124.field_1056)).method_10852((class_2561)new class_2585(Platform.formatTimeMeasurement(sum)).method_27692(class_124.field_1068)));
        }
        if (tag.method_10545(TAG_TICK_QUEUED)) {
            ArrayList<String> status = new ArrayList<String>();
            if (tag.method_10577(TAG_TICK_SLEEPING)) {
                status.add("Sleeping");
            }
            if (tag.method_10577(TAG_TICK_ALERTABLE)) {
                status.add("Alertable");
            }
            if (tag.method_10577(TAG_TICK_AWAKE)) {
                status.add("Awake");
            }
            if (tag.method_10577(TAG_TICK_QUEUED)) {
                status.add("Queued");
            }
            tooltip.add((class_2561)new class_2585("").method_10852((class_2561)new class_2585("Tick Status: ").method_27692(class_124.field_1068)).method_27693(String.join((CharSequence)", ", status)));
            tooltip.add((class_2561)new class_2585("").method_10852((class_2561)new class_2585("Tick Rate: ").method_27692(class_124.field_1068)).method_27693(String.valueOf(tag.method_10550(TAG_TICK_CURRENT_RATE))).method_10852((class_2561)new class_2585(" Last: ").method_27692(class_124.field_1068)).method_27693(tag.method_10550(TAG_TICK_LAST_TICK) + " ticks ago"));
        }
        if (tag.method_10573(TAG_NODE_EXPOSED, 3)) {
            int exposedSides = tag.method_10550(TAG_NODE_EXPOSED);
            class_5250 line = new class_2585("Node Exposed: ").method_27692(class_124.field_1068);
            for (class_2350 value : class_2350.values()) {
                class_2585 sideText = new class_2585(value.name().substring(0, 1));
                if ((exposedSides & 1 << value.ordinal()) == 0) {
                    sideText.method_27692(class_124.field_1080);
                } else {
                    sideText.method_27692(class_124.field_1060);
                }
                line.method_10852((class_2561)sideText);
            }
            tooltip.add((class_2561)line);
        }
    }

    @Override
    public void appendServerData(class_3222 player, IPart part, class_2487 partTag) {
        if (DebugDataProvider.isVisible((class_1657)player) && part instanceof AEBasePart) {
            AEBasePart basePart = (AEBasePart)part;
            DebugDataProvider.addServerDataMainNode(partTag, basePart.getMainNode());
            class_2487 externalNodeTag = DebugDataProvider.toServerData(basePart.getExternalFacingNode());
            if (externalNodeTag != null) {
                partTag.method_10566(TAG_EXTERNAL_NODE, (class_2520)externalNodeTag);
            }
        }
    }

    @Override
    public void appendServerData(class_2487 tag, class_3222 player, class_1937 level, class_2586 blockEntity) {
        if (DebugDataProvider.isVisible((class_1657)player) && blockEntity instanceof IGridConnectedBlockEntity) {
            IGridConnectedBlockEntity gridConnected = (IGridConnectedBlockEntity)blockEntity;
            DebugDataProvider.addServerDataMainNode(tag, gridConnected.getMainNode());
        }
    }

    private static void addServerDataMainNode(class_2487 tag, IManagedGridNode managedGridNode) {
        class_2487 nodeTag;
        IGridNode node = managedGridNode.getNode();
        if (node != null && (nodeTag = DebugDataProvider.toServerData(managedGridNode.getNode())) != null) {
            tag.method_10566(TAG_MAIN_NODE, (class_2520)nodeTag);
        }
    }

    private static class_2487 toServerData(IGridNode node) {
        if (node == null) {
            return null;
        }
        class_2487 tag = new class_2487();
        if (node.getService(IGridTickable.class) != null) {
            TickManagerService tickManager = (TickManagerService)node.getGrid().getTickManager();
            long avg = tickManager.getAverageTime(node);
            long max = tickManager.getMaximumTime(node);
            long sum = tickManager.getOverallTime(node);
            tag.method_10564(TAG_TICK_TIME, new long[]{avg, max, sum});
            TickManagerService.NodeStatus status = tickManager.getStatus(node);
            tag.method_10556(TAG_TICK_SLEEPING, status.sleeping());
            tag.method_10556(TAG_TICK_ALERTABLE, status.alertable());
            tag.method_10556(TAG_TICK_AWAKE, status.awake());
            tag.method_10556(TAG_TICK_QUEUED, status.queued());
            tag.method_10569(TAG_TICK_CURRENT_RATE, status.currentRate());
            tag.method_10544(TAG_TICK_LAST_TICK, status.lastTick());
        }
        if (node instanceof InWorldGridNode) {
            int exposedSides = 0;
            for (class_2350 value : class_2350.values()) {
                if (!node.isExposedOnSide(value)) continue;
                exposedSides |= 1 << value.ordinal();
            }
            tag.method_10569(TAG_NODE_EXPOSED, exposedSides);
        }
        return tag;
    }

    private static boolean isVisible(class_1657 player) {
        return AEItems.DEBUG_CARD.isSameAs(player.method_5998(class_1268.field_5810)) || AEItems.DEBUG_CARD.isSameAs(player.method_5998(class_1268.field_5808));
    }
}

