/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.crafting;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.storage.ISubMenuHost;
import appeng.api.storage.ITerminalHost;
import appeng.core.AELog;
import appeng.core.sync.packets.CraftConfirmPlanPacket;
import appeng.me.helpers.PlayerSource;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.me.crafting.CraftAmountMenu;
import appeng.menu.me.crafting.CraftingCPUCycler;
import appeng.menu.me.crafting.CraftingCPURecord;
import appeng.menu.me.crafting.CraftingPlanSummary;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public class CraftConfirmMenu
extends AEBaseMenu
implements ISubMenu {
    private static final String ACTION_BACK = "back";
    private static final String ACTION_CYCLE_CPU = "cycleCpu";
    private static final String ACTION_START_JOB = "startJob";
    public static final class_3917<CraftConfirmMenu> TYPE = MenuTypeBuilder.create(CraftConfirmMenu::new, ITerminalHost.class).requirePermission(SecurityPermissions.CRAFT).build("craftconfirm");
    private final CraftingCPUCycler cpuCycler;
    private ICraftingCPU selectedCpu;
    private AEKey whatToCraft;
    private int amount;
    private Future<ICraftingPlan> job;
    private ICraftingPlan result;
    @GuiSync(value=3)
    public boolean autoStart = false;
    @GuiSync(value=6)
    public boolean noCPU = true;
    @GuiSync(value=1)
    public long cpuBytesAvail;
    @GuiSync(value=2)
    public int cpuCoProcessors;
    @GuiSync(value=7)
    public class_2561 cpuName;
    private CraftingPlanSummary plan;
    private final ITerminalHost host;

    public CraftConfirmMenu(int id, class_1661 ip, ITerminalHost te) {
        super(TYPE, id, ip, te);
        this.host = te;
        this.cpuCycler = new CraftingCPUCycler(this::cpuMatches, this::onCPUSelectionChanged);
        this.cpuCycler.setAllowNoSelection(true);
        this.registerClientAction(ACTION_BACK, this::goBack);
        this.registerClientAction(ACTION_CYCLE_CPU, Boolean.class, this::cycleSelectedCPU);
        this.registerClientAction(ACTION_START_JOB, this::startJob);
    }

    public void cycleSelectedCPU(boolean next) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_CYCLE_CPU, next);
        } else {
            this.cpuCycler.cycleCpu(next);
        }
    }

    @Override
    public void method_7623() {
        if (this.isClientSide()) {
            return;
        }
        IGrid grid = this.getGrid();
        if (grid == null) {
            this.setValidMenu(false);
            return;
        }
        this.cpuCycler.detectAndSendChanges(grid);
        super.method_7623();
        if (this.job != null && this.job.isDone()) {
            try {
                this.result = this.job.get();
                if (!this.result.simulation() && this.isAutoStart()) {
                    this.startJob();
                    return;
                }
                this.plan = CraftingPlanSummary.fromJob(this.getGrid(), this.getActionSrc(), this.result);
                this.sendPacketToClient(new CraftConfirmPlanPacket(this.plan));
            }
            catch (Throwable e) {
                this.getPlayerInventory().field_7546.method_9203((class_2561)new class_2585("Error: " + e), class_156.field_25140);
                AELog.debug(e);
                this.setValidMenu(false);
                this.result = null;
            }
            this.setJob(null);
        }
        this.verifyPermissions(SecurityPermissions.CRAFT, false);
    }

    private IGrid getGrid() {
        IActionHost h = (IActionHost)this.getTarget();
        IGridNode a = h.getActionableNode();
        return a != null ? a.getGrid() : null;
    }

    private boolean cpuMatches(ICraftingCPU c) {
        if (this.plan == null) {
            return true;
        }
        return c.getAvailableStorage() >= this.plan.getUsedBytes() && !c.isBusy();
    }

    public void startJob() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_START_JOB);
            return;
        }
        if (this.result != null && !this.result.simulation()) {
            ICraftingService cc = this.getGrid().getCraftingService();
            ICraftingLink g = cc.submitJob(this.result, null, this.selectedCpu, true, this.getActionSrc());
            this.setAutoStart(false);
            if (g != null) {
                this.host.returnToMainMenu(this.getPlayer(), this);
            }
        }
    }

    private IActionSource getActionSrc() {
        return new PlayerSource(this.getPlayerInventory().field_7546, (IActionHost)this.getTarget());
    }

    public void method_7595(class_1657 par1PlayerEntity) {
        super.method_7595(par1PlayerEntity);
        if (this.job != null) {
            this.job.cancel(true);
            this.setJob(null);
        }
    }

    private void onCPUSelectionChanged(CraftingCPURecord cpuRecord, boolean cpusAvailable) {
        boolean bl = this.noCPU = !cpusAvailable;
        if (cpuRecord == null) {
            this.cpuBytesAvail = 0L;
            this.cpuCoProcessors = 0;
            this.cpuName = null;
            this.selectedCpu = null;
        } else {
            this.cpuBytesAvail = cpuRecord.getSize();
            this.cpuCoProcessors = cpuRecord.getProcessors();
            this.cpuName = cpuRecord.getName();
            this.selectedCpu = cpuRecord.getCpu();
        }
    }

    public class_1937 getLevel() {
        return this.getPlayerInventory().field_7546.field_6002;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public long getCpuAvailableBytes() {
        return this.cpuBytesAvail;
    }

    public int getCpuCoProcessors() {
        return this.cpuCoProcessors;
    }

    public class_2561 getName() {
        return this.cpuName;
    }

    public boolean hasNoCPU() {
        return this.noCPU;
    }

    public void setWhatToCraft(AEKey whatToCraft, int amount) {
        this.whatToCraft = whatToCraft;
        this.amount = amount;
    }

    public void setJob(Future<ICraftingPlan> job) {
        this.job = job;
    }

    @Nullable
    public CraftingPlanSummary getPlan() {
        return this.plan;
    }

    public void setPlan(CraftingPlanSummary plan) {
        this.plan = plan;
    }

    public void goBack() {
        class_1657 player = this.getPlayerInventory().field_7546;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (this.whatToCraft != null) {
                CraftAmountMenu.open(serverPlayer, this.getLocator(), this.whatToCraft, this.amount);
            }
        } else {
            this.sendClientAction(ACTION_BACK);
        }
    }

    @Override
    public ISubMenuHost getHost() {
        return this.host;
    }
}

