/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testworld;

import appeng.core.definitions.AEBlocks;
import appeng.server.testworld.Plot;
import appeng.server.testworld.RectanglePacking;
import appeng.server.testworld.TestPlots;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;

public class TestWorldGenerator {
    private static final int PADDING = 3;
    private static final int OUTER_PADDING = 10;
    private final class_3218 level;
    private final class_2338 origin;
    private final class_3222 player;
    private final List<PositionedPlot> positionedPlots;
    private final class_3341 overallBounds;
    private final class_2338 suitableStartPos;

    public TestWorldGenerator(class_3218 level, class_3222 player, class_2338 origin, @Nullable class_2960 plotId) {
        this.level = level;
        this.origin = origin;
        this.player = player;
        List<Plot> plots = plotId != null ? Collections.singletonList(TestPlots.getById(plotId)) : TestPlots.createPlots();
        RectanglePacking.PositionedArea<Plot> positionedArea = RectanglePacking.pack(plots, plot -> {
            class_3341 bb = plot.getBounds();
            return new RectanglePacking.Size(bb.method_35414() + 6, bb.method_14663() + 6);
        });
        this.positionedPlots = positionedArea.rectangles().stream().map(pp -> {
            class_3341 relativeBounds = ((Plot)pp.what()).getBounds();
            class_2338 plotOrigin = new class_2338(pp.x() - ((Plot)pp.what()).getBounds().method_35415() + 3, origin.method_10264(), pp.y() - ((Plot)pp.what()).getBounds().method_35417() + 3);
            class_3341 absBoundingBox = relativeBounds.method_19311(plotOrigin.method_10263(), plotOrigin.method_10264(), plotOrigin.method_10260());
            return new PositionedPlot(plotOrigin, absBoundingBox, (Plot)pp.what());
        }).toList();
        this.overallBounds = (class_3341)class_3341.method_35413(this.positionedPlots.stream().map(PositionedPlot::bounds).toList()).orElseThrow();
        this.suitableStartPos = origin.method_10069(positionedArea.w() / 2, 0, -2);
    }

    public class_2338 getSuitableStartPos() {
        return this.suitableStartPos;
    }

    public boolean isWithinBounds(class_2338 pos) {
        return this.overallBounds.method_35410(10).method_14662((class_2382)pos);
    }

    public void generate() {
        this.clearLevel();
        this.buildPlatform();
        ArrayList<class_1297> entities = new ArrayList<class_1297>();
        this.buildPlots(entities);
        this.clearEntities(entities);
    }

    private void buildPlots(List<class_1297> entities) {
        for (PositionedPlot positionedPlot : this.positionedPlots) {
            this.outline(positionedPlot);
            this.placeSign(positionedPlot);
            positionedPlot.plot.build(this.level, (class_1657)this.player, positionedPlot.origin, entities);
        }
    }

    private void placeSign(PositionedPlot positionedPlot) {
        class_2338 signPos = new class_2338(positionedPlot.bounds.method_35418() + 2, this.origin.method_10264(), positionedPlot.bounds.method_35417() - 2);
        this.level.method_8652(signPos, class_2246.field_10121.method_9564().method_26186(class_2470.field_11464), 3);
        this.level.method_35230(signPos, class_2591.field_11911).ifPresent(sign -> {
            sign.method_11303(false);
            sign.method_34270(true);
            sign.method_16127(class_1767.field_7952);
            StringBuilder text = new StringBuilder(positionedPlot.plot.getId().method_12832());
            int line = 0;
            while (line < 4 && !text.isEmpty()) {
                int lineLength = Math.min(12, text.length());
                String lineText = text.substring(0, lineLength);
                text.delete(0, lineLength);
                sign.method_11299(line++, (class_2561)new class_2585(lineText));
            }
        });
    }

    private void outline(PositionedPlot positionedPlot) {
        class_2338 from = new class_2338(positionedPlot.bounds.method_35415() - 1, positionedPlot.origin.method_10264() - 1, positionedPlot.bounds.method_35417() - 1);
        class_2338 to = new class_2338(positionedPlot.bounds.method_35418() + 1, positionedPlot.origin.method_10264() - 1, positionedPlot.bounds.method_35420() + 1);
        for (class_2338 pos : class_2338.method_10097((class_2338)from, (class_2338)to)) {
            this.level.method_8652(pos, AEBlocks.SKY_STONE_SMALL_BRICK.block().method_9564(), 3);
        }
    }

    private void buildPlatform() {
        class_2680 state = AEBlocks.SKY_STONE_BRICK.block().method_9564();
        class_2338 from = new class_2338(this.overallBounds.method_35415() - 10, this.origin.method_10264() - 3, this.overallBounds.method_35417() - 10);
        class_2338 to = new class_2338(this.overallBounds.method_35418() + 10, this.origin.method_10264() - 1, this.overallBounds.method_35420() + 10);
        for (class_2338 pos : class_2338.method_10097((class_2338)from, (class_2338)to)) {
            this.level.method_8652(pos, state, 3);
        }
    }

    private void clearLevel() {
        class_1923 from = new class_1923(new class_2338(this.overallBounds.method_35415() - 10, 0, this.overallBounds.method_35417() - 10));
        class_1923 to = new class_1923(new class_2338(this.overallBounds.method_35418() + 10, 0, this.overallBounds.method_35420() + 10));
        class_1923.method_19281((class_1923)from, (class_1923)to).forEach(chunkPos -> {
            class_2818 chunk = this.level.method_8497(chunkPos.field_9181, chunkPos.field_9180);
            if (!chunk.method_12223()) {
                this.clearChunk(chunk);
            }
        });
    }

    private void clearChunk(class_2818 chunk) {
        if (chunk.method_12223()) {
            return;
        }
        for (class_2826 sec : chunk.method_12006()) {
            if (sec.method_38292()) continue;
            class_2338.class_2339 p = new class_2338.class_2339();
            class_2680 air = class_2246.field_10124.method_9564();
            for (int y = 0; y < 16; ++y) {
                p.method_33098(sec.method_12259() + y);
                for (int x = 0; x < 16; ++x) {
                    p.method_33097(chunk.method_12004().method_8326() + x);
                    for (int z = 0; z < 16; ++z) {
                        p.method_33099(chunk.method_12004().method_8328() + z);
                        this.level.method_8652((class_2338)p, air, 3);
                    }
                }
            }
        }
    }

    private void clearEntities(List<class_1297> plotEntities) {
        class_1297[] entities;
        for (class_1297 entity : entities = (class_1297[])Iterables.toArray((Iterable)this.level.method_27909(), class_1297.class)) {
            if (plotEntities.contains(entity) || entity instanceof class_1657 || !entity.method_5805()) continue;
            entity.method_31472();
        }
    }

    private record PositionedPlot(class_2338 origin, class_3341 bounds, Plot plot) {
    }
}

