/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.fabric.mixin.LevelResourceAccess;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import me.shedaniel.cloth.api.utils.v1.GameInstanceUtils;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public final class IDAssigner {
    private static final class_5218 FOLDER = LevelResourceAccess.create("computercraft");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type ID_TOKEN = new TypeToken<Map<String, Integer>>(){}.getType();
    private static Map<String, Integer> ids;
    private static WeakReference<MinecraftServer> server;
    private static Path idFile;

    private IDAssigner() {
    }

    public static File getDir() {
        return GameInstanceUtils.getServer().method_27050(FOLDER).toFile();
    }

    private static MinecraftServer getCachedServer() {
        if (server == null) {
            return null;
        }
        MinecraftServer currentServer = (MinecraftServer)server.get();
        if (currentServer == null) {
            return null;
        }
        if (currentServer != GameInstanceUtils.getServer()) {
            return null;
        }
        return currentServer;
    }

    public static synchronized int getNextId(String kind) {
        Integer existing;
        MinecraftServer currentServer = IDAssigner.getCachedServer();
        if (currentServer == null) {
            server = new WeakReference<MinecraftServer>(GameInstanceUtils.getServer());
            File dir = IDAssigner.getDir();
            dir.mkdirs();
            idFile = new File(dir, "ids.json").toPath();
            if (Files.isRegularFile(idFile, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(idFile, StandardCharsets.UTF_8);){
                    ids = (Map)GSON.fromJson((Reader)reader, ID_TOKEN);
                }
                catch (Exception e) {
                    ComputerCraft.log.error("Cannot load id file '" + idFile + "'", (Throwable)e);
                    ids = new HashMap<String, Integer>();
                }
            } else {
                ids = new HashMap<String, Integer>();
            }
        }
        int next = (existing = ids.get(kind)) == null ? 0 : existing + 1;
        ids.put(kind, next);
        try (BufferedWriter writer = Files.newBufferedWriter(idFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson(ids, (Appendable)writer);
        }
        catch (Exception e) {
            ComputerCraft.log.error("Cannot update ID file '" + idFile + "'", (Throwable)e);
        }
        return next;
    }
}

