/*
 * Decompiled with CFR 0.152.
 */
package io.zhile.research.intellij.ier.listener;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBusConnection;
import io.zhile.research.intellij.ier.helper.BrokenPlugins;
import io.zhile.research.intellij.ier.helper.CustomProperties;
import io.zhile.research.intellij.ier.helper.CustomRepository;
import io.zhile.research.intellij.ier.listener.AppActivationListener;
import io.zhile.research.intellij.ier.listener.AppEventListener;

public class ListenerConnector {
    private static Disposable disposable;

    public static void setup() {
        ListenerConnector.dispose();
        CustomProperties.fix();
        BrokenPlugins.fix();
        CustomRepository.checkAndAdd("https://plugins.zhile.io");
        Application app = ApplicationManager.getApplication();
        disposable = Disposer.newDisposable();
        Disposer.register((Disposable)app, (Disposable)disposable);
        MessageBusConnection connection = app.getMessageBus().connect(disposable);
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppEventListener());
        connection.subscribe(ApplicationActivationListener.TOPIC, (Object)new AppActivationListener());
    }

    public static void dispose() {
        if (null == disposable || Disposer.isDisposed((Disposable)disposable)) {
            return;
        }
        Disposer.dispose((Disposable)disposable);
        disposable = null;
    }
}

