/*
 * Decompiled with CFR 0.152.
 */
package io.zhile.research.intellij.ier.common;

import com.intellij.ide.Prefs;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.PropertiesComponentImpl;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import io.zhile.research.intellij.ier.common.EvalRecord;
import io.zhile.research.intellij.ier.common.LicenseFileRecord;
import io.zhile.research.intellij.ier.common.NormalFileRecord;
import io.zhile.research.intellij.ier.common.PreferenceRecord;
import io.zhile.research.intellij.ier.common.PropertyRecord;
import io.zhile.research.intellij.ier.helper.Constants;
import io.zhile.research.intellij.ier.helper.NotificationHelper;
import io.zhile.research.intellij.ier.helper.ReflectionHelper;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.jdom.Attribute;
import org.jdom.Element;

public class Resetter {
    private static final String DEFAULT_VENDOR = "jetbrains";
    private static final String OLD_MACHINE_ID_KEY = "JetBrains.UserIdOnMachine";
    private static final String NEW_MACHINE_ID_KEY = "jetbrains.user_id_on_machine";
    private static final String DEVICE_ID_KEY = "jetbrains.device_id";
    private static final String EVAL_KEY = "evlsprt";
    private static final String AUTO_RESET_KEY = "Ide-Eval-Reset.auto_reset." + Constants.IDE_NAME_LOWER + "." + Constants.IDE_HASH;

    public static List<EvalRecord> getEvalRecords() {
        PreferenceRecord[] prefsValue;
        Element state;
        File licenseDir;
        ArrayList<EvalRecord> list = new ArrayList<EvalRecord>();
        File evalDir = Resetter.getEvalDir();
        if (evalDir.exists()) {
            File[] files = evalDir.listFiles();
            if (files == null) {
                NotificationHelper.showError(null, "List eval license file failed!");
            } else {
                for (File file : files) {
                    if (!file.getName().endsWith(".key")) continue;
                    list.add(new LicenseFileRecord(file));
                }
            }
        }
        if ((licenseDir = Resetter.getLicenseDir()).exists()) {
            File[] files = licenseDir.listFiles();
            if (files == null) {
                NotificationHelper.showError(null, "List license file failed!");
            } else {
                for (File file : files) {
                    if (!file.getName().endsWith(".key") && !file.getName().endsWith(".license") || file.length() > 1024L) continue;
                    list.add(new NormalFileRecord(file));
                }
            }
        }
        if ((state = ((PropertiesComponentImpl)PropertiesComponent.getInstance()).getState()) != null) {
            for (Element element : state.getChildren()) {
                if (!element.getName().equals("property")) continue;
                Attribute attrName = element.getAttribute("name");
                Attribute attrValue = element.getAttribute("value");
                if (attrName == null || attrValue == null || !attrName.getValue().startsWith(EVAL_KEY)) continue;
                list.add(new PropertyRecord(attrName.getValue()));
            }
        }
        for (PreferenceRecord record : prefsValue = new PreferenceRecord[]{new PreferenceRecord(OLD_MACHINE_ID_KEY, true), new PreferenceRecord(NEW_MACHINE_ID_KEY), new PreferenceRecord(DEVICE_ID_KEY)}) {
            if (record.getValue() == null) continue;
            list.add(record);
        }
        try {
            ArrayList<String> prefsList = new ArrayList<String>();
            for (String name : Preferences.userRoot().node(DEFAULT_VENDOR).childrenNames()) {
                if (!name.toLowerCase().startsWith(Constants.IDE_NAME_LOWER)) continue;
                Resetter.getAllPrefsKeys(Preferences.userRoot().node("jetbrains/" + name + "/" + Constants.IDE_HASH), prefsList);
            }
            Method methodGetProductCode = ReflectionHelper.getMethod(IdeaPluginDescriptor.class, "getProductCode", new Class[0]);
            if (null != methodGetProductCode) {
                for (IdeaPluginDescriptor descriptor : PluginManager.getPlugins()) {
                    String productCode = (String)methodGetProductCode.invoke((Object)descriptor, new Object[0]);
                    if (null == productCode || productCode.isEmpty()) continue;
                    Resetter.getAllPrefsKeys(Preferences.userRoot().node("jetbrains/" + productCode.toLowerCase()), prefsList);
                }
            }
            for (String key : prefsList) {
                if (!key.contains(EVAL_KEY)) continue;
                if (key.startsWith("/")) {
                    key = key.substring(1).replace('/', '.');
                }
                list.add(new PreferenceRecord(key));
            }
        }
        catch (Exception e) {
            NotificationHelper.showError(null, "List eval preferences failed!");
        }
        if (SystemInfo.isWindows) {
            for (String name : new String[]{"PermanentUserId", "PermanentDeviceId"}) {
                File file = Resetter.getSharedFile(name);
                if (null == file || !file.exists()) continue;
                list.add(new NormalFileRecord(file));
            }
        }
        return list;
    }

    public static void reset(List<EvalRecord> records) {
        for (EvalRecord record : records) {
            Resetter.reset(record);
        }
    }

    public static void reset(EvalRecord record) {
        try {
            record.reset();
        }
        catch (Exception e) {
            NotificationHelper.showError(null, e.getMessage());
        }
    }

    public static boolean isAutoReset() {
        return Prefs.getBoolean((String)AUTO_RESET_KEY, (boolean)false);
    }

    public static void setAutoReset(boolean isAutoReset) {
        Prefs.putBoolean((String)AUTO_RESET_KEY, (boolean)isAutoReset);
        Resetter.syncPrefs();
    }

    public static void syncPrefs() {
        try {
            Preferences.userRoot().sync();
        }
        catch (BackingStoreException e) {
            NotificationHelper.showError(null, "Flush preferences failed!");
        }
    }

    protected static File getSharedFile(String fileName) {
        String appData = System.getenv("APPDATA");
        if (appData == null) {
            return null;
        }
        return Paths.get(appData, "JetBrains", fileName).toFile();
    }

    protected static File getEvalDir() {
        String configPath = PathManager.getConfigPath();
        return new File(configPath, "eval");
    }

    protected static File getLicenseDir() {
        return new File(PathManager.getConfigPath());
    }

    protected static void getAllPrefsKeys(Preferences prefs, List<String> list) throws BackingStoreException {
        String[] childrenNames = prefs.childrenNames();
        if (childrenNames.length == 0) {
            for (String key : prefs.keys()) {
                list.add(prefs.absolutePath() + "/" + key);
            }
            return;
        }
        for (String childName : childrenNames) {
            Resetter.getAllPrefsKeys(prefs.node(childName), list);
        }
    }
}

