/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.media.DeniedByServerException;
import android.media.NotProvisionedException;
import android.media.ResourceBusyException;
import android.media.UnsupportedSchemeException;
import android.os.Handler;
import android.os.PersistableBundle;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;

public final class MediaDrm
implements AutoCloseable {
    @Deprecated
    public static final int EVENT_KEY_EXPIRED = 3;
    public static final int EVENT_KEY_REQUIRED = 2;
    @Deprecated
    public static final int EVENT_PROVISION_REQUIRED = 1;
    public static final int EVENT_SESSION_RECLAIMED = 5;
    public static final int EVENT_VENDOR_DEFINED = 4;
    public static final int HDCP_LEVEL_UNKNOWN = 0;
    public static final int HDCP_NONE = 1;
    public static final int HDCP_NO_DIGITAL_OUTPUT = Integer.MAX_VALUE;
    public static final int HDCP_V1 = 2;
    public static final int HDCP_V2 = 3;
    public static final int HDCP_V2_1 = 4;
    public static final int HDCP_V2_2 = 5;
    public static final int HDCP_V2_3 = 6;
    public static final int KEY_TYPE_OFFLINE = 2;
    public static final int KEY_TYPE_RELEASE = 3;
    public static final int KEY_TYPE_STREAMING = 1;
    public static final int OFFLINE_LICENSE_STATE_RELEASED = 2;
    public static final int OFFLINE_LICENSE_STATE_UNKNOWN = 0;
    public static final int OFFLINE_LICENSE_STATE_USABLE = 1;
    public static final String PROPERTY_ALGORITHMS = "algorithms";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_DEVICE_UNIQUE_ID = "deviceUniqueId";
    public static final String PROPERTY_VENDOR = "vendor";
    public static final String PROPERTY_VERSION = "version";
    public static final int SECURITY_LEVEL_HW_SECURE_ALL = 5;
    public static final int SECURITY_LEVEL_HW_SECURE_CRYPTO = 3;
    public static final int SECURITY_LEVEL_HW_SECURE_DECODE = 4;
    public static final int SECURITY_LEVEL_SW_SECURE_CRYPTO = 1;
    public static final int SECURITY_LEVEL_SW_SECURE_DECODE = 2;
    public static final int SECURITY_LEVEL_UNKNOWN = 0;

    public MediaDrm(@NonNull UUID uuid) throws UnsupportedSchemeException {
        throw new RuntimeException("Stub!");
    }

    public static boolean isCryptoSchemeSupported(@NonNull UUID uuid) {
        throw new RuntimeException("Stub!");
    }

    public static boolean isCryptoSchemeSupported(@NonNull UUID uuid, @NonNull String mimeType) {
        throw new RuntimeException("Stub!");
    }

    public static boolean isCryptoSchemeSupported(@NonNull UUID uuid, @NonNull String mimeType, int securityLevel) {
        throw new RuntimeException("Stub!");
    }

    public void setOnExpirationUpdateListener(@Nullable OnExpirationUpdateListener listener, @Nullable Handler handler) {
        throw new RuntimeException("Stub!");
    }

    public void setOnExpirationUpdateListener(@NonNull Executor executor, @NonNull OnExpirationUpdateListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void clearOnExpirationUpdateListener() {
        throw new RuntimeException("Stub!");
    }

    public void setOnKeyStatusChangeListener(@Nullable OnKeyStatusChangeListener listener, @Nullable Handler handler) {
        throw new RuntimeException("Stub!");
    }

    public void setOnKeyStatusChangeListener(@NonNull Executor executor, @NonNull OnKeyStatusChangeListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void clearOnKeyStatusChangeListener() {
        throw new RuntimeException("Stub!");
    }

    public void setOnSessionLostStateListener(@Nullable OnSessionLostStateListener listener, @Nullable Handler handler) {
        throw new RuntimeException("Stub!");
    }

    public void setOnSessionLostStateListener(@NonNull Executor executor, @Nullable OnSessionLostStateListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void clearOnSessionLostStateListener() {
        throw new RuntimeException("Stub!");
    }

    public void setOnEventListener(@Nullable OnEventListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void setOnEventListener(@Nullable OnEventListener listener, @Nullable Handler handler) {
        throw new RuntimeException("Stub!");
    }

    public void setOnEventListener(@NonNull Executor executor, @NonNull OnEventListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void clearOnEventListener() {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public byte[] openSession() throws NotProvisionedException, ResourceBusyException {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public native byte[] openSession(int var1) throws NotProvisionedException, ResourceBusyException;

    public native void closeSession(@NonNull byte[] var1);

    @NonNull
    public native KeyRequest getKeyRequest(@NonNull byte[] var1, @Nullable byte[] var2, @Nullable String var3, int var4, @Nullable HashMap<String, String> var5) throws NotProvisionedException;

    @Nullable
    public native byte[] provideKeyResponse(@NonNull byte[] var1, @NonNull byte[] var2) throws DeniedByServerException, NotProvisionedException;

    public native void restoreKeys(@NonNull byte[] var1, @NonNull byte[] var2);

    public native void removeKeys(@NonNull byte[] var1);

    @NonNull
    public native HashMap<String, String> queryKeyStatus(@NonNull byte[] var1);

    @NonNull
    public ProvisionRequest getProvisionRequest() {
        throw new RuntimeException("Stub!");
    }

    public void provideProvisionResponse(@NonNull byte[] response) throws DeniedByServerException {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public native List<byte[]> getOfflineLicenseKeySetIds();

    public native void removeOfflineLicense(@NonNull byte[] var1);

    public native int getOfflineLicenseState(@NonNull byte[] var1);

    @NonNull
    public native List<byte[]> getSecureStops();

    @NonNull
    public native List<byte[]> getSecureStopIds();

    @NonNull
    public native byte[] getSecureStop(@NonNull byte[] var1);

    public native void releaseSecureStops(@NonNull byte[] var1);

    public native void removeSecureStop(@NonNull byte[] var1);

    public native void removeAllSecureStops();

    @Deprecated
    public void releaseAllSecureStops() {
        throw new RuntimeException("Stub!");
    }

    public native int getConnectedHdcpLevel();

    public native int getMaxHdcpLevel();

    public native int getOpenSessionCount();

    public native int getMaxSessionCount();

    public static int getMaxSecurityLevel() {
        throw new RuntimeException("Stub!");
    }

    public native int getSecurityLevel(@NonNull byte[] var1);

    @NonNull
    public native String getPropertyString(@NonNull String var1);

    public native void setPropertyString(@NonNull String var1, @NonNull String var2);

    @NonNull
    public native byte[] getPropertyByteArray(String var1);

    public native void setPropertyByteArray(@NonNull String var1, @NonNull byte[] var2);

    public PersistableBundle getMetrics() {
        throw new RuntimeException("Stub!");
    }

    public CryptoSession getCryptoSession(@NonNull byte[] sessionId, @NonNull String cipherAlgorithm, @NonNull String macAlgorithm) {
        throw new RuntimeException("Stub!");
    }

    protected void finalize() throws Throwable {
        throw new RuntimeException("Stub!");
    }

    @Override
    public void close() {
        throw new RuntimeException("Stub!");
    }

    @Deprecated
    public void release() {
        throw new RuntimeException("Stub!");
    }

    public static final class SessionException
    extends RuntimeException {
        public static final int ERROR_RESOURCE_CONTENTION = 1;
        public static final int ERROR_UNKNOWN = 0;

        public SessionException(int errorCode, @Nullable String detailMessage) {
            throw new RuntimeException("Stub!");
        }

        public int getErrorCode() {
            throw new RuntimeException("Stub!");
        }
    }

    @Deprecated
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SecurityLevel {
    }

    public static final class ProvisionRequest {
        ProvisionRequest() {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public byte[] getData() {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public String getDefaultUrl() {
            throw new RuntimeException("Stub!");
        }
    }

    public static interface OnSessionLostStateListener {
        public void onSessionLostState(@NonNull MediaDrm var1, @NonNull byte[] var2);
    }

    public static interface OnKeyStatusChangeListener {
        public void onKeyStatusChange(@NonNull MediaDrm var1, @NonNull byte[] var2, @NonNull List<KeyStatus> var3, boolean var4);
    }

    public static interface OnExpirationUpdateListener {
        public void onExpirationUpdate(@NonNull MediaDrm var1, @NonNull byte[] var2, long var3);
    }

    public static interface OnEventListener {
        public void onEvent(@NonNull MediaDrm var1, @Nullable byte[] var2, int var3, int var4, @Nullable byte[] var5);
    }

    public static final class MetricsConstants {
        public static final String CLOSE_SESSION_ERROR_COUNT = "drm.mediadrm.close_session.error.count";
        public static final String CLOSE_SESSION_ERROR_LIST = "drm.mediadrm.close_session.error.list";
        public static final String CLOSE_SESSION_OK_COUNT = "drm.mediadrm.close_session.ok.count";
        public static final String EVENT_KEY_EXPIRED_COUNT = "drm.mediadrm.event.KEY_EXPIRED.count";
        public static final String EVENT_KEY_NEEDED_COUNT = "drm.mediadrm.event.KEY_NEEDED.count";
        public static final String EVENT_PROVISION_REQUIRED_COUNT = "drm.mediadrm.event.PROVISION_REQUIRED.count";
        public static final String EVENT_SESSION_RECLAIMED_COUNT = "drm.mediadrm.event.SESSION_RECLAIMED.count";
        public static final String EVENT_VENDOR_DEFINED_COUNT = "drm.mediadrm.event.VENDOR_DEFINED.count";
        public static final String GET_DEVICE_UNIQUE_ID_ERROR_COUNT = "drm.mediadrm.get_device_unique_id.error.count";
        public static final String GET_DEVICE_UNIQUE_ID_ERROR_LIST = "drm.mediadrm.get_device_unique_id.error.list";
        public static final String GET_DEVICE_UNIQUE_ID_OK_COUNT = "drm.mediadrm.get_device_unique_id.ok.count";
        public static final String GET_KEY_REQUEST_ERROR_COUNT = "drm.mediadrm.get_key_request.error.count";
        public static final String GET_KEY_REQUEST_ERROR_LIST = "drm.mediadrm.get_key_request.error.list";
        public static final String GET_KEY_REQUEST_OK_COUNT = "drm.mediadrm.get_key_request.ok.count";
        public static final String GET_KEY_REQUEST_OK_TIME_MICROS = "drm.mediadrm.get_key_request.ok.average_time_micros";
        public static final String GET_PROVISION_REQUEST_ERROR_COUNT = "drm.mediadrm.get_provision_request.error.count";
        public static final String GET_PROVISION_REQUEST_ERROR_LIST = "drm.mediadrm.get_provision_request.error.list";
        public static final String GET_PROVISION_REQUEST_OK_COUNT = "drm.mediadrm.get_provision_request.ok.count";
        public static final String KEY_STATUS_EXPIRED_COUNT = "drm.mediadrm.key_status.EXPIRED.count";
        public static final String KEY_STATUS_INTERNAL_ERROR_COUNT = "drm.mediadrm.key_status.INTERNAL_ERROR.count";
        public static final String KEY_STATUS_OUTPUT_NOT_ALLOWED_COUNT = "drm.mediadrm.key_status_change.OUTPUT_NOT_ALLOWED.count";
        public static final String KEY_STATUS_PENDING_COUNT = "drm.mediadrm.key_status_change.PENDING.count";
        public static final String KEY_STATUS_USABLE_COUNT = "drm.mediadrm.key_status_change.USABLE.count";
        public static final String OPEN_SESSION_ERROR_COUNT = "drm.mediadrm.open_session.error.count";
        public static final String OPEN_SESSION_ERROR_LIST = "drm.mediadrm.open_session.error.list";
        public static final String OPEN_SESSION_OK_COUNT = "drm.mediadrm.open_session.ok.count";
        public static final String PROVIDE_KEY_RESPONSE_ERROR_COUNT = "drm.mediadrm.provide_key_response.error.count";
        public static final String PROVIDE_KEY_RESPONSE_ERROR_LIST = "drm.mediadrm.provide_key_response.error.list";
        public static final String PROVIDE_KEY_RESPONSE_OK_COUNT = "drm.mediadrm.provide_key_response.ok.count";
        public static final String PROVIDE_KEY_RESPONSE_OK_TIME_MICROS = "drm.mediadrm.provide_key_response.ok.average_time_micros";
        public static final String PROVIDE_PROVISION_RESPONSE_ERROR_COUNT = "drm.mediadrm.provide_provision_response.error.count";
        public static final String PROVIDE_PROVISION_RESPONSE_ERROR_LIST = "drm.mediadrm.provide_provision_response.error.list";
        public static final String PROVIDE_PROVISION_RESPONSE_OK_COUNT = "drm.mediadrm.provide_provision_response.ok.count";
        public static final String SESSION_END_TIMES_MS = "drm.mediadrm.session_end_times_ms";
        public static final String SESSION_START_TIMES_MS = "drm.mediadrm.session_start_times_ms";

        MetricsConstants() {
            throw new RuntimeException("Stub!");
        }
    }

    public static final class MediaDrmStateException
    extends IllegalStateException {
        MediaDrmStateException(int errorCode, @Nullable String detailMessage) {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public String getDiagnosticInfo() {
            throw new RuntimeException("Stub!");
        }
    }

    public static final class KeyStatus {
        public static final int STATUS_EXPIRED = 1;
        public static final int STATUS_INTERNAL_ERROR = 4;
        public static final int STATUS_OUTPUT_NOT_ALLOWED = 2;
        public static final int STATUS_PENDING = 3;
        public static final int STATUS_USABLE = 0;
        public static final int STATUS_USABLE_IN_FUTURE = 5;

        KeyStatus(@NonNull byte[] keyId, int statusCode) {
            throw new RuntimeException("Stub!");
        }

        public int getStatusCode() {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public byte[] getKeyId() {
            throw new RuntimeException("Stub!");
        }
    }

    public static final class KeyRequest {
        public static final int REQUEST_TYPE_INITIAL = 0;
        public static final int REQUEST_TYPE_NONE = 3;
        public static final int REQUEST_TYPE_RELEASE = 2;
        public static final int REQUEST_TYPE_RENEWAL = 1;
        public static final int REQUEST_TYPE_UPDATE = 4;

        KeyRequest() {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public byte[] getData() {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public String getDefaultUrl() {
            throw new RuntimeException("Stub!");
        }

        public int getRequestType() {
            throw new RuntimeException("Stub!");
        }
    }

    @Deprecated
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HdcpLevel {
    }

    public final class CryptoSession {
        CryptoSession(@NonNull byte[] sessionId, @NonNull String cipherAlgorithm, String macAlgorithm) {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public byte[] encrypt(@NonNull byte[] keyid, @NonNull byte[] input, @NonNull byte[] iv) {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public byte[] decrypt(@NonNull byte[] keyid, @NonNull byte[] input, @NonNull byte[] iv) {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public byte[] sign(@NonNull byte[] keyid, @NonNull byte[] message) {
            throw new RuntimeException("Stub!");
        }

        public boolean verify(@NonNull byte[] keyid, @NonNull byte[] message, @NonNull byte[] signature) {
            throw new RuntimeException("Stub!");
        }
    }
}

