#include <REGX51.H>

unsigned char Time[7] = {0x08, 0x34, 2, 28, 23, 59, 50};
void Timer0_Init() {
    TMOD &= 0xF0;
    TMOD |= 0x01;
    TH0 = 0xFC;
    TL0 = 0x18;
    ET0 = 1;
    EA = 1;
    TR0 = 1;
}

void Timer0_ISR() interrupt 1 {
    unsigned int year;
    unsigned char daysInMonth;
    TH0 = 0xFC;
    TL0 = 0x18;
    // 递增秒
    Time[6]++;
    if (Time[6] >= 60) {
        // 递增分钟
        Time[6] = 0;
        Time[5]++;
        if (Time[5] >= 60) {
            // 递增小时
            Time[5] = 0;
            Time[4]++;
            if (Time[4] >= 24) {
                // 递增天
                Time[3]++;
                Time[4] = 0;

                // 生成年份
                year = (Time[0] << 8) | Time[1];
                
                // 根据月份确定该月天数
                if (Time[2] == 4 || Time[2] == 6 || Time[2] == 9 || Time[2] == 11) {
                    daysInMonth = 30;
                } else if (Time[2] == 2) {
                    // 检查闰年对于2月的影响
                    if ((year % 4 == 0 && year % 100 != 0) || (year % 400 == 0)) {
                        daysInMonth = 29;
                    } else {
                        daysInMonth = 28;
                    }
                } else {
                    daysInMonth = 31;
                }

                // 更新天
                if (Time[3] > daysInMonth) {
                    Time[3] = 1;
                    Time[2]++;
                    // 更新月
                    if (Time[2] > 12) {
                        Time[1]++; // 先更新年份的低8位
                        if(Time[1] == 0) { // 如果低8位从0xFF溢出到0x00，则高8位递增
                            Time[0]++;
                        }
                        Time[2] = 1; // 更新为1月
                    }
                }
            }
        }
    }
}
void main() {
    Timer0_Init(); // Initialize Timer0 for accelerated RTC
    while(1) {
    }
}