; C51 Assembly program for air conditioner control 

ORG 0H
MOV R1, #25 ; Set target temperature to 25 degrees Celsius
MAIN: 
    MOV A, P1 ; Read room temperature from P1
    CLR C    ; Clear the Carry flag
    SUBB A, R1 ; Subtract target temp from room temp, sets Carry flag if room temperature is less than R1
    JC TURN_OFF ; If Carry is set (room temperature is less than target), jump to turn off compressor
TURN_ON:
    SETB P2.1 ; Else, turn on compressor if room temp is higher than target
    SJMP MAIN ; Go back to main loop
TURN_OFF:
    CLR P2.1 ; Turn off compressor if room temp is less than target
    SJMP MAIN ; Go back to main loop
END