/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.AbstractChannel;
import io.netty.channel.AbstractChannelHandlerContext;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineException;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;

final class DefaultChannelPipeline
implements ChannelPipeline {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelPipeline.class);
    private static final WeakHashMap<Class<?>, String>[] nameCaches = new WeakHashMap[Runtime.getRuntime().availableProcessors()];
    final AbstractChannel channel;
    final AbstractChannelHandlerContext head;
    final AbstractChannelHandlerContext tail;
    private final Map<String, AbstractChannelHandlerContext> name2ctx = new HashMap<String, AbstractChannelHandlerContext>(4);
    final Map<EventExecutorGroup, EventExecutor> childExecutors = new IdentityHashMap<EventExecutorGroup, EventExecutor>();

    public DefaultChannelPipeline(AbstractChannel channel) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        this.channel = channel;
        this.tail = new TailContext(this);
        this.head = new HeadContext(this);
        this.head.next = this.tail;
        this.tail.prev = this.head;
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public ChannelPipeline addFirst(String name, ChannelHandler handler) {
        return this.addFirst(null, name, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelPipeline addFirst(EventExecutorGroup group, String name, ChannelHandler handler) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            this.checkDuplicateName(name);
            DefaultChannelHandlerContext newCtx = new DefaultChannelHandlerContext(this, group, name, handler);
            this.addFirst0(name, newCtx);
        }
        return this;
    }

    private void addFirst0(String name, AbstractChannelHandlerContext newCtx) {
        DefaultChannelPipeline.checkMultiplicity(newCtx);
        AbstractChannelHandlerContext nextCtx = this.head.next;
        newCtx.prev = this.head;
        newCtx.next = nextCtx;
        this.head.next = newCtx;
        nextCtx.prev = newCtx;
        this.name2ctx.put(name, newCtx);
        this.callHandlerAdded(newCtx);
    }

    @Override
    public ChannelPipeline addLast(String name, ChannelHandler handler) {
        return this.addLast(null, name, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelPipeline addLast(EventExecutorGroup group, String name, ChannelHandler handler) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            this.checkDuplicateName(name);
            DefaultChannelHandlerContext newCtx = new DefaultChannelHandlerContext(this, group, name, handler);
            this.addLast0(name, newCtx);
        }
        return this;
    }

    private void addLast0(String name, AbstractChannelHandlerContext newCtx) {
        AbstractChannelHandlerContext prev;
        DefaultChannelPipeline.checkMultiplicity(newCtx);
        newCtx.prev = prev = this.tail.prev;
        newCtx.next = this.tail;
        prev.next = newCtx;
        this.tail.prev = newCtx;
        this.name2ctx.put(name, newCtx);
        this.callHandlerAdded(newCtx);
    }

    @Override
    public ChannelPipeline addBefore(String baseName, String name, ChannelHandler handler) {
        return this.addBefore(null, baseName, name, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelPipeline addBefore(EventExecutorGroup group, String baseName, String name, ChannelHandler handler) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            AbstractChannelHandlerContext ctx2 = this.getContextOrDie(baseName);
            this.checkDuplicateName(name);
            DefaultChannelHandlerContext newCtx = new DefaultChannelHandlerContext(this, group, name, handler);
            this.addBefore0(name, ctx2, newCtx);
        }
        return this;
    }

    private void addBefore0(String name, AbstractChannelHandlerContext ctx2, AbstractChannelHandlerContext newCtx) {
        DefaultChannelPipeline.checkMultiplicity(newCtx);
        newCtx.prev = ctx2.prev;
        newCtx.next = ctx2;
        ctx2.prev.next = newCtx;
        ctx2.prev = newCtx;
        this.name2ctx.put(name, newCtx);
        this.callHandlerAdded(newCtx);
    }

    @Override
    public ChannelPipeline addAfter(String baseName, String name, ChannelHandler handler) {
        return this.addAfter(null, baseName, name, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelPipeline addAfter(EventExecutorGroup group, String baseName, String name, ChannelHandler handler) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            AbstractChannelHandlerContext ctx2 = this.getContextOrDie(baseName);
            this.checkDuplicateName(name);
            DefaultChannelHandlerContext newCtx = new DefaultChannelHandlerContext(this, group, name, handler);
            this.addAfter0(name, ctx2, newCtx);
        }
        return this;
    }

    private void addAfter0(String name, AbstractChannelHandlerContext ctx2, AbstractChannelHandlerContext newCtx) {
        this.checkDuplicateName(name);
        DefaultChannelPipeline.checkMultiplicity(newCtx);
        newCtx.prev = ctx2;
        newCtx.next = ctx2.next;
        ctx2.next.prev = newCtx;
        ctx2.next = newCtx;
        this.name2ctx.put(name, newCtx);
        this.callHandlerAdded(newCtx);
    }

    @Override
    public ChannelPipeline addFirst(ChannelHandler ... handlers) {
        return this.addFirst((EventExecutorGroup)null, handlers);
    }

    @Override
    public ChannelPipeline addFirst(EventExecutorGroup executor, ChannelHandler ... handlers) {
        if (handlers == null) {
            throw new NullPointerException("handlers");
        }
        if (handlers.length == 0 || handlers[0] == null) {
            return this;
        }
        for (int size = 1; size < handlers.length && handlers[size] != null; ++size) {
        }
        for (int i2 = size - 1; i2 >= 0; --i2) {
            ChannelHandler h2 = handlers[i2];
            this.addFirst(executor, this.generateName(h2), h2);
        }
        return this;
    }

    @Override
    public ChannelPipeline addLast(ChannelHandler ... handlers) {
        return this.addLast((EventExecutorGroup)null, handlers);
    }

    @Override
    public ChannelPipeline addLast(EventExecutorGroup executor, ChannelHandler ... handlers) {
        if (handlers == null) {
            throw new NullPointerException("handlers");
        }
        for (ChannelHandler h2 : handlers) {
            if (h2 == null) break;
            this.addLast(executor, this.generateName(h2), h2);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateName(ChannelHandler handler) {
        String name;
        WeakHashMap<Class<?>, String> cache = nameCaches[(int)(Thread.currentThread().getId() % (long)nameCaches.length)];
        Class<?> handlerType = handler.getClass();
        Object object = cache;
        synchronized (object) {
            name = cache.get(handlerType);
            if (name == null) {
                name = DefaultChannelPipeline.generateName0(handlerType);
                cache.put(handlerType, name);
            }
        }
        object = this;
        synchronized (object) {
            if (this.name2ctx.containsKey(name)) {
                String baseName = name.substring(0, name.length() - 1);
                int i2 = 1;
                while (true) {
                    String newName;
                    if (!this.name2ctx.containsKey(newName = baseName + i2)) {
                        name = newName;
                        break;
                    }
                    ++i2;
                }
            }
        }
        return name;
    }

    private static String generateName0(Class<?> handlerType) {
        return StringUtil.simpleClassName(handlerType) + "#0";
    }

    @Override
    public ChannelPipeline remove(ChannelHandler handler) {
        this.remove(this.getContextOrDie(handler));
        return this;
    }

    @Override
    public ChannelHandler remove(String name) {
        return this.remove(this.getContextOrDie(name)).handler();
    }

    @Override
    public <T extends ChannelHandler> T remove(Class<T> handlerType) {
        return (T)this.remove(this.getContextOrDie(handlerType)).handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractChannelHandlerContext remove(final AbstractChannelHandlerContext ctx2) {
        AbstractChannelHandlerContext context;
        Future<?> future;
        assert (ctx2 != this.head && ctx2 != this.tail);
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            if (!ctx2.channel().isRegistered() || ctx2.executor().inEventLoop()) {
                this.remove0(ctx2);
                return ctx2;
            }
            future = ctx2.executor().submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DefaultChannelPipeline defaultChannelPipeline = DefaultChannelPipeline.this;
                    synchronized (defaultChannelPipeline) {
                        DefaultChannelPipeline.this.remove0(ctx2);
                    }
                }
            });
            context = ctx2;
        }
        DefaultChannelPipeline.waitForFuture(future);
        return context;
    }

    void remove0(AbstractChannelHandlerContext ctx2) {
        AbstractChannelHandlerContext next;
        AbstractChannelHandlerContext prev = ctx2.prev;
        prev.next = next = ctx2.next;
        next.prev = prev;
        this.name2ctx.remove(ctx2.name());
        this.callHandlerRemoved(ctx2);
    }

    @Override
    public ChannelHandler removeFirst() {
        if (this.head.next == this.tail) {
            throw new NoSuchElementException();
        }
        return this.remove(this.head.next).handler();
    }

    @Override
    public ChannelHandler removeLast() {
        if (this.head.next == this.tail) {
            throw new NoSuchElementException();
        }
        return this.remove(this.tail.prev).handler();
    }

    @Override
    public ChannelPipeline replace(ChannelHandler oldHandler, String newName, ChannelHandler newHandler) {
        this.replace(this.getContextOrDie(oldHandler), newName, newHandler);
        return this;
    }

    @Override
    public ChannelHandler replace(String oldName, String newName, ChannelHandler newHandler) {
        return this.replace(this.getContextOrDie(oldName), newName, newHandler);
    }

    @Override
    public <T extends ChannelHandler> T replace(Class<T> oldHandlerType, String newName, ChannelHandler newHandler) {
        return (T)this.replace(this.getContextOrDie(oldHandlerType), newName, newHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelHandler replace(final AbstractChannelHandlerContext ctx2, final String newName, ChannelHandler newHandler) {
        Future<?> future;
        assert (ctx2 != this.head && ctx2 != this.tail);
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            DefaultChannelHandlerContext newCtx;
            boolean sameName = ctx2.name().equals(newName);
            if (!sameName) {
                this.checkDuplicateName(newName);
            }
            if (!(newCtx = new DefaultChannelHandlerContext(this, ctx2.executor, newName, newHandler)).channel().isRegistered() || newCtx.executor().inEventLoop()) {
                this.replace0(ctx2, newName, newCtx);
                return ctx2.handler();
            }
            future = newCtx.executor().submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DefaultChannelPipeline defaultChannelPipeline = DefaultChannelPipeline.this;
                    synchronized (defaultChannelPipeline) {
                        DefaultChannelPipeline.this.replace0(ctx2, newName, newCtx);
                    }
                }
            });
        }
        DefaultChannelPipeline.waitForFuture(future);
        return ctx2.handler();
    }

    private void replace0(AbstractChannelHandlerContext oldCtx, String newName, AbstractChannelHandlerContext newCtx) {
        DefaultChannelPipeline.checkMultiplicity(newCtx);
        AbstractChannelHandlerContext prev = oldCtx.prev;
        AbstractChannelHandlerContext next = oldCtx.next;
        newCtx.prev = prev;
        newCtx.next = next;
        prev.next = newCtx;
        next.prev = newCtx;
        if (!oldCtx.name().equals(newName)) {
            this.name2ctx.remove(oldCtx.name());
        }
        this.name2ctx.put(newName, newCtx);
        oldCtx.prev = newCtx;
        oldCtx.next = newCtx;
        this.callHandlerAdded(newCtx);
        this.callHandlerRemoved(oldCtx);
    }

    private static void checkMultiplicity(ChannelHandlerContext ctx2) {
        ChannelHandler handler = ctx2.handler();
        if (handler instanceof ChannelHandlerAdapter) {
            ChannelHandlerAdapter h2 = (ChannelHandlerAdapter)handler;
            if (!h2.isSharable() && h2.added) {
                throw new ChannelPipelineException(h2.getClass().getName() + " is not a @Sharable handler, so can't be added or removed multiple times.");
            }
            h2.added = true;
        }
    }

    private void callHandlerAdded(final ChannelHandlerContext ctx2) {
        if (ctx2.channel().isRegistered() && !ctx2.executor().inEventLoop()) {
            ctx2.executor().execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelPipeline.this.callHandlerAdded0(ctx2);
                }
            });
            return;
        }
        this.callHandlerAdded0(ctx2);
    }

    private void callHandlerAdded0(ChannelHandlerContext ctx2) {
        try {
            ctx2.handler().handlerAdded(ctx2);
        }
        catch (Throwable t2) {
            boolean removed;
            block5: {
                removed = false;
                try {
                    this.remove((AbstractChannelHandlerContext)ctx2);
                    removed = true;
                }
                catch (Throwable t22) {
                    if (!logger.isWarnEnabled()) break block5;
                    logger.warn("Failed to remove a handler: " + ctx2.name(), t22);
                }
            }
            if (removed) {
                this.fireExceptionCaught(new ChannelPipelineException(ctx2.handler().getClass().getName() + ".handlerAdded() has thrown an exception; removed.", t2));
            }
            this.fireExceptionCaught(new ChannelPipelineException(ctx2.handler().getClass().getName() + ".handlerAdded() has thrown an exception; also failed to remove.", t2));
        }
    }

    private void callHandlerRemoved(final AbstractChannelHandlerContext ctx2) {
        if (ctx2.channel().isRegistered() && !ctx2.executor().inEventLoop()) {
            ctx2.executor().execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelPipeline.this.callHandlerRemoved0(ctx2);
                }
            });
            return;
        }
        this.callHandlerRemoved0(ctx2);
    }

    private void callHandlerRemoved0(AbstractChannelHandlerContext ctx2) {
        try {
            ctx2.handler().handlerRemoved(ctx2);
            ctx2.setRemoved();
        }
        catch (Throwable t2) {
            this.fireExceptionCaught(new ChannelPipelineException(ctx2.handler().getClass().getName() + ".handlerRemoved() has thrown an exception.", t2));
        }
    }

    private static void waitForFuture(java.util.concurrent.Future<?> future) {
        try {
            future.get();
        }
        catch (ExecutionException ex2) {
            PlatformDependent.throwException(ex2.getCause());
        }
        catch (InterruptedException ex3) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public ChannelHandler first() {
        ChannelHandlerContext first = this.firstContext();
        if (first == null) {
            return null;
        }
        return first.handler();
    }

    @Override
    public ChannelHandlerContext firstContext() {
        AbstractChannelHandlerContext first = this.head.next;
        if (first == this.tail) {
            return null;
        }
        return this.head.next;
    }

    @Override
    public ChannelHandler last() {
        AbstractChannelHandlerContext last = this.tail.prev;
        if (last == this.head) {
            return null;
        }
        return last.handler();
    }

    @Override
    public ChannelHandlerContext lastContext() {
        AbstractChannelHandlerContext last = this.tail.prev;
        if (last == this.head) {
            return null;
        }
        return last;
    }

    @Override
    public ChannelHandler get(String name) {
        ChannelHandlerContext ctx2 = this.context(name);
        if (ctx2 == null) {
            return null;
        }
        return ctx2.handler();
    }

    @Override
    public <T extends ChannelHandler> T get(Class<T> handlerType) {
        ChannelHandlerContext ctx2 = this.context(handlerType);
        if (ctx2 == null) {
            return null;
        }
        return (T)ctx2.handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelHandlerContext context(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            return this.name2ctx.get(name);
        }
    }

    @Override
    public ChannelHandlerContext context(ChannelHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        AbstractChannelHandlerContext ctx2 = this.head.next;
        while (ctx2 != null) {
            if (ctx2.handler() == handler) {
                return ctx2;
            }
            ctx2 = ctx2.next;
        }
        return null;
    }

    @Override
    public ChannelHandlerContext context(Class<? extends ChannelHandler> handlerType) {
        if (handlerType == null) {
            throw new NullPointerException("handlerType");
        }
        AbstractChannelHandlerContext ctx2 = this.head.next;
        while (ctx2 != null) {
            if (handlerType.isAssignableFrom(ctx2.handler().getClass())) {
                return ctx2;
            }
            ctx2 = ctx2.next;
        }
        return null;
    }

    @Override
    public List<String> names() {
        ArrayList<String> list = new ArrayList<String>();
        AbstractChannelHandlerContext ctx2 = this.head.next;
        while (ctx2 != null) {
            list.add(ctx2.name());
            ctx2 = ctx2.next;
        }
        return list;
    }

    @Override
    public Map<String, ChannelHandler> toMap() {
        LinkedHashMap<String, ChannelHandler> map = new LinkedHashMap<String, ChannelHandler>();
        AbstractChannelHandlerContext ctx2 = this.head.next;
        while (ctx2 != this.tail) {
            map.put(ctx2.name(), ctx2.handler());
            ctx2 = ctx2.next;
        }
        return map;
    }

    @Override
    public Iterator<Map.Entry<String, ChannelHandler>> iterator() {
        return this.toMap().entrySet().iterator();
    }

    public String toString() {
        StringBuilder buf2 = new StringBuilder();
        buf2.append(StringUtil.simpleClassName(this));
        buf2.append('{');
        AbstractChannelHandlerContext ctx2 = this.head.next;
        while (ctx2 != this.tail) {
            buf2.append('(');
            buf2.append(ctx2.name());
            buf2.append(" = ");
            buf2.append(ctx2.handler().getClass().getName());
            buf2.append(')');
            ctx2 = ctx2.next;
            if (ctx2 == this.tail) break;
            buf2.append(", ");
        }
        buf2.append('}');
        return buf2.toString();
    }

    @Override
    public ChannelPipeline fireChannelRegistered() {
        this.head.fireChannelRegistered();
        return this;
    }

    @Override
    public ChannelPipeline fireChannelUnregistered() {
        this.head.fireChannelUnregistered();
        if (!this.channel.isOpen()) {
            this.teardownAll();
        }
        return this;
    }

    private void teardownAll() {
        this.tail.prev.teardown();
    }

    @Override
    public ChannelPipeline fireChannelActive() {
        this.head.fireChannelActive();
        if (this.channel.config().isAutoRead()) {
            this.channel.read();
        }
        return this;
    }

    @Override
    public ChannelPipeline fireChannelInactive() {
        this.head.fireChannelInactive();
        return this;
    }

    @Override
    public ChannelPipeline fireExceptionCaught(Throwable cause) {
        this.head.fireExceptionCaught(cause);
        return this;
    }

    @Override
    public ChannelPipeline fireUserEventTriggered(Object event) {
        this.head.fireUserEventTriggered(event);
        return this;
    }

    @Override
    public ChannelPipeline fireChannelRead(Object msg) {
        this.head.fireChannelRead(msg);
        return this;
    }

    @Override
    public ChannelPipeline fireChannelReadComplete() {
        this.head.fireChannelReadComplete();
        if (this.channel.config().isAutoRead()) {
            this.read();
        }
        return this;
    }

    @Override
    public ChannelPipeline fireChannelWritabilityChanged() {
        this.head.fireChannelWritabilityChanged();
        return this;
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress) {
        return this.tail.bind(localAddress);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.tail.connect(remoteAddress);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.tail.connect(remoteAddress, localAddress);
    }

    @Override
    public ChannelFuture disconnect() {
        return this.tail.disconnect();
    }

    @Override
    public ChannelFuture close() {
        return this.tail.close();
    }

    @Override
    public ChannelFuture deregister() {
        return this.tail.deregister();
    }

    @Override
    public ChannelPipeline flush() {
        this.tail.flush();
        return this;
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        return this.tail.bind(localAddress, promise);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        return this.tail.connect(remoteAddress, promise);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        return this.tail.connect(remoteAddress, localAddress, promise);
    }

    @Override
    public ChannelFuture disconnect(ChannelPromise promise) {
        return this.tail.disconnect(promise);
    }

    @Override
    public ChannelFuture close(ChannelPromise promise) {
        return this.tail.close(promise);
    }

    @Override
    public ChannelFuture deregister(ChannelPromise promise) {
        return this.tail.deregister(promise);
    }

    @Override
    public ChannelPipeline read() {
        this.tail.read();
        return this;
    }

    @Override
    public ChannelFuture write(Object msg) {
        return this.tail.write(msg);
    }

    @Override
    public ChannelFuture write(Object msg, ChannelPromise promise) {
        return this.tail.write(msg, promise);
    }

    @Override
    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        return this.tail.writeAndFlush(msg, promise);
    }

    @Override
    public ChannelFuture writeAndFlush(Object msg) {
        return this.tail.writeAndFlush(msg);
    }

    private void checkDuplicateName(String name) {
        if (this.name2ctx.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate handler name: " + name);
        }
    }

    private AbstractChannelHandlerContext getContextOrDie(String name) {
        AbstractChannelHandlerContext ctx2 = (AbstractChannelHandlerContext)this.context(name);
        if (ctx2 == null) {
            throw new NoSuchElementException(name);
        }
        return ctx2;
    }

    private AbstractChannelHandlerContext getContextOrDie(ChannelHandler handler) {
        AbstractChannelHandlerContext ctx2 = (AbstractChannelHandlerContext)this.context(handler);
        if (ctx2 == null) {
            throw new NoSuchElementException(handler.getClass().getName());
        }
        return ctx2;
    }

    private AbstractChannelHandlerContext getContextOrDie(Class<? extends ChannelHandler> handlerType) {
        AbstractChannelHandlerContext ctx2 = (AbstractChannelHandlerContext)this.context(handlerType);
        if (ctx2 == null) {
            throw new NoSuchElementException(handlerType.getName());
        }
        return ctx2;
    }

    static /* synthetic */ String access$300(Class x0) {
        return DefaultChannelPipeline.generateName0(x0);
    }

    static {
        for (int i2 = 0; i2 < nameCaches.length; ++i2) {
            DefaultChannelPipeline.nameCaches[i2] = new WeakHashMap();
        }
    }

    static final class HeadContext
    extends AbstractChannelHandlerContext
    implements ChannelOutboundHandler {
        private static final String HEAD_NAME = DefaultChannelPipeline.access$300(HeadContext.class);
        protected final Channel.Unsafe unsafe;

        HeadContext(DefaultChannelPipeline pipeline) {
            super(pipeline, null, HEAD_NAME, false, true);
            this.unsafe = pipeline.channel().unsafe();
        }

        @Override
        public ChannelHandler handler() {
            return this;
        }

        @Override
        public void handlerAdded(ChannelHandlerContext ctx2) throws Exception {
        }

        @Override
        public void handlerRemoved(ChannelHandlerContext ctx2) throws Exception {
        }

        @Override
        public void bind(ChannelHandlerContext ctx2, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            this.unsafe.bind(localAddress, promise);
        }

        @Override
        public void connect(ChannelHandlerContext ctx2, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            this.unsafe.connect(remoteAddress, localAddress, promise);
        }

        @Override
        public void disconnect(ChannelHandlerContext ctx2, ChannelPromise promise) throws Exception {
            this.unsafe.disconnect(promise);
        }

        @Override
        public void close(ChannelHandlerContext ctx2, ChannelPromise promise) throws Exception {
            this.unsafe.close(promise);
        }

        @Override
        public void deregister(ChannelHandlerContext ctx2, ChannelPromise promise) throws Exception {
            this.unsafe.deregister(promise);
        }

        @Override
        public void read(ChannelHandlerContext ctx2) {
            this.unsafe.beginRead();
        }

        @Override
        public void write(ChannelHandlerContext ctx2, Object msg, ChannelPromise promise) throws Exception {
            this.unsafe.write(msg, promise);
        }

        @Override
        public void flush(ChannelHandlerContext ctx2) throws Exception {
            this.unsafe.flush();
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx2, Throwable cause) throws Exception {
            ctx2.fireExceptionCaught(cause);
        }
    }

    static final class TailContext
    extends AbstractChannelHandlerContext
    implements ChannelInboundHandler {
        private static final String TAIL_NAME = DefaultChannelPipeline.access$300(TailContext.class);

        TailContext(DefaultChannelPipeline pipeline) {
            super(pipeline, null, TAIL_NAME, true, false);
        }

        @Override
        public ChannelHandler handler() {
            return this;
        }

        @Override
        public void channelRegistered(ChannelHandlerContext ctx2) throws Exception {
        }

        @Override
        public void channelUnregistered(ChannelHandlerContext ctx2) throws Exception {
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx2) throws Exception {
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx2) throws Exception {
        }

        @Override
        public void channelWritabilityChanged(ChannelHandlerContext ctx2) throws Exception {
        }

        @Override
        public void handlerAdded(ChannelHandlerContext ctx2) throws Exception {
        }

        @Override
        public void handlerRemoved(ChannelHandlerContext ctx2) throws Exception {
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx2, Object evt) throws Exception {
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx2, Throwable cause) throws Exception {
            logger.warn("An exceptionCaught() event was fired, and it reached at the tail of the pipeline. It usually means the last handler in the pipeline did not handle the exception.", cause);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelRead(ChannelHandlerContext ctx2, Object msg) throws Exception {
            try {
                logger.debug("Discarded inbound message {} that reached at the tail of the pipeline. Please check your pipeline configuration.", msg);
            }
            finally {
                ReferenceCountUtil.release(msg);
            }
        }

        @Override
        public void channelReadComplete(ChannelHandlerContext ctx2) throws Exception {
        }
    }
}

