/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieEncoderUtil;
import io.netty.handler.codec.http.DefaultCookie;

public final class ClientCookieEncoder {
    public static String encode(String name, String value) {
        return ClientCookieEncoder.encode((Cookie)new DefaultCookie(name, value));
    }

    public static String encode(Cookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie");
        }
        StringBuilder buf2 = CookieEncoderUtil.stringBuilder();
        ClientCookieEncoder.encode(buf2, cookie);
        return CookieEncoderUtil.stripTrailingSeparator(buf2);
    }

    public static String encode(Cookie ... cookies) {
        if (cookies == null) {
            throw new NullPointerException("cookies");
        }
        StringBuilder buf2 = CookieEncoderUtil.stringBuilder();
        for (Cookie c2 : cookies) {
            if (c2 == null) break;
            ClientCookieEncoder.encode(buf2, c2);
        }
        return CookieEncoderUtil.stripTrailingSeparator(buf2);
    }

    public static String encode(Iterable<Cookie> cookies) {
        if (cookies == null) {
            throw new NullPointerException("cookies");
        }
        StringBuilder buf2 = CookieEncoderUtil.stringBuilder();
        for (Cookie c2 : cookies) {
            if (c2 == null) break;
            ClientCookieEncoder.encode(buf2, c2);
        }
        return CookieEncoderUtil.stripTrailingSeparator(buf2);
    }

    private static void encode(StringBuilder buf2, Cookie c2) {
        if (c2.getVersion() >= 1) {
            CookieEncoderUtil.add(buf2, "$Version", 1L);
        }
        CookieEncoderUtil.add(buf2, c2.getName(), c2.getValue());
        if (c2.getPath() != null) {
            CookieEncoderUtil.add(buf2, "$Path", c2.getPath());
        }
        if (c2.getDomain() != null) {
            CookieEncoderUtil.add(buf2, "$Domain", c2.getDomain());
        }
        if (c2.getVersion() >= 1 && !c2.getPorts().isEmpty()) {
            buf2.append('$');
            buf2.append("Port");
            buf2.append('=');
            buf2.append('\"');
            for (int port : c2.getPorts()) {
                buf2.append(port);
                buf2.append(',');
            }
            buf2.setCharAt(buf2.length() - 1, '\"');
            buf2.append(';');
            buf2.append(' ');
        }
    }

    private ClientCookieEncoder() {
    }
}

