/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpObject;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.internal.StringUtil;
import java.util.Map;

public abstract class DefaultHttpMessage
extends DefaultHttpObject
implements HttpMessage {
    private HttpVersion version;
    private final HttpHeaders headers;

    protected DefaultHttpMessage(HttpVersion version) {
        this(version, true);
    }

    protected DefaultHttpMessage(HttpVersion version, boolean validate) {
        if (version == null) {
            throw new NullPointerException("version");
        }
        this.version = version;
        this.headers = new DefaultHttpHeaders(validate);
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public HttpVersion getProtocolVersion() {
        return this.version;
    }

    public String toString() {
        StringBuilder buf2 = new StringBuilder();
        buf2.append(StringUtil.simpleClassName(this));
        buf2.append("(version: ");
        buf2.append(this.getProtocolVersion().text());
        buf2.append(", keepAlive: ");
        buf2.append(HttpHeaders.isKeepAlive(this));
        buf2.append(')');
        buf2.append(StringUtil.NEWLINE);
        this.appendHeaders(buf2);
        buf2.setLength(buf2.length() - StringUtil.NEWLINE.length());
        return buf2.toString();
    }

    @Override
    public HttpMessage setProtocolVersion(HttpVersion version) {
        if (version == null) {
            throw new NullPointerException("version");
        }
        this.version = version;
        return this;
    }

    void appendHeaders(StringBuilder buf2) {
        for (Map.Entry e2 : this.headers()) {
            buf2.append((String)e2.getKey());
            buf2.append(": ");
            buf2.append((String)e2.getValue());
            buf2.append(StringUtil.NEWLINE);
        }
    }
}

