/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieEncoderUtil;
import io.netty.handler.codec.http.DefaultCookie;
import io.netty.handler.codec.http.HttpHeaderDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public final class ServerCookieEncoder {
    public static String encode(String name, String value) {
        return ServerCookieEncoder.encode((Cookie)new DefaultCookie(name, value));
    }

    public static String encode(Cookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie");
        }
        StringBuilder buf2 = CookieEncoderUtil.stringBuilder();
        CookieEncoderUtil.add(buf2, cookie.getName(), cookie.getValue());
        if (cookie.getMaxAge() != Long.MIN_VALUE) {
            if (cookie.getVersion() == 0) {
                CookieEncoderUtil.addUnquoted(buf2, "Expires", HttpHeaderDateFormat.get().format(new Date(System.currentTimeMillis() + cookie.getMaxAge() * 1000L)));
            } else {
                CookieEncoderUtil.add(buf2, "Max-Age", cookie.getMaxAge());
            }
        }
        if (cookie.getPath() != null) {
            if (cookie.getVersion() > 0) {
                CookieEncoderUtil.add(buf2, "Path", cookie.getPath());
            } else {
                CookieEncoderUtil.addUnquoted(buf2, "Path", cookie.getPath());
            }
        }
        if (cookie.getDomain() != null) {
            if (cookie.getVersion() > 0) {
                CookieEncoderUtil.add(buf2, "Domain", cookie.getDomain());
            } else {
                CookieEncoderUtil.addUnquoted(buf2, "Domain", cookie.getDomain());
            }
        }
        if (cookie.isSecure()) {
            buf2.append("Secure");
            buf2.append(';');
            buf2.append(' ');
        }
        if (cookie.isHttpOnly()) {
            buf2.append("HTTPOnly");
            buf2.append(';');
            buf2.append(' ');
        }
        if (cookie.getVersion() >= 1) {
            if (cookie.getComment() != null) {
                CookieEncoderUtil.add(buf2, "Comment", cookie.getComment());
            }
            CookieEncoderUtil.add(buf2, "Version", 1L);
            if (cookie.getCommentUrl() != null) {
                CookieEncoderUtil.addQuoted(buf2, "CommentURL", cookie.getCommentUrl());
            }
            if (!cookie.getPorts().isEmpty()) {
                buf2.append("Port");
                buf2.append('=');
                buf2.append('\"');
                for (int port : cookie.getPorts()) {
                    buf2.append(port);
                    buf2.append(',');
                }
                buf2.setCharAt(buf2.length() - 1, '\"');
                buf2.append(';');
                buf2.append(' ');
            }
            if (cookie.isDiscard()) {
                buf2.append("Discard");
                buf2.append(';');
                buf2.append(' ');
            }
        }
        return CookieEncoderUtil.stripTrailingSeparator(buf2);
    }

    public static List<String> encode(Cookie ... cookies) {
        if (cookies == null) {
            throw new NullPointerException("cookies");
        }
        ArrayList<String> encoded = new ArrayList<String>(cookies.length);
        for (Cookie c2 : cookies) {
            if (c2 == null) break;
            encoded.add(ServerCookieEncoder.encode(c2));
        }
        return encoded;
    }

    public static List<String> encode(Collection<Cookie> cookies) {
        if (cookies == null) {
            throw new NullPointerException("cookies");
        }
        ArrayList<String> encoded = new ArrayList<String>(cookies.size());
        for (Cookie c2 : cookies) {
            if (c2 == null) break;
            encoded.add(ServerCookieEncoder.encode(c2));
        }
        return encoded;
    }

    public static List<String> encode(Iterable<Cookie> cookies) {
        if (cookies == null) {
            throw new NullPointerException("cookies");
        }
        ArrayList<String> encoded = new ArrayList<String>();
        for (Cookie c2 : cookies) {
            if (c2 == null) break;
            encoded.add(ServerCookieEncoder.encode(c2));
        }
        return encoded;
    }

    private ServerCookieEncoder() {
    }
}

