/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.serialization;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.serialization.ClassResolver;
import io.netty.handler.codec.serialization.CompactObjectInputStream;

public class ObjectDecoder
extends LengthFieldBasedFrameDecoder {
    private final ClassResolver classResolver;

    public ObjectDecoder(ClassResolver classResolver) {
        this(0x100000, classResolver);
    }

    public ObjectDecoder(int maxObjectSize, ClassResolver classResolver) {
        super(maxObjectSize, 0, 4, 0, 4);
        this.classResolver = classResolver;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx2, ByteBuf in2) throws Exception {
        ByteBuf frame = (ByteBuf)super.decode(ctx2, in2);
        if (frame == null) {
            return null;
        }
        CompactObjectInputStream is2 = new CompactObjectInputStream(new ByteBufInputStream(frame), this.classResolver);
        Object result = is2.readObject();
        is2.close();
        return result;
    }

    @Override
    protected ByteBuf extractFrame(ChannelHandlerContext ctx2, ByteBuf buffer, int index, int length) {
        return buffer.slice(index, length);
    }
}

