/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.logging;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.logging.LogLevel;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;

@ChannelHandler.Sharable
public class LoggingHandler
extends ChannelDuplexHandler {
    private static final LogLevel DEFAULT_LEVEL;
    private static final String NEWLINE;
    private static final String[] BYTE2HEX;
    private static final String[] HEXPADDING;
    private static final String[] BYTEPADDING;
    private static final char[] BYTE2CHAR;
    protected final InternalLogger logger;
    protected final InternalLogLevel internalLevel;
    private final LogLevel level;

    public LoggingHandler() {
        this(DEFAULT_LEVEL);
    }

    public LoggingHandler(LogLevel level) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        this.logger = InternalLoggerFactory.getInstance(this.getClass());
        this.level = level;
        this.internalLevel = level.toInternalLevel();
    }

    public LoggingHandler(Class<?> clazz) {
        this(clazz, DEFAULT_LEVEL);
    }

    public LoggingHandler(Class<?> clazz, LogLevel level) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (level == null) {
            throw new NullPointerException("level");
        }
        this.logger = InternalLoggerFactory.getInstance(clazz);
        this.level = level;
        this.internalLevel = level.toInternalLevel();
    }

    public LoggingHandler(String name) {
        this(name, DEFAULT_LEVEL);
    }

    public LoggingHandler(String name, LogLevel level) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (level == null) {
            throw new NullPointerException("level");
        }
        this.logger = InternalLoggerFactory.getInstance(name);
        this.level = level;
        this.internalLevel = level.toInternalLevel();
    }

    public LogLevel level() {
        return this.level;
    }

    protected String format(ChannelHandlerContext ctx2, String message) {
        String chStr = ctx2.channel().toString();
        StringBuilder buf2 = new StringBuilder(chStr.length() + message.length() + 1);
        buf2.append(chStr);
        buf2.append(' ');
        buf2.append(message);
        return buf2.toString();
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx2) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "REGISTERED"));
        }
        super.channelRegistered(ctx2);
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx2) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "UNREGISTERED"));
        }
        super.channelUnregistered(ctx2);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx2) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "ACTIVE"));
        }
        super.channelActive(ctx2);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx2) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "INACTIVE"));
        }
        super.channelInactive(ctx2);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx2, Throwable cause) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "EXCEPTION: " + cause), cause);
        }
        super.exceptionCaught(ctx2, cause);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx2, Object evt) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "USER_EVENT: " + evt));
        }
        super.userEventTriggered(ctx2, evt);
    }

    @Override
    public void bind(ChannelHandlerContext ctx2, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "BIND(" + localAddress + ')'));
        }
        super.bind(ctx2, localAddress, promise);
    }

    @Override
    public void connect(ChannelHandlerContext ctx2, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "CONNECT(" + remoteAddress + ", " + localAddress + ')'));
        }
        super.connect(ctx2, remoteAddress, localAddress, promise);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx2, ChannelPromise promise) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "DISCONNECT()"));
        }
        super.disconnect(ctx2, promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx2, ChannelPromise promise) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "CLOSE()"));
        }
        super.close(ctx2, promise);
    }

    @Override
    public void deregister(ChannelHandlerContext ctx2, ChannelPromise promise) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "DEREGISTER()"));
        }
        super.deregister(ctx2, promise);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx2, Object msg) throws Exception {
        this.logMessage(ctx2, "RECEIVED", msg);
        ctx2.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx2, Object msg, ChannelPromise promise) throws Exception {
        this.logMessage(ctx2, "WRITE", msg);
        ctx2.write(msg, promise);
    }

    @Override
    public void flush(ChannelHandlerContext ctx2) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "FLUSH"));
        }
        ctx2.flush();
    }

    private void logMessage(ChannelHandlerContext ctx2, String eventName, Object msg) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, this.formatMessage(eventName, msg)));
        }
    }

    protected String formatMessage(String eventName, Object msg) {
        if (msg instanceof ByteBuf) {
            return this.formatByteBuf(eventName, (ByteBuf)msg);
        }
        if (msg instanceof ByteBufHolder) {
            return this.formatByteBufHolder(eventName, (ByteBufHolder)msg);
        }
        return this.formatNonByteBuf(eventName, msg);
    }

    protected String formatByteBuf(String eventName, ByteBuf buf2) {
        int i2;
        int length = buf2.readableBytes();
        int rows = length / 16 + (length % 15 == 0 ? 0 : 1) + 4;
        StringBuilder dump = new StringBuilder(rows * 80 + eventName.length() + 16);
        dump.append(eventName).append('(').append(length).append('B').append(')');
        dump.append(NEWLINE + "         +-------------------------------------------------+" + NEWLINE + "         |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |" + NEWLINE + "+--------+-------------------------------------------------+----------------+");
        int startIndex = buf2.readerIndex();
        int endIndex = buf2.writerIndex();
        for (i2 = startIndex; i2 < endIndex; ++i2) {
            int relIdx = i2 - startIndex;
            int relIdxMod16 = relIdx & 0xF;
            if (relIdxMod16 == 0) {
                dump.append(NEWLINE);
                dump.append(Long.toHexString((long)relIdx & 0xFFFFFFFFL | 0x100000000L));
                dump.setCharAt(dump.length() - 9, '|');
                dump.append('|');
            }
            dump.append(BYTE2HEX[buf2.getUnsignedByte(i2)]);
            if (relIdxMod16 != 15) continue;
            dump.append(" |");
            for (int j2 = i2 - 15; j2 <= i2; ++j2) {
                dump.append(BYTE2CHAR[buf2.getUnsignedByte(j2)]);
            }
            dump.append('|');
        }
        if ((i2 - startIndex & 0xF) != 0) {
            int remainder = length & 0xF;
            dump.append(HEXPADDING[remainder]);
            dump.append(" |");
            for (int j3 = i2 - remainder; j3 < i2; ++j3) {
                dump.append(BYTE2CHAR[buf2.getUnsignedByte(j3)]);
            }
            dump.append(BYTEPADDING[remainder]);
            dump.append('|');
        }
        dump.append(NEWLINE + "+--------+-------------------------------------------------+----------------+");
        return dump.toString();
    }

    protected String formatNonByteBuf(String eventName, Object msg) {
        return eventName + ": " + msg;
    }

    protected String formatByteBufHolder(String eventName, ByteBufHolder msg) {
        return this.formatByteBuf(eventName, msg.content());
    }

    static {
        int j2;
        StringBuilder buf2;
        int padding;
        int i2;
        DEFAULT_LEVEL = LogLevel.DEBUG;
        NEWLINE = StringUtil.NEWLINE;
        BYTE2HEX = new String[256];
        HEXPADDING = new String[16];
        BYTEPADDING = new String[16];
        BYTE2CHAR = new char[256];
        for (i2 = 0; i2 < BYTE2HEX.length; ++i2) {
            LoggingHandler.BYTE2HEX[i2] = ' ' + StringUtil.byteToHexStringPadded(i2);
        }
        for (i2 = 0; i2 < HEXPADDING.length; ++i2) {
            padding = HEXPADDING.length - i2;
            buf2 = new StringBuilder(padding * 3);
            for (j2 = 0; j2 < padding; ++j2) {
                buf2.append("   ");
            }
            LoggingHandler.HEXPADDING[i2] = buf2.toString();
        }
        for (i2 = 0; i2 < BYTEPADDING.length; ++i2) {
            padding = BYTEPADDING.length - i2;
            buf2 = new StringBuilder(padding);
            for (j2 = 0; j2 < padding; ++j2) {
                buf2.append(' ');
            }
            LoggingHandler.BYTEPADDING[i2] = buf2.toString();
        }
        for (i2 = 0; i2 < BYTE2CHAR.length; ++i2) {
            LoggingHandler.BYTE2CHAR[i2] = i2 <= 31 || i2 >= 127 ? 46 : (char)i2;
        }
    }
}

