/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.timeout;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.timeout.WriteTimeoutException;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class WriteTimeoutHandler
extends ChannelOutboundHandlerAdapter {
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final long timeoutNanos;
    private boolean closed;

    public WriteTimeoutHandler(int timeoutSeconds) {
        this(timeoutSeconds, TimeUnit.SECONDS);
    }

    public WriteTimeoutHandler(long timeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.timeoutNanos = timeout <= 0L ? 0L : Math.max(unit.toNanos(timeout), MIN_TIMEOUT_NANOS);
    }

    @Override
    public void write(ChannelHandlerContext ctx2, Object msg, ChannelPromise promise) throws Exception {
        this.scheduleTimeout(ctx2, promise);
        ctx2.write(msg, promise);
    }

    private void scheduleTimeout(final ChannelHandlerContext ctx2, final ChannelPromise future) {
        if (this.timeoutNanos > 0L) {
            final ScheduledFuture<?> sf2 = ctx2.executor().schedule(new Runnable(){

                @Override
                public void run() {
                    if (!future.isDone()) {
                        try {
                            WriteTimeoutHandler.this.writeTimedOut(ctx2);
                        }
                        catch (Throwable t2) {
                            ctx2.fireExceptionCaught(t2);
                        }
                    }
                }
            }, this.timeoutNanos, TimeUnit.NANOSECONDS);
            future.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    sf2.cancel(false);
                }
            });
        }
    }

    protected void writeTimedOut(ChannelHandlerContext ctx2) throws Exception {
        if (!this.closed) {
            ctx2.fireExceptionCaught(WriteTimeoutException.INSTANCE);
            ctx2.close();
            this.closed = true;
        }
    }
}

