/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.expr;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.optifine.expr.CV;
import net.optifine.expr.FX;
import net.optifine.expr.GB;
import net.optifine.expr.HD;
import net.optifine.expr.HE;
import net.optifine.expr.HJ;
import net.optifine.expr.IA;
import net.optifine.expr.IM;
import net.optifine.expr.NX;
import net.optifine.expr.QM;
import net.optifine.expr.ST;
import net.optifine.expr.TL;
import net.optifine.expr.UL;
import net.optifine.expr.VI;

public class IQ {
    private HD OM;

    public IQ(HD hD) {
        this.OM = hD;
    }

    public HJ OM(String string) throws NX {
        HE hE = this.MT(string);
        if (!(hE instanceof HJ)) {
            throw new NX("Not a float expression: " + (Object)((Object)hE.OM()));
        }
        return (HJ)hE;
    }

    public GB BN(String string) throws NX {
        HE hE = this.MT(string);
        if (!(hE instanceof GB)) {
            throw new NX("Not a boolean expression: " + (Object)((Object)hE.OM()));
        }
        return (GB)hE;
    }

    public HE MT(String string) throws NX {
        try {
            CV[] cVArray = VI.OM(string);
            if (cVArray == null) {
                return null;
            }
            ArrayDeque<CV> arrayDeque = new ArrayDeque<CV>(Arrays.asList(cVArray));
            return this.OM(arrayDeque);
        }
        catch (IOException iOException) {
            throw new NX(iOException.getMessage(), iOException);
        }
    }

    private HE OM(Deque deque) throws NX {
        if (deque.isEmpty()) {
            return null;
        }
        LinkedList<HE> linkedList = new LinkedList<HE>();
        LinkedList<CV> linkedList2 = new LinkedList<CV>();
        HE hE = this.BN(deque);
        IQ.OM(hE, "Missing expression");
        linkedList.add(hE);
        CV cV;
        while ((cV = (CV)deque.poll()) != null) {
            if (cV.OM() != QM.MT) {
                throw new NX("Invalid operator: " + cV);
            }
            HE hE2 = this.BN(deque);
            IQ.OM(hE2, "Missing expression");
            linkedList2.add(cV);
            linkedList.add(hE2);
        }
        return this.OM(linkedList, linkedList2);
    }

    private HE OM(List list, List list2) throws NX {
        LinkedList<TL> linkedList = new LinkedList<TL>();
        for (CV cV : list2) {
            TL tL = TL.OM(cV.BN());
            IQ.OM((Object)tL, "Invalid operator: " + cV);
            linkedList.add(tL);
        }
        return this.BN(list, linkedList);
    }

    private HE BN(List list, List list2) throws NX {
        if (list.size() != list2.size() + 1) {
            throw new NX("Invalid infix expression, expressions: " + list.size() + ", operators: " + list2.size());
        }
        if (list.size() == 1) {
            return (HE)list.get(0);
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        for (TL tL : list2) {
            n2 = Math.min(tL.BN(), n2);
            n3 = Math.max(tL.BN(), n3);
        }
        if (n3 >= n2 && n3 - n2 <= 10) {
            for (int i2 = n3; i2 >= n2; --i2) {
                this.OM(list, list2, i2);
            }
            if (list.size() == 1 && list2.size() == 0) {
                return (HE)list.get(0);
            }
            throw new NX("Error merging operators, expressions: " + list.size() + ", operators: " + list2.size());
        }
        throw new NX("Invalid infix precedence, min: " + n2 + ", max: " + n3);
    }

    private void OM(List list, List list2, int n2) throws NX {
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            TL tL = (TL)((Object)list2.get(i2));
            if (tL.BN() != n2) continue;
            list2.remove(i2);
            HE hE = (HE)list.remove(i2);
            HE hE2 = (HE)list.remove(i2);
            HE hE3 = IQ.OM(tL, new HE[]{hE, hE2});
            list.add(i2, hE3);
            --i2;
        }
    }

    private HE BN(Deque deque) throws NX {
        CV cV = (CV)deque.poll();
        IQ.OM(cV, "Missing expression");
        switch (cV.OM()) {
            case BN: {
                return IQ.OM(cV);
            }
            case OM: {
                TL tL = this.OM(cV, deque);
                if (tL != null) {
                    return this.OM(tL, deque);
                }
                return this.BN(cV);
            }
            case LS: {
                return this.BN(cV, deque);
            }
            case MT: {
                TL tL = TL.OM(cV.BN());
                IQ.OM((Object)tL, "Invalid operator: " + cV);
                if (tL == TL.OM) {
                    return this.BN(deque);
                }
                if (tL == TL.BN) {
                    HE hE = this.BN(deque);
                    return IQ.OM(TL.UK, new HE[]{hE});
                }
                if (tL != TL.FW) break;
                HE hE = this.BN(deque);
                return IQ.OM(TL.FW, new HE[]{hE});
            }
        }
        throw new NX("Invalid expression: " + cV);
    }

    private static HE OM(CV cV) throws NX {
        float f2 = bxl.OM(cV.BN(), Float.NaN);
        if (f2 == Float.NaN) {
            throw new NX("Invalid float value: " + cV);
        }
        return new FX(f2);
    }

    private TL OM(CV cV, Deque deque) throws NX {
        CV cV2 = (CV)deque.peek();
        if (cV != null && cV2.OM() == QM.LS) {
            TL tL = TL.OM(cV2.BN());
            IQ.OM((Object)tL, "Unknown function: " + cV2);
            return tL;
        }
        TL tL = TL.OM(cV2.BN());
        if (tL == null) {
            return null;
        }
        if (tL.OM(new HE[0]) > 0) {
            throw new NX("Missing arguments: " + (Object)((Object)tL));
        }
        return tL;
    }

    private HE OM(TL tL, Deque deque) throws NX {
        CV cV;
        if (tL.OM(new HE[0]) == 0 && ((cV = (CV)deque.peek()) == null || cV.OM() != QM.LS)) {
            return IQ.OM(tL, new HE[0]);
        }
        cV = (CV)deque.poll();
        Deque deque2 = IQ.OM(deque, QM.UK, true);
        HE[] hEArray = this.MT(deque2);
        return IQ.OM(tL, hEArray);
    }

    private HE[] MT(Deque deque) throws NX {
        ArrayList<HE> arrayList = new ArrayList<HE>();
        while (true) {
            Deque deque2;
            HE hE;
            if ((hE = this.OM(deque2 = IQ.OM(deque, QM.NN, false))) == null) {
                HE[] hEArray = arrayList.toArray(new HE[arrayList.size()]);
                return hEArray;
            }
            arrayList.add(hE);
        }
    }

    private static HE OM(TL tL, HE[] hEArray) throws NX {
        UL[] uLArray = tL.BN(hEArray);
        if (hEArray.length != uLArray.length) {
            throw new NX("Invalid number of arguments, function: \"" + tL.OM() + "\", count arguments: " + hEArray.length + ", should be: " + uLArray.length);
        }
        for (int i2 = 0; i2 < hEArray.length; ++i2) {
            UL uL;
            HE hE = hEArray[i2];
            UL uL2 = hE.OM();
            if (uL2 == (uL = uLArray[i2])) continue;
            throw new NX("Invalid argument type, function: \"" + tL.OM() + "\", index: " + i2 + ", type: " + (Object)((Object)uL2) + ", should be: " + (Object)((Object)uL));
        }
        if (tL.MT() == UL.OM) {
            return new ST(tL, hEArray);
        }
        if (tL.MT() == UL.MT) {
            return new IA(tL, hEArray);
        }
        if (tL.MT() == UL.BN) {
            return new IM(tL, hEArray);
        }
        throw new NX("Unknown function type: " + (Object)((Object)tL.MT()) + ", function: " + tL.OM());
    }

    private HE BN(CV cV) throws NX {
        if (this.OM == null) {
            throw new NX("Model variable not found: " + cV);
        }
        HE hE = this.OM.MT(cV.BN());
        if (hE == null) {
            throw new NX("Model variable not found: " + cV);
        }
        return hE;
    }

    private HE BN(CV cV, Deque deque) throws NX {
        Deque deque2 = IQ.OM(deque, QM.UK, true);
        return this.OM(deque2);
    }

    private static Deque OM(Deque deque, QM qM, boolean bl2) throws NX {
        ArrayDeque<CV> arrayDeque = new ArrayDeque<CV>();
        int n2 = 0;
        Iterator iterator = deque.iterator();
        while (iterator.hasNext()) {
            CV cV = (CV)iterator.next();
            iterator.remove();
            if (n2 == 0 && cV.OM() == qM) {
                return arrayDeque;
            }
            arrayDeque.add(cV);
            if (cV.OM() == QM.LS) {
                ++n2;
            }
            if (cV.OM() != QM.UK) continue;
            --n2;
        }
        if (bl2) {
            throw new NX("Missing end token: " + (Object)((Object)qM));
        }
        return arrayDeque;
    }

    private static void OM(Object object, String string) throws NX {
        if (object == null) {
            throw new NX(string);
        }
    }
}

