/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.helpers.Charsets;
import org.apache.logging.log4j.core.helpers.Throwables;
import org.apache.logging.log4j.core.helpers.Transform;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MultiformatMessage;

@Plugin(name="JSONLayout", category="Core", elementType="layout", printObject=true)
public class JSONLayout
extends AbstractStringLayout {
    private static final int DEFAULT_SIZE = 256;
    private static final String DEFAULT_EOL = "\r\n";
    private static final String COMPACT_EOL = "";
    private static final String DEFAULT_INDENT = "  ";
    private static final String COMPACT_INDENT = "";
    private static final String[] FORMATS = new String[]{"json"};
    private final boolean locationInfo;
    private final boolean properties;
    private final boolean complete;
    private final String eol;
    private final String indent1;
    private final String indent2;
    private final String indent3;
    private final String indent4;
    private volatile boolean firstLayoutDone;

    protected JSONLayout(boolean locationInfo, boolean properties, boolean complete, boolean compact, Charset charset) {
        super(charset);
        this.locationInfo = locationInfo;
        this.properties = properties;
        this.complete = complete;
        this.eol = compact ? "" : DEFAULT_EOL;
        this.indent1 = compact ? "" : DEFAULT_INDENT;
        this.indent2 = this.indent1 + this.indent1;
        this.indent3 = this.indent2 + this.indent1;
        this.indent4 = this.indent3 + this.indent1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toSerializable(LogEvent event) {
        Throwable throwable;
        StringBuilder buf2 = new StringBuilder(256);
        boolean check = this.firstLayoutDone;
        if (!this.firstLayoutDone) {
            JSONLayout jSONLayout = this;
            synchronized (jSONLayout) {
                check = this.firstLayoutDone;
                if (!check) {
                    this.firstLayoutDone = true;
                } else {
                    buf2.append(',');
                    buf2.append(this.eol);
                }
            }
        } else {
            buf2.append(',');
            buf2.append(this.eol);
        }
        buf2.append(this.indent1);
        buf2.append('{');
        buf2.append(this.eol);
        buf2.append(this.indent2);
        buf2.append("\"logger\":\"");
        String name = event.getLoggerName();
        if (name.isEmpty()) {
            name = "root";
        }
        buf2.append(Transform.escapeJsonControlCharacters(name));
        buf2.append("\",");
        buf2.append(this.eol);
        buf2.append(this.indent2);
        buf2.append("\"timestamp\":\"");
        buf2.append(event.getMillis());
        buf2.append("\",");
        buf2.append(this.eol);
        buf2.append(this.indent2);
        buf2.append("\"level\":\"");
        buf2.append(Transform.escapeJsonControlCharacters(String.valueOf(event.getLevel())));
        buf2.append("\",");
        buf2.append(this.eol);
        buf2.append(this.indent2);
        buf2.append("\"thread\":\"");
        buf2.append(Transform.escapeJsonControlCharacters(event.getThreadName()));
        buf2.append("\",");
        buf2.append(this.eol);
        Message msg = event.getMessage();
        if (msg != null) {
            boolean jsonSupported = false;
            if (msg instanceof MultiformatMessage) {
                String[] formats;
                for (String format : formats = ((MultiformatMessage)msg).getFormats()) {
                    if (!format.equalsIgnoreCase("JSON")) continue;
                    jsonSupported = true;
                    break;
                }
            }
            buf2.append(this.indent2);
            buf2.append("\"message\":\"");
            if (jsonSupported) {
                buf2.append(((MultiformatMessage)msg).getFormattedMessage(FORMATS));
            } else {
                Transform.appendEscapingCDATA(buf2, event.getMessage().getFormattedMessage());
            }
            buf2.append('\"');
        }
        if (event.getContextStack().getDepth() > 0) {
            buf2.append(",");
            buf2.append(this.eol);
            buf2.append("\"ndc\":");
            Transform.appendEscapingCDATA(buf2, event.getContextStack().toString());
            buf2.append("\"");
        }
        if ((throwable = event.getThrown()) != null) {
            buf2.append(",");
            buf2.append(this.eol);
            buf2.append(this.indent2);
            buf2.append("\"throwable\":\"");
            List<String> list = Throwables.toStringList(throwable);
            for (String str : list) {
                buf2.append(Transform.escapeJsonControlCharacters(str));
                buf2.append("\\\\n");
            }
            buf2.append("\"");
        }
        if (this.locationInfo) {
            StackTraceElement element = event.getSource();
            buf2.append(",");
            buf2.append(this.eol);
            buf2.append(this.indent2);
            buf2.append("\"LocationInfo\":{");
            buf2.append(this.eol);
            buf2.append(this.indent3);
            buf2.append("\"class\":\"");
            buf2.append(Transform.escapeJsonControlCharacters(element.getClassName()));
            buf2.append("\",");
            buf2.append(this.eol);
            buf2.append(this.indent3);
            buf2.append("\"method\":\"");
            buf2.append(Transform.escapeJsonControlCharacters(element.getMethodName()));
            buf2.append("\",");
            buf2.append(this.eol);
            buf2.append(this.indent3);
            buf2.append("\"file\":\"");
            buf2.append(Transform.escapeJsonControlCharacters(element.getFileName()));
            buf2.append("\",");
            buf2.append(this.eol);
            buf2.append(this.indent3);
            buf2.append("\"line\":\"");
            buf2.append(element.getLineNumber());
            buf2.append("\"");
            buf2.append(this.eol);
            buf2.append(this.indent2);
            buf2.append("}");
        }
        if (this.properties && event.getContextMap().size() > 0) {
            buf2.append(",");
            buf2.append(this.eol);
            buf2.append(this.indent2);
            buf2.append("\"Properties\":[");
            buf2.append(this.eol);
            Set<Map.Entry<String, String>> entrySet = event.getContextMap().entrySet();
            int i2 = 1;
            for (Map.Entry<String, String> entry : entrySet) {
                buf2.append(this.indent3);
                buf2.append('{');
                buf2.append(this.eol);
                buf2.append(this.indent4);
                buf2.append("\"name\":\"");
                buf2.append(Transform.escapeJsonControlCharacters(entry.getKey()));
                buf2.append("\",");
                buf2.append(this.eol);
                buf2.append(this.indent4);
                buf2.append("\"value\":\"");
                buf2.append(Transform.escapeJsonControlCharacters(String.valueOf(entry.getValue())));
                buf2.append("\"");
                buf2.append(this.eol);
                buf2.append(this.indent3);
                buf2.append("}");
                if (i2 < entrySet.size()) {
                    buf2.append(",");
                }
                buf2.append(this.eol);
                ++i2;
            }
            buf2.append(this.indent2);
            buf2.append("]");
        }
        buf2.append(this.eol);
        buf2.append(this.indent1);
        buf2.append("}");
        return buf2.toString();
    }

    @Override
    public byte[] getHeader() {
        if (!this.complete) {
            return null;
        }
        StringBuilder buf2 = new StringBuilder();
        buf2.append('[');
        buf2.append(this.eol);
        return buf2.toString().getBytes(this.getCharset());
    }

    @Override
    public byte[] getFooter() {
        if (!this.complete) {
            return null;
        }
        return (this.eol + "]" + this.eol).getBytes(this.getCharset());
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("version", "2.0");
        return result;
    }

    @Override
    public String getContentType() {
        return "application/json; charset=" + this.getCharset();
    }

    @PluginFactory
    public static JSONLayout createLayout(@PluginAttribute(value="locationInfo") String locationInfo, @PluginAttribute(value="properties") String properties, @PluginAttribute(value="complete") String completeStr, @PluginAttribute(value="compact") String compactStr, @PluginAttribute(value="charset") String charsetName) {
        Charset charset = Charsets.getSupportedCharset(charsetName, Charsets.UTF_8);
        boolean info = Boolean.parseBoolean(locationInfo);
        boolean props = Boolean.parseBoolean(properties);
        boolean complete = Boolean.parseBoolean(completeStr);
        boolean compact = Boolean.parseBoolean(compactStr);
        return new JSONLayout(info, props, complete, compact, charset);
    }
}

