/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import javax.servlet.ServletContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.impl.ContextAnchor;
import org.apache.logging.log4j.core.lookup.StrLookup;

@Plugin(name="web", category="Lookup")
public class WebLookup
implements StrLookup {
    private static final String ATTR_PREFIX = "attr.";
    private static final String INIT_PARAM_PREFIX = "initParam.";

    protected ServletContext getServletContext() {
        LoggerContext lc2 = ContextAnchor.THREAD_CONTEXT.get();
        if (lc2 == null) {
            lc2 = (LoggerContext)LogManager.getContext((boolean)false);
        }
        if (lc2 != null) {
            Object obj = lc2.getExternalContext();
            return obj != null && obj instanceof ServletContext ? (ServletContext)obj : null;
        }
        return null;
    }

    @Override
    public String lookup(String key) {
        ServletContext ctx2 = this.getServletContext();
        if (ctx2 == null) {
            return null;
        }
        if (key.startsWith(ATTR_PREFIX)) {
            String attrName = key.substring(ATTR_PREFIX.length());
            Object attrValue = ctx2.getAttribute(attrName);
            return attrValue == null ? null : attrValue.toString();
        }
        if (key.startsWith(INIT_PARAM_PREFIX)) {
            String paramName = key.substring(INIT_PARAM_PREFIX.length());
            return ctx2.getInitParameter(paramName);
        }
        if ("rootDir".equals(key)) {
            String root = ctx2.getRealPath("/");
            if (root == null) {
                String msg = "failed to resolve web:rootDir -- servlet container unable to translate virtual path  to real path (probably not deployed as exploded";
                throw new RuntimeException(msg);
            }
            return root;
        }
        if ("contextPath".equals(key)) {
            return ctx2.getContextPath();
        }
        if ("servletContextName".equals(key)) {
            return ctx2.getServletContextName();
        }
        if ("serverInfo".equals(key)) {
            return ctx2.getServerInfo();
        }
        if ("effectiveMajorVersion".equals(key)) {
            return String.valueOf(ctx2.getEffectiveMajorVersion());
        }
        if ("effectiveMinorVersion".equals(key)) {
            return String.valueOf(ctx2.getEffectiveMinorVersion());
        }
        if ("majorVersion".equals(key)) {
            return String.valueOf(ctx2.getMajorVersion());
        }
        if ("minorVersion".equals(key)) {
            return String.valueOf(ctx2.getMinorVersion());
        }
        if (ctx2.getAttribute(key) != null) {
            return ctx2.getAttribute(key).toString();
        }
        if (ctx2.getInitParameter(key) != null) {
            return ctx2.getInitParameter(key);
        }
        ctx2.log(this.getClass().getName() + " unable to resolve key '" + key + "'");
        return null;
    }

    @Override
    public String lookup(LogEvent event, String key) {
        return this.lookup(key);
    }
}

