/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.selector;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.helpers.Loader;
import org.apache.logging.log4j.core.impl.ContextAnchor;
import org.apache.logging.log4j.core.impl.ReflectiveCallerClassUtility;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.status.StatusLogger;

public class ClassLoaderContextSelector
implements ContextSelector {
    private static final AtomicReference<LoggerContext> CONTEXT = new AtomicReference();
    private static final PrivateSecurityManager SECURITY_MANAGER;
    private static final StatusLogger LOGGER;
    private static final ConcurrentMap<String, AtomicReference<WeakReference<LoggerContext>>> CONTEXT_MAP;

    @Override
    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext) {
        return this.getContext(fqcn, loader, currentContext, null);
    }

    @Override
    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext, URI configLocation) {
        LoggerContext lc2;
        boolean next;
        Class clazz;
        if (currentContext) {
            LoggerContext ctx2 = ContextAnchor.THREAD_CONTEXT.get();
            if (ctx2 != null) {
                return ctx2;
            }
            return this.getDefault();
        }
        if (loader != null) {
            return this.locateContext(loader, configLocation);
        }
        if (ReflectiveCallerClassUtility.isSupported()) {
            try {
                clazz = Class.class;
                next = false;
                int index = 2;
                while (clazz != null && (clazz = ReflectiveCallerClassUtility.getCaller(index)) != null) {
                    if (clazz.getName().equals(fqcn)) {
                        next = true;
                    } else if (next) break;
                    ++index;
                }
                if (clazz != null) {
                    return this.locateContext(clazz.getClassLoader(), configLocation);
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
        if (SECURITY_MANAGER != null && (clazz = SECURITY_MANAGER.getCaller(fqcn)) != null) {
            ClassLoader ldr = clazz.getClassLoader() != null ? clazz.getClassLoader() : ClassLoader.getSystemClassLoader();
            return this.locateContext(ldr, configLocation);
        }
        Throwable t2 = new Throwable();
        next = false;
        String name = null;
        for (StackTraceElement element : t2.getStackTrace()) {
            if (element.getClassName().equals(fqcn)) {
                next = true;
                continue;
            }
            if (!next) continue;
            name = element.getClassName();
            break;
        }
        if (name != null) {
            try {
                return this.locateContext(Loader.loadClass(name).getClassLoader(), configLocation);
            }
            catch (ClassNotFoundException ignore) {
                // empty catch block
            }
        }
        if ((lc2 = ContextAnchor.THREAD_CONTEXT.get()) != null) {
            return lc2;
        }
        return this.getDefault();
    }

    @Override
    public void removeContext(LoggerContext context) {
        for (Map.Entry entry : CONTEXT_MAP.entrySet()) {
            LoggerContext ctx2 = (LoggerContext)((WeakReference)((AtomicReference)entry.getValue()).get()).get();
            if (ctx2 != context) continue;
            CONTEXT_MAP.remove(entry.getKey());
        }
    }

    @Override
    public List<LoggerContext> getLoggerContexts() {
        ArrayList<LoggerContext> list = new ArrayList<LoggerContext>();
        Collection coll = CONTEXT_MAP.values();
        for (AtomicReference ref : coll) {
            LoggerContext ctx2 = (LoggerContext)((WeakReference)ref.get()).get();
            if (ctx2 == null) continue;
            list.add(ctx2);
        }
        return Collections.unmodifiableList(list);
    }

    private LoggerContext locateContext(ClassLoader loader, URI configLocation) {
        String name = loader.toString();
        AtomicReference ref = (AtomicReference)CONTEXT_MAP.get(name);
        if (ref == null) {
            Object r2;
            if (configLocation == null) {
                for (ClassLoader parent = loader.getParent(); parent != null; parent = parent.getParent()) {
                    LoggerContext ctx2;
                    ref = (AtomicReference)CONTEXT_MAP.get(parent.toString());
                    if (ref == null || (ctx2 = (LoggerContext)((Reference)(r2 = (WeakReference)ref.get())).get()) == null) continue;
                    return ctx2;
                }
            }
            LoggerContext ctx3 = new LoggerContext(name, null, configLocation);
            r2 = new AtomicReference<WeakReference<LoggerContext>>();
            ((AtomicReference)r2).set(new WeakReference<LoggerContext>(ctx3));
            CONTEXT_MAP.putIfAbsent(loader.toString(), (AtomicReference<WeakReference<LoggerContext>>)r2);
            ctx3 = (LoggerContext)((WeakReference)((AtomicReference)CONTEXT_MAP.get(name)).get()).get();
            return ctx3;
        }
        WeakReference r3 = (WeakReference)ref.get();
        LoggerContext ctx4 = (LoggerContext)r3.get();
        if (ctx4 != null) {
            if (ctx4.getConfigLocation() == null && configLocation != null) {
                LOGGER.debug("Setting configuration to {}", new Object[]{configLocation});
                ctx4.setConfigLocation(configLocation);
            } else if (ctx4.getConfigLocation() != null && configLocation != null && !ctx4.getConfigLocation().equals(configLocation)) {
                LOGGER.warn("locateContext called with URI {}. Existing LoggerContext has URI {}", new Object[]{configLocation, ctx4.getConfigLocation()});
            }
            return ctx4;
        }
        ctx4 = new LoggerContext(name, null, configLocation);
        ref.compareAndSet(r3, new WeakReference<LoggerContext>(ctx4));
        return ctx4;
    }

    private LoggerContext getDefault() {
        LoggerContext ctx2 = CONTEXT.get();
        if (ctx2 != null) {
            return ctx2;
        }
        CONTEXT.compareAndSet(null, new LoggerContext("Default"));
        return CONTEXT.get();
    }

    static {
        LOGGER = StatusLogger.getLogger();
        CONTEXT_MAP = new ConcurrentHashMap<String, AtomicReference<WeakReference<LoggerContext>>>();
        if (ReflectiveCallerClassUtility.isSupported()) {
            SECURITY_MANAGER = null;
        } else {
            PrivateSecurityManager securityManager;
            try {
                securityManager = new PrivateSecurityManager();
                if (securityManager.getCaller(ClassLoaderContextSelector.class.getName()) == null) {
                    securityManager = null;
                    LOGGER.error("Unable to obtain call stack from security manager.");
                }
            }
            catch (Exception e2) {
                securityManager = null;
                LOGGER.debug("Unable to install security manager", (Throwable)e2);
            }
            SECURITY_MANAGER = securityManager;
        }
    }

    private static class PrivateSecurityManager
    extends SecurityManager {
        private PrivateSecurityManager() {
        }

        public Class<?> getCaller(String fqcn) {
            Class<?>[] classes = this.getClassContext();
            boolean next = false;
            for (Class<?> clazz : classes) {
                if (clazz.getName().equals(fqcn)) {
                    next = true;
                    continue;
                }
                if (!next) continue;
                return clazz;
            }
            return null;
        }
    }
}

