/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus;

import com.tmtravlr.lootplusplus.LootPPBlocks;
import com.tmtravlr.lootplusplus.LootPPCommonProxy;
import com.tmtravlr.lootplusplus.LootPPHelper;
import com.tmtravlr.lootplusplus.LootPPIDFileGenerator;
import com.tmtravlr.lootplusplus.LootPPItems;
import com.tmtravlr.lootplusplus.additions.EntityAddedThrownItem;
import com.tmtravlr.lootplusplus.additions.TileEntityAddedFurnace;
import com.tmtravlr.lootplusplus.commands.BlockCommandBlockTrigger;
import com.tmtravlr.lootplusplus.commands.BlockCommandTrigger;
import com.tmtravlr.lootplusplus.commands.ItemCommandTrigger;
import com.tmtravlr.lootplusplus.commands.LPPCommandCondition;
import com.tmtravlr.lootplusplus.commands.LPPCommandDamage;
import com.tmtravlr.lootplusplus.commands.LPPCommandDamageItem;
import com.tmtravlr.lootplusplus.commands.LPPCommandEffect;
import com.tmtravlr.lootplusplus.commands.LPPCommandEntityData;
import com.tmtravlr.lootplusplus.commands.LPPCommandExplode;
import com.tmtravlr.lootplusplus.commands.LPPCommandGenLoot;
import com.tmtravlr.lootplusplus.commands.LPPCommandLock;
import com.tmtravlr.lootplusplus.commands.LPPCommandMount;
import com.tmtravlr.lootplusplus.commands.LPPCommandNBTDump;
import com.tmtravlr.lootplusplus.commands.LPPCommandTeleport;
import com.tmtravlr.lootplusplus.commands.TileEntityCommandTrigger;
import com.tmtravlr.lootplusplus.config.ConfigExtrasLoader;
import com.tmtravlr.lootplusplus.config.ConfigLoaderBlockDrops;
import com.tmtravlr.lootplusplus.config.ConfigLoaderBlocks;
import com.tmtravlr.lootplusplus.config.ConfigLoaderChestLoot;
import com.tmtravlr.lootplusplus.config.ConfigLoaderEffects;
import com.tmtravlr.lootplusplus.config.ConfigLoaderEntityDrops;
import com.tmtravlr.lootplusplus.config.ConfigLoaderFishingLoot;
import com.tmtravlr.lootplusplus.config.ConfigLoaderFurnaceRecipes;
import com.tmtravlr.lootplusplus.config.ConfigLoaderGeneral;
import com.tmtravlr.lootplusplus.config.ConfigLoaderItems;
import com.tmtravlr.lootplusplus.config.ConfigLoaderOreDict;
import com.tmtravlr.lootplusplus.config.ConfigLoaderRecipes;
import com.tmtravlr.lootplusplus.config.ConfigLoaderRecords;
import com.tmtravlr.lootplusplus.config.ConfigLoaderStackSize;
import com.tmtravlr.lootplusplus.config.ConfigLoaderWorldGen;
import com.tmtravlr.lootplusplus.loot.BlockLootChest;
import com.tmtravlr.lootplusplus.loot.ItemBlockLootChest;
import com.tmtravlr.lootplusplus.loot.ItemLootItem;
import com.tmtravlr.lootplusplus.loot.TileEntityLootChest;
import com.tmtravlr.lootplusplus.network.CToSMessage;
import com.tmtravlr.lootplusplus.network.PacketHandlerClient;
import com.tmtravlr.lootplusplus.network.PacketHandlerServer;
import com.tmtravlr.lootplusplus.network.SToCMessage;
import com.tmtravlr.lootplusplus.testing.BlockTestingEntitySpawner;
import com.tmtravlr.lootplusplus.testing.ItemTestingEntitySpawner;
import com.tmtravlr.lootplusplus.testing.TileEntityTestingEntitySpawner;
import com.tmtravlr.lootplusplus.worldGen.WorldGenSurfaceBlocks;
import com.tmtravlr.lootplusplus.worldGen.WorldGenUndergroundBlocks;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.command.ICommand;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="lootplusplus", name="Loot++", version="1.7.1_for_1.8", acceptedMinecraftVersions="[1.8]")
public class LootPlusPlusMod {
    public static final String MOD_ID = "lootplusplus";
    public static final String MOD_NAME = "Loot++";
    public static final String MOD_VERSION = "1.7.1_for_1.8";
    @Mod.Instance(value="lootplusplus")
    public static LootPlusPlusMod instance;
    @SidedProxy(clientSide="com.tmtravlr.lootplusplus.LootPPClientProxy", serverSide="com.tmtravlr.lootplusplus.LootPPCommonProxy")
    public static LootPPCommonProxy proxy;
    public static boolean debug;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        instance = this;
        int serverMessageID = 1;
        int clientMessageID = 2;
        LootPPHelper.lppNetworkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel(MOD_ID);
        LootPPHelper.lppNetworkWrapper.registerMessage(PacketHandlerServer.class, CToSMessage.class, serverMessageID, Side.SERVER);
        LootPPHelper.lppNetworkWrapper.registerMessage(PacketHandlerClient.class, SToCMessage.class, clientMessageID, Side.CLIENT);
        LootPPHelper.configFolder = new File(event.getSuggestedConfigurationFile().getParentFile(), MOD_NAME);
        if (!LootPPHelper.configFolder.exists()) {
            LootPPHelper.configFolder.mkdir();
        }
        if (!(LootPPHelper.idFolder = new File(LootPPHelper.configFolder, "IDs")).exists()) {
            LootPPHelper.idFolder.mkdir();
        }
        ConfigLoaderGeneral.instance.loadGeneral();
        LootPPBlocks.blockLootChest = new BlockLootChest(99).func_149711_c(2.5f).func_149672_a(Block.field_149766_f).func_149663_c("loot_chest");
        LootPPItems.itemLootItem = new ItemLootItem().func_77655_b("loot_item");
        LootPPBlocks.blockCommandBlockTrigger = new BlockCommandBlockTrigger().func_149663_c("command_block_trigger");
        LootPPBlocks.blockCommandTrigger = new BlockCommandTrigger().func_149663_c("command_trigger_block").func_149711_c(-1.0f).func_149752_b(6000000.0f);
        LootPPItems.itemCommandTrigger = new ItemCommandTrigger().func_77655_b("command_trigger_item").func_77625_d(1);
        LootPPBlocks.blockTestingSpawner = new BlockTestingEntitySpawner().func_149663_c("single_entity_spawner");
        LootPPItems.itemTestingSpawner = new ItemTestingEntitySpawner().func_77655_b("custom_spawn_egg");
        GameRegistry.registerItem((Item)LootPPItems.generalDummyIcon, (String)"dummy_tab_icon_present");
        GameRegistry.registerItem((Item)LootPPItems.additionsDummyIcon, (String)"dummy_tab_icon_record");
        GameRegistry.registerBlock((Block)LootPPBlocks.blockLootChest, ItemBlockLootChest.class, (String)"loot_chest");
        GameRegistry.registerItem((Item)LootPPItems.itemLootItem, (String)"loot_item");
        GameRegistry.registerBlock((Block)LootPPBlocks.blockTestingSpawner, (String)"single_entity_spawner");
        GameRegistry.registerItem((Item)LootPPItems.itemTestingSpawner, (String)"custom_spawn_egg");
        GameRegistry.registerBlock((Block)LootPPBlocks.blockCommandBlockTrigger, (String)"command_block_trigger");
        GameRegistry.registerBlock((Block)LootPPBlocks.blockCommandTrigger, (String)"command_trigger_block");
        GameRegistry.registerItem((Item)LootPPItems.itemCommandTrigger, (String)"command_trigger_item");
        GameRegistry.registerItem((Item)LootPPItems.itemNBTChecker, (String)"nbt_checker");
        GameRegistry.registerTileEntity(TileEntityTestingEntitySpawner.class, (String)"tile_single_entity_spawner");
        GameRegistry.registerTileEntity(TileEntityCommandTrigger.class, (String)"tile_command_trigger");
        GameRegistry.registerTileEntity(TileEntityAddedFurnace.class, (String)"tile_entity_added_furnace");
        GameRegistry.registerTileEntity(TileEntityLootChest.class, (String)"tile_entity_loot_chest");
        BlockDispenser.field_149943_a.func_82595_a((Object)LootPPItems.itemTestingSpawner, (Object)new BehaviorDefaultDispenseItem(){

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                EnumFacing enumfacing = BlockDispenser.func_149937_b((int)source.func_82620_h());
                double d0 = source.func_82615_a() + (double)enumfacing.func_82601_c();
                double d1 = (float)source.func_180699_d().func_177956_o() + 0.2f;
                double d2 = source.func_82616_c() + (double)enumfacing.func_82599_e();
                Entity entity = ItemTestingEntitySpawner.spawnEntity(source.func_82618_k(), stack, d0, d1, d2);
                if (entity instanceof EntityLivingBase && stack.func_82837_s()) {
                    ((EntityLiving)entity).func_96094_a(stack.func_82833_r());
                }
                stack.func_77979_a(1);
                return stack;
            }
        });
        proxy.registerEventHandlers();
        proxy.registerTickHandlers();
        GameRegistry.registerFuelHandler((IFuelHandler)LootPPHelper.fuelHandler);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenSurfaceBlocks(), (int)Integer.MAX_VALUE);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenUndergroundBlocks(), (int)Integer.MAX_VALUE);
        proxy.registerRenderers();
        EntityRegistry.registerModEntity(EntityAddedThrownItem.class, (String)"ThrownItem", (int)0, (Object)this, (int)80, (int)1, (boolean)true);
    }

    @Mod.EventHandler
    public void afterInit(FMLInterModComms.IMCEvent event) {
        ConfigExtrasLoader.loadAllExtras();
        ConfigLoaderRecords.instance.loadRecordConfig();
        ConfigLoaderBlocks.instance.loadBlockAdditions();
        ConfigLoaderItems.instance.loadItemAdditions();
        ConfigLoaderBlocks.instance.loadCropAdditions();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ConfigLoaderGeneral.instance.loadCreativeAdditions();
        ConfigLoaderStackSize.instance.loadStackSizes();
        ConfigLoaderWorldGen.instance.loadWorldGen();
        if (LootPPHelper.creepersDropAllRecords) {
            for (Object key : Item.field_150901_e.func_148742_b()) {
                if (!(Item.field_150901_e.func_82594_a(key) instanceof ItemRecord)) continue;
                ItemRecord record = (ItemRecord)Item.field_150901_e.func_82594_a(key);
                LootPPItems.allRecords.add(record);
            }
        }
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        if (!LootPPHelper.loadedDropsAndChestLoot) {
            ConfigLoaderChestLoot.instance.loadChestContent();
            ConfigLoaderFishingLoot.instance.loadFishingLoot();
            ConfigLoaderEntityDrops.instance.loadEntityDrops();
            ConfigLoaderBlockDrops.instance.loadBlockDrops();
            LootPPHelper.loadedDropsAndChestLoot = true;
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        if (debug) {
            System.out.println("[Loot++] Registering commands");
        }
        event.registerServerCommand((ICommand)new LPPCommandNBTDump());
        event.registerServerCommand((ICommand)new LPPCommandTeleport());
        event.registerServerCommand((ICommand)new LPPCommandMount());
        event.registerServerCommand((ICommand)new LPPCommandCondition());
        event.registerServerCommand((ICommand)new LPPCommandEffect());
        event.registerServerCommand((ICommand)new LPPCommandEntityData());
        event.registerServerCommand((ICommand)new LPPCommandGenLoot());
        event.registerServerCommand((ICommand)new LPPCommandLock());
        event.registerServerCommand((ICommand)new LPPCommandDamage());
        event.registerServerCommand((ICommand)new LPPCommandDamageItem());
        event.registerServerCommand((ICommand)new LPPCommandExplode());
        if (!LootPPHelper.loadedRecipes && MinecraftServer.func_71276_C().func_130014_f_() != null) {
            LootPlusPlusMod.loadRecipesAndSuch(MinecraftServer.func_71276_C().func_130014_f_());
            LootPPHelper.loadedRecipes = true;
        }
        if (LootPPHelper.generateFiles) {
            LootPPIDFileGenerator.generateDimensionIDFile();
        }
    }

    public static void loadRecipesAndSuch(World world) {
        if (LootPPHelper.generateFiles) {
            LootPPIDFileGenerator.generateIDFiles();
        }
        ConfigLoaderOreDict.instance.loadOreDict();
        ConfigLoaderRecipes.instance.loadRecipes(world);
        ConfigLoaderFurnaceRecipes.instance.loadFurnaceRecipes();
        ConfigLoaderEffects.instance.loadItemEffects();
    }

    static {
        debug = false;
        new LootPPHelper();
    }
}

