/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.additions;

import com.tmtravlr.lootplusplus.LootPPHelper;
import com.tmtravlr.lootplusplus.additions.EntityAddedThrownItem;
import com.tmtravlr.lootplusplus.additions.ItemAddedThrowable;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAddedBow
extends ItemBow {
    public static final DecimalFormat DECIMALFORMAT = new DecimalFormat("#.###");
    public String displayName = "";
    public float baseDamage = 0.0f;
    public int drawTime = 20;
    public int arrowCount = 1;
    public int enchantability = 1;
    public ItemStack repairStack;
    public Item ammoItem;
    public String shootingSound;

    public ItemAddedBow(String display, float damage, int time, int durability, int arrows, int enchant, ItemStack repairItem, Item ammo, String sound) {
        this.func_77637_a(LootPPHelper.tabLootPPAdditions);
        this.func_77656_e(durability);
        this.baseDamage = damage;
        this.drawTime = time;
        this.arrowCount = arrows;
        this.enchantability = enchant;
        this.repairStack = repairItem;
        this.displayName = display;
        this.ammoItem = ammo;
        this.shootingSound = sound;
    }

    public int getDrawTime(ItemStack stack) {
        int time = this.drawTime;
        if (stack == null || stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("ench")) {
            return this.drawTime;
        }
        NBTTagList enchList = stack.func_77978_p().func_150295_c("ench", 10);
        int size = enchList.func_74745_c();
        for (int i = 0; i < size; ++i) {
            int lvl;
            NBTTagCompound tag = enchList.func_150305_b(i);
            int id = tag.func_74762_e("id");
            Enchantment enchant = Enchantment.func_180306_c((int)id);
            if (!LootPPHelper.isQuickdraw(enchant) || (lvl = tag.func_74762_e("lvl")) <= 0) continue;
            time = time / 2 + time / (2 * (lvl + 1));
        }
        return time;
    }

    public String func_77653_i(ItemStack stack) {
        return StatCollector.func_74838_a((String)this.displayName).trim();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List tooltip, boolean advanced) {
        tooltip.add("");
        tooltip.add(EnumChatFormatting.BLUE + "+" + DECIMALFORMAT.format((float)this.getDrawTime(stack) / 20.0f) + StatCollector.func_74838_a((String)"bow.info.drawtime"));
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int amountDrawn) {
        if (!world.field_72995_K) {
            boolean flag;
            int j = this.func_77626_a(stack) - amountDrawn;
            boolean shouldContinue = true;
            boolean bl = flag = player.field_71075_bZ.field_75098_d || this.arrowCount == 0 || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)stack) > 0;
            if (this.ammoItem == Items.field_151032_g) {
                for (int i = 0; i < this.arrowCount; ++i) {
                    ArrowLooseEvent event = new ArrowLooseEvent(player, stack, j);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (event.isCanceled()) {
                        shouldContinue = false;
                    }
                    j = event.charge;
                }
            }
            if (shouldContinue && (flag || player.field_71071_by.func_146028_b(this.ammoItem))) {
                float drawAmount = (float)j / (float)this.getDrawTime(stack);
                if ((double)(drawAmount = (drawAmount * drawAmount + drawAmount * 2.0f) / 3.0f) < 0.1) {
                    return;
                }
                if (drawAmount > 1.0f) {
                    drawAmount = 1.0f;
                }
                int power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack);
                int punch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)stack);
                for (int i = 0; i < (this.arrowCount < 1 ? 1 : this.arrowCount) && (flag || player.field_71071_by.func_146028_b(this.ammoItem)); ++i) {
                    if (this.ammoItem == Items.field_151032_g) {
                        EntityArrow entityarrow = new EntityArrow(world, (EntityLivingBase)player, drawAmount * 2.0f);
                        int disp = i % 4;
                        entityarrow.field_70163_u += 0.25 * (double)disp;
                        if (drawAmount == 1.0f) {
                            entityarrow.func_70243_d(true);
                        }
                        if (power > 0) {
                            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)power * 0.5 + 0.5);
                        }
                        if (punch > 0) {
                            entityarrow.func_70240_a(punch);
                        }
                        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)stack) > 0) {
                            entityarrow.func_70015_d(100);
                        }
                        if (flag) {
                            entityarrow.field_70251_a = 2;
                        } else {
                            player.field_71071_by.func_146026_a(Items.field_151032_g);
                        }
                        if (world.field_72995_K) continue;
                        world.func_72838_d((Entity)entityarrow);
                        continue;
                    }
                    if (!(this.ammoItem instanceof ItemAddedThrowable)) continue;
                    if (!flag) {
                        player.field_71071_by.func_146026_a(this.ammoItem);
                    }
                    if (world.field_72995_K) continue;
                    EntityAddedThrownItem.nextVelocity = ((ItemAddedThrowable)this.ammoItem).velocity * drawAmount * 2.0f;
                    EntityAddedThrownItem thrown = new EntityAddedThrownItem(world, (EntityLivingBase)player, (ItemAddedThrowable)this.ammoItem);
                    if (drawAmount == 1.0f) {
                        thrown.damage = (float)((double)thrown.damage * 1.5);
                    }
                    if (power > 0 && thrown.damage > 0.0f) {
                        thrown.damage += (float)power * 0.5f + 0.5f;
                    }
                    if (punch > 0) {
                        thrown.punch = punch;
                    }
                    world.func_72838_d((Entity)thrown);
                }
                stack.func_77972_a(1, (EntityLivingBase)player);
                world.func_72956_a((Entity)player, this.shootingSound, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + drawAmount * 0.5f);
            }
        }
        double xPos = player.field_70165_t - (double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        double yPos = player.field_70163_u + (double)player.func_70047_e() - (double)0.1f;
        double zPos = player.field_70161_v - (double)(MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        if (this.ammoItem == Items.field_151032_g) {
            List arrowList = world.func_72872_a(EntityArrow.class, new AxisAlignedBB(xPos - 1.0, yPos - 1.0, zPos - 1.0, xPos + 1.0, yPos + 1.5, zPos + 1.0));
            for (EntityArrow arrow : arrowList) {
                arrow.func_70239_b(arrow.func_70242_d() + (double)this.baseDamage);
            }
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        ArrowNockEvent event;
        if (this.ammoItem == Items.field_151032_g && MinecraftForge.EVENT_BUS.post((Event)(event = new ArrowNockEvent(player, stack)))) {
            return event.result;
        }
        if (player.field_71075_bZ.field_75098_d || player.field_71071_by.func_146028_b(this.ammoItem) || this.arrowCount == 0 || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)stack) > 0) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public int func_77619_b() {
        return this.enchantability;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModel(ItemStack stack, EntityPlayer player, int useRemaining) {
        if (player.func_71011_bu() != null && stack != null && stack.func_77973_b() == this) {
            int i = stack.func_77988_m() - player.func_71052_bv();
            if (i >= this.getDrawTime(stack)) {
                return new ModelResourceLocation(this.getName() + "_pulling_2", "inventory");
            }
            if (i > this.getDrawTime(stack) * 2 / 3) {
                return new ModelResourceLocation(this.getName() + "_pulling_1", "inventory");
            }
            if (i > 0) {
                return new ModelResourceLocation(this.getName() + "_pulling_0", "inventory");
            }
        }
        return null;
    }

    private String getName() {
        return "lootplusplus:" + this.func_77658_a().substring(this.func_77658_a().indexOf(".") + 1);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repairMaterial) {
        return this.repairStack != null && repairMaterial != null && this.repairStack.func_77973_b() == repairMaterial.func_77973_b() && (this.repairStack.func_77952_i() == Short.MAX_VALUE || this.repairStack.func_77952_i() == repairMaterial.func_77952_i());
    }
}

