/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.additions;

import com.tmtravlr.lootplusplus.LootPPHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAddedMultiTool
extends ItemTool {
    public static Item.ToolMaterial multiMaterial = EnumHelper.addToolMaterial((String)"lpp_multitool", (int)0, (int)1, (float)1.0f, (float)0.0f, (int)1);
    public String displayName = "";
    public float damageModifier = 0.0f;
    public int harvestLevel = 0;
    public float efficiency = 0.0f;
    public int enchantability = 1;
    public Set<String> toolClasses = new HashSet<String>();
    public ItemStack repairStack = null;
    private boolean isSword;
    private boolean isPick;
    private boolean isAxe;
    private boolean isShovel;
    private boolean isHoe;

    public ItemAddedMultiTool(String[] types, int harvestLevel, int durability, float damage, float efficiency, int enchantability, ItemStack repairItem, String display) {
        super(damage, multiMaterial, new HashSet());
        this.field_77777_bU = 1;
        this.func_77637_a(LootPPHelper.tabLootPPAdditions);
        this.func_77656_e(durability);
        this.damageModifier = damage;
        this.harvestLevel = harvestLevel;
        this.efficiency = efficiency;
        this.enchantability = enchantability;
        this.toolClasses.addAll(Arrays.asList(types));
        this.displayName = display;
        this.isSword = this.toolClasses.contains("sword");
        this.isPick = this.toolClasses.contains("pickaxe");
        this.isAxe = this.toolClasses.contains("axe");
        this.isShovel = this.toolClasses.contains("shovel");
        this.isHoe = this.toolClasses.contains("hoe");
    }

    public String func_77653_i(ItemStack stack) {
        return StatCollector.func_74838_a((String)this.displayName).trim();
    }

    public float func_150893_a(ItemStack stack, Block block) {
        float strength = 1.0f;
        if (this.isSword) {
            strength = Math.max(Items.field_151048_u.func_150893_a(stack, block), strength);
        }
        if (this.isPick) {
            strength = Math.max(block.func_149688_o() != Material.field_151573_f && block.func_149688_o() != Material.field_151574_g && block.func_149688_o() != Material.field_151576_e ? super.func_150893_a(stack, block) : this.efficiency, strength);
        }
        if (this.isAxe) {
            strength = Math.max(block.func_149688_o() != Material.field_151575_d && block.func_149688_o() != Material.field_151585_k && block.func_149688_o() != Material.field_151582_l ? super.func_150893_a(stack, block) : this.efficiency, strength);
        }
        return strength;
    }

    public boolean func_150897_b(Block blockIn) {
        if (this.isSword && blockIn == Blocks.field_150321_G) {
            return true;
        }
        if (this.isPick && (blockIn == Blocks.field_150343_Z ? this.harvestLevel >= 3 : (blockIn != Blocks.field_150484_ah && blockIn != Blocks.field_150482_ag ? (blockIn != Blocks.field_150412_bA && blockIn != Blocks.field_150475_bE ? (blockIn != Blocks.field_150340_R && blockIn != Blocks.field_150352_o ? (blockIn != Blocks.field_150339_S && blockIn != Blocks.field_150366_p ? (blockIn != Blocks.field_150368_y && blockIn != Blocks.field_150369_x ? (blockIn != Blocks.field_150450_ax && blockIn != Blocks.field_150439_ay ? blockIn.func_149688_o() == Material.field_151576_e || blockIn.func_149688_o() == Material.field_151573_f || blockIn.func_149688_o() == Material.field_151574_g : this.harvestLevel >= 2) : this.harvestLevel >= 1) : this.harvestLevel >= 1) : this.harvestLevel >= 2) : this.harvestLevel >= 2) : this.harvestLevel >= 2))) {
            return true;
        }
        return this.isShovel && (blockIn == Blocks.field_150431_aC || blockIn == Blocks.field_150433_aE);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(this.isSword ? 1 : 2, attacker);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, Block blockIn, BlockPos pos, EntityLivingBase playerIn) {
        if ((double)blockIn.func_176195_g(worldIn, pos) != 0.0) {
            stack.func_77972_a(this.toolClasses.size() == 1 && this.isSword ? 2 : 1, playerIn);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int func_77619_b() {
        return this.enchantability;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.isSword ? EnumAction.BLOCK : EnumAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return this.isSword ? 72000 : 0;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        if (this.isSword) {
            playerIn.func_71008_a(itemStackIn, this.func_77626_a(itemStackIn));
        }
        return itemStackIn;
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.isHoe) {
            if (!playerIn.func_175151_a(pos.func_177972_a(side), side, stack)) {
                return false;
            }
            int hook = ForgeEventFactory.onHoeUse((ItemStack)stack, (EntityPlayer)playerIn, (World)worldIn, (BlockPos)pos);
            if (hook != 0) {
                return hook > 0;
            }
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            Block block = iblockstate.func_177230_c();
            if (side != EnumFacing.DOWN && worldIn.func_175623_d(pos.func_177984_a())) {
                if (block == Blocks.field_150349_c) {
                    return this.useHoe(stack, playerIn, worldIn, pos, Blocks.field_150458_ak.func_176223_P());
                }
                if (block == Blocks.field_150346_d) {
                    switch (SwitchDirtType.TYPE_LOOKUP[((BlockDirt.DirtType)iblockstate.func_177229_b((IProperty)BlockDirt.field_176386_a)).ordinal()]) {
                        case 1: {
                            return this.useHoe(stack, playerIn, worldIn, pos, Blocks.field_150458_ak.func_176223_P());
                        }
                        case 2: {
                            return this.useHoe(stack, playerIn, worldIn, pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                        }
                    }
                }
            }
        }
        return false;
    }

    protected boolean useHoe(ItemStack stack, EntityPlayer player, World worldIn, BlockPos target, IBlockState newState) {
        worldIn.func_72908_a((double)((float)target.func_177958_n() + 0.5f), (double)((float)target.func_177956_o() + 0.5f), (double)((float)target.func_177952_p() + 0.5f), newState.func_177230_c().field_149762_H.func_150498_e(), (newState.func_177230_c().field_149762_H.func_150497_c() + 1.0f) / 2.0f, newState.func_177230_c().field_149762_H.func_150494_d() * 0.8f);
        if (worldIn.field_72995_K) {
            return true;
        }
        worldIn.func_175656_a(target, newState);
        stack.func_77972_a(1, (EntityLivingBase)player);
        return true;
    }

    public boolean func_82789_a(ItemStack tool, ItemStack materialStack) {
        return materialStack != null && this.repairStack != null && materialStack.func_77973_b() == this.repairStack.func_77973_b() && (this.repairStack.func_77952_i() == Short.MAX_VALUE || materialStack.func_77952_i() == this.repairStack.func_77952_i());
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        int level = super.getHarvestLevel(stack, toolClass);
        if (level == -1 && toolClass != null && this.toolClasses.contains(toolClass)) {
            return this.harvestLevel;
        }
        return level;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return !this.toolClasses.isEmpty() ? this.toolClasses : super.getToolClasses(stack);
    }

    public float getDigSpeed(ItemStack stack, IBlockState state) {
        for (String type : this.getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return this.efficiency;
        }
        return super.getDigSpeed(stack, state);
    }

    static final class SwitchDirtType {
        static final int[] TYPE_LOOKUP = new int[BlockDirt.DirtType.values().length];
        private static final String __OBFID = "CL_00002179";

        SwitchDirtType() {
        }

        static {
            try {
                SwitchDirtType.TYPE_LOOKUP[BlockDirt.DirtType.DIRT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchDirtType.TYPE_LOOKUP[BlockDirt.DirtType.COARSE_DIRT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

