/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.additions;

import com.tmtravlr.lootplusplus.additions.BlockAddedFurnace;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.MathHelper;

public class TileEntityAddedFurnace
extends TileEntityFurnace {
    private static final int[] topSlots = new int[]{0};
    private static final int[] bottomSlots = new int[]{2, 1};
    private static final int[] sideSlots = new int[]{1};
    private ItemStack[] storedItems = new ItemStack[3];
    private String customInventoryName;
    public int trueFurnaceCookTime = 0;
    public int totalFurnaceCookTime = 200;
    public int field_145956_a;
    public int furnaceCookTime;
    public int field_145963_i;

    public TileEntityAddedFurnace() {
        this("Furnace", 200.0f);
    }

    public TileEntityAddedFurnace(String name, float speed) {
        this.customInventoryName = name;
        super.func_145951_a(name);
        this.totalFurnaceCookTime = MathHelper.func_76141_d((float)(200.0f / speed));
    }

    public int func_70302_i_() {
        return this.storedItems.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.storedItems[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.storedItems[slot] != null) {
            if (this.storedItems[slot].field_77994_a <= amount) {
                ItemStack itemstack = this.storedItems[slot];
                this.storedItems[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.storedItems[slot].func_77979_a(amount);
            if (this.storedItems[slot].field_77994_a == 0) {
                this.storedItems[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.storedItems[slot] != null) {
            ItemStack itemstack = this.storedItems[slot];
            this.storedItems[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.storedItems[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customInventoryName : "container.furnace";
    }

    public boolean hasCustomInventoryName() {
        return this.customInventoryName != null && this.customInventoryName.length() > 0;
    }

    public void func_145951_a(String name) {
        this.customInventoryName = name;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList nbttaglist = tag.func_150295_c("Items", 10);
        this.storedItems = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.storedItems.length) continue;
            this.storedItems[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.field_145956_a = tag.func_74765_d("BurnTime");
        this.furnaceCookTime = tag.func_74765_d("CookTime");
        this.trueFurnaceCookTime = tag.func_74762_e("TrueCookTime");
        this.field_145963_i = TileEntityAddedFurnace.func_145952_a((ItemStack)this.storedItems[1]);
        this.totalFurnaceCookTime = tag.func_74762_e("SmeltingTime");
        if (tag.func_150297_b("CustomName", 8)) {
            this.customInventoryName = tag.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74777_a("BurnTime", (short)this.field_145956_a);
        tag.func_74777_a("CookTime", (short)this.furnaceCookTime);
        tag.func_74768_a("TrueCookTime", this.trueFurnaceCookTime);
        tag.func_74768_a("SmeltingTime", this.totalFurnaceCookTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.storedItems.length; ++i) {
            if (this.storedItems[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.storedItems[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        tag.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.hasCustomInventoryName()) {
            tag.func_74778_a("CustomName", this.customInventoryName);
        }
    }

    public boolean func_145950_i() {
        return this.field_145956_a > 0;
    }

    public void func_73660_a() {
        boolean isBurning = this.func_145950_i();
        boolean flag1 = false;
        if (isBurning) {
            --this.field_145956_a;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!(isBurning || this.storedItems[1] != null && this.storedItems[0] != null)) {
                MathHelper.func_76125_a((int)this.trueFurnaceCookTime, (int)0, (int)this.totalFurnaceCookTime);
            } else {
                if (this.field_145956_a == 0 && this.canSmelt()) {
                    this.field_145963_i = this.field_145956_a = TileEntityAddedFurnace.func_145952_a((ItemStack)this.storedItems[1]);
                    if (this.field_145956_a > 0) {
                        flag1 = true;
                        if (this.storedItems[1] != null) {
                            --this.storedItems[1].field_77994_a;
                            if (this.storedItems[1].field_77994_a == 0) {
                                this.storedItems[1] = this.storedItems[1].func_77973_b().getContainerItem(this.storedItems[1]);
                            }
                        }
                    }
                }
                if (this.func_145950_i() && this.canSmelt()) {
                    ++this.trueFurnaceCookTime;
                    if (this.trueFurnaceCookTime == this.totalFurnaceCookTime) {
                        this.trueFurnaceCookTime = 0;
                        this.func_145949_j();
                        flag1 = true;
                    }
                } else {
                    this.trueFurnaceCookTime = 0;
                }
                this.furnaceCookTime = this.trueFurnaceCookTime * 200 / this.totalFurnaceCookTime;
            }
            if (isBurning != this.field_145956_a > 0) {
                flag1 = true;
                BlockAddedFurnace.setState(this.field_145956_a > 0, this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        if (this.storedItems[0] == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.storedItems[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.storedItems[2] == null) {
            return true;
        }
        if (!this.storedItems[2].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.storedItems[2].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.storedItems[2].func_77976_d();
    }

    public void func_145949_j() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.storedItems[0]);
            if (this.storedItems[2] == null) {
                this.storedItems[2] = itemstack.func_77946_l();
            } else if (this.storedItems[2].func_77973_b() == itemstack.func_77973_b()) {
                this.storedItems[2].field_77994_a += itemstack.field_77994_a;
            }
            --this.storedItems[0].field_77994_a;
            if (this.storedItems[0].field_77994_a <= 0) {
                this.storedItems[0] = null;
            }
        }
    }

    public int[] getAccessibleSlotsFromSide(int p_94128_1_) {
        return p_94128_1_ == 0 ? bottomSlots : (p_94128_1_ == 1 ? topSlots : sideSlots);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.field_145956_a;
            }
            case 1: {
                return this.field_145963_i;
            }
            case 2: {
                return this.trueFurnaceCookTime;
            }
            case 3: {
                return this.totalFurnaceCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.field_145956_a = value;
                break;
            }
            case 1: {
                this.field_145963_i = value;
                break;
            }
            case 2: {
                this.trueFurnaceCookTime = value;
                break;
            }
            case 3: {
                this.totalFurnaceCookTime = value;
            }
        }
    }
}

