/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.config;

import com.tmtravlr.lootplusplus.LootPlusPlusMod;
import com.tmtravlr.lootplusplus.config.ConfigLoader;
import com.tmtravlr.lootplusplus.config.ConfigLoaderBlockDrops;
import com.tmtravlr.lootplusplus.config.ConfigLoaderBlocks;
import com.tmtravlr.lootplusplus.config.ConfigLoaderChestLoot;
import com.tmtravlr.lootplusplus.config.ConfigLoaderEffects;
import com.tmtravlr.lootplusplus.config.ConfigLoaderEntityDrops;
import com.tmtravlr.lootplusplus.config.ConfigLoaderFishingLoot;
import com.tmtravlr.lootplusplus.config.ConfigLoaderFurnaceRecipes;
import com.tmtravlr.lootplusplus.config.ConfigLoaderGeneral;
import com.tmtravlr.lootplusplus.config.ConfigLoaderItems;
import com.tmtravlr.lootplusplus.config.ConfigLoaderOreDict;
import com.tmtravlr.lootplusplus.config.ConfigLoaderRecipes;
import com.tmtravlr.lootplusplus.config.ConfigLoaderRecords;
import com.tmtravlr.lootplusplus.config.ConfigLoaderStackSize;
import com.tmtravlr.lootplusplus.config.ConfigLoaderWorldGen;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.server.MinecraftServer;

public class ConfigExtrasLoader {
    public static HashMap<String, ConfigLoader> loadersMap = new HashMap();
    public static final String ADDON_LOCATION = "/addons/Loot++";
    public static final String LUCKY_BLOCK_ADDON_LOCATION = "/addons/lucky_block";
    public static File lppAddonFolder;
    public static File lbAddonFolder;
    public static ArrayList<File> addonsList;

    public static void loadAllExtras() {
        File[] addonFiles;
        ConfigExtrasLoader.initLoaders();
        lppAddonFolder = new File(MinecraftServer.func_71276_C().func_71238_n().getPath() + ADDON_LOCATION);
        if (!lppAddonFolder.exists()) {
            lppAddonFolder.mkdirs();
            ConfigExtrasLoader.createExampleAddon();
        }
        if (!(lbAddonFolder = new File(MinecraftServer.func_71276_C().func_71238_n().getPath() + LUCKY_BLOCK_ADDON_LOCATION)).exists()) {
            lbAddonFolder = null;
        }
        if ((addonFiles = lppAddonFolder.listFiles()) != null && addonFiles.length != 0) {
            for (File file : addonFiles) {
                if (!file.isDirectory() && !file.getName().endsWith(".zip") && !file.getName().endsWith(".jar")) continue;
                addonsList.add(file);
                LootPlusPlusMod.proxy.registerAsResourcePack(file);
            }
        }
        if (lbAddonFolder != null && (addonFiles = lbAddonFolder.listFiles()) != null && addonFiles.length != 0) {
            for (File file : addonFiles) {
                if (!file.isDirectory() && !file.getName().endsWith(".zip") && !file.getName().endsWith(".jar")) continue;
                addonsList.add(file);
            }
        }
        for (File addon : addonsList) {
            if (LootPlusPlusMod.debug) {
                System.out.println("[Loot++] Loading in addon file: " + addon.getPath());
            }
            ConfigExtrasLoader.loadExtras(addon);
        }
    }

    public static void loadExtras(File folderToLoad) {
        for (String loaderName : loadersMap.keySet()) {
            ConfigLoader loader = loadersMap.get(loaderName);
            loader.loadExtras(folderToLoad);
        }
    }

    public static void readFileIntoList(File addonFolder, String filePath, ArrayList<String> extras) {
        try {
            BufferedReader br = null;
            ZipFile zipFile = null;
            if (addonFolder.isDirectory()) {
                File file = new File(addonFolder, filePath);
                if (file.exists()) {
                    br = new BufferedReader(new FileReader(file));
                }
            } else {
                zipFile = new ZipFile(addonFolder);
                ZipEntry entry = zipFile.getEntry(filePath);
                if (entry == null) {
                    zipFile.close();
                    return;
                }
                InputStream stream = zipFile.getInputStream(entry);
                br = new BufferedReader(new InputStreamReader(stream));
            }
            if (br != null) {
                String line;
                while ((line = br.readLine()) != null) {
                    extras.add(line);
                }
                if (zipFile != null) {
                    zipFile.close();
                }
                br.close();
            }
        }
        catch (Exception e) {
            System.err.println("[Loot++] Caught an exception while trying to load in extra config options!");
            e.printStackTrace();
        }
    }

    public static ArrayList<String> combineLists(String[] configLoaded, ArrayList<String> extraList) {
        ArrayList<String> toReturn = new ArrayList<String>();
        toReturn.addAll(Arrays.asList(configLoaded));
        if (extraList != null) {
            toReturn.addAll(extraList);
        }
        return toReturn;
    }

    private static void initLoaders() {
        loadersMap.put(ConfigLoaderBlockDrops.instance.getFileName(), ConfigLoaderBlockDrops.instance);
        loadersMap.put(ConfigLoaderBlocks.instance.getFileName(), ConfigLoaderBlocks.instance);
        loadersMap.put(ConfigLoaderChestLoot.instance.getFileName(), ConfigLoaderChestLoot.instance);
        loadersMap.put(ConfigLoaderEffects.instance.getFileName(), ConfigLoaderEffects.instance);
        loadersMap.put(ConfigLoaderEntityDrops.instance.getFileName(), ConfigLoaderEntityDrops.instance);
        loadersMap.put(ConfigLoaderFurnaceRecipes.instance.getFileName(), ConfigLoaderFurnaceRecipes.instance);
        loadersMap.put(ConfigLoaderGeneral.instance.getFileName(), ConfigLoaderGeneral.instance);
        loadersMap.put(ConfigLoaderItems.instance.getFileName(), ConfigLoaderItems.instance);
        loadersMap.put(ConfigLoaderOreDict.instance.getFileName(), ConfigLoaderOreDict.instance);
        loadersMap.put(ConfigLoaderRecipes.instance.getFileName(), ConfigLoaderRecipes.instance);
        loadersMap.put(ConfigLoaderRecords.instance.getFileName(), ConfigLoaderRecords.instance);
        loadersMap.put(ConfigLoaderStackSize.instance.getFileName(), ConfigLoaderStackSize.instance);
        loadersMap.put(ConfigLoaderWorldGen.instance.getFileName(), ConfigLoaderWorldGen.instance);
        loadersMap.put(ConfigLoaderFishingLoot.instance.getFileName(), ConfigLoaderFishingLoot.instance);
    }

    private static void createExampleAddon() {
        File exampleFolder = new File(lppAddonFolder, "Example");
        exampleFolder.mkdir();
        File packMCMeta = new File(exampleFolder, "pack.mcmeta");
        try {
            PrintStream writeStream = new PrintStream(packMCMeta);
            writeStream.println("{");
            writeStream.println("  \"pack\": {");
            writeStream.println("    \"pack_format\": 1,");
            writeStream.println("    \"description\": \"Loot++ example addon.\"");
            writeStream.println("  }");
            writeStream.println("}");
            writeStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File lppFolder = new File(exampleFolder, "assets/lootplusplus");
        lppFolder.mkdirs();
        File other = new File(lppFolder, "blockstates");
        other.mkdir();
        other = new File(lppFolder, "textures/blocks");
        other.mkdirs();
        other = new File(lppFolder, "textures/items");
        other.mkdirs();
        other = new File(lppFolder, "textures/models/armor");
        other.mkdirs();
        other = new File(lppFolder, "models/block");
        other.mkdirs();
        other = new File(lppFolder, "models/item");
        other.mkdirs();
        other = new File(lppFolder, "sounds/records");
        File soundsJson = new File(lppFolder, "sounds.json");
        try {
            PrintStream writeStream = new PrintStream(soundsJson);
            writeStream.println("{");
            writeStream.println();
            writeStream.println("}");
            writeStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            File config = new File(exampleFolder, "config");
            config.mkdir();
            for (String folderName : loadersMap.keySet()) {
                ConfigLoader configLoader = loadersMap.get(folderName);
                File loader = new File(config, folderName);
                loader.mkdirs();
                for (String fileName : configLoader.namesToExtras.keySet()) {
                    other = new File(loader, fileName + ".txt");
                    other.createNewFile();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        addonsList = new ArrayList();
    }
}

