/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.config;

import com.tmtravlr.lootplusplus.LootPPBlocks;
import com.tmtravlr.lootplusplus.LootPPHelper;
import com.tmtravlr.lootplusplus.LootPPItems;
import com.tmtravlr.lootplusplus.LootPPNotifier;
import com.tmtravlr.lootplusplus.LootPlusPlusMod;
import com.tmtravlr.lootplusplus.additions.BlockAdded;
import com.tmtravlr.lootplusplus.additions.BlockAddedButton;
import com.tmtravlr.lootplusplus.additions.BlockAddedCake;
import com.tmtravlr.lootplusplus.additions.BlockAddedCarpet;
import com.tmtravlr.lootplusplus.additions.BlockAddedCrops;
import com.tmtravlr.lootplusplus.additions.BlockAddedDoor;
import com.tmtravlr.lootplusplus.additions.BlockAddedFalling;
import com.tmtravlr.lootplusplus.additions.BlockAddedFence;
import com.tmtravlr.lootplusplus.additions.BlockAddedFenceGate;
import com.tmtravlr.lootplusplus.additions.BlockAddedFurnace;
import com.tmtravlr.lootplusplus.additions.BlockAddedLadder;
import com.tmtravlr.lootplusplus.additions.BlockAddedMetadata;
import com.tmtravlr.lootplusplus.additions.BlockAddedPane;
import com.tmtravlr.lootplusplus.additions.BlockAddedPillar;
import com.tmtravlr.lootplusplus.additions.BlockAddedPlant;
import com.tmtravlr.lootplusplus.additions.BlockAddedPressurePlate;
import com.tmtravlr.lootplusplus.additions.BlockAddedSlab;
import com.tmtravlr.lootplusplus.additions.BlockAddedSlabFull;
import com.tmtravlr.lootplusplus.additions.BlockAddedStairs;
import com.tmtravlr.lootplusplus.additions.BlockAddedWall;
import com.tmtravlr.lootplusplus.additions.BlockAddedWorkbench;
import com.tmtravlr.lootplusplus.additions.ItemBlockAdded;
import com.tmtravlr.lootplusplus.additions.ItemBlockAddedDoor;
import com.tmtravlr.lootplusplus.additions.ItemBlockAddedMultipleMeta;
import com.tmtravlr.lootplusplus.additions.ItemBlockAddedSlab;
import com.tmtravlr.lootplusplus.config.ConfigExtrasLoader;
import com.tmtravlr.lootplusplus.config.ConfigLoader;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ConfigLoaderBlocks
extends ConfigLoader {
    public static ConfigLoaderBlocks instance = new ConfigLoaderBlocks();
    Configuration blockConfig;

    ConfigLoaderBlocks() {
        this.namesToExtras.put("generic", new ArrayList());
        this.namesToExtras.put("multiple_metadata", new ArrayList());
        this.namesToExtras.put("logs_pillars", new ArrayList());
        this.namesToExtras.put("plants", new ArrayList());
        this.namesToExtras.put("slabs", new ArrayList());
        this.namesToExtras.put("stairs", new ArrayList());
        this.namesToExtras.put("tiles_carpets", new ArrayList());
        this.namesToExtras.put("panes_bars", new ArrayList());
        this.namesToExtras.put("walls", new ArrayList());
        this.namesToExtras.put("fences", new ArrayList());
        this.namesToExtras.put("buttons", new ArrayList());
        this.namesToExtras.put("pressure_plates", new ArrayList());
        this.namesToExtras.put("doors", new ArrayList());
        this.namesToExtras.put("fence_gates", new ArrayList());
        this.namesToExtras.put("ladders", new ArrayList());
        this.namesToExtras.put("furnaces", new ArrayList());
        this.namesToExtras.put("crafting_tables", new ArrayList());
        this.namesToExtras.put("cakes", new ArrayList());
        this.namesToExtras.put("crops", new ArrayList());
    }

    @Override
    public String getFileName() {
        return "block_additions";
    }

    public void loadBlockAdditions() {
        String existingBlockName;
        Block block;
        int opacity;
        int flammability;
        float slipperiness;
        float resistance;
        boolean beaconBase;
        String materialName;
        String displayName;
        String blockName;
        String[] parts;
        boolean comment;
        String title;
        String info;
        int index;
        this.blockConfig = new Configuration(new File(LootPPHelper.configFolder, this.getFileName() + ".cfg"));
        this.blockConfig.load();
        Property temp = this.blockConfig.get("add_generic", "generic", new String[0]);
        temp.comment = "This adds full 1m cube with a very long list of options in the format:\n\n      <Block name>_____<Block display name>_____<Block material>_____<Falls (like sand, true or false)>_____<Beacon Base (true or false)>_____<Hardness>_____<Explosion resistance>_____<Harvesting item type>_____<Harvest level (-1 for any)>_____<Light emitted>_____<Slipperiness>_____<Fire Spread Speed>_____<Flammability>_____<Opacity>\n\n- The <Block name> is the name the block will be registered with (note that a\n'lootplusplus:' will be added to the front; don't add anything with a colon\nyourself!). You should also include a blockstate and item model file for each added\nblock in your resource pack at assets/lootplusplus/blockstates/<Block name>.json and\nassets/lootplusplus/models/item/<Block name>.json.\n- The <Block display name> is what people will see ingame while holding the block.\n- The <Block material> is one of the default materials (determines some things about\nthe block like footstep sounds and such). The possible values are:\n\n      air, anvil, cactus, cake, carpet, circuits, clay, cloth, coral, craftedSnow, dragonEgg, fire\n      glass, gourd, grass, ground, ice, iron, lava, leaves, packedIce, piston, plants, portal\n      redstoneLight, rock, sand, snow, sponge, tnt, vine, water, web, wood\n\n- If <Falls> is true, the block will fall like sand.\n- If <Beacon Base> is true, the block can be used for beacon bases.\n- The <Hardness> is a float that determines how long the block takes to break. If it is\nnegative, the block will be unbreakable like bedrock.\n- The <Explosion resistance> is a float that represents how resistant the block is to explosions.\n- The <Harvesting item type> is a tool type. The default options are 'pickaxe', 'shovel',\n'axe', or 'none'.\n- The <Harvest level> is what level of tool can harvest the block if the tool type is not\n'none'; the default levels are wood and gold = 0, stone = 1, iron = 2, and diamond = 3.\n- The <Light emitted> is how much the block glows, from 0.0 to 1.0.\n- The <Slipperiness> is how slippery the block is, with 0.6 as normal and ice as 0.98.\n- The higher the <Fire spread speed>, the faster the block will catch fire (0 for none).\n- The higher the <Flammability>, the faster the block will burn and disappear (0 for none).\n- The <Opacity> is how opaque the block is, with 0 being transparent, and 255 being almost\ntotally opaque. If -1, the block will be totally opaque.\n\nHere are some examples of what default blocks would look like:\n\nWood Planks: planks_oak_____Oak Planks_____wood_____false_____false_____2.0_____5.0_____axe_____-1_____0.0_____0.6_____5_____20_____-1\nStone:       stone_____Stone_____rock_____false_____false_____1.5_____10.0_____pickaxe_____0_____0.0_____0.6_____0_____0_____-1\nIron:        iron_block_____Iron Block_____metal_____false_____true_____5.0_____10.0_____pickaxe_____1_____0.0_____0.6_____0_____0_____-1\nSand:        sand_____Sand_____sand_____true_____false_____0.5_____0.0_____shovel_____-1_____0.0_____0.6_____0_____0_____-1\nGlowstone:   glowstone_____Glowstone_____glass_____false_____false_____0.3_____0.0_____none_____-1_____1.0_____0.6_____0_____0_____-1\nPacked Ice:  packed_ice_____Packed Ice_____glass_____false_____false_____0.5_____0.0_____pickaxe_____-1_____0.0_____0.98_____0_____0_____-1\nIce:         ice_____Ice_____ice_____false_____false_____0.5_____0.0_____pickaxe_____-1_____0.0_____0.98_____0_____0_____3\nObsidian:    obsidian_____Obsidian_____rock_____false_____false_____50.0_____2000.0_____pickaxe_____3_____0.0_____0.6_____0_____0_____-1\nBedrock:     bedrock_____Bedrock_____rock_____false_____false_____-1.0_____6000000.0_____pickaxe_____-1_____0.0_____0.6_____0_____0_____-1\nGlass:       glass_____Glass_____glass_____false_____false_____0.3_____0.0_____none_____-1_____0.0_____0.6_____0_____0_____0\n\nFor an example, if you wanted to add a ruby ore and resource block for ruby, you could put:\n\n      ruby_ore_____Ruby Ore_____rock_____false_____false_____3.0_____5.0_____pickaxe_____2_____0.0_____0.6_____0_____0_____-1\n      ruby_block_____Ruby Block_____iron_____false_____true_____5.0_____10.0_____pickaxe_____2_____0.0_____0.6_____0_____0_____-1";
        ArrayList<String> infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("generic"));
        for (index = 0; index < infoList.size(); ++index) {
            int opacity2;
            int flammability2;
            int fireSpread;
            float slipperiness2;
            float lightEmitted;
            int harvestLevel;
            String toolType;
            float resistance2;
            float hardness;
            boolean beaconBase2;
            boolean falls;
            block117: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'generic' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length != 14) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                blockName = parts[0];
                displayName = parts[1];
                materialName = parts[2];
                falls = false;
                beaconBase2 = false;
                hardness = 1.0f;
                resistance2 = 0.0f;
                toolType = parts[7];
                harvestLevel = -1;
                lightEmitted = 0.0f;
                slipperiness2 = 0.0f;
                fireSpread = 0;
                flammability2 = 0;
                opacity2 = -1;
                try {
                    falls = Boolean.valueOf(parts[3]);
                    beaconBase2 = Boolean.valueOf(parts[4]);
                    hardness = Float.valueOf(parts[5]).floatValue();
                    resistance2 = Float.valueOf(parts[6]).floatValue();
                    harvestLevel = Integer.valueOf(parts[8]);
                    lightEmitted = Float.valueOf(parts[9]).floatValue();
                    slipperiness2 = Float.valueOf(parts[10]).floatValue();
                    fireSpread = Integer.valueOf(parts[11]);
                    flammability2 = Integer.valueOf(parts[12]);
                    opacity2 = Integer.valueOf(parts[13]);
                }
                catch (NumberFormatException e) {
                    if (comment) break block117;
                    System.err.println("[Loot++] Caught exception while trying to add a generic block " + blockName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[3], parts[4], parts[5], parts[6], parts[8], parts[9], parts[10], parts[11], parts[12], parts[13]);
                }
            }
            slipperiness2 = MathHelper.func_76131_a((float)slipperiness2, (float)0.2f, (float)0.98f);
            Material blockMaterial = ConfigLoaderBlocks.getMaterialFromString(materialName);
            if (blockMaterial == null) {
                LootPPNotifier.notify(comment, title, "Couldn't find a material for name: " + materialName);
                continue;
            }
            Block block2 = falls ? new BlockAddedFalling(blockMaterial, opacity2, beaconBase2, toolType, harvestLevel, slipperiness2, displayName).func_149711_c(hardness).func_149752_b(resistance2).func_149672_a(ConfigLoaderBlocks.getSoundsFromString(materialName)).func_149715_a(lightEmitted).func_149663_c(blockName) : new BlockAdded(blockMaterial, opacity2, beaconBase2, toolType, harvestLevel, slipperiness2, displayName).func_149711_c(hardness).func_149752_b(resistance2).func_149672_a(ConfigLoaderBlocks.getSoundsFromString(materialName)).func_149715_a(lightEmitted).func_149663_c(blockName);
            LootPPBlocks.addedBlocks.add(block2);
            GameRegistry.registerBlock((Block)block2, ItemBlockAdded.class, (String)blockName);
            LootPlusPlusMod.proxy.registerBlockRender(block2);
            Blocks.field_150480_ab.func_180686_a(block2, fireSpread, flammability2);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom generic block: lootplusplus:" + blockName);
        }
        temp = this.blockConfig.get("add_generic", "multiple_metadata", new String[0]);
        temp.comment = "This adds full 1m cube with 16 metadata values and options in the format:\n\n      <Block name>_____<Block display name 0>_____<Block display name 1>_____<Block display name 2>_____<Block display name 3>_____<Block display name 4>_____<Block display name 5>_____<Block display name 6>_____<Block display name 7>_____<Block display name 8>_____<Block display name 9>_____<Block display name 10>_____<Block display name 11>_____<Block display name 12>_____<Block display name 13>_____<Block display name 14>_____<Block display name 15>_____<Block material>_____<Beacon Base (true or false)>_____<Hardness>_____<Explosion resistance>_____<Harvesting item type>_____<Harvest level (-1 for any)>_____<Light emitted>_____<Slipperiness>_____<Fire Spread Speed>_____<Flammability>_____<Opacity>\n\n- The <Block name> is the name the block will be registered with (note that a\n'lootplusplus:' will be added to the front; don't add anything with a colon\nyourself!). You should also include a blockstate and item model file for each added\nblock in your resource pack at assets/lootplusplus/blockstates/<Block name>.json and\nassets/lootplusplus/models/item/<Block name>_0.json to <Block name>_15. Note that in your\nblockstates, you should have an entry for every metadata, from \"metadata=0\": to \"metadata=15\":\n- The <Block display name>s are what people will see ingame while holding the block.\n- The <Block material> is one of the default materials (determines some things about\nthe block like footstep sounds and such). The possible values are:\n\n      air, anvil, cactus, cake, carpet, circuits, clay, cloth, coral, craftedSnow, dragonEgg, fire\n      glass, gourd, grass, ground, ice, iron, lava, leaves, packedIce, piston, plants, portal\n      redstoneLight, rock, sand, snow, sponge, tnt, vine, water, web, wood\n\n- If <Beacon Base> is true, the block can be used for beacon bases.\n- The <Hardness> is a float that determines how long the block takes to break. If it is\nnegative, the block will be unbreakable like bedrock.\n- The <Explosion resistance> is a float that represents how resistant the block is to explosions.\n- The <Harvesting item type> is a tool type. The default options are 'pickaxe', 'shovel',\n'axe', or 'none'.\n- The <Harvest level> is what level of tool can harvest the block if the tool type is not\n'none'; the default levels are wood and gold = 0, stone = 1, iron = 2, and diamond = 3.\n- The <Light emitted> is how much the block glows, from 0.0 to 1.0.\n- The <Slipperiness> is how slippery the block is, with 0.6 as normal and ice as 0.98.\n- The higher the <Fire spread speed>, the faster the block will catch fire (0 for none).\n- The higher the <Flammability>, the faster the block will burn and disappear (0 for none).\n- The <Opacity> is how opaque the block is, with 0 being transparent, and 255 being almost\ntotally opaque. If -1, the block will be totally opaque.\n\nHere are some examples of what default blocks would look like:\n\nWool:             wool_____White Wool_____Orange Wool_____Magenta Wool_____Light Blue Wool_____Yellow Wool_____Lime Wool_____Pink Wool_____Grey Wool_____Light Grey Wool_____Cyan Wool_____Purple Wool_____Blue Wool_____Brown Wool_____Green Wool_____Red Wool_____Black Wool_____cloth_____false_____0.8_____0.0_____none_____-1_____0.0_____0.6_____30_____60_____-1\nStained Glass:    stained_glass_____White Stained Glass_____Orange Stained Glass_____Magenta Stained Glass_____Light Blue Stained Glass_____Yellow Stained Glass_____Lime Stained Glass_____Pink Stained Glass_____Grey Stained Glass_____Light Grey Stained Glass_____Cyan Stained Glass_____Purple Stained Glass_____Blue Stained Glass_____Brown Stained Glass_____Green Stained Glass_____Red Stained Glass_____Black Stained Glass_____glass_____false_____0.3_____0.0_____none_____-1_____0.0_____0.6_____0_____0_____0\n\nFor an example, if you wanted to add 16 colours of bricks, assuming that you have\n16 models that you list in the blockstates file, you could put:\n\n      stained_bricks_____White Bricks_____Orange Bricks_____Magenta Bricks_____Light Blue Bricks_____Yellow Bricks_____Lime Bricks_____Pink Bricks_____Grey Bricks_____Light Grey Bricks_____Cyan Bricks_____Purple Bricks_____Blue Bricks_____Brown Bricks_____Green Bricks_____Red Bricks_____Black Bricks_____rock_____false_____3.0_____5.0_____pickaxe_____0_____0.0_____0.6_____0_____0_____-1";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("multiple_metadata"));
        for (index = 0; index < infoList.size(); ++index) {
            int fireSpread;
            float lightEmitted;
            int harvestLevel;
            String toolType;
            float hardness;
            String blockName2;
            String[] displayNames;
            block118: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'generic' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length != 28) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                displayNames = new String[16];
                blockName2 = parts[0];
                displayNames[0] = parts[1];
                displayNames[1] = parts[2];
                displayNames[2] = parts[3];
                displayNames[3] = parts[4];
                displayNames[4] = parts[5];
                displayNames[5] = parts[6];
                displayNames[6] = parts[7];
                displayNames[7] = parts[8];
                displayNames[8] = parts[9];
                displayNames[9] = parts[10];
                displayNames[10] = parts[11];
                displayNames[11] = parts[12];
                displayNames[12] = parts[13];
                displayNames[13] = parts[14];
                displayNames[14] = parts[15];
                displayNames[15] = parts[16];
                materialName = parts[17];
                beaconBase = false;
                hardness = 1.0f;
                resistance = 0.0f;
                toolType = parts[21];
                harvestLevel = -1;
                lightEmitted = 0.0f;
                slipperiness = 0.0f;
                fireSpread = 0;
                flammability = 0;
                opacity = -1;
                try {
                    beaconBase = Boolean.valueOf(parts[18]);
                    hardness = Float.valueOf(parts[19]).floatValue();
                    resistance = Float.valueOf(parts[20]).floatValue();
                    harvestLevel = Integer.valueOf(parts[22]);
                    lightEmitted = Float.valueOf(parts[23]).floatValue();
                    slipperiness = Float.valueOf(parts[24]).floatValue();
                    fireSpread = Integer.valueOf(parts[25]);
                    flammability = Integer.valueOf(parts[26]);
                    opacity = Integer.valueOf(parts[27]);
                }
                catch (NumberFormatException e) {
                    if (comment) break block118;
                    System.err.println("[Loot++] Caught exception while trying to add a generic block " + blockName2);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[18], parts[19], parts[20], parts[22], parts[23], parts[24], parts[25], parts[26], parts[27]);
                }
            }
            slipperiness = MathHelper.func_76131_a((float)slipperiness, (float)0.2f, (float)0.98f);
            Material blockMaterial = ConfigLoaderBlocks.getMaterialFromString(materialName);
            if (blockMaterial == null) {
                LootPPNotifier.notify(comment, title, "Couldn't find a material for name: " + materialName);
                continue;
            }
            block = new BlockAddedMetadata(blockMaterial, opacity, beaconBase, toolType, harvestLevel, slipperiness, displayNames).func_149711_c(hardness).func_149752_b(resistance).func_149672_a(ConfigLoaderBlocks.getSoundsFromString(materialName)).func_149715_a(lightEmitted).func_149663_c(blockName2);
            LootPPBlocks.addedBlocks.add(block);
            GameRegistry.registerBlock((Block)block, ItemBlockAddedMultipleMeta.class, (String)blockName2);
            LootPlusPlusMod.proxy.registerVariants(Item.func_150898_a((Block)block), "lootplusplus:" + blockName2 + "_0", "lootplusplus:" + blockName2 + "_1", "lootplusplus:" + blockName2 + "_2", "lootplusplus:" + blockName2 + "_3", "lootplusplus:" + blockName2 + "_4", "lootplusplus:" + blockName2 + "_5", "lootplusplus:" + blockName2 + "_6", "lootplusplus:" + blockName2 + "_7", "lootplusplus:" + blockName2 + "_8", "lootplusplus:" + blockName2 + "_9", "lootplusplus:" + blockName2 + "_10", "lootplusplus:" + blockName2 + "_11", "lootplusplus:" + blockName2 + "_12", "lootplusplus:" + blockName2 + "_13", "lootplusplus:" + blockName2 + "_14", "lootplusplus:" + blockName2 + "_15");
            for (int i = 0; i < 16; ++i) {
                LootPlusPlusMod.proxy.registerBlockRenderWithDamage(block, i, blockName2 + "_" + i);
            }
            Blocks.field_150480_ab.func_180686_a(block, fireSpread, flammability);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom 16 meta block: lootplusplus:" + blockName2);
        }
        temp = this.blockConfig.get("add_generic", "logs/pillars", new String[0]);
        temp.comment = "This adds a pillar-like block with a very long list of options in the format:\n\n      <Block name>_____<Block display name>_____<Block material>_____<Beacon Base (true or false)>_____<Hardness>_____<Explosion resistance>_____<Harvesting item type>_____<Harvest level (-1 for any)>_____<Light emitted>_____<Slipperiness>_____<Fire Spread Speed>_____<Flammability>_____<Opacity>\n\n- The <Block name> is the name the block will be registered with (note that a\n'lootplusplus:' will be added to the front; don't add anything with a colon\nyourself!). You should also include a blockstate and item model file for each added\nblock in your resource pack at assets/lootplusplus/blockstates/<Block name>.json and\nassets/lootplusplus/models/item/<Block name>.json.\n- The <Block display name> is what people will see ingame while holding the block.\n- The <Block material> is one of the default materials (determines some things about\nthe block like footstep sounds and such). The possible values are:\n\n      air, anvil, cactus, cake, carpet, circuits, clay, cloth, coral, craftedSnow, dragonEgg, fire\n      glass, gourd, grass, ground, ice, iron, lava, leaves, packedIce, piston, plants, portal\n      redstoneLight, rock, sand, snow, sponge, tnt, vine, water, web, wood\n\n- If <Beacon Base> is true, the block can be used for beacon bases.\n- The <Hardness> is a float that determines how long the block takes to break. If it is\nnegative, the block will be unbreakable like bedrock.\n- The <Explosion resistance> is a float that represents how resistant the block is to explosions.\n- The <Harvesting item type> is a tool type. The default options are 'pickaxe', 'shovel',\n'axe', or 'none'.\n- The <Harvest level> is what level of tool can harvest the block if the tool type is not\n'none'; the default levels are wood and gold = 0, stone = 1, iron = 2, and diamond = 3.\n- The <Light emitted> is how much the block glows, from 0.0 to 1.0.\n- The <Slipperiness> is how slippery the block is, with 0.6 as normal and ice as 0.98.\n- The higher the <Fire spread speed>, the faster the block will catch fire (0 for none).\n- The higher the <Flammability>, the faster the block will burn and disappear (0 for none).\n- The <Opacity> is how opaque the block is, with 0 being transparent, and 255 being almost\ntotally opaque. If -1, the block will be totally opaque.\nHere are some examples of what default blocks would look like:\n\nOak Logs:      log_oak_____Oak Log_____wood_____false_____2.0_____0.0_____axe_____-1_____0.0_____0.6_____5_____5_____-1\nQuartz Pillar: quartz_pillar_____Quartz Pillar_____rock_____false_____0.8_____0.0_____pickaxe_____0_____0.0_____0.6_____0_____0_____-1\n\nFor an example, if you wanted to add a ruby pillar, you could put:\n\n      ruby_pillar_____Ruby Pillar_____iron_____true_____5.0_____10.0_____pickaxe_____2_____0.0_____0.6_____0_____0_____-1";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("logs_pillars"));
        for (index = 0; index < infoList.size(); ++index) {
            int fireSpread;
            float lightEmitted;
            int harvestLevel;
            String toolType;
            float hardness;
            block119: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'logs/pillars' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length != 13) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                blockName = parts[0];
                displayName = parts[1];
                materialName = parts[2];
                beaconBase = false;
                hardness = 1.0f;
                resistance = 0.0f;
                toolType = parts[6];
                harvestLevel = -1;
                lightEmitted = 0.0f;
                slipperiness = 0.0f;
                fireSpread = 0;
                flammability = 0;
                opacity = -1;
                try {
                    beaconBase = Boolean.valueOf(parts[3]);
                    hardness = Float.valueOf(parts[4]).floatValue();
                    resistance = Float.valueOf(parts[5]).floatValue();
                    harvestLevel = Integer.valueOf(parts[7]);
                    lightEmitted = Float.valueOf(parts[8]).floatValue();
                    slipperiness = Float.valueOf(parts[9]).floatValue();
                    fireSpread = Integer.valueOf(parts[10]);
                    flammability = Integer.valueOf(parts[11]);
                    opacity = Integer.valueOf(parts[12]);
                }
                catch (NumberFormatException e) {
                    if (comment) break block119;
                    System.err.println("[Loot++] Caught exception while trying to add a generic block " + blockName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[3], parts[4], parts[5], parts[7], parts[8], parts[9], parts[10], parts[11], parts[12]);
                }
            }
            slipperiness = MathHelper.func_76131_a((float)slipperiness, (float)0.2f, (float)0.98f);
            Material blockMaterial = ConfigLoaderBlocks.getMaterialFromString(materialName);
            if (blockMaterial == null) {
                LootPPNotifier.notify(comment, title, "Couldn't find a material for name: " + materialName);
                continue;
            }
            block = new BlockAddedPillar(blockMaterial, opacity, beaconBase, toolType, harvestLevel, slipperiness, displayName).func_149711_c(hardness).func_149752_b(resistance).func_149672_a(ConfigLoaderBlocks.getSoundsFromString(materialName)).func_149715_a(lightEmitted).func_149663_c(blockName);
            LootPPBlocks.addedBlocks.add(block);
            GameRegistry.registerBlock((Block)block, ItemBlockAdded.class, (String)blockName);
            LootPlusPlusMod.proxy.registerBlockRender(block);
            Blocks.field_150480_ab.func_180686_a(block, fireSpread, flammability);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom pillar block: lootplusplus:" + blockName);
        }
        temp = this.blockConfig.get("adding_decoration", "plants", new String[0]);
        temp.comment = "This adds a 'plant' (single crossed texture) in the format:\n\n      <Block name>_____<Block display name>_____<Block material>_____<Hardness>_____<Explosion resistance>_____<Harvesting item type>_____<Harvest level (-1 for any)>_____<Light emitted>_____<Fire Spread Speed>_____<Flammability>\n\n- The <Block name> is the name the block will be registered with (note that a\n'lootplusplus:' will be added to the front; don't add anything with a colon\nyourself!). You should also include a blockstate and item model file for each added\nblock in your resource pack at assets/lootplusplus/blockstates/<Block name>.json and\nassets/lootplusplus/models/item/<Block name>.json.\n- The <Block display name> is what people will see ingame while holding the block.\n- The <Block material> is one of the default materials (determines some things about\nthe block like footstep sounds and such). The possible values are:\n\n      air, anvil, cactus, cake, carpet, circuits, clay, cloth, coral, craftedSnow, dragonEgg, fire\n      glass, gourd, grass, ground, ice, iron, lava, leaves, packedIce, piston, plants, portal\n      redstoneLight, rock, sand, snow, sponge, tnt, vine, water, web, wood\n\n- The <Hardness> is a float that determines how long the block takes to break.\n- The <Explosion resistance> is a float that represents how resistant the block is to explosions.\n- The <Harvesting item type> is a tool type. The default options are 'pickaxe', 'shovel',\n'axe', or 'none'.\n- The <Harvest level> is what level of tool can harvest the block if the tool type is not\n'none'; the default levels are wood and gold = 0, stone = 1, iron = 2, and diamond = 3.\n- The <Light emitted> is how much the block glows, from 0.0 to 1.0.\n- The higher the <Fire spread speed>, the faster the block will catch fire (0 for none).\n- The higher the <Flammability>, the faster the block will burn and disappear (0 for none).\n\nHere is an example of what a default flower would look like:\n\n      dandelion_____Dandelion_____plants_____0.0_____0.0_____none_____-1_____0.0_____60_____100\n\nFor an example, if you wanted to add a ruby ore and resource block for ruby, you could put:\n\n      ruby_flower_____Ruby Flower_____plants_____0.0_____0.0_____none_____-1_____0.0_____60_____100\n";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("plants"));
        for (index = 0; index < infoList.size(); ++index) {
            int flammability3;
            int fireSpread;
            float lightEmitted;
            int harvestLevel;
            String toolType;
            float resistance3;
            float hardness;
            block120: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'plants' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length != 10) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                blockName = parts[0];
                displayName = parts[1];
                materialName = parts[2];
                hardness = 1.0f;
                resistance3 = 0.0f;
                toolType = parts[5];
                harvestLevel = -1;
                lightEmitted = 0.0f;
                fireSpread = 0;
                flammability3 = 0;
                try {
                    hardness = Float.valueOf(parts[3]).floatValue();
                    resistance3 = Float.valueOf(parts[4]).floatValue();
                    harvestLevel = Integer.valueOf(parts[6]);
                    lightEmitted = Float.valueOf(parts[7]).floatValue();
                    fireSpread = Integer.valueOf(parts[8]);
                    flammability3 = Integer.valueOf(parts[9]);
                }
                catch (NumberFormatException e) {
                    if (comment) break block120;
                    System.err.println("[Loot++] Caught exception while trying to add a plant block " + blockName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[3], parts[4], parts[6], parts[7], parts[8], parts[9]);
                }
            }
            Material blockMaterial = ConfigLoaderBlocks.getMaterialFromString(materialName);
            if (blockMaterial == null) {
                LootPPNotifier.notify(comment, title, "Couldn't find a material for name: " + materialName);
                continue;
            }
            Block block3 = new BlockAddedPlant(blockMaterial, toolType, harvestLevel, displayName).func_149711_c(hardness).func_149752_b(resistance3).func_149672_a(ConfigLoaderBlocks.getSoundsFromString(materialName)).func_149715_a(lightEmitted).func_149663_c(blockName);
            LootPPBlocks.addedBlocks.add(block3);
            GameRegistry.registerBlock((Block)block3, ItemBlockAdded.class, (String)blockName);
            LootPlusPlusMod.proxy.registerBlockRender(block3);
            Blocks.field_150480_ab.func_180686_a(block3, fireSpread, flammability3);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom plant block: lootplusplus:" + blockName);
        }
        temp = this.blockConfig.get("adding_decoration", "slabs", new String[0]);
        temp.comment = "This adds a half slab based on an existing block in the format:\n\n      <Block name>_____<Block display name>_____<Existing block name>_____<Existing block metadata>\n\n- The <Block name> is the name the block will be registered with (note that a\n'lootplusplus:' will be added to the front; don't add anything with a colon\nyourself!). You should also include a blockstate and item model file for each added\nblock in your resource pack at assets/lootplusplus/blockstates/<Block name>.json and\nassets/lootplusplus/models/item/<Block name>.json, and also files for the double block\nassets/lootplusplus/blockstates/<Block name>_double.json and\nassets/lootplusplus/models/item/<Block name>_double.json.\n- The <Block display name> is what people will see ingame while holding the block.\n- The <Existing block name> is the name of the block the slab should be based on.\n- The <Existing block metadata> is the metadata of the block it is based on.\n\nHere are some examples of what default blocks would look like:\n\nWood Slab:    wooden_slab_____Oak Slab_____minecraft:planks_____0\nStone Slab:   stone_slab_____Stone Slab_____minecraft:stone_____0\n\nFor an example, if you wanted to add a ruby slab, you could put:\n\n      ruby_block_slab_____Ruby Block Slab_____lootplusplus:ruby_block_____0\n      ruby_pillar_slab_____Ruby Pillar Slab_____lootplusplus:ruby_pillar_____0";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("slabs"));
        for (index = 0; index < infoList.size(); ++index) {
            Block full;
            Block base;
            float resistance4;
            float hardness;
            int meta;
            block121: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'slabs' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length != 4) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                blockName = parts[0];
                displayName = parts[1];
                existingBlockName = parts[2];
                meta = 0;
                hardness = 1.0f;
                resistance4 = 0.0f;
                Object blockObj = Block.field_149771_c.func_82594_a((Object)existingBlockName);
                if (blockObj == null || !(blockObj instanceof Block) || blockObj == Blocks.field_150350_a) {
                    LootPPNotifier.notifyNonexistant(comment, title, blockName);
                    continue;
                }
                base = (Block)blockObj;
                try {
                    meta = Integer.valueOf(parts[3]);
                    hardness = base.func_176195_g(null, new BlockPos(0, 0, 0));
                    resistance4 = base.func_149638_a(null) * 5.0f / 3.0f;
                }
                catch (Exception e) {
                    if (comment) break block121;
                    System.err.println("[Loot++] Caught exception while trying to add a slab " + blockName);
                    e.printStackTrace();
                    if (!(e instanceof NumberFormatException)) break block121;
                    LootPPNotifier.notifyNumber(comment, title, parts[3]);
                }
            }
            meta = MathHelper.func_76125_a((int)meta, (int)0, (int)15);
            Material blockMaterial = base.func_149688_o();
            Block half = new BlockAddedSlab(blockMaterial, base.func_149662_c() ? -1 : base.func_149717_k(), base.getHarvestTool(base.func_176203_a(meta)), base.getHarvestLevel(base.func_176203_a(meta)), base.field_149765_K, displayName).func_149711_c(hardness).func_149752_b(resistance4).func_149672_a(base.field_149762_H).func_149715_a((float)base.func_149750_m()).func_149663_c(blockName);
            ((BlockAddedSlab)half).full = full = new BlockAddedSlabFull(blockMaterial, base.func_149662_c() ? -1 : base.func_149717_k(), base.getHarvestTool(base.func_176203_a(meta)), base.getHarvestLevel(base.func_176203_a(meta)), base.field_149765_K, displayName).func_149711_c(hardness).func_149752_b(resistance4).func_149672_a(base.field_149762_H).func_149715_a((float)base.func_149750_m()).func_149663_c(blockName + "_double");
            ((BlockAddedSlab)full).slab = half;
            LootPPBlocks.addedBlocks.add(half);
            LootPPBlocks.addedBlocks.add(full);
            GameRegistry.registerBlock((Block)half, ItemBlockAddedSlab.class, (String)blockName);
            GameRegistry.registerBlock((Block)full, null, (String)(blockName + "_double"));
            LootPlusPlusMod.proxy.registerBlockRender(half);
            LootPlusPlusMod.proxy.registerBlockRender(full);
            Blocks.field_150480_ab.func_180686_a(half, Blocks.field_150480_ab.func_176534_d(base), Blocks.field_150480_ab.func_176532_c(base));
            Blocks.field_150480_ab.func_180686_a(full, Blocks.field_150480_ab.func_176534_d(base), Blocks.field_150480_ab.func_176532_c(base));
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom half slab block: lootplusplus:" + blockName);
        }
        temp = this.blockConfig.get("adding_decoration", "stairs", new String[0]);
        temp.comment = "This adds stairs based on an existing block:\n\n      <Block name>_____<Block display name>_____<Existing block name>_____<Existing block metadata>\n\n- The <Block name> is the name the block will be registered with (note that a\n'lootplusplus:' will be added to the front; don't add anything with a colon\nyourself!). You should also include a blockstate and item model file for each added\nblock in your resource pack at assets/lootplusplus/blockstates/<Block name>.json and\nassets/lootplusplus/models/item/<Block name>.json.\n- The <Block display name> is what people will see ingame while holding the block.\n- The <Existing block name> is the name of the block these stairs should be based on.\n- The <Existing block metadata> is the metadata of the block these are based on.\n\nHere are some examples of what default blocks would look like:\n\nOak wood stairs:   oak_stairs_____Oak Stairs_____minecraft:planks_____0\nStone Brick Slab:  stonebrick_stairs_____Stone Brick Stairs_____minecraft:stonebrick_____0\n\nFor an example, if you wanted to add a ruby ore and resource block for ruby, you could put:\n\n      ruby_block_stairs_____Ruby Block Stairs_____lootplusplus:ruby_block_____0";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("stairs"));
        for (index = 0; index < infoList.size(); ++index) {
            int meta;
            block122: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'stairs' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length != 4) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                blockName = parts[0];
                displayName = parts[1];
                existingBlockName = parts[2];
                meta = 0;
                try {
                    meta = Integer.valueOf(parts[3]);
                }
                catch (NumberFormatException e) {
                    if (comment) break block122;
                    System.err.println("[Loot++] Caught exception while trying to add stairs " + blockName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[3]);
                }
            }
            meta = MathHelper.func_76125_a((int)meta, (int)0, (int)15);
            Object blockObj = Block.field_149771_c.func_82594_a((Object)existingBlockName);
            if (blockObj == null || !(blockObj instanceof Block) || blockObj == Blocks.field_150350_a) {
                LootPPNotifier.notifyNonexistant(comment, title, blockName);
                continue;
            }
            Block base = (Block)blockObj;
            Block block4 = new BlockAddedStairs(base, meta, displayName).func_149663_c(blockName);
            LootPPBlocks.addedBlocks.add(block4);
            GameRegistry.registerBlock((Block)block4, ItemBlockAdded.class, (String)blockName);
            LootPlusPlusMod.proxy.registerBlockRender(block4);
            Blocks.field_150480_ab.func_180686_a(block4, Blocks.field_150480_ab.func_176534_d(base), Blocks.field_150480_ab.func_176532_c(base));
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom stairs block: lootplusplus:" + blockName);
        }
        temp = this.blockConfig.get("adding_decoration", "tiles/carpets", new String[0]);
        temp.comment = "This adds a carpet-like block based on an existing block in the format:\n\n      <Block name>_____<Block display name>_____<Existing block name>_____<Existing block metadata>\n\n- The <Block name> is the name the block will be registered with (note that a\n'lootplusplus:' will be added to the front; don't add anything with a colon\nyourself!). You should also include a blockstate and item model file for each added\nblock in your resource pack at assets/lootplusplus/blockstates/<Block name>.json and\nassets/lootplusplus/models/item/<Block name>.json.\n- The <Block display name> is what people will see ingame while holding the block.\n- The <Existing block name> is the name of the block the slab should be based on.\n- The <Existing block metadata> is the metadata of the block it is based on.\n\nFor an example, if you wanted to add a ruby block tile, you could put:\n\n      ruby_tile_____Ruby Tile_____lootplusplus:ruby_block_____0";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("tiles_carpets"));
        for (index = 0; index < infoList.size(); ++index) {
            Block base;
            float resistance5;
            float hardness;
            int meta;
            block123: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'tiles/carpets' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length != 4) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                blockName = parts[0];
                displayName = parts[1];
                existingBlockName = parts[2];
                meta = 0;
                hardness = 1.0f;
                resistance5 = 0.0f;
                Object blockObj = Block.field_149771_c.func_82594_a((Object)existingBlockName);
                if (blockObj == null || !(blockObj instanceof Block) || blockObj == Blocks.field_150350_a) {
                    LootPPNotifier.notifyNonexistant(comment, title, blockName);
                    continue;
                }
                base = (Block)blockObj;
                try {
                    meta = Integer.valueOf(parts[3]);
                    hardness = base.func_176195_g(null, new BlockPos(0, 0, 0));
                    resistance5 = base.func_149638_a(null) * 5.0f / 3.0f;
                }
                catch (Exception e) {
                    if (comment) break block123;
                    System.err.println("[Loot++] Caught exception while trying to add carpet " + blockName);
                    e.printStackTrace();
                    if (!(e instanceof NumberFormatException)) break block123;
                    LootPPNotifier.notifyNumber(comment, title, parts[3]);
                }
            }
            meta = MathHelper.func_76125_a((int)meta, (int)0, (int)15);
            Material blockMaterial = base.func_149688_o();
            Block block5 = new BlockAddedCarpet(blockMaterial, base.func_149717_k(), base.func_149662_c(), false, base.getHarvestTool(base.func_176203_a(meta)), base.getHarvestLevel(base.func_176203_a(meta)), base.field_149765_K, displayName).func_149711_c(hardness / 2.0f).func_149752_b(resistance5).func_149672_a(base.field_149762_H).func_149715_a((float)base.func_149750_m()).func_149663_c(blockName);
            LootPPBlocks.addedBlocks.add(block5);
            GameRegistry.registerBlock((Block)block5, ItemBlockAdded.class, (String)blockName);
            LootPlusPlusMod.proxy.registerBlockRender(block5);
            Blocks.field_150480_ab.func_180686_a(block5, Blocks.field_150480_ab.func_176534_d(base), Blocks.field_150480_ab.func_176532_c(base));
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom carpet block: lootplusplus:" + blockName);
        }
        temp = this.blockConfig.get("adding_decoration", "panes/bars", new String[0]);
        temp.comment = "This adds a glass-pane-like block based on an existing block in the format:\n\n      <Block name>_____<Block display name>_____<Existing block name>_____<Existing block metadata>\n\n- The <Block name> is the name the block will be registered with (note that a\n'lootplusplus:' will be added to the front; don't add anything with a colon\nyourself!). You should also include a blockstate and item model file for each added\nblock in your resource pack at assets/lootplusplus/blockstates/<Block name>.json and\nassets/lootplusplus/models/item/<Block name>.json.\n- The <Block display name> is what people will see ingame while holding the block.\n- The <Existing block name> is the name of the block the slab should be based on.\n- The <Existing block metadata> is the metadata of the block it is based on.\n\nHere are some examples of what default blocks would look like:\n\nGlass Pane:  glass_pane_____Glass Pane_____minecraft:glass_____0\nIron Bars:   iron_bars_____Iron Bars_____minecraft:iron_block_____0\n\nFor an example, if you wanted to add ruby bars, you could put:\n\n      ruby_bars_____Ruby Bars_____lootplusplus:ruby_block_____0";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("panes_bars"));
        for (index = 0; index < infoList.size(); ++index) {
            Block base;
            float resistance6;
            float hardness;
            int meta;
            block124: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'panes/bars' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length != 4) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                blockName = parts[0];
                displayName = parts[1];
                existingBlockName = parts[2];
                meta = 0;
                hardness = 1.0f;
                resistance6 = 0.0f;
                Object blockObj = Block.field_149771_c.func_82594_a((Object)existingBlockName);
                if (blockObj == null || !(blockObj instanceof Block) || blockObj == Blocks.field_150350_a) {
                    LootPPNotifier.notifyNonexistant(comment, title, blockName);
                    continue;
                }
                base = (Block)blockObj;
                try {
                    meta = Integer.valueOf(parts[3]);
                    hardness = base.func_176195_g(null, new BlockPos(0, 0, 0));
                    resistance6 = base.func_149638_a(null) * 5.0f / 3.0f;
                }
                catch (Exception e) {
                    if (comment) break block124;
                    System.err.println("[Loot++] Caught exception while trying to add a pane " + blockName);
                    e.printStackTrace();
                    if (!(e instanceof NumberFormatException)) break block124;
                    LootPPNotifier.notifyNumber(comment, title, parts[3]);
                }
            }
            meta = MathHelper.func_76125_a((int)meta, (int)0, (int)15);
            Material blockMaterial = base.func_149688_o();
            Block block6 = new BlockAddedPane(blockMaterial, base.func_149662_c(), base.getHarvestTool(base.func_176203_a(meta)), base.getHarvestLevel(base.func_176203_a(meta)), base.field_149765_K, displayName).func_149711_c(hardness / 2.0f).func_149752_b(resistance6).func_149672_a(base.field_149762_H).func_149715_a((float)base.func_149750_m()).func_149663_c(blockName);
            LootPPBlocks.addedBlocks.add(block6);
            GameRegistry.registerBlock((Block)block6, ItemBlockAdded.class, (String)blockName);
            LootPlusPlusMod.proxy.registerBlockRender(block6);
            Blocks.field_150480_ab.func_180686_a(block6, Blocks.field_150480_ab.func_176534_d(base), Blocks.field_150480_ab.func_176532_c(base));
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom pane block: lootplusplus:" + blockName);
        }
        temp = this.blockConfig.get("adding_decoration", "walls", new String[0]);
        temp.comment = "This adds a cobblestone wall-like block based on an existing block in the format:\n\n      <Block name>_____<Block display name>_____<Existing block name>_____<Existing block metadata>\n\n- The <Block name> is the name the block will be registered with (note that a\n'lootplusplus:' will be added to the front; don't add anything with a colon\nyourself!). You should also include a blockstate and item model file for each added\nblock in your resource pack at assets/lootplusplus/blockstates/<Block name>.json and\nassets/lootplusplus/models/item/<Block name>.json.\n- The <Block display name> is what people will see ingame while holding the block.\n- The <Existing block name> is the name of the block the slab should be based on.\n- The <Existing block metadata> is the metadata of the block it is based on.\n\nFor an example, if you wanted to add a ruby block wall, you could put:\n\n      ruby_wall_____Ruby Wall_____lootplusplus:ruby_block_____0";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("walls"));
        for (index = 0; index < infoList.size(); ++index) {
            Block base;
            float resistance7;
            float hardness;
            int meta;
            block125: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'walls' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length != 4) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                blockName = parts[0];
                displayName = parts[1];
                existingBlockName = parts[2];
                meta = 0;
                hardness = 1.0f;
                resistance7 = 0.0f;
                Object blockObj = Block.field_149771_c.func_82594_a((Object)existingBlockName);
                if (blockObj == null || !(blockObj instanceof Block) || blockObj == Blocks.field_150350_a) {
                    LootPPNotifier.notifyNonexistant(comment, title, blockName);
                    continue;
                }
                base = (Block)blockObj;
                try {
                    meta = Integer.valueOf(parts[3]);
                    hardness = base.func_176195_g(null, new BlockPos(0, 0, 0));
                    resistance7 = base.func_149638_a(null) * 5.0f / 3.0f;
                }
                catch (Exception e) {
                    if (comment) break block125;
                    System.err.println("[Loot++] Caught exception while trying to add a wall " + blockName);
                    e.printStackTrace();
                    if (!(e instanceof NumberFormatException)) break block125;
                    LootPPNotifier.notifyNumber(comment, title, parts[3]);
                }
            }
            meta = MathHelper.func_76125_a((int)meta, (int)0, (int)15);
            Material blockMaterial = base.func_149688_o();
            Block block7 = new BlockAddedWall(base, base.func_149662_c(), base.getHarvestTool(base.func_176203_a(meta)), base.getHarvestLevel(base.func_176203_a(meta)), displayName).func_149715_a(base.func_149750_m()).func_149711_c(hardness).func_149752_b(resistance7).func_149672_a(base.field_149762_H).func_149663_c(blockName);
            LootPPBlocks.addedBlocks.add(block7);
            GameRegistry.registerBlock((Block)block7, ItemBlockAdded.class, (String)blockName);
            LootPlusPlusMod.proxy.registerBlockRender(block7);
            Blocks.field_150480_ab.func_180686_a(block7, Blocks.field_150480_ab.func_176534_d(base), Blocks.field_150480_ab.func_176532_c(base));
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom wall block: lootplusplus:" + blockName);
        }
        temp = this.blockConfig.get("adding_decoration", "fences", new String[0]);
        temp.comment = "This adds a fence-like block based on an existing block in the format:\n\n      <Block name>_____<Block display name>_____<Existing block name>_____<Existing block metadata>\n\n- The <Block name> is the name the block will be registered with (note that a\n'lootplusplus:' will be added to the front; don't add anything with a colon\nyourself!). You should also include a blockstate and item model file for each added\nblock in your resource pack at assets/lootplusplus/blockstates/<Block name>.json and\nassets/lootplusplus/models/item/<Block name>.json.\n- The <Block display name> is what people will see ingame while holding the block.\n- The <Existing block name> is the name of the block the slab should be based on.\n- The <Existing block metadata> is the metadata of the block it is based on.\n\nFor an example, if you wanted to add a ruby block fence, you could put:\n\n      ruby_fence_____Ruby Fence_____lootplusplus:ruby_block_____0";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("fences"));
        for (index = 0; index < infoList.size(); ++index) {
            Block base;
            float resistance8;
            float hardness;
            int meta;
            block126: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'fences' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length != 4) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                blockName = parts[0];
                displayName = parts[1];
                existingBlockName = parts[2];
                meta = 0;
                hardness = 1.0f;
                resistance8 = 0.0f;
                Object blockObj = Block.field_149771_c.func_82594_a((Object)existingBlockName);
                if (blockObj == null || !(blockObj instanceof Block) || blockObj == Blocks.field_150350_a) {
                    LootPPNotifier.notifyNonexistant(comment, title, blockName);
                    continue;
                }
                base = (Block)blockObj;
                try {
                    meta = Integer.valueOf(parts[3]);
                    hardness = base.func_176195_g(null, new BlockPos(0, 0, 0));
                    resistance8 = base.func_149638_a(null) * 5.0f / 3.0f;
                }
                catch (Exception e) {
                    if (comment) break block126;
                    System.err.println("[Loot++] Caught exception while trying to add fence " + blockName);
                    e.printStackTrace();
                    if (!(e instanceof NumberFormatException)) break block126;
                    LootPPNotifier.notifyNumber(comment, title, parts[3]);
                }
            }
            meta = MathHelper.func_76125_a((int)meta, (int)0, (int)15);
            Material blockMaterial = base.func_149688_o();
            Block block8 = new BlockAddedFence(blockMaterial, base.func_149662_c(), base.getHarvestTool(base.func_176203_a(meta)), base.getHarvestLevel(base.func_176203_a(meta)), displayName).func_149711_c(hardness).func_149752_b(resistance8).func_149672_a(base.field_149762_H).func_149715_a((float)base.func_149750_m()).func_149663_c(blockName);
            LootPPBlocks.addedBlocks.add(block8);
            GameRegistry.registerBlock((Block)block8, ItemBlockAdded.class, (String)blockName);
            LootPlusPlusMod.proxy.registerBlockRender(block8);
            Blocks.field_150480_ab.func_180686_a(block8, Blocks.field_150480_ab.func_176534_d(base), Blocks.field_150480_ab.func_176532_c(base));
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom fence block: lootplusplus:" + blockName);
        }
        temp = this.blockConfig.get("adding_redstone_interacting", "buttons", new String[0]);
        temp.comment = "This adds a button block based on an existing block in the format:\n\n      <Block name>_____<Block display name>_____<Existing block name>_____<Existing block metadata>_____<Pressed time>_____<Arrows Trigger>\n\n- The <Block name> is the name the block will be registered with (note that a\n'lootplusplus:' will be added to the front; don't add anything with a colon\nyourself!). You should also include a blockstate and item model file for each added\nblock in your resource pack at assets/lootplusplus/blockstates/<Block name>.json and\nassets/lootplusplus/models/item/<Block name>.json.\n- The <Block display name> is what people will see ingame while holding the block.\n- The <Existing block name> is the name of the block the slab should be based on.\n- The <Existing block metadata> is the metadata of the block it is based on.\n- The <Pressed time> is how many ticks the button will stay pressed for. For wood buttons\nthis is 30, and for stone, 20 (Note there are 20 ticks per second).\n- If <Arrows trigger> is true, arrows will set off the button.\n\nFor an example, if you wanted to add a ruby button, which presses for 2 seconds, you could put:\n\n      ruby_button_____Ruby Button_____lootplusplus:ruby_block_____0_____40_____false";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("buttons"));
        for (index = 0; index < infoList.size(); ++index) {
            Block base;
            float resistance9;
            float hardness;
            boolean arrowsTrigger;
            int tickRate;
            int meta;
            block127: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'buttons' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length != 6) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                blockName = parts[0];
                displayName = parts[1];
                existingBlockName = parts[2];
                meta = 0;
                tickRate = 20;
                arrowsTrigger = false;
                hardness = 1.0f;
                resistance9 = 0.0f;
                Object blockObj = Block.field_149771_c.func_82594_a((Object)existingBlockName);
                if (blockObj == null || !(blockObj instanceof Block) || blockObj == Blocks.field_150350_a) {
                    LootPPNotifier.notifyNonexistant(comment, title, blockName);
                    continue;
                }
                base = (Block)blockObj;
                try {
                    meta = Integer.valueOf(parts[3]);
                    tickRate = Integer.valueOf(parts[4]);
                    arrowsTrigger = Boolean.valueOf(parts[5]);
                    hardness = base.func_176195_g(null, new BlockPos(0, 0, 0));
                    resistance9 = base.func_149638_a(null) * 5.0f / 3.0f;
                }
                catch (Exception e) {
                    if (comment) break block127;
                    System.err.println("[Loot++] Caught exception while trying to add button " + blockName);
                    e.printStackTrace();
                    if (!(e instanceof NumberFormatException)) break block127;
                    LootPPNotifier.notifyNumber(comment, title, parts[3], parts[4], parts[5]);
                }
            }
            meta = MathHelper.func_76125_a((int)meta, (int)0, (int)15);
            Material blockMaterial = base.func_149688_o();
            Block block9 = new BlockAddedButton(arrowsTrigger, base.func_149662_c(), tickRate, base.getHarvestTool(base.func_176203_a(meta)), base.getHarvestLevel(base.func_176203_a(meta)), displayName).func_149711_c(hardness / 2.0f).func_149752_b(resistance9).func_149672_a(base.field_149762_H).func_149715_a((float)base.func_149750_m()).func_149663_c(blockName);
            LootPPBlocks.addedBlocks.add(block9);
            GameRegistry.registerBlock((Block)block9, ItemBlockAdded.class, (String)blockName);
            LootPlusPlusMod.proxy.registerBlockRender(block9);
            Blocks.field_150480_ab.func_180686_a(block9, Blocks.field_150480_ab.func_176534_d(base), Blocks.field_150480_ab.func_176532_c(base));
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom button: lootplusplus:" + blockName);
        }
        temp = this.blockConfig.get("adding_redstone_interacting", "pressure_plates", new String[0]);
        temp.comment = "This adds a pressure plate block based on an existing block in the format:\n\n      <Block name>_____<Block display name>_____<Existing block name>_____<Existing block metadata>_____<Pressed time>_____<Weight>_____<What triggers>\n\n- The <Block name> is the name the block will be registered with (note that a\n'lootplusplus:' will be added to the front; don't add anything with a colon\nyourself!). You should also include a blockstate and item model file for each added\nblock in your resource pack at assets/lootplusplus/blockstates/<Block name>.json and\nassets/lootplusplus/models/item/<Block name>.json.\n- The <Block display name> is what people will see ingame while holding the block.\n- The <Existing block name> is the name of the block the slab should be based on.\n- The <Existing block metadata> is the metadata of the block it is based on.\n- The <Pressed time> is how many ticks the plate will stay pressed for. For wood buttons\nthis is 30, and for stone, 20 (Note there are 20 ticks per second).\n- The <Weight> is how many valid entities have to be on the plate for it to output a full\nrestone signal.\n- <What triggers> determines what sets off the pressure plate. The valid options are\n\n      everything, mobs, players, items\n\nThe default pressure plates could be represented with:\n\nWooden:  wooden_pressure_plate_____Wooden Pressure Plate_____minecraft:planks_____0_____20_____1_____everything\nStone:   stone_pressure_plate_____Stone Pressure Plate_____minecraft:stone_____0_____20_____1_____mobs\nIron:    iron_pressure_plate_____Iron Pressure Plate_____minecraft:iron_block_____0_____10_____150_____everything\nGold:    gold_pressure_plate_____Gold Pressure Plate_____minecraft:gold_block_____0_____10_____15_____everything\n\nFor an example, if you wanted to add a ruby pressure plate that will give a full redstone\nsignal when 10 players stand on it, and stays pressed for 2 seconds, you could put:\n\n      ruby_pressure_plate_____Ruby Pressure Plate_____lootplusplus:ruby_block_____0_____40_____10_____players";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("pressure_plates"));
        for (index = 0; index < infoList.size(); ++index) {
            Block base;
            float resistance10;
            float hardness;
            String sensitivityName;
            int weight;
            int time;
            int meta;
            block128: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'pressure_plates' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length != 7) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                blockName = parts[0];
                displayName = parts[1];
                existingBlockName = parts[2];
                meta = 0;
                time = 10;
                weight = 1;
                sensitivityName = parts[6];
                hardness = 1.0f;
                resistance10 = 0.0f;
                Object blockObj = Block.field_149771_c.func_82594_a((Object)existingBlockName);
                if (blockObj == null || !(blockObj instanceof Block) || blockObj == Blocks.field_150350_a) {
                    LootPPNotifier.notifyNonexistant(comment, title, blockName);
                    continue;
                }
                base = (Block)blockObj;
                try {
                    meta = Integer.valueOf(parts[3]);
                    time = Integer.valueOf(parts[4]);
                    weight = Integer.valueOf(parts[5]);
                    hardness = base.func_176195_g(null, new BlockPos(0, 0, 0));
                    resistance10 = base.func_149638_a(null) * 5.0f / 3.0f;
                }
                catch (Exception e) {
                    if (comment) break block128;
                    System.err.println("[Loot++] Caught exception while trying to add pressure plate " + blockName);
                    e.printStackTrace();
                    if (!(e instanceof NumberFormatException)) break block128;
                    LootPPNotifier.notifyNumber(comment, title, parts[3], parts[4], parts[5]);
                }
            }
            meta = MathHelper.func_76125_a((int)meta, (int)0, (int)15);
            if (weight < 1) {
                weight = 1;
            }
            Material blockMaterial = base.func_149688_o();
            Block block10 = new BlockAddedPressurePlate(blockMaterial, sensitivityName, time, weight, base.func_149662_c(), base.getHarvestTool(base.func_176203_a(meta)), base.getHarvestLevel(base.func_176203_a(meta)), displayName).func_149711_c(hardness / 2.0f).func_149752_b(resistance10).func_149672_a(base.field_149762_H).func_149715_a((float)base.func_149750_m()).func_149663_c(blockName);
            LootPPBlocks.addedBlocks.add(block10);
            GameRegistry.registerBlock((Block)block10, ItemBlockAdded.class, (String)blockName);
            LootPlusPlusMod.proxy.registerBlockRender(block10);
            Blocks.field_150480_ab.func_180686_a(block10, Blocks.field_150480_ab.func_176534_d(base), Blocks.field_150480_ab.func_176532_c(base));
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom pressure plate: lootplusplus:" + blockName);
        }
        temp = this.blockConfig.get("adding_redstone_interacting", "doors", new String[0]);
        temp.comment = "This adds a door block based on an existing block in the format:\n\n      <Block name>_____<Block display name>_____<Existing block name>_____<Existing block metadata>_____<Only redstone opens (true or false)>\n\n- The <Block name> is the name the block will be registered with (note that a\n'lootplusplus:' will be added to the front; don't add anything with a colon\nyourself!). You should also include a blockstate and item model file for each added\nblock in your resource pack at assets/lootplusplus/blockstates/<Block name>.json and\nassets/lootplusplus/models/item/<Block name>.json.\n- The <Item name> is the name the door item will be registered with (note that a\n'lootplusplus:' will be added to the front; don't add anything with a colon\nyourself!). You should also include an item model for the door item at\nassets/lootplusplus/models/item/<Block name>_item.json\n- The <Block display name> is what people will see ingame while holding the block.\n- The <Existing block name> is the name of the block the slab should be based on.\n- The <Existing block metadata> is the metadata of the block it is based on.\n- If <Only redstone opens> is true, the door can only be openned with a redstone signal\n\nThe default doors could be represented with:\n\nWooden: wooden_door_____Wooden Door_____minecraft:planks_____0_____false\nIron:   iron_door_____Iron Door_____minecraft:iron_block_____0_____true\n\nFor an example, if you wanted to add a ruby door that only opens with redstone, you could put:\n\n      ruby_door_____Ruby Door_____lootplusplus:ruby_block_____0_____true";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("doors"));
        for (index = 0; index < infoList.size(); ++index) {
            Block base;
            float resistance11;
            float hardness;
            boolean onlyRedstone;
            int meta;
            block129: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'doors' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length != 5) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                blockName = parts[0];
                displayName = parts[1];
                existingBlockName = parts[2];
                meta = 0;
                onlyRedstone = false;
                hardness = 1.0f;
                resistance11 = 0.0f;
                Object blockObj = Block.field_149771_c.func_82594_a((Object)existingBlockName);
                if (blockObj == null || !(blockObj instanceof Block) || blockObj == Blocks.field_150350_a) {
                    LootPPNotifier.notifyNonexistant(comment, title, blockName);
                    continue;
                }
                base = (Block)blockObj;
                try {
                    meta = Integer.valueOf(parts[3]);
                    onlyRedstone = Boolean.valueOf(parts[4]);
                    hardness = base.func_176195_g(null, new BlockPos(0, 0, 0));
                    resistance11 = base.func_149638_a(null) * 5.0f / 3.0f;
                }
                catch (Exception e) {
                    if (comment) break block129;
                    System.err.println("[Loot++] Caught exception while trying to add door " + blockName);
                    e.printStackTrace();
                    if (!(e instanceof NumberFormatException)) break block129;
                    LootPPNotifier.notifyNumber(comment, title, parts[3], parts[4]);
                }
            }
            meta = MathHelper.func_76125_a((int)meta, (int)0, (int)15);
            Block block11 = new BlockAddedDoor(base.func_149688_o(), onlyRedstone, base.func_149662_c(), base.getHarvestTool(base.func_176203_a(meta)), base.getHarvestLevel(base.func_176203_a(meta)), base.field_149765_K, displayName).func_149711_c(hardness).func_149752_b(resistance11).func_149672_a(base.field_149762_H).func_149715_a((float)base.func_149750_m()).func_149663_c(blockName);
            Item blockItem = new ItemBlockAddedDoor(block11).func_77655_b(blockName);
            LootPPBlocks.addedBlocks.add(block11);
            LootPPItems.addedItems.add(blockItem);
            GameRegistry.registerBlock((Block)block11, null, (String)blockName);
            GameRegistry.registerItem((Item)blockItem, (String)blockName);
            LootPlusPlusMod.proxy.registerBlockRender(block11);
            LootPlusPlusMod.proxy.registerItemRender(blockItem);
            Blocks.field_150480_ab.func_180686_a(block11, Blocks.field_150480_ab.func_176534_d(base), Blocks.field_150480_ab.func_176532_c(base));
            ((BlockAddedDoor)block11).doorItem = blockItem;
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom door: lootplusplus:" + blockName);
        }
        temp = this.blockConfig.get("adding_redstone_interacting", "fence_gates", new String[0]);
        temp.comment = "This adds a fence gate based on an existing block in the format:\n\n      <Block name>_____<Block display name>_____<Existing block name>_____<Existing block metadata>_____<Only redstone opens (true or false)>\n\n- The <Block name> is the name the block will be registered with (note that a\n'lootplusplus:' will be added to the front; don't add anything with a colon\nyourself!). You should also include a blockstate and item model file for each added\nblock in your resource pack at assets/lootplusplus/blockstates/<Block name>.json and\nassets/lootplusplus/models/item/<Block name>.json.\n- The <Block display name> is what people will see ingame while holding the block.\n- The <Existing block name> is the name of the block the slab should be based on.\n- The <Existing block metadata> is the metadata of the block it is based on.\n- If <Only redstone opens> is true, the door can only be openned with a redstone signal\n\nFor an example, if you wanted to add a ruby fence gate that only opens with redstone, you could put:\n\n      ruby_fence_gate_____Ruby Fence Gate_____lootplusplus:ruby_block_____0_____true";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("fence_gates"));
        for (index = 0; index < infoList.size(); ++index) {
            Block base;
            float resistance12;
            float hardness;
            boolean onlyRedstone;
            int meta;
            block130: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'fence_gates' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length != 5) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                blockName = parts[0];
                displayName = parts[1];
                existingBlockName = parts[2];
                meta = 0;
                onlyRedstone = false;
                hardness = 1.0f;
                resistance12 = 0.0f;
                Object blockObj = Block.field_149771_c.func_82594_a((Object)existingBlockName);
                if (blockObj == null || !(blockObj instanceof Block) || blockObj == Blocks.field_150350_a) {
                    LootPPNotifier.notifyNonexistant(comment, title, blockName);
                    continue;
                }
                base = (Block)blockObj;
                try {
                    meta = Integer.valueOf(parts[3]);
                    onlyRedstone = Boolean.valueOf(parts[4]);
                    hardness = base.func_176195_g(null, new BlockPos(0, 0, 0));
                    resistance12 = base.func_149638_a(null) * 5.0f / 3.0f;
                }
                catch (Exception e) {
                    if (comment) break block130;
                    System.err.println("[Loot++] Caught exception while trying to add fence gate " + blockName);
                    e.printStackTrace();
                    if (!(e instanceof NumberFormatException)) break block130;
                    LootPPNotifier.notifyNumber(comment, title, parts[3], parts[4]);
                }
            }
            meta = MathHelper.func_76125_a((int)meta, (int)0, (int)15);
            Material blockMaterial = base.func_149688_o();
            Block block12 = new BlockAddedFenceGate(blockMaterial, onlyRedstone, base.func_149662_c(), base.getHarvestTool(base.func_176203_a(meta)), base.getHarvestLevel(base.func_176203_a(meta)), base.field_149765_K, displayName).func_149711_c(hardness).func_149752_b(resistance12).func_149672_a(base.field_149762_H).func_149715_a((float)base.func_149750_m()).func_149663_c(blockName);
            LootPPBlocks.addedBlocks.add(block12);
            GameRegistry.registerBlock((Block)block12, ItemBlockAdded.class, (String)blockName);
            LootPlusPlusMod.proxy.registerBlockRender(block12);
            Blocks.field_150480_ab.func_180686_a(block12, Blocks.field_150480_ab.func_176534_d(base), Blocks.field_150480_ab.func_176532_c(base));
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom fence gate: lootplusplus:" + blockName);
        }
        temp = this.blockConfig.get("adding_interactable", "ladders", new String[0]);
        temp.comment = "This adds a ladder block in the format:\n\n      <Block name>_____<Block display name>_____<Hardness>_____<Explosion resistance>_____<Harvesting item type>_____<Harvest level (-1 for any)>_____<Light emitted>_____<Fire Spread Speed>_____<Flammability>_____<Slipperiness>\n\n- The <Block name> is the name the block will be registered with (note that a\n'lootplusplus:' will be added to the front; don't add anything with a colon\nyourself!). You should also include a blockstate and item model file for each added\nblock in your resource pack at assets/lootplusplus/blockstates/<Block name>.json and\nassets/lootplusplus/models/item/<Block name>.json.\n- The <Block display name> is what people will see ingame while holding the block.\n- The <Hardness> is a float that determines how long the block takes to break.\n- The <Explosion resistance> is a float that represents how resistant the block is to explosions.\n- The <Harvesting item type> is a tool type. The default options are 'pickaxe', 'shovel',\n'axe', or 'none'.\n- The <Harvest level> is what level of tool can harvest the block if the tool type is not\n'none'; the default levels are wood and gold = 0, stone = 1, iron = 2, and diamond = 3.\n- The <Light emitted> is how much the block glows, from 0.0 to 1.0.\n- The higher the <Fire spread speed>, the faster the block will catch fire (0 for none).\n- The higher the <Flammability>, the faster the block will burn and disappear (0 for none).\n- The <Slipperiness> is how slippery the block is, with 0.6 as normal and ice as 0.98.\n\nFor an example, if you wanted to add a ruby ladder, you could put:\n\n      ruby_ladder_____Ruby Ladder_____3.0_____10.0_____pickaxe_____2_____0.0_____0_____0_____0.6\n";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("ladders"));
        for (index = 0; index < infoList.size(); ++index) {
            float slipperiness3;
            int flammability4;
            int fireSpread;
            float lightEmitted;
            int harvestLevel;
            String toolType;
            float resistance13;
            float hardness;
            block131: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'ladders' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length != 10) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                blockName = parts[0];
                displayName = parts[1];
                hardness = 1.0f;
                resistance13 = 0.0f;
                toolType = parts[4];
                harvestLevel = -1;
                lightEmitted = 0.0f;
                fireSpread = 0;
                flammability4 = 0;
                slipperiness3 = 0.6f;
                try {
                    hardness = Float.valueOf(parts[2]).floatValue();
                    resistance13 = Float.valueOf(parts[3]).floatValue();
                    harvestLevel = Integer.valueOf(parts[5]);
                    lightEmitted = Float.valueOf(parts[6]).floatValue();
                    fireSpread = Integer.valueOf(parts[7]);
                    flammability4 = Integer.valueOf(parts[8]);
                    slipperiness3 = Float.valueOf(parts[9]).floatValue();
                }
                catch (NumberFormatException e) {
                    if (comment) break block131;
                    System.err.println("[Loot++] Caught exception while trying to add a ladder " + blockName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[2], parts[3], parts[5], parts[6], parts[7], parts[8], parts[9]);
                }
            }
            slipperiness3 = MathHelper.func_76131_a((float)slipperiness3, (float)0.2f, (float)0.98f);
            Block block13 = new BlockAddedLadder(toolType, harvestLevel, slipperiness3, displayName).func_149711_c(hardness).func_149752_b(resistance13).func_149672_a(Block.field_149774_o).func_149715_a(lightEmitted).func_149663_c(blockName);
            LootPPBlocks.addedBlocks.add(block13);
            GameRegistry.registerBlock((Block)block13, ItemBlockAdded.class, (String)blockName);
            LootPlusPlusMod.proxy.registerBlockRender(block13);
            Blocks.field_150480_ab.func_180686_a(block13, fireSpread, flammability4);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom ladder: lootplusplus:" + blockName);
        }
        temp = this.blockConfig.get("adding_interactable", "furnaces", new String[0]);
        temp.comment = "This adds a furnace block in the format:\n\n      <Block name>_____<Block display name>_____<Block material>_____<Hardness>_____<Explosion resistance>_____<Harvesting item type>_____<Harvest level (-1 for any)>_____<Light emitted>_____<Slipperiness>_____<Speed>_____<Opacity>\n\n- The <Block name> is the name the block will be registered with (note that a\n'lootplusplus:' will be added to the front; don't add anything with a colon\nyourself!). You should also include a blockstate and item model file for each added\nblock in your resource pack with suffixes _lit and _unlit. So the files would be at\nassets/lootplusplus/blockstates/<Block name>_lit.json, assets/lootplusplus/models/item/<Block name>_lit.json,\nassets/lootplusplus/blockstates/<Block name>_unlit.json, assets/lootplusplus/models/item/<Block name>_unlit.json.\n- The <Block display name> is what people will see ingame while holding the block.\n- The <Block material> is one of the default materials. (In this case the material is hard\ncoded to be 'rock', so this will only determine mining/footstep sounds!) The possible values are:\n\n      air, anvil, cactus, cake, carpet, circuits, clay, cloth, coral, craftedSnow, dragonEgg, fire\n      glass, gourd, grass, ground, ice, iron, lava, leaves, packedIce, piston, plants, portal\n      redstoneLight, rock, sand, snow, sponge, tnt, vine, water, web, wood\n\n- The <Hardness> is a float that determines how long the block takes to break.\n- The <Explosion resistance> is a float that represents how resistant the block is to explosions.\n- The <Harvesting item type> is a tool type. The default options are 'pickaxe', 'shovel',\n'axe', or 'none'.\n- The <Harvest level> is what level of tool can harvest the block if the tool type is not\n'none'; the default levels are wood and gold = 0, stone = 1, iron = 2, and diamond = 3.\n- The <Light emitted> is how much the block glows, from 0.0 to 1.0.\n- The <Slipperiness> is how slippery the block is, with 0.6 as normal and ice as 0.98.\n- The <Speed> is how fast the furnace runs, with 1.0 being normal, 2.0 twice as fast, ect.\n- The <Opacity> is how opaque the block is, with 0 being transparent, and 255 being almost\ntotally opaque. If -1, the block will be totally opaque.\n\nFor an example, if you wanted to add a ruby furnace which is a bit faster, you could put:\n\n      ruby_furnace_____Ruby Furnace_____iron_____3.0_____10.0_____pickaxe_____2_____0.0_____0.6_____1.5_____-1\n";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("furnaces"));
        for (index = 0; index < infoList.size(); ++index) {
            int opacity3;
            float speed;
            float slipperiness4;
            float light;
            int harvestLevel;
            String toolType;
            float resistance14;
            float hardness;
            String materialName2;
            block132: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'furnaces' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length != 11) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                blockName = parts[0];
                displayName = parts[1];
                materialName2 = parts[2];
                hardness = 1.0f;
                resistance14 = 0.0f;
                toolType = parts[5];
                harvestLevel = -1;
                light = 0.0f;
                slipperiness4 = 0.6f;
                speed = 1.0f;
                opacity3 = -1;
                try {
                    hardness = Float.valueOf(parts[3]).floatValue();
                    resistance14 = Float.valueOf(parts[4]).floatValue();
                    harvestLevel = Integer.valueOf(parts[6]);
                    light = Float.valueOf(parts[7]).floatValue();
                    slipperiness4 = Float.valueOf(parts[8]).floatValue();
                    speed = Float.valueOf(parts[9]).floatValue();
                    opacity3 = Integer.valueOf(parts[10]);
                }
                catch (NumberFormatException e) {
                    if (comment) break block132;
                    System.err.println("[Loot++] Caught exception while trying to add a furnace block " + blockName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[3], parts[4], parts[6], parts[7], parts[8], parts[9], parts[10]);
                }
            }
            slipperiness4 = MathHelper.func_76131_a((float)slipperiness4, (float)0.2f, (float)0.98f);
            Material blockMaterial = ConfigLoaderBlocks.getMaterialFromString(materialName2);
            if (blockMaterial == null) {
                LootPPNotifier.notify(comment, title, "Couldn't find a material for name: " + materialName2);
                continue;
            }
            Block block14 = new BlockAddedFurnace(blockMaterial, speed, toolType, opacity3, harvestLevel, light, slipperiness4, displayName).func_149711_c(hardness).func_149752_b(resistance14).func_149672_a(ConfigLoaderBlocks.getSoundsFromString(materialName2)).func_149663_c(blockName);
            LootPPBlocks.addedBlocks.add(block14);
            GameRegistry.registerBlock((Block)block14, ItemBlockAdded.class, (String)blockName);
            LootPlusPlusMod.proxy.registerBlockRender(block14);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom furnace: lootplusplus:" + blockName);
        }
        temp = this.blockConfig.get("adding_interactable", "crafting_tables", new String[0]);
        temp.comment = "This adds a crafting table with options in the format:\n\n      <Block name>_____<Block display name>_____<Block material>_____<Hardness>_____<Explosion resistance>_____<Harvesting item type>_____<Harvest level (-1 for any)>_____<Light emitted>_____<Slipperiness>_____<Fire Spread Speed>_____<Flammability>_____<Opacity>\n\n- The <Block name> is the name the block will be registered with (note that a\n'lootplusplus:' will be added to the front; don't add anything with a colon\nyourself!). You should also include a blockstate and item model file for each added\nblock in your resource pack at assets/lootplusplus/blockstates/<Block name>.json and\nassets/lootplusplus/models/item/<Block name>.json.\n- The <Block display name> is what people will see ingame while holding the block.\n- The <Block material> is one of the default materials (determines some things about\nthe block like footstep sounds and such). The possible values are:\n\n      air, anvil, cactus, cake, carpet, circuits, clay, cloth, coral, craftedSnow, dragonEgg, fire\n      glass, gourd, grass, ground, ice, iron, lava, leaves, packedIce, piston, plants, portal\n      redstoneLight, rock, sand, snow, sponge, tnt, vine, water, web, wood\n\n- The <Hardness> is a float that determines how long the block takes to break. If it is\nnegative, the block will be unbreakable like bedrock.\n- The <Explosion resistance> is a float that represents how resistant the block is to explosions.\n- The <Harvesting item type> is a tool type. The default options are 'pickaxe', 'shovel',\n'axe', or 'none'.\n- The <Harvest level> is what level of tool can harvest the block if the tool type is not\n'none'; the default levels are wood and gold = 0, stone = 1, iron = 2, and diamond = 3.\n- The <Light emitted> is how much the block glows, from 0.0 to 1.0.\n- The <Slipperiness> is how slippery the block is, with 0.6 as normal and ice as 0.98.\n- The higher the <Fire spread speed>, the faster the block will catch fire (0 for none).\n- The higher the <Flammability>, the faster the block will burn and disappear (0 for none).\n- The <Opacity> is how opaque the block is, with 0 being transparent, and 255 being almost\ntotally opaque. If -1, the block will be totally opaque.\nFor an example, if you wanted to add a ruby block crafting table, you could put:\n\n      ruby_crafting_table_____Ruby Crafting Table_____iron_____5.0_____10.0_____pickaxe_____2_____0.0_____0.6_____0_____0_____-1";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("crafting_tables"));
        for (index = 0; index < infoList.size(); ++index) {
            int opacity4;
            int flammability5;
            int fireSpread;
            float slipperiness5;
            float lightEmitted;
            int harvestLevel;
            String toolType;
            float resistance15;
            float hardness;
            String materialName3;
            block133: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'crafting_tables' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length != 12) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                blockName = parts[0];
                displayName = parts[1];
                materialName3 = parts[2];
                hardness = 1.0f;
                resistance15 = 0.0f;
                toolType = parts[5];
                harvestLevel = -1;
                lightEmitted = 0.0f;
                slipperiness5 = 0.0f;
                fireSpread = 0;
                flammability5 = 0;
                opacity4 = -1;
                try {
                    hardness = Float.valueOf(parts[3]).floatValue();
                    resistance15 = Float.valueOf(parts[4]).floatValue();
                    harvestLevel = Integer.valueOf(parts[6]);
                    lightEmitted = Float.valueOf(parts[7]).floatValue();
                    slipperiness5 = Float.valueOf(parts[8]).floatValue();
                    fireSpread = Integer.valueOf(parts[9]);
                    flammability5 = Integer.valueOf(parts[10]);
                    opacity4 = Integer.valueOf(parts[11]);
                }
                catch (NumberFormatException e) {
                    if (comment) break block133;
                    System.err.println("[Loot++] Caught exception while trying to add a crafting table " + blockName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[3], parts[4], parts[6], parts[7], parts[8], parts[9], parts[10], parts[11]);
                }
            }
            slipperiness5 = MathHelper.func_76131_a((float)slipperiness5, (float)0.2f, (float)0.98f);
            Material blockMaterial = ConfigLoaderBlocks.getMaterialFromString(materialName3);
            if (blockMaterial == null) {
                LootPPNotifier.notify(comment, title, "Couldn't find a material for name: " + materialName3);
                continue;
            }
            Block block15 = new BlockAddedWorkbench(blockMaterial, opacity4, toolType, harvestLevel, slipperiness5, displayName).func_149711_c(hardness).func_149752_b(resistance15).func_149672_a(ConfigLoaderBlocks.getSoundsFromString(materialName3)).func_149715_a(lightEmitted).func_149663_c(blockName);
            LootPPBlocks.addedBlocks.add(block15);
            GameRegistry.registerBlock((Block)block15, ItemBlockAdded.class, (String)blockName);
            LootPlusPlusMod.proxy.registerBlockRender(block15);
            Blocks.field_150480_ab.func_180686_a(block15, fireSpread, flammability5);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom crafting table: lootplusplus:" + blockName);
        }
        temp = this.blockConfig.get("adding_interactable", "cakes", new String[0]);
        temp.comment = "This adds a cake block with options in the format:\n\n      <Block name>_____<Block display name>_____<Hardness>_____<Explosion resistance>_____<Light emitted>_____<Slipperiness>_____<Fire Spread Speed>_____<Flammability>_____<Number of bites>_____<Hunger restored>_____<Saturation restored>_____<Always edible? (true or false)>_____<Potion effects given (optional)>\n\n- The <Block name> is the name the block will be registered with (note that a\n'lootplusplus:' will be added to the front; don't add anything with a colon\nyourself!). You should also include a blockstate and item model file for each added\nblock in your resource pack at assets/lootplusplus/blockstates/<Block name>.json and\nassets/lootplusplus/models/item/<Block name>.json.\n- The <Hardness> is a float that determines how long the block takes to break. If it is\nnegative, the block will be unbreakable like bedrock.\n- The <Explosion resistance> is a float that represents how resistant the block is to explosions.\n- The <Light emitted> is how much the block glows, from 0.0 to 1.0.\n- The <Slipperiness> is how slippery the block is, with 0.6 as normal and ice as 0.98.\n- The higher the <Fire spread speed>, the faster the block will catch fire (0 for none).\n- The higher the <Flammability>, the faster the block will burn and disappear (0 for none).\n- The <Number of bites> is how many bites the cake has.\n- The <Hunger restored> is the number of hunger points restored\n- The <Saturation restored> is the percentage of saturation restored\n- If <Always edible> is true, you can eat the cake even if you're not hungry\n- Finally the potions the food gives you is a list of potion effects in the format:\n\n      ..._____<Potion effect id>-<Potion duration>-<Potion level (0 is 1)>-<Probability (between 0.0 and 1.0)>-<Particle type (normal, faded, none)>_____...\n\nFor example, the vanilla cake (lol, I always laugh at that) would look like:\n\n      cake_____Cake_____0.3_____0.0_____0.0_____0.6_____0_____0_____7_____2_____0.1_____false\n\nFor an example, if you wanted to add a ruby cake that gives you health boost and is always\nedible, you could put:\n\n      ruby_apple_cake_____\u00a7bRuby Apple Cake_____0.6_____10.0_____0.0_____0.6_____0_____0_____7_____4_____0.5_____true_____10-150-1-1.0-normal_____21-2400-1-1.0-normal";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("cakes"));
        for (index = 0; index < infoList.size(); ++index) {
            boolean alwaysEat;
            float saturation;
            int hunger;
            int slices;
            int flammability6;
            int fireSpread;
            float slipperiness6;
            float lightEmitted;
            float resistance16;
            float hardness;
            block134: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'cakes' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length < 12) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                blockName = parts[0];
                displayName = parts[1];
                hardness = 1.0f;
                resistance16 = 0.0f;
                lightEmitted = 0.0f;
                slipperiness6 = 0.0f;
                fireSpread = 0;
                flammability6 = 0;
                slices = 7;
                hunger = 2;
                saturation = 0.1f;
                alwaysEat = false;
                try {
                    hardness = Float.valueOf(parts[2]).floatValue();
                    resistance16 = Float.valueOf(parts[3]).floatValue();
                    lightEmitted = Float.valueOf(parts[4]).floatValue();
                    slipperiness6 = Float.valueOf(parts[5]).floatValue();
                    fireSpread = Integer.valueOf(parts[6]);
                    flammability6 = Integer.valueOf(parts[7]);
                    slices = Integer.valueOf(parts[8]);
                    hunger = Integer.valueOf(parts[9]);
                    saturation = Float.valueOf(parts[10]).floatValue();
                    alwaysEat = Boolean.valueOf(parts[11]);
                }
                catch (NumberFormatException e) {
                    if (comment) break block134;
                    System.err.println("[Loot++] Caught exception while trying to add a cake block " + blockName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[2], parts[3], parts[4], parts[5], parts[6], parts[7], parts[8], parts[9], parts[10], parts[11]);
                }
            }
            BlockAddedCake.nextNumBites = slices;
            Block block16 = new BlockAddedCake(slipperiness6, slices, hunger, saturation, alwaysEat, displayName).func_149711_c(hardness).func_149752_b(resistance16).func_149672_a(ConfigLoaderBlocks.getSoundsFromString("cake")).func_149715_a(lightEmitted).func_149663_c(blockName);
            LootPPBlocks.addedBlocks.add(block16);
            GameRegistry.registerBlock((Block)block16, ItemBlockAdded.class, (String)blockName);
            LootPlusPlusMod.proxy.registerBlockRender(block16);
            Blocks.field_150480_ab.func_180686_a(block16, fireSpread, flammability6);
            if (parts.length > 12) {
                for (int i = 12; i < parts.length; ++i) {
                    String particles;
                    float probability;
                    int potionAmplifier;
                    int potionDuration;
                    Potion potion;
                    block135: {
                        String[] potionParts = parts[i].split("-");
                        if (potionParts.length != 5) {
                            LootPPNotifier.notifyWrongNumberOfParts(comment, title, parts[i]);
                            continue;
                        }
                        potion = Potion.func_180142_b((String)potionParts[0]);
                        potionDuration = 100;
                        potionAmplifier = 0;
                        probability = 1.0f;
                        particles = potionParts[4];
                        if (potion == null) {
                            try {
                                int effectId = Integer.valueOf(potionParts[0]);
                                potion = Potion.field_76425_a[effectId];
                            }
                            catch (NumberFormatException effectId) {
                                // empty catch block
                            }
                            if (potion == null) {
                                LootPPNotifier.notify(comment, title, "Couldn't find potion effect '" + potionParts[0] + "'");
                                continue;
                            }
                        }
                        try {
                            potionDuration = Integer.valueOf(potionParts[1]);
                            potionAmplifier = Integer.valueOf(potionParts[2]);
                            probability = Float.valueOf(potionParts[3]).floatValue();
                        }
                        catch (NumberFormatException e) {
                            if (comment) break block135;
                            System.err.println("[Loot++] Caught an exception while trying to create a cake " + blockName);
                            e.printStackTrace();
                            LootPPNotifier.notifyNumber(comment, title, potionParts[1], potionParts[2], potionParts[3]);
                        }
                    }
                    PotionEffect effect = new PotionEffect(potion.func_76396_c(), potionDuration, potionAmplifier);
                    ((BlockAddedCake)block16).addPotionEffect(effect, probability, particles);
                }
            }
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom cake block: lootplusplus:" + blockName);
        }
    }

    public void loadCropAdditions() {
        Property temp = this.blockConfig.get("adding_crops", "crops", new String[0]);
        temp.comment = "This adds a crop block with options in the format:\n\n      <Block name>_____<Block display name>_____<Seed item name>_____<Seed item metadata>_____<Light emitted>_____<Fire Spread Speed>_____<Flammability>_____<Can bonemeal (true or false)>_____<Nether plant (true or false)>_____<Right click to harvest (true or false)>\n\n- The <Block name> is the name the block will be registered with (note that a\n'lootplusplus:' will be added to the front; don't add anything with a colon\nyourself!). You should also include a blockstate and item model file for each added\nblock in your resource pack at assets/lootplusplus/blockstates/<Block name>.json and\nassets/lootplusplus/models/item/<Block name>.json.\n- The <Seed item name> is the name of the item that is considered the seed for this crop.\n- The <Seed item metadata> is the metadata value of the seed item, with -1 for any.\n- The <Light emitted> is how much the block glows, from 0.0 to 1.0.\n- The higher the <Fire spread speed>, the faster the block will catch fire (0 for none).\n- The higher the <Flammability>, the faster the block will burn and disappear (0 for none).\n- If <Can bonemeal> is true, bonemeal will grow the crops.\n- If <Nether plant> is true, the crop should be planted on soul sand like nether wart.\n- If <Right click to harvest> is true, you can harvest and replant the crop by right clicking.\n\nFor example, wheat and nether wart would look something like:\n\n      wheat_____Wheat_____wheat_seeds_____-1_____0.0_____0_____0_____true_____false_____false\n      nether_wart_____Nether Wart_____nether_wart_____-1_____0.0_____0_____0_____false_____true_____false\n\nFor an example, if you wanted to add a 'ruby crop' that you can right click harvest, you could put:\n\n      ruby_crop_____Ruby Crop_____lootplusplus:ruby_____-1_____0.0_____0_____0_____true_____false_____true";
        ArrayList<String> infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("crops"));
        for (int index = 0; index < infoList.size(); ++index) {
            Object itemObj;
            boolean rightClick;
            boolean nether;
            boolean bonemeal;
            int flammability;
            int fireSpread;
            float lightEmitted;
            int seedItemMeta;
            String seedItemName;
            String displayName;
            String blockName;
            boolean comment;
            String title;
            block8: {
                String info = infoList.get(index);
                title = this.getFileName() + ".cfg 'crops' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                String[] parts = info.split("_____");
                if (parts.length < 10) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                blockName = parts[0];
                displayName = parts[1];
                seedItemName = parts[2];
                seedItemMeta = -1;
                lightEmitted = 0.0f;
                fireSpread = 0;
                flammability = 0;
                bonemeal = true;
                nether = false;
                rightClick = false;
                try {
                    seedItemMeta = Integer.valueOf(parts[3]);
                    lightEmitted = Float.valueOf(parts[4]).floatValue();
                    fireSpread = Integer.valueOf(parts[5]);
                    flammability = Integer.valueOf(parts[6]);
                    bonemeal = Boolean.valueOf(parts[7]);
                    nether = Boolean.valueOf(parts[8]);
                    rightClick = Boolean.valueOf(parts[9]);
                }
                catch (NumberFormatException e) {
                    if (comment) break block8;
                    System.err.println("[Loot++] Caught exception while trying to add a cake block " + blockName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[3], parts[4], parts[5], parts[6], parts[7], parts[8], parts[9]);
                }
            }
            if (seedItemMeta < 0) {
                seedItemMeta = Short.MAX_VALUE;
            }
            if ((itemObj = Item.field_150901_e.func_82594_a((Object)seedItemName)) == null || !(itemObj instanceof Item)) {
                LootPPNotifier.notifyNonexistant(comment, title, seedItemName);
            }
            Item item = (Item)itemObj;
            ItemStack seedItem = new ItemStack(item, 1, seedItemMeta);
            if (BlockAddedCrops.itemToCrop.keySet().contains(seedItem)) {
                LootPPNotifier.notify(comment, title, "A custom crop block is already registered for 'seed' item " + seedItemName + " with meta " + seedItemMeta);
                continue;
            }
            Block block = new BlockAddedCrops(seedItem, bonemeal, nether, rightClick, displayName).func_149672_a(ConfigLoaderBlocks.getSoundsFromString("plants")).func_149715_a(lightEmitted).func_149663_c(blockName);
            LootPPBlocks.addedBlocks.add(block);
            GameRegistry.registerBlock((Block)block, null, (String)blockName);
            Blocks.field_150480_ab.func_180686_a(block, fireSpread, flammability);
        }
        this.blockConfig.save();
    }

    public static Material getMaterialFromString(String materialName) {
        if (materialName.equalsIgnoreCase("air")) {
            return Material.field_151579_a;
        }
        if (materialName.equalsIgnoreCase("anvil")) {
            return Material.field_151574_g;
        }
        if (materialName.equalsIgnoreCase("cactus")) {
            return Material.field_151570_A;
        }
        if (materialName.equalsIgnoreCase("cake")) {
            return Material.field_151568_F;
        }
        if (materialName.equalsIgnoreCase("carpet")) {
            return Material.field_151593_r;
        }
        if (materialName.equalsIgnoreCase("circuits")) {
            return Material.field_151594_q;
        }
        if (materialName.equalsIgnoreCase("clay")) {
            return Material.field_151571_B;
        }
        if (materialName.equalsIgnoreCase("cloth")) {
            return Material.field_151580_n;
        }
        if (materialName.equalsIgnoreCase("coral")) {
            return Material.field_151589_v;
        }
        if (materialName.equalsIgnoreCase("craftedSnow")) {
            return Material.field_151596_z;
        }
        if (materialName.equalsIgnoreCase("dragonEgg")) {
            return Material.field_151566_D;
        }
        if (materialName.equalsIgnoreCase("fire")) {
            return Material.field_151581_o;
        }
        if (materialName.equalsIgnoreCase("glass")) {
            return Material.field_151592_s;
        }
        if (materialName.equalsIgnoreCase("gourd")) {
            return Material.field_151572_C;
        }
        if (materialName.equalsIgnoreCase("grass")) {
            return Material.field_151577_b;
        }
        if (materialName.equalsIgnoreCase("ground")) {
            return Material.field_151578_c;
        }
        if (materialName.equalsIgnoreCase("ice")) {
            return Material.field_151588_w;
        }
        if (materialName.equalsIgnoreCase("iron")) {
            return Material.field_151573_f;
        }
        if (materialName.equalsIgnoreCase("lava")) {
            return Material.field_151587_i;
        }
        if (materialName.equalsIgnoreCase("leaves")) {
            return Material.field_151584_j;
        }
        if (materialName.equalsIgnoreCase("packedIce")) {
            return Material.field_151598_x;
        }
        if (materialName.equalsIgnoreCase("piston")) {
            return Material.field_76233_E;
        }
        if (materialName.equalsIgnoreCase("plants")) {
            return Material.field_151585_k;
        }
        if (materialName.equalsIgnoreCase("portal")) {
            return Material.field_151567_E;
        }
        if (materialName.equalsIgnoreCase("redstoneLight")) {
            return Material.field_151591_t;
        }
        if (materialName.equalsIgnoreCase("rock")) {
            return Material.field_151576_e;
        }
        if (materialName.equalsIgnoreCase("sand")) {
            return Material.field_151595_p;
        }
        if (materialName.equalsIgnoreCase("snow")) {
            return Material.field_151597_y;
        }
        if (materialName.equalsIgnoreCase("sponge")) {
            return Material.field_151583_m;
        }
        if (materialName.equalsIgnoreCase("tnt")) {
            return Material.field_151590_u;
        }
        if (materialName.equalsIgnoreCase("vine")) {
            return Material.field_151582_l;
        }
        if (materialName.equalsIgnoreCase("water")) {
            return Material.field_151586_h;
        }
        if (materialName.equalsIgnoreCase("web")) {
            return Material.field_151569_G;
        }
        if (materialName.equalsIgnoreCase("wood")) {
            return Material.field_151575_d;
        }
        return null;
    }

    public static Block.SoundType getSoundsFromString(String materialName) {
        if (materialName.equalsIgnoreCase("anvil")) {
            return Block.field_149788_p;
        }
        if (materialName.equalsIgnoreCase("cactus")) {
            return Block.field_149775_l;
        }
        if (materialName.equalsIgnoreCase("cake")) {
            return Block.field_149775_l;
        }
        if (materialName.equalsIgnoreCase("carpet")) {
            return Block.field_149775_l;
        }
        if (materialName.equalsIgnoreCase("circuits")) {
            return Block.field_149769_e;
        }
        if (materialName.equalsIgnoreCase("clay")) {
            return Block.field_149767_g;
        }
        if (materialName.equalsIgnoreCase("cloth")) {
            return Block.field_149775_l;
        }
        if (materialName.equalsIgnoreCase("coral")) {
            return Block.field_149779_h;
        }
        if (materialName.equalsIgnoreCase("craftedSnow")) {
            return Block.field_149773_n;
        }
        if (materialName.equalsIgnoreCase("dragonEgg")) {
            return Block.field_149780_i;
        }
        if (materialName.equalsIgnoreCase("fire")) {
            return Block.field_149775_l;
        }
        if (materialName.equalsIgnoreCase("glass")) {
            return Block.field_149778_k;
        }
        if (materialName.equalsIgnoreCase("gourd")) {
            return Block.field_149766_f;
        }
        if (materialName.equalsIgnoreCase("grass")) {
            return Block.field_149779_h;
        }
        if (materialName.equalsIgnoreCase("ground")) {
            return Block.field_149767_g;
        }
        if (materialName.equalsIgnoreCase("ice")) {
            return Block.field_149778_k;
        }
        if (materialName.equalsIgnoreCase("iron")) {
            return Block.field_149777_j;
        }
        if (materialName.equalsIgnoreCase("lava")) {
            return Block.field_149780_i;
        }
        if (materialName.equalsIgnoreCase("leaves")) {
            return Block.field_149779_h;
        }
        if (materialName.equalsIgnoreCase("packedIce")) {
            return Block.field_149778_k;
        }
        if (materialName.equalsIgnoreCase("piston")) {
            return Block.field_149780_i;
        }
        if (materialName.equalsIgnoreCase("plants")) {
            return Block.field_149779_h;
        }
        if (materialName.equalsIgnoreCase("portal")) {
            return Block.field_149780_i;
        }
        if (materialName.equalsIgnoreCase("redstoneLight")) {
            return Block.field_149780_i;
        }
        if (materialName.equalsIgnoreCase("rock")) {
            return Block.field_149780_i;
        }
        if (materialName.equalsIgnoreCase("sand")) {
            return Block.field_149776_m;
        }
        if (materialName.equalsIgnoreCase("snow")) {
            return Block.field_149773_n;
        }
        if (materialName.equalsIgnoreCase("sponge")) {
            return Block.field_149779_h;
        }
        if (materialName.equalsIgnoreCase("tnt")) {
            return Block.field_149779_h;
        }
        if (materialName.equalsIgnoreCase("vine")) {
            return Block.field_149779_h;
        }
        if (materialName.equalsIgnoreCase("water")) {
            return Block.field_149780_i;
        }
        if (materialName.equalsIgnoreCase("web")) {
            return Block.field_149780_i;
        }
        if (materialName.equalsIgnoreCase("wood")) {
            return Block.field_149766_f;
        }
        return Block.field_149769_e;
    }
}

