/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.config;

import com.tmtravlr.lootplusplus.LootPPHelper;
import com.tmtravlr.lootplusplus.LootPPNotifier;
import com.tmtravlr.lootplusplus.LootPlusPlusMod;
import com.tmtravlr.lootplusplus.config.ConfigExtrasLoader;
import com.tmtravlr.lootplusplus.config.ConfigLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.config.Configuration;

public class ConfigLoaderChestLoot
extends ConfigLoader {
    public static ConfigLoaderChestLoot instance = new ConfigLoaderChestLoot();
    public static HashMap<String, ArrayList<String>> extraExisting = new HashMap();

    ConfigLoaderChestLoot() {
        this.namesToExtras.put("custom_chest_content", new ArrayList());
        this.namesToExtras.put("min_max_amounts", new ArrayList());
    }

    @Override
    public String getFileName() {
        return "chest_content";
    }

    @Override
    public void loadExtras(File folder) {
        super.loadExtras(folder);
        Set<String> defaultChestTypes = this.getChestTypes();
        for (String type : defaultChestTypes) {
            String filePath = "config/" + this.getFileName() + "/" + type.toLowerCase() + "_additions.txt";
            ArrayList<String> extraList = extraExisting.get(type);
            if (extraList == null) {
                extraList = new ArrayList();
            }
            ConfigExtrasLoader.readFileIntoList(folder, filePath, extraList);
            extraExisting.put(type, extraList);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void loadChestContent() {
        void var7_9;
        ArrayList<String> contentList;
        Configuration chestContent = new Configuration(new File(LootPPHelper.configFolder, this.getFileName() + ".cfg"));
        Random rand = new Random(0L);
        chestContent.load();
        chestContent.addCustomCategoryComment("_instructions", "************   Instructions   *************\nFor the default entries, they are formatted as follows:\n\n      <min items>-<max items>-<weight>-<metadata>.\n\nDisable them by setting the weights to 0.\nTo add new things, put items in the lists in the format:\n\n      <name>-<min items>-<max items>-<weight>-<metadata (optional)>-<NBT Tag (optional)>.\n\nSo, say, if you wanted to add 6-10 slime balls to the bonus chest with a weight of\n10, you could put:\n\n      minecraft:slime_ball-6-10-10\n\nNote the NBT tag is optional, and so is the metadata (defaults to 0), so you don't have\nto include them.\nYou can also add entries to custom chest types in custom_chest in the form:\n\n      <type>-<name>-<min items>-<max items>-<weight>-<metadata (optional)>-<NBT Tag (optional)>.\nTo change the number of items that generate in a chest, in the '_min_max_amounts' section,\nchange the numbers which are in the format:\n\n      <chest type>-<min items in chest>-<max items in chest>");
        Set<String> defaultChestTypes = this.getChestTypes();
        LootPPHelper.chestTypes.addAll(defaultChestTypes);
        for (String string : defaultChestTypes) {
            this.loadDefaultContent(chestContent, string, string + "_default");
        }
        for (String type : defaultChestTypes) {
            contentList = ConfigExtrasLoader.combineLists(chestContent.get(type.toLowerCase() + "_additions", type + " Additions:", new String[0]).getStringList(), extraExisting.get(type));
            this.addEntriesFromStringList(type, contentList);
        }
        contentList = ConfigExtrasLoader.combineLists(chestContent.get("custom_chest_type", "Custom Chest Type Content:", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("custom_chest_content"));
        this.addCustomEntriesFromStringArray(contentList);
        Object var7_7 = null;
        if (LootPPHelper.gotChestInfo) {
            try {
                HashMap hashMap = (HashMap)LootPPHelper.chestInfo.get(null);
            }
            catch (Exception e) {
                System.err.println("[Loot++] Error while getting chest info.");
                e.printStackTrace();
            }
        }
        String[] configContent = chestContent.get("_min_max_amounts", "min_max_amounts", new String[0]).getStringList();
        contentList = ConfigExtrasLoader.combineLists(configContent, (ArrayList)this.namesToExtras.get("min_max_amounts"));
        HashSet<String> chestTypesFound = new HashSet<String>();
        chestTypesFound.addAll(LootPPHelper.chestTypes);
        int index = 0;
        for (String string : contentList) {
            String[] parts;
            boolean comment = false;
            String title = this.getFileName() + ".cfg '_min_max_amounts'";
            if (string.length() > 0) {
                boolean bl = comment = string.charAt(0) == '#';
            }
            if ((parts = string.split("-")).length != 3) {
                LootPPNotifier.notifyWrongNumberOfParts(comment, title, string);
                continue;
            }
            String type = parts[0];
            int min = 1;
            int max = 1;
            try {
                min = Integer.valueOf(parts[1]);
                max = Integer.valueOf(parts[2]);
            }
            catch (NumberFormatException e) {
                LootPPNotifier.notifyNumber(comment, title, parts[1], parts[2]);
                e.printStackTrace();
            }
            if (min < 0) {
                min = 0;
            }
            if (max < min) {
                max = min;
            }
            if (!LootPPHelper.gotChestInfo || var7_9 == null || !var7_9.containsKey(type)) continue;
            ChestGenHooks chest = (ChestGenHooks)var7_9.get(type);
            if (chest.getMin() != min) {
                chest.setMin(min);
            }
            if (chest.getMax() != max) {
                chest.setMax(max);
            }
            if (LootPlusPlusMod.debug) {
                System.out.println("[Loot++] Set chest size for type '" + type + "' to min: " + min + ", max: " + max);
            }
            chestTypesFound.remove(type);
        }
        if (!chestTypesFound.isEmpty()) {
            ArrayList<String> newEntries = new ArrayList<String>();
            for (String type : chestTypesFound) {
                if (!LootPPHelper.gotChestInfo || var7_9 == null || !var7_9.containsKey(type)) continue;
                ChestGenHooks chest = (ChestGenHooks)var7_9.get(type);
                newEntries.add(type + "-" + chest.getMin() + "-" + chest.getMax());
            }
            if (!newEntries.isEmpty()) {
                int i;
                String[] stringArray = new String[configContent.length + newEntries.size()];
                for (i = 0; i < configContent.length; ++i) {
                    stringArray[i] = configContent[i];
                }
                for (i = configContent.length; i < stringArray.length; ++i) {
                    stringArray[i] = (String)newEntries.get(i - configContent.length);
                }
                chestContent.get("_min_max_amounts", "min_max_amounts", new String[0]).set(stringArray);
            }
        }
        chestContent.save();
        ++index;
    }

    private Set<String> getChestTypes() {
        Set<String> defaultChestTypes = new HashSet<String>();
        defaultChestTypes.addAll(Arrays.asList("bonusChest", "dungeonChest", "mineshaftCorridor", "pyramidDesertyChest", "pyramidJungleChest", "pyramidJungleDispenser", "strongholdCorridor", "strongholdCrossing", "strongholdLibrary", "villageBlacksmith", "netherFortress"));
        if (LootPPHelper.gotChestInfo) {
            try {
                HashMap loadedChestInfo = (HashMap)LootPPHelper.chestInfo.get(null);
                defaultChestTypes = loadedChestInfo.keySet();
            }
            catch (Exception e) {
                System.out.println("[Loot++] Caught Exception while trying to load in chest info.");
                e.printStackTrace();
            }
        }
        return defaultChestTypes;
    }

    private void loadDefaultContent(Configuration chestContent, String type, String optionName) {
        List chestContentList = ChestGenHooks.getInfo((String)type).getItems(new Random(0L));
        if (LootPPHelper.gotContents) {
            try {
                chestContentList = (List)LootPPHelper.contents.get(ChestGenHooks.getInfo((String)type));
            }
            catch (Exception e) {
                System.out.println("[Loot++] Caught Exception while trying to load in " + type + " contents.");
                e.printStackTrace();
            }
        }
        for (WeightedRandomChestContent content : chestContentList) {
            if (content == null || content.field_76297_b == null || content.field_76297_b.func_77973_b() == null) continue;
            String options = "" + content.field_76295_d + "-" + content.field_76296_e + "-" + content.field_76292_a;
            String nbtTag = !content.field_76297_b.func_77942_o() ? "" : "-" + content.field_76297_b.func_77978_p().toString();
            if ((nbtTag = nbtTag.replace('\"', '\'')).length() > 100) {
                nbtTag = nbtTag.substring(0, 100);
            }
            options = chestContent.get(optionName, Item.field_150901_e.func_177774_c((Object)content.field_76297_b.func_77973_b()) + "-" + content.field_76297_b.func_77952_i() + nbtTag, options).getString();
            this.setDefaultContentDataFromString(options, content, this.getFileName() + ".cfg '" + optionName + "'");
        }
    }

    private void addCustomEntriesFromStringArray(ArrayList<String> entries) {
        for (int index = 0; index < entries.size(); ++index) {
            int meta;
            int weight;
            int max;
            int min;
            ItemStack itemStack;
            String type;
            block18: {
                Object itemObj;
                String[] parts;
                String options = entries.get(index);
                boolean comment = false;
                String title = this.getFileName() + ".cfg 'custom_chest_type' #" + (index + 1);
                if (options.length() > 0) {
                    boolean bl = comment = options.charAt(0) == '#';
                }
                if ((parts = options.split("-", 7)).length < 5) {
                    if (options.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, options);
                    continue;
                }
                type = parts[0];
                String name = parts[1];
                String minString = parts[2];
                String maxString = parts[3];
                String weightString = parts[4];
                String metaString = "0";
                String nbtString = "{}";
                NBTTagCompound nbt = null;
                if (parts.length > 5) {
                    metaString = parts[5];
                }
                if (parts.length > 6) {
                    nbtString = parts[6];
                }
                if (!nbtString.equals("") && !nbtString.equals("{}")) {
                    try {
                        nbt = JsonToNBT.func_180713_a((String)nbtString.trim());
                    }
                    catch (Exception e) {
                        if (!comment) {
                            LootPPNotifier.notifyNBT(comment, title, nbtString, e.getMessage());
                            e.printStackTrace();
                        }
                        nbt = null;
                    }
                }
                if ((itemObj = Item.field_150901_e.func_82594_a((Object)name)) == null || !(itemObj instanceof Item)) {
                    LootPPNotifier.notifyNonexistant(comment, title, name);
                    continue;
                }
                Item item = (Item)itemObj;
                itemStack = new ItemStack(item);
                if (nbt != null) {
                    itemStack.func_77982_d(nbt);
                }
                min = 1;
                max = 1;
                weight = 0;
                meta = 0;
                try {
                    min = Integer.valueOf(minString);
                    max = Integer.valueOf(maxString);
                    weight = Integer.valueOf(weightString);
                    meta = Integer.valueOf(metaString);
                }
                catch (Exception e) {
                    if (comment) break block18;
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, minString, maxString, weightString, metaString);
                }
            }
            if (min < 0) {
                min = 0;
            }
            if (max < min) {
                max = min;
            }
            if (meta < 0) {
                meta = 0;
            }
            if (weight < 0) {
                weight = 0;
            }
            itemStack.func_77964_b(meta);
            WeightedRandomChestContent content = new WeightedRandomChestContent(itemStack, min, max, weight);
            ChestGenHooks.getInfo((String)type).addItem(content);
            if (ChestGenHooks.getInfo((String)type).getMax() == 0 && ChestGenHooks.getInfo((String)type).getMin() == 0) {
                ChestGenHooks.getInfo((String)type).setMin(3);
                ChestGenHooks.getInfo((String)type).setMax(9);
            }
            LootPPHelper.chestTypes.add(type);
        }
    }

    private void addEntriesFromStringList(String type, ArrayList<String> entries) {
        for (int index = 0; index < entries.size(); ++index) {
            int meta;
            int weight;
            int max;
            int min;
            ItemStack itemStack;
            block17: {
                Object itemObj;
                String options = entries.get(index);
                String[] parts = options.split("-", 6);
                boolean comment = false;
                String title = this.getFileName() + ".cfg '" + type.toLowerCase() + "_additions' #" + (index + 1);
                if (options.length() > 0) {
                    boolean bl = comment = options.charAt(0) == '#';
                }
                if (parts.length < 4) {
                    if (options.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, options);
                    continue;
                }
                String name = parts[0];
                String minString = parts[1];
                String maxString = parts[2];
                String weightString = parts[3];
                String metaString = "0";
                String nbtString = "{}";
                NBTTagCompound nbt = null;
                if (parts.length > 4) {
                    metaString = parts[4];
                }
                if (parts.length > 5) {
                    nbtString = parts[5];
                }
                if (!nbtString.equals("") && !nbtString.equals("{}")) {
                    try {
                        nbt = JsonToNBT.func_180713_a((String)nbtString.trim());
                    }
                    catch (NBTException e) {
                        if (!comment) {
                            LootPPNotifier.notifyNBT(comment, title, nbtString, e.getMessage());
                            e.printStackTrace();
                        }
                        nbt = null;
                    }
                }
                if ((itemObj = Item.field_150901_e.func_82594_a((Object)name)) == null || !(itemObj instanceof Item)) {
                    LootPPNotifier.notifyNonexistant(comment, title, name);
                    continue;
                }
                Item item = (Item)itemObj;
                itemStack = new ItemStack(item);
                if (nbt != null) {
                    itemStack.func_77982_d(nbt);
                }
                min = 1;
                max = 1;
                weight = 0;
                meta = 0;
                try {
                    min = Integer.valueOf(minString);
                    max = Integer.valueOf(maxString);
                    weight = Integer.valueOf(weightString);
                    meta = Integer.valueOf(metaString);
                }
                catch (NumberFormatException e) {
                    if (comment) break block17;
                    LootPPNotifier.notifyNumber(comment, title, minString, maxString, weightString, metaString);
                    e.printStackTrace();
                }
            }
            if (min < 0) {
                min = 0;
            }
            if (max < min) {
                max = min;
            }
            if (meta < 0) {
                meta = 0;
            }
            if (weight < 0) {
                weight = 0;
            }
            itemStack.func_77964_b(meta);
            WeightedRandomChestContent content = new WeightedRandomChestContent(itemStack, min, max, weight);
            ChestGenHooks.getInfo((String)type).addItem(content);
        }
        LootPPHelper.chestTypes.add(type);
    }

    private void setDefaultContentDataFromString(String options, WeightedRandomChestContent content, String title) {
        String[] parts = options.split("-");
        if (parts.length > 3) {
            LootPPNotifier.notifyWrongNumberOfParts(false, title, options);
            return;
        }
        String minString = parts[0];
        String maxString = parts[1];
        String weightString = parts[2];
        try {
            int min = Integer.valueOf(minString);
            int max = Integer.valueOf(maxString);
            int weight = Integer.valueOf(weightString);
            if (min < 0) {
                min = 0;
            }
            if (max < min) {
                max = min;
            }
            if (weight < 0) {
                weight = 0;
            }
            content.field_76295_d = min;
            content.field_76296_e = max;
            content.field_76292_a = weight;
        }
        catch (NumberFormatException e) {
            LootPPNotifier.notifyNumber(false, title, minString, maxString, weightString);
            e.printStackTrace();
        }
    }
}

