/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.config;

import com.tmtravlr.lootplusplus.LootPPHelper;
import com.tmtravlr.lootplusplus.LootPPItems;
import com.tmtravlr.lootplusplus.LootPPNotifier;
import com.tmtravlr.lootplusplus.LootPlusPlusMod;
import com.tmtravlr.lootplusplus.config.ConfigExtrasLoader;
import com.tmtravlr.lootplusplus.config.ConfigLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;

public class ConfigLoaderEntityDrops
extends ConfigLoader {
    public static ConfigLoaderEntityDrops instance = new ConfigLoaderEntityDrops();

    ConfigLoaderEntityDrops() {
        this.namesToExtras.put("removing", new ArrayList());
        this.namesToExtras.put("adding", new ArrayList());
    }

    @Override
    public String getFileName() {
        return "entity_drops";
    }

    public void loadEntityDrops() {
        String entry;
        int index;
        Configuration entityDropConfig = new Configuration(new File(LootPPHelper.configFolder, this.getFileName() + ".cfg"));
        entityDropConfig.load();
        entityDropConfig.addCustomCategoryComment("removing", "To remove an item drop from an entity, add entries, each on a new line\nin the format:\n\n      <Entity name (any for any)>_____<Entity NBT tag ({} for any)>_____<Item name>_____<Metadata (optional, or -1 for any)>_____<NBT tag (optional)>.\n\nSo if you wanted to remove rotten flesh as a drop from zombies, you could put\n\n      Zombie_____{}_____minecraft:rotten_flesh\n\nThis will prevent any rotten flesh from dropping from zombies.");
        ArrayList<String> dropsList = ConfigExtrasLoader.combineLists(entityDropConfig.get("removing", "Drops to remove from entities:", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("removing"));
        for (index = 0; index < dropsList.size(); ++index) {
            NBTTagCompound nbtBase;
            int meta;
            String nbtString;
            String itemName;
            String entityNBTString;
            String entityName;
            String title;
            boolean comment;
            block47: {
                entry = dropsList.get(index);
                String[] split = entry.split("_____", 5);
                comment = false;
                title = this.getFileName() + ".cfg 'removing' #" + (index + 1);
                if (entry.length() > 0) {
                    boolean bl = comment = entry.charAt(0) == '#';
                }
                if (split.length < 3) {
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, entry);
                    continue;
                }
                entityName = split[0];
                entityNBTString = split[1];
                itemName = split[2];
                String metaString = "-1";
                nbtString = "{}";
                if (split.length > 3) {
                    metaString = split[3];
                }
                if (split.length > 4) {
                    nbtString = split[4];
                }
                meta = -1;
                try {
                    meta = Integer.valueOf(metaString);
                }
                catch (NumberFormatException e) {
                    if (comment) break block47;
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, metaString);
                }
            }
            if (meta < 0) {
                meta = Short.MAX_VALUE;
            }
            NBTTagCompound entityNBT = null;
            NBTTagCompound dropNBT = null;
            if (!entityNBTString.equals("") && !entityNBTString.equals("{}")) {
                try {
                    entityNBT = nbtBase = JsonToNBT.func_180713_a((String)entityNBTString.trim());
                }
                catch (Exception e) {
                    if (!comment) {
                        e.printStackTrace();
                        LootPPNotifier.notifyNBT(comment, title, entityNBTString, e.getMessage());
                    }
                    entityNBT = null;
                }
            }
            if (!nbtString.equals("") && !nbtString.equals("{}")) {
                try {
                    dropNBT = nbtBase = JsonToNBT.func_180713_a((String)nbtString.trim());
                }
                catch (Exception e) {
                    if (!comment) {
                        e.printStackTrace();
                        LootPPNotifier.notifyNBT(comment, title, nbtString, e.getMessage());
                    }
                    dropNBT = null;
                }
            }
            Item item = null;
            if (itemName.equalsIgnoreCase("any") || itemName.equalsIgnoreCase("all")) {
                item = LootPPItems.generalDummyIcon;
            } else {
                Object itemObj = Item.field_150901_e.func_82594_a((Object)itemName);
                if (itemObj == null || !(itemObj instanceof Item)) {
                    LootPPNotifier.notifyNonexistant(comment, title, itemName);
                    continue;
                }
                item = (Item)itemObj;
            }
            ItemStack stack = new ItemStack(item, 1, meta);
            if (dropNBT != null) {
                stack.func_77982_d(dropNBT);
            }
            if (entityNBT == null) {
                entityNBT = new NBTTagCompound();
            }
            if (!entityName.equalsIgnoreCase("any")) {
                entityNBT.func_74778_a("id", entityName);
            }
            if (LootPlusPlusMod.debug) {
                System.out.println("[Loot++] Removing drop from entity " + entityName);
            }
            if (LootPPHelper.entityDropRemovals.containsKey(entityNBT)) {
                Set<ItemStack> itemSet = LootPPHelper.entityDropRemovals.get(entityNBT);
                if (itemSet == null) {
                    itemSet = new HashSet<ItemStack>();
                }
                itemSet.add(stack);
                continue;
            }
            HashSet<ItemStack> newSet = new HashSet<ItemStack>();
            newSet.add(stack);
            LootPPHelper.entityDropRemovals.put(entityNBT, newSet);
        }
        entityDropConfig.addCustomCategoryComment("adding", "There are two types of drops to add: items and entities.\n\nIn either case, the first options should be:\n\n      <Entity name (any for any)>-<Rarity>-<Only player kill (true or false)>-<Affected by looting (true or false)>-<Entity NBT (optional)>,\n\nWhere:- The <Entity name> is the name of the entity, as appears in the Entity IDs.txt file.\n- The <Rarity> is the probability of the drop, from 0.0 to 1.0.\n- If <Only player kill> is true, the drop will only drop if the entity is killed by a\nplayer.\n- If <Affected by looting> is true, the drops will increase if killed with a weapon\nenchanted with looting.\n\nNext you can specify the items or entities to drop, in a list. The list should be in the formats:\n\n      ..._____i-<Item id>-<Min>-<Max>-<Weight (optional)>-<Metadata (optional)>-<NBT Tag (optional)>_____...\n\nfor items, or:\n\n      ..._____e-<Entity id>-<Weight (optional)>-<NBT tag (optional)>_____...\n\nfor entities, or:\n\n      ..._____c-<Weight>-<Command>_____...\n\nfor commands, where:\n- The <Item id> or<Entity id> is the string id for the item or entity.- The <Weight> is the chance that this drop will be chosen out of all the combined weights.\nMake sure it's bigger than 0. If you don't specify the weight, it will default to 1.\n- And the <Command> is a command you want to run where the block breaks.\n\nAlso, you can put %%%%% between drops to create groups of drops. In a group, only the weight of\nthe first drop will count.\n\n###############################################  Examples  #############################################\nIf you wanted zombies to drop feathers, you could write:\n\n      Zombie-1.0-false-true_____i-minecraft:feather-1-3\n\nIf you wanted silverfish to have a chance to drop extra xp when killed by a player, you could put:\n\n      Silverfish-0.7-true-false_____e-XPOrb-1-{Value:1}_____e-XPOrb-1-{Value:2}_____e-XPOrb-1-{Value:3}\n\nIf you wanted wither skeletons to drop fire charges 50% of the time, you could put:\n\n      Skeleton-0.5-false-true-{SkeletonType:1}_____i-minecraft:fire_charge-1-1");
        dropsList = ConfigExtrasLoader.combineLists(entityDropConfig.get("adding", "Drops to add to entities:", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("adding"));
        for (index = 0; index < dropsList.size(); ++index) {
            entry = dropsList.get(index);
            boolean comment = false;
            String title = this.getFileName() + ".cfg 'adding' #" + (index + 1);
            if (entry.length() > 0) {
                comment = entry.charAt(0) == '#';
            }
            try {
                ArrayList entityDrops;
                NBTTagCompound entityNBT;
                boolean looting;
                boolean pk;
                float rarity;
                String entityName;
                String[] split;
                String[] dropStrings;
                block48: {
                    dropStrings = entry.split("_____");
                    if (dropStrings.length < 2) {
                        if (entry.equals("")) continue;
                        LootPPNotifier.notifyWrongNumberOfParts(comment, title, entry);
                        continue;
                    }
                    split = dropStrings[0].split("-", 5);
                    if (split.length < 4) {
                        LootPPNotifier.notifyWrongNumberOfParts(comment, title, dropStrings[0]);
                        continue;
                    }
                    entityName = split[0];
                    String rarityString = split[1];
                    String pkString = split[2];
                    String lootingString = split[3];
                    rarity = 1.0f;
                    pk = false;
                    looting = true;
                    entityNBT = null;
                    entityDrops = new ArrayList();
                    try {
                        rarity = Float.valueOf(rarityString).floatValue();
                        pk = Boolean.valueOf(pkString);
                        looting = Boolean.valueOf(lootingString);
                    }
                    catch (Exception e) {
                        if (comment) break block48;
                        e.printStackTrace();
                        LootPPNotifier.notifyNumber(comment, title, rarityString, pkString, lootingString);
                    }
                }
                if (rarity < 0.0f) {
                    rarity = 0.0f;
                }
                if (rarity > 1.0f) {
                    rarity = 1.0f;
                }
                if (split.length > 4 && !split[4].equals("") && !split[4].equals("{}")) {
                    try {
                        NBTTagCompound nbtBase;
                        entityNBT = nbtBase = JsonToNBT.func_180713_a((String)split[4].trim());
                    }
                    catch (Exception e) {
                        if (!comment) {
                            e.printStackTrace();
                            LootPPNotifier.notifyNBT(comment, title, split[4], e.getMessage());
                        }
                        entityNBT = null;
                    }
                }
                if (entityNBT == null) {
                    entityNBT = new NBTTagCompound();
                }
                if (!entityName.equalsIgnoreCase("any")) {
                    entityNBT.func_74778_a("id", entityName);
                }
                for (int i = 1; i < dropStrings.length; ++i) {
                    String dropString = dropStrings[i];
                    if (dropString.equals("")) continue;
                    String[] subParts = dropString.split("%%%%%");
                    ArrayList<LootPPHelper.DropInfo> infoList = new ArrayList<LootPPHelper.DropInfo>();
                    for (int j = 0; j < subParts.length; ++j) {
                        char type;
                        LootPPHelper.DropInfo info;
                        String subString = subParts[j];
                        int dashIndex = subString.indexOf("-");
                        if (dashIndex < 0 || (info = LootPPHelper.getDropInfo(type = subString.charAt(0), subString.substring(dashIndex + 1), comment, title)) == null) continue;
                        infoList.add(info);
                    }
                    if (infoList.isEmpty()) continue;
                    entityDrops.add(infoList);
                }
                if (!entityDrops.isEmpty()) {
                    LootPPHelper.EntityDropInfo toAdd;
                    if (LootPlusPlusMod.debug) {
                        System.out.println("[Loot++] Adding Drops to entity " + entityName);
                    }
                    if (LootPPHelper.entityDropAdditions.containsKey(entityNBT)) {
                        ArrayList<LootPPHelper.EntityDropInfo> existingList = LootPPHelper.entityDropAdditions.get(entityNBT);
                        if (existingList == null) {
                            existingList = new ArrayList();
                        }
                        toAdd = new LootPPHelper.EntityDropInfo(rarity, pk, looting);
                        toAdd.dropList = entityDrops;
                        existingList.add(toAdd);
                        LootPPHelper.entityDropAdditions.put(entityNBT, existingList);
                        continue;
                    }
                    ArrayList<LootPPHelper.EntityDropInfo> newList = new ArrayList<LootPPHelper.EntityDropInfo>();
                    toAdd = new LootPPHelper.EntityDropInfo(rarity, pk, looting);
                    toAdd.dropList = entityDrops;
                    newList.add(toAdd);
                    LootPPHelper.entityDropAdditions.put(entityNBT, newList);
                    continue;
                }
                if (!LootPlusPlusMod.debug) continue;
                System.out.println("[Loot++] Drops List was empty for " + entityName + "!");
                continue;
            }
            catch (Exception e) {
                if (comment) continue;
                System.err.println("[Loot++] Caught an exception while trying to load entity drops.");
                e.printStackTrace();
                LootPPNotifier.notify(comment, title, "=( Unexpected problem '" + e.getMessage() + "' while loading entitiy drop additions for: " + entry);
            }
        }
        entityDropConfig.save();
    }
}

