/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.worldGen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenSurfaceBlocks
implements IWorldGenerator {
    public static ArrayList<SurfaceGenInfo> surfaceGens = new ArrayList();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int xPos = chunkX * 16;
        int zPos = chunkZ * 16;
        for (SurfaceGenInfo info : surfaceGens) {
            if (info.dimensionBl.contains(world.field_73011_w.func_177502_q()) || !info.dimensionWl.isEmpty() && !info.dimensionWl.contains(world.field_73011_w.func_177502_q()) || !(info.chancePerChunk >= random.nextFloat())) continue;
            for (int i = 0; i < info.triesPerChunk; ++i) {
                BlockPos tryPos = new BlockPos(xPos + random.nextInt(16), random.nextInt(info.heightMax - info.heightMin) + info.heightMin, zPos + random.nextInt(16));
                BiomeGenBase biome = world.func_180494_b(tryPos);
                if (info.biomeBl.contains(biome.field_76791_y.toLowerCase()) || !info.biomeWl.isEmpty() && !info.biomeWl.contains(biome.field_76791_y.toLowerCase())) continue;
                boolean shouldGenerate = false;
                for (BiomeDictionary.Type biomeType : BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)) {
                    if (info.biomeTypeBl.contains(biomeType)) break;
                    if (!info.biomeTypeWl.isEmpty() && !info.biomeTypeWl.contains(biomeType)) continue;
                    shouldGenerate = true;
                    break;
                }
                if (!shouldGenerate || !this.canGenerateOnBlock(world, tryPos) || world.func_175623_d(tryPos.func_177977_b())) continue;
                if (info.groupSize > 1) {
                    this.generateBlocks(world, random, tryPos, info);
                    continue;
                }
                this.generateBlock(world, random, tryPos, info);
            }
        }
    }

    public void generateBlocks(World world, Random random, BlockPos pos, SurfaceGenInfo info) {
        for (int tries = 0; tries < info.triesPerGroup; ++tries) {
            BlockPos tryPos = pos.func_177982_a(random.nextInt((info.groupSize - 1) * 2) - info.groupSize, random.nextInt((info.groupSize - 1) * 2) - info.groupSize, random.nextInt((info.groupSize - 1) * 2) - info.groupSize);
            if (!this.canGenerateOnBlock(world, tryPos) || world.func_175623_d(tryPos.func_177977_b())) continue;
            this.generateBlock(world, random, tryPos, info);
        }
    }

    public void generateBlock(World world, Random random, BlockPos pos, SurfaceGenInfo info) {
        TileEntity te;
        if (pos.func_177956_o() < 0 || pos.func_177956_o() > 255) {
            return;
        }
        if (!this.canGenerateOnBlock(world, pos) || world.func_175623_d(pos.func_177977_b())) {
            return;
        }
        Block beneath = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        Material beneathMaterial = beneath.func_149688_o();
        if (info.blocksBl.contains(beneath) || !info.blocksWl.isEmpty() && !info.blocksWl.contains(beneath)) {
            return;
        }
        if (info.materialsBl.contains(beneathMaterial) || !info.materialsWl.isEmpty() && !info.materialsWl.contains(beneathMaterial)) {
            return;
        }
        world.func_175656_a(pos, info.toGenerate);
        if (info.blockTag != null && (te = world.func_175625_s(pos)) != null) {
            NBTTagCompound tagToGenerate = (NBTTagCompound)info.blockTag.func_74737_b();
            tagToGenerate.func_74768_a("x", pos.func_177958_n());
            tagToGenerate.func_74768_a("y", pos.func_177956_o());
            tagToGenerate.func_74768_a("z", pos.func_177952_p());
            te.func_145839_a(tagToGenerate);
        }
        if (info.bonemeal) {
            ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR, 1, 15), (World)world, (BlockPos)pos);
        }
    }

    private boolean canGenerateOnBlock(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return !(block instanceof BlockLiquid) && !(block instanceof BlockFluidBase) && block.func_176200_f(world, pos);
    }

    public static class SurfaceGenInfo {
        public IBlockState toGenerate;
        public NBTTagCompound blockTag;
        public boolean bonemeal;
        public float chancePerChunk;
        public int triesPerChunk;
        public int groupSize;
        public int triesPerGroup;
        public int heightMin;
        public int heightMax;
        public HashSet<Block> blocksBl = new HashSet();
        public HashSet<Block> blocksWl = new HashSet();
        public HashSet<Material> materialsBl = new HashSet();
        public HashSet<Material> materialsWl = new HashSet();
        public HashSet<String> biomeBl = new HashSet();
        public HashSet<String> biomeWl = new HashSet();
        public HashSet<BiomeDictionary.Type> biomeTypeBl = new HashSet();
        public HashSet<BiomeDictionary.Type> biomeTypeWl = new HashSet();
        public HashSet<Integer> dimensionBl = new HashSet();
        public HashSet<Integer> dimensionWl = new HashSet();

        public SurfaceGenInfo(IBlockState state, NBTTagCompound tag, boolean grow, float chance, int triesChunk, int group, int triesGroup, int heightMin, int heightMax) {
            this.toGenerate = state;
            this.blockTag = tag;
            this.chancePerChunk = chance;
            this.triesPerChunk = triesChunk;
            this.groupSize = group;
            this.triesPerGroup = triesGroup;
            this.bonemeal = grow;
            this.heightMin = heightMin;
            this.heightMax = heightMax;
        }
    }
}

