/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.potioncore;

import com.tmtravlr.potioncore.CommonProxy;
import com.tmtravlr.potioncore.PotionCoreEntityRenderer;
import com.tmtravlr.potioncore.PotionCoreEventHandlerClient;
import com.tmtravlr.potioncore.PotionCoreHelper;
import com.tmtravlr.potioncore.potion.EntityPotionCorePotion;
import com.tmtravlr.potioncore.potion.ItemPotionCorePotion;
import com.tmtravlr.potioncore.potion.RenderPotionCorePotion;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ClientProxy
extends CommonProxy {
    Random random = new Random();

    @Override
    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void replaceEntityRenderer() {
        Minecraft mc = Minecraft.func_71410_x();
        PotionCoreEntityRenderer renderer = new PotionCoreEntityRenderer(mc, mc.func_110442_L());
        ObfuscationReflectionHelper.setPrivateValue(Minecraft.class, (Object)mc, (Object)((Object)renderer), (String[])new String[]{"entityRenderer", "field_71460_t"});
    }

    @Override
    public void registerEventHandlers() {
        super.registerEventHandlers();
        MinecraftForge.EVENT_BUS.register((Object)new PotionCoreEventHandlerClient());
        FMLCommonHandler.instance().bus().register((Object)new PotionCoreEventHandlerClient());
    }

    @Override
    public void registerRenderers() {
        RenderItem renderer = Minecraft.func_71410_x().func_175599_af();
        renderer.func_175037_a().func_178080_a((Item)ItemPotionCorePotion.instance, new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return ItemPotionCorePotion.isSplash(stack.func_77960_j()) ? new ModelResourceLocation("bottle_splash", "inventory") : new ModelResourceLocation("bottle_drinkable", "inventory");
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityPotionCorePotion.class, (Render)new RenderPotionCorePotion(Minecraft.func_71410_x().func_175598_ae(), Minecraft.func_71410_x().func_175599_af()));
    }

    @Override
    public void loadInverted() {
        PotionCoreEventHandlerClient.loadInverted();
    }

    @Override
    public void doPotionSmashEffects(BlockPos pos, ItemStack stack) {
        if (stack == null) {
            return;
        }
        double d13 = pos.func_177958_n();
        double d14 = pos.func_177956_o();
        double d16 = pos.func_177952_p();
        int j1 = PotionCoreHelper.getCustomPotionColor(ItemPotionCorePotion.instance.getEffects(stack));
        float f = (float)(j1 >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(j1 >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(j1 >> 0 & 0xFF) / 255.0f;
        EnumParticleTypes enumparticletypes = EnumParticleTypes.SPELL;
        if (ItemPotionCorePotion.instance.isEffectInstant(stack)) {
            enumparticletypes = EnumParticleTypes.SPELL_INSTANT;
        }
        for (int l1 = 0; l1 < 100; ++l1) {
            double d22 = this.random.nextDouble() * 4.0;
            double d23 = this.random.nextDouble() * Math.PI * 2.0;
            double d24 = Math.cos(d23) * d22;
            double d9 = 0.01 + this.random.nextDouble() * 0.5;
            double d11 = Math.sin(d23) * d22;
            EntityFX entityfx = this.spawnPotionParticle(enumparticletypes.func_179348_c(), enumparticletypes.func_179344_e(), d13 + d24 * 0.1, d14 + 0.3, d16 + d11 * 0.1, d24, d9, d11, new int[0]);
            if (entityfx == null) continue;
            float f3 = 0.75f + this.random.nextFloat() * 0.25f;
            entityfx.func_70538_b(f * f3, f1 * f3, f2 * f3);
            entityfx.func_70543_e((float)d22);
        }
    }

    private EntityFX spawnPotionParticle(int type, boolean ignoreRange, double posX, double posY, double posZ, double speedX, double speedY, double speedZ, int ... parameters) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc != null && mc.func_175606_aa() != null && mc.field_71452_i != null) {
            int particleSetting = mc.field_71474_y.field_74362_aa;
            if (particleSetting == 1 && mc.field_71441_e.field_73012_v.nextInt(3) == 0) {
                particleSetting = 2;
            }
            double offsetX = mc.func_175606_aa().field_70165_t - posX;
            double offsetY = mc.func_175606_aa().field_70163_u - posY;
            double offsetZ = mc.func_175606_aa().field_70161_v - posZ;
            if (ignoreRange) {
                return mc.field_71452_i.func_178927_a(type, posX, posY, posZ, speedX, speedY, speedZ, parameters);
            }
            double d3 = 16.0;
            return offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ > 256.0 ? null : (particleSetting > 1 ? null : mc.field_71452_i.func_178927_a(type, posX, posY, posZ, speedX, speedY, speedZ, parameters));
        }
        return null;
    }
}

