/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.potioncore;

import com.tmtravlr.potioncore.ConfigLoader;
import com.tmtravlr.potioncore.PotionCore;
import com.tmtravlr.potioncore.PotionCoreHelper;
import com.tmtravlr.potioncore.PotionCoreTeleporter;
import com.tmtravlr.potioncore.effects.PotionAntidote;
import com.tmtravlr.potioncore.effects.PotionBless;
import com.tmtravlr.potioncore.effects.PotionChance;
import com.tmtravlr.potioncore.effects.PotionCurse;
import com.tmtravlr.potioncore.effects.PotionDrown;
import com.tmtravlr.potioncore.effects.PotionFlight;
import com.tmtravlr.potioncore.effects.PotionPurity;
import com.tmtravlr.potioncore.effects.PotionReach;
import com.tmtravlr.potioncore.effects.PotionRecoil;
import com.tmtravlr.potioncore.effects.PotionRevival;
import com.tmtravlr.potioncore.effects.PotionSlowfall;
import com.tmtravlr.potioncore.effects.PotionStepup;
import com.tmtravlr.potioncore.effects.PotionTeleportSpawn;
import com.tmtravlr.potioncore.network.SToCMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PotionCoreEventHandler {
    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityLivingBase) {
            ((EntityLivingBase)event.entity).func_110140_aT().func_111150_b((IAttribute)PotionCoreHelper.projectileDamage);
            ((EntityLivingBase)event.entity).func_110140_aT().func_111150_b((IAttribute)PotionCoreHelper.magicDamage);
            ((EntityLivingBase)event.entity).func_110140_aT().func_111150_b((IAttribute)PotionCoreHelper.attackSpeed);
            ((EntityLivingBase)event.entity).func_110140_aT().func_111150_b((IAttribute)PotionCoreHelper.jumpHeight);
            ((EntityLivingBase)event.entity).func_110140_aT().func_111150_b((IAttribute)PotionCoreHelper.damageResistance);
            ((EntityLivingBase)event.entity).func_110140_aT().func_111150_b((IAttribute)PotionCoreHelper.magicShielding);
            if (event.entity instanceof EntityPlayer) {
                ((EntityLivingBase)event.entity).func_110140_aT().func_111150_b((IAttribute)PotionCoreHelper.reach);
                ((EntityLivingBase)event.entity).func_110140_aT().func_111150_b((IAttribute)PotionCoreHelper.stepHeight);
            }
            if (event.entity.field_70170_p != null && !event.entity.field_70170_p.field_72995_K) {
                PotionCoreHelper.entitiesToHeal.add((EntityLivingBase)event.entity);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        double jump = PotionCoreHelper.getJumpHeightAttribute(event.entityLiving);
        event.entityLiving.field_70181_x += jump / 10.0;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingFall(LivingFallEvent event) {
        double jump = PotionCoreHelper.getJumpHeightAttribute(event.entityLiving);
        if (jump > 0.0) {
            event.distance = (float)((double)event.distance - jump);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingHurt(LivingHurtEvent event) {
        if (!event.source.func_151517_h()) {
            AttributeModifier tempModifier;
            EntityLivingBase source;
            if (event.source.func_76352_a() && event.source.func_76346_g() instanceof EntityLivingBase) {
                source = (EntityLivingBase)event.source.func_76346_g();
                tempModifier = new AttributeModifier(PotionCoreHelper.tempUUID, "Base", (double)event.ammount - 1.0, 0);
                source.func_110148_a((IAttribute)PotionCoreHelper.projectileDamage).func_111121_a(tempModifier);
                event.ammount = (float)source.func_110148_a((IAttribute)PotionCoreHelper.projectileDamage).func_111126_e();
                source.func_110148_a((IAttribute)PotionCoreHelper.projectileDamage).func_111124_b(tempModifier);
            }
            if (event.source.func_82725_o() && event.source.func_76346_g() instanceof EntityLivingBase) {
                source = (EntityLivingBase)event.source.func_76346_g();
                tempModifier = new AttributeModifier(PotionCoreHelper.tempUUID, "Base", (double)event.ammount - 1.0, 0);
                source.func_110148_a((IAttribute)PotionCoreHelper.magicDamage).func_111121_a(tempModifier);
                event.ammount = (float)source.func_110148_a((IAttribute)PotionCoreHelper.magicDamage).func_111126_e();
                source.func_110148_a((IAttribute)PotionCoreHelper.magicDamage).func_111124_b(tempModifier);
            }
            if (event.source == DamageSource.field_76379_h && PotionSlowfall.instance != null && event.entityLiving.func_70644_a((Potion)PotionSlowfall.instance)) {
                int level = event.entityLiving.func_70660_b((Potion)PotionSlowfall.instance).func_76458_c();
                if (level > 0) {
                    event.ammount = -1.0f;
                    return;
                }
                event.ammount *= 0.5f;
                if (event.ammount > 4.0f) {
                    event.ammount = 4.0f;
                }
            }
            double multiplier = 1.0;
            double resistance = PotionCoreHelper.getDamageResistanceAttribute(event.entityLiving);
            event.ammount = (float)((double)event.ammount * (1.0 - resistance));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingHurtLow(LivingHurtEvent event) {
        double magicShield;
        if (!event.source.func_151517_h() && event.source.func_82725_o() && (magicShield = event.entityLiving.func_110148_a((IAttribute)PotionCoreHelper.magicShielding).func_111126_e()) > 0.0) {
            float baseDamage = event.ammount;
            event.ammount = (float)((double)event.ammount * (1.0 - magicShield / 25.0));
            if (event.entityLiving instanceof EntityPlayer) {
                for (int x = 0; x < ((EntityPlayer)event.entityLiving).field_71071_by.field_70460_b.length; ++x) {
                    ItemStack stack = ((EntityPlayer)event.entityLiving).field_71071_by.field_70460_b[x];
                    if (stack == null) continue;
                    int itemDamage = (int)((double)((event.ammount - baseDamage) * -1.0f * (float)((ItemArmor)stack.func_77973_b()).field_77879_b) / magicShield < 1.0 ? 1.0 : (double)((event.ammount - baseDamage) * -1.0f * (float)((ItemArmor)stack.func_77973_b()).field_77879_b) / magicShield);
                    if (stack.func_77973_b() instanceof ISpecialArmor) {
                        ((ISpecialArmor)stack.func_77973_b()).damageArmor(event.entityLiving, stack, event.source, itemDamage, x);
                        continue;
                    }
                    stack.func_77972_a(itemDamage, event.entityLiving);
                }
            }
        }
        if (event.source.func_76364_f() instanceof EntityLivingBase) {
            EntityLivingBase source = (EntityLivingBase)event.source.func_76364_f();
            if (PotionRecoil.instance != null && event.entityLiving.func_70644_a((Potion)PotionRecoil.instance)) {
                float reflectPercent = MathHelper.func_76131_a((float)((float)(event.entityLiving.func_70660_b((Potion)PotionRecoil.instance).func_76458_c() + 1) * PotionRecoil.reflectDamage), (float)PotionRecoil.reflectDamage, (float)(9.0f * PotionRecoil.reflectDamage));
                source.func_70097_a(DamageSource.func_92087_a((Entity)source), event.ammount * reflectPercent);
            }
            if (ConfigLoader.modifyHasteFatigue) {
                PotionCoreHelper.hurtEntities.put(event.entityLiving, source.func_110148_a((IAttribute)PotionCoreHelper.attackSpeed).func_111126_e());
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase target;
        if (!event.entity.field_70170_p.field_72995_K && event.entityLiving.getEntityData().func_74762_e("Potion Core - Health Fix Delay") == -1) {
            if (event.entityLiving.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() != SharedMonsterAttributes.field_111267_a.func_111110_b()) {
                // empty if block
            }
            event.entityLiving.getEntityData().func_74776_a("Potion Core - Health Fix", event.entityLiving.func_110143_aJ());
        }
        if (PotionDrown.instance != null && event.entityLiving.func_70644_a((Potion)PotionDrown.instance)) {
            if (event.entityLiving.func_70613_aW() && event.entityLiving instanceof EntityPlayerMP && event.entityLiving.field_70173_aa % 20 == 0) {
                PacketBuffer out = new PacketBuffer(Unpooled.buffer());
                out.writeInt(1);
                out.writeInt(event.entity.getEntityData().func_74762_e("potioncore - drown air"));
                SToCMessage packet = new SToCMessage((ByteBuf)out);
                PotionCore.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)event.entityLiving);
            }
            event.entity.getEntityData().func_74757_a("potioncore - doing drown", true);
        } else if (event.entity.getEntityData().func_74767_n("potioncore - doing drown")) {
            event.entity.getEntityData().func_74768_a("potioncore - drown air", 300);
        }
        if (PotionAntidote.instance != null && event.entityLiving.func_70644_a((Potion)PotionAntidote.instance)) {
            event.entityLiving.func_82170_o(Potion.field_76436_u.func_76396_c());
        }
        if (PotionPurity.instance != null && event.entityLiving.func_70644_a((Potion)PotionPurity.instance)) {
            event.entityLiving.func_82170_o(Potion.field_82731_v.func_76396_c());
        }
        if (PotionSlowfall.instance != null && event.entityLiving.func_70644_a((Potion)PotionSlowfall.instance) && event.entityLiving.func_70660_b((Potion)PotionSlowfall.instance).func_76458_c() > 0) {
            event.entity.field_70143_R = 0.0f;
        }
        if (ConfigLoader.fixBlindness && event.entityLiving.func_70644_a(Potion.field_76440_q) && event.entityLiving instanceof EntityLiving && ((EntityLiving)event.entityLiving).func_70638_az() != null) {
            int effectLevel = 3 - event.entityLiving.func_70660_b(Potion.field_76440_q).func_76458_c();
            if (effectLevel < 0) {
                effectLevel = 0;
            }
            if (event.entityLiving.func_70032_d((Entity)((EntityLiving)event.entityLiving).func_70638_az()) > (float)effectLevel) {
                ((EntityLiving)event.entityLiving).func_70624_b(null);
            }
        }
        if (ConfigLoader.fixInvisibility && event.entityLiving.func_70681_au().nextInt(60) == 0 && event.entityLiving instanceof EntityLiving && ((EntityLiving)event.entityLiving).func_70638_az() != null && (target = ((EntityLiving)event.entityLiving).func_70638_az()).func_70644_a(Potion.field_76441_p)) {
            int equipmentCount = 0;
            for (int i = 0; i < 5; ++i) {
                if (target.func_71124_b(i) == null) continue;
                ++equipmentCount;
            }
            if (target.func_85035_bI() > 0) {
                equipmentCount += MathHelper.func_76123_f((float)((float)target.func_85035_bI() / 10.0f));
            }
            if (equipmentCount > 5) {
                equipmentCount = 5;
            }
            if (event.entityLiving.func_70032_d((Entity)target) > (float)(1 + 3 * equipmentCount)) {
                ((EntityLiving)event.entityLiving).func_70624_b(null);
            }
        }
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            NBTTagCompound persisted = player.getEntityData().func_74775_l("PlayerPersisted");
            if (event.entityLiving instanceof EntityPlayerMP && player.field_70173_aa % 9 == 0 && PotionReach.instance != null && !player.field_70128_L) {
                if (!persisted.func_74767_n("potion core - reach")) {
                    if (player.func_110148_a((IAttribute)PotionCoreHelper.reach).func_111126_e() != PotionCoreHelper.reach.func_111110_b()) {
                        persisted.func_74757_a("potion core - reach", true);
                    }
                } else {
                    ((EntityPlayerMP)player).field_71134_c.setBlockReachDistance(player.func_110148_a((IAttribute)PotionCoreHelper.reach).func_111126_e() + 0.5);
                    if (player.func_110148_a((IAttribute)PotionCoreHelper.reach).func_111126_e() == PotionCoreHelper.reach.func_111110_b()) {
                        persisted.func_74757_a("potion core - reach", false);
                    }
                }
            }
            if (!player.getEntityData().func_74764_b("PlayerPersisted")) {
                player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persisted);
            }
            if (player.field_70173_aa % 11 == 0 && PotionStepup.instance != null) {
                if (!persisted.func_74767_n("potion core - stepup")) {
                    if (player.func_110148_a((IAttribute)PotionCoreHelper.stepHeight).func_111126_e() != PotionCoreHelper.stepHeight.func_111110_b()) {
                        persisted.func_74757_a("potion core - stepup", true);
                    }
                } else {
                    player.field_70138_W = (float)player.func_110148_a((IAttribute)PotionCoreHelper.stepHeight).func_111126_e();
                    if (player.func_110148_a((IAttribute)PotionCoreHelper.stepHeight).func_111126_e() == PotionCoreHelper.stepHeight.func_111110_b()) {
                        persisted.func_74757_a("potion core - stepup", false);
                    }
                }
            }
            if (PotionFlight.instance != null && player.func_70644_a((Potion)PotionFlight.instance)) {
                if (!persisted.func_74767_n("potion core - flight")) {
                    persisted.func_74757_a("potion core - flight", true);
                }
                player.field_71075_bZ.field_75101_c = true;
            } else if (persisted.func_74767_n("potion core - flight")) {
                persisted.func_74757_a("potion core - flight", false);
                player.field_70143_R = 0.0f;
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71075_bZ.field_75100_b = false;
                    player.field_71075_bZ.field_75101_c = false;
                }
            }
            if (PotionTeleportSpawn.instance != null && player.func_70644_a((Potion)PotionTeleportSpawn.instance)) {
                int spawnDelay = persisted.func_74762_e("potion core - spawn teleport");
                if (Math.abs(persisted.func_74769_h("potion core - spawn teleport x") - player.field_70165_t) > 0.01 || Math.abs(persisted.func_74769_h("potion core - spawn teleport y") - player.field_70163_u) > 0.01 || Math.abs(persisted.func_74769_h("potion core - spawn teleport z") - player.field_70161_v) > 0.01) {
                    persisted.func_74780_a("potion core - spawn teleport x", player.field_70165_t);
                    persisted.func_74780_a("potion core - spawn teleport y", player.field_70163_u);
                    persisted.func_74780_a("potion core - spawn teleport z", player.field_70161_v);
                    spawnDelay = 0;
                }
                if (spawnDelay++ >= PotionTeleportSpawn.teleportDelay) {
                    double initialX = player.field_70165_t;
                    double initialY = player.field_70163_u;
                    double initialZ = player.field_70161_v;
                    if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
                        int dimension = player.field_70170_p.field_73011_w.func_177502_q();
                        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(dimension);
                        if (world == null) {
                            dimension = 0;
                        } else if (!world.field_73011_w.func_76567_e()) {
                            dimension = world.field_73011_w.getRespawnDimension((EntityPlayerMP)player);
                        }
                        world = MinecraftServer.func_71276_C().func_71218_a(dimension);
                        BlockPos blockpos = player.getBedLocation(dimension);
                        if (blockpos != null) {
                            blockpos = EntityPlayer.func_180467_a((World)world, (BlockPos)blockpos, (boolean)player.isSpawnForced(dimension));
                        }
                        if (blockpos == null) {
                            blockpos = world.func_175694_M();
                            blockpos = world.func_175672_r(blockpos);
                        }
                        PotionCoreTeleporter.teleportPlayer((EntityPlayerMP)player, null, (World)world, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.1, (double)blockpos.func_177952_p() + 0.5);
                    }
                    persisted.func_74768_a("potion core - spawn teleport", 0);
                    player.func_82170_o(PotionTeleportSpawn.instance.func_76396_c());
                    int maxParticles = 128;
                    for (int i = 0; i < maxParticles; ++i) {
                        double scale = (double)i / ((double)maxParticles - 1.0);
                        float motionX = (player.func_70681_au().nextFloat() - 0.5f) * 0.2f;
                        float motionY = (player.func_70681_au().nextFloat() - 0.5f) * 0.2f;
                        float motionZ = (player.func_70681_au().nextFloat() - 0.5f) * 0.2f;
                        double posX = initialX + (player.field_70165_t - initialX) * scale + (player.func_70681_au().nextDouble() - 0.5) * (double)player.field_70130_N * 2.0;
                        double posY = initialY + (player.field_70163_u - initialY) * scale + player.func_70681_au().nextDouble() * (double)player.field_70131_O;
                        double posZ = initialZ + (player.field_70161_v - initialZ) * scale + (player.func_70681_au().nextDouble() - 0.5) * (double)player.field_70130_N * 2.0;
                        player.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, posX, posY, posZ, (double)motionX, (double)motionY, (double)motionZ, new int[0]);
                    }
                    player.field_70170_p.func_72908_a(initialX, initialY, initialZ, "mob.endermen.portal", 1.0f, 1.0f);
                    player.field_70170_p.func_72956_a((Entity)player, "mob.endermen.portal", 1.0f, 1.0f);
                } else {
                    int particles = spawnDelay == 1 ? 0 : MathHelper.func_76143_f((double)((double)spawnDelay / 10.0));
                    for (int i = 0; i < particles; ++i) {
                        player.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, player.field_70165_t + (double)(player.func_70681_au().nextFloat() * 2.0f) - 1.0, player.field_70163_u + (double)(player.func_70681_au().nextFloat() * 8.0f), player.field_70161_v + (double)(player.func_70681_au().nextFloat() * 2.0f) - 1.0, 0.0, 0.0, 0.0, new int[0]);
                    }
                    persisted.func_74768_a("potion core - spawn teleport", spawnDelay);
                }
            } else if (persisted.func_74762_e("potion core - spawn teleport") > 0) {
                persisted.func_74768_a("potion core - spawn teleport", 0);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingDeath(LivingDeathEvent event) {
        if (PotionRevival.instance != null && event.entityLiving.func_70644_a((Potion)PotionRevival.instance)) {
            int level = event.entityLiving.func_70660_b((Potion)PotionRevival.instance).func_76458_c() + 1;
            event.setCanceled(true);
            event.entityLiving.func_70606_j(PotionRevival.reviveHealth * (float)level);
            event.entityLiving.field_70170_p.func_72956_a((Entity)event.entityLiving, "random.levelup", 1.0f, 0.6f);
            PacketBuffer out = new PacketBuffer(Unpooled.buffer());
            out.writeInt(3);
            out.writeInt(event.entityLiving.func_145782_y());
            SToCMessage packet = new SToCMessage((ByteBuf)out);
            PotionCore.networkWrapper.sendToAllAround((IMessage)packet, new NetworkRegistry.TargetPoint(event.entityLiving.field_70170_p.field_73011_w.func_177502_q(), event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, 16.0));
            event.entityLiving.func_82170_o(PotionRevival.instance.func_76396_c());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSetAttackTarget(LivingSetAttackTargetEvent event) {
        EntityLiving entity;
        if (event.entity instanceof EntityLiving && (entity = (EntityLiving)event.entity).func_70638_az() != null && event.target != null) {
            if (ConfigLoader.fixInvisibility && event.target.func_70644_a(Potion.field_76441_p)) {
                int equipmentCount = 0;
                for (int i = 0; i < 5; ++i) {
                    if (event.target.func_71124_b(i) == null) continue;
                    ++equipmentCount;
                }
                if (event.target.func_85035_bI() > 0) {
                    equipmentCount += MathHelper.func_76123_f((float)((float)event.target.func_85035_bI() / 10.0f));
                }
                if (equipmentCount > 5) {
                    equipmentCount = 5;
                }
                if (entity.func_70032_d((Entity)event.target) > (float)(1 + 3 * equipmentCount)) {
                    entity.func_70624_b(null);
                }
            }
            if (ConfigLoader.fixBlindness && entity.func_70644_a(Potion.field_76440_q)) {
                int effectLevel = 3 - entity.func_70660_b(Potion.field_76440_q).func_76458_c();
                if (effectLevel < 0) {
                    effectLevel = 0;
                }
                if (entity.func_70032_d((Entity)event.target) > (float)effectLevel) {
                    entity.func_70624_b(null);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLoadPlayer(PlayerEvent.LoadFromFile event) {
        PotionCoreHelper.entitiesToHeal.add((EntityLivingBase)event.entityPlayer);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (!PotionCoreHelper.entitiesToHeal.isEmpty()) {
                Iterator<EntityLivingBase> it = PotionCoreHelper.entitiesToHeal.iterator();
                while (it.hasNext()) {
                    EntityLivingBase entity = it.next();
                    if (entity.field_70170_p.field_72995_K) continue;
                    int delay = entity.getEntityData().func_74762_e("Potion Core - Health Fix Delay");
                    if (delay < 5) {
                        entity.getEntityData().func_74768_a("Potion Core - Health Fix Delay", delay + 1);
                        continue;
                    }
                    for (int i = 0; i < 5; ++i) {
                        ItemStack stack = entity.func_71124_b(i);
                        if (stack == null) continue;
                        entity.func_110140_aT().func_111147_b(stack.func_111283_C());
                    }
                    if (entity instanceof EntityPlayer) {
                        FMLLog.info((String)("[Potion Core] Equipment: [0:" + entity.func_71124_b(0) + ", 1:" + entity.func_71124_b(1) + ", 2:" + entity.func_71124_b(2) + ", 3:" + entity.func_71124_b(3) + ", 4:" + entity.func_71124_b(4) + "}"), (Object[])new Object[0]);
                    }
                    if (entity.getEntityData().func_74764_b("Potion Core - Health Fix")) {
                        entity.func_70606_j(entity.getEntityData().func_74760_g("Potion Core - Health Fix"));
                    } else {
                        entity.func_70606_j(entity.func_110138_aP());
                        entity.getEntityData().func_74776_a("Potion Core - Health Fix", entity.func_110143_aJ());
                    }
                    entity.getEntityData().func_74768_a("Potion Core - Health Fix Delay", -1);
                    it.remove();
                }
            }
            if (!PotionCoreHelper.cureEntities.isEmpty()) {
                for (EntityLivingBase entity : PotionCoreHelper.cureEntities) {
                    PotionCoreHelper.clearNegativeEffects(entity);
                }
            }
            PotionCoreHelper.cureEntities.clear();
            if (!PotionCoreHelper.dispelEntities.isEmpty()) {
                for (EntityLivingBase entity : PotionCoreHelper.dispelEntities) {
                    PotionCoreHelper.clearPositiveEffects(entity);
                }
            }
            PotionCoreHelper.dispelEntities.clear();
            if (!PotionCoreHelper.blessEntities.isEmpty()) {
                for (EntityLivingBase entity : PotionCoreHelper.blessEntities) {
                    PotionCoreHelper.addPotionEffectPositive(entity);
                    if (PotionBless.instance != null) {
                        entity.func_82170_o(PotionBless.instance.func_76396_c());
                    }
                    if (PotionChance.instance == null) continue;
                    entity.func_82170_o(PotionChance.instance.func_76396_c());
                }
            }
            PotionCoreHelper.blessEntities.clear();
            if (!PotionCoreHelper.curseEntities.isEmpty()) {
                for (EntityLivingBase entity : PotionCoreHelper.curseEntities) {
                    PotionCoreHelper.addPotionEffectNegative(entity);
                    if (PotionCurse.instance != null) {
                        entity.func_82170_o(PotionCurse.instance.func_76396_c());
                    }
                    if (PotionChance.instance == null) continue;
                    entity.func_82170_o(PotionChance.instance.func_76396_c());
                }
            }
            PotionCoreHelper.curseEntities.clear();
            if (!PotionCoreHelper.invertEntities.isEmpty()) {
                for (EntityLivingBase entity : PotionCoreHelper.invertEntities) {
                    PotionCoreHelper.invertPotionEffects(entity);
                }
            }
            PotionCoreHelper.invertEntities.clear();
            if (!PotionCoreHelper.hurtEntities.isEmpty()) {
                for (EntityLivingBase entity : PotionCoreHelper.hurtEntities.keySet()) {
                    Double multiplier = PotionCoreHelper.hurtEntities.get(entity);
                    if (multiplier == null) continue;
                    entity.field_70172_ad = (int)((double)entity.field_70172_ad * (1.0 / multiplier));
                }
            }
            PotionCoreHelper.hurtEntities.clear();
        }
    }
}

