/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.potioncore;

import com.tmtravlr.potioncore.ConfigLoader;
import com.tmtravlr.potioncore.PotionCoreEffects;
import com.tmtravlr.potioncore.PotionCoreHelper;
import com.tmtravlr.potioncore.PotionCorePlayerController;
import com.tmtravlr.potioncore.effects.PotionPerplexity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

@SideOnly(value=Side.CLIENT)
public class PotionCoreEventHandlerClient {
    public static boolean inverted = false;
    private static final ResourceLocation ARMOR_OVERLAYS = new ResourceLocation("potioncore", "textures/gui/armor_overlays.png");
    private static final ResourceLocation ARMOR_MAGIC_SHIELD = new ResourceLocation("potioncore", "textures/gui/armor_magic_shield.png");

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onOverlayRender(RenderGameOverlayEvent.Pre event) {
        int top;
        int left;
        EntityLivingBase player;
        Minecraft mc = Minecraft.func_71410_x();
        if (event.type == RenderGameOverlayEvent.ElementType.AIR) {
            player = (EntityLivingBase)mc.func_175606_aa();
            PotionCoreEffects.PotionData drown = PotionCoreEffects.potionMap.get("drown");
            if (player != null && drown != null && drown.potion != null && player.func_70644_a((Potion)drown.potion)) {
                event.setCanceled(true);
                if (!player.func_70055_a(Material.field_151586_h)) {
                    int air = player.getEntityData().func_74762_e("potioncore - drown air");
                    mc.field_71424_I.func_76320_a("air");
                    GlStateManager.func_179147_l();
                    int width = event.resolution.func_78326_a();
                    int height = event.resolution.func_78328_b();
                    left = width / 2 + 91;
                    top = height - GuiIngameForge.right_height;
                    int full = MathHelper.func_76143_f((double)((double)(air - 2) * 10.0 / 300.0));
                    int partial = MathHelper.func_76143_f((double)((double)air * 10.0 / 300.0)) - full;
                    for (int i = 0; i < full + partial; ++i) {
                        mc.field_71456_v.func_73729_b(left - i * 8 - 9, top, i < full ? 16 : 25, 18, 9, 9);
                    }
                    GuiIngameForge.right_height += 10;
                    GlStateManager.func_179084_k();
                    mc.field_71424_I.func_76319_b();
                }
            }
        }
        if (event.type == RenderGameOverlayEvent.ElementType.ARMOR && ConfigLoader.renderArmorOverlay) {
            int i;
            event.setCanceled(true);
            player = (EntityLivingBase)mc.func_175606_aa();
            int armorAmout = ForgeHooks.getTotalArmorValue((EntityPlayer)mc.field_71439_g);
            mc.field_71424_I.func_76320_a("armor");
            GlStateManager.func_179147_l();
            ScaledResolution scale = event.resolution;
            double z = -90.0;
            left = scale.func_78326_a() / 2 - 91;
            top = scale.func_78328_b() - GuiIngameForge.left_height;
            boolean renderBase = false;
            double magicShield = player.func_110148_a((IAttribute)PotionCoreHelper.magicShielding).func_111126_e();
            double resistance = (player.func_110148_a((IAttribute)PotionCoreHelper.damageResistance).func_111126_e() - 1.0) * 20.0;
            int armor = ForgeHooks.getTotalArmorValue((EntityPlayer)mc.field_71439_g);
            if (magicShield > 0.0 || resistance > 0.0 || armor > 0) {
                renderBase = true;
            }
            int currentLeft = left;
            mc.func_110434_K().func_110577_a(ARMOR_OVERLAYS);
            for (i = 1; renderBase && i < 20; i += 2) {
                if (i < armor - 20) {
                    this.drawArmorOverlayRectangle(currentLeft, top, z, 36.0, 0.0, 9.0, 9.0);
                } else if (i == armor - 20) {
                    this.drawArmorOverlayRectangle(currentLeft, top, z, 27.0, 0.0, 9.0, 9.0);
                } else if (i < armor) {
                    this.drawArmorOverlayRectangle(currentLeft, top, z, 18.0, 0.0, 9.0, 9.0);
                } else if (i == armor) {
                    this.drawArmorOverlayRectangle(currentLeft, top, z, 9.0, 0.0, 9.0, 9.0);
                } else if (i > armor) {
                    this.drawArmorOverlayRectangle(currentLeft, top, z, 0.0, 0.0, 9.0, 9.0);
                }
                currentLeft += 8;
            }
            currentLeft = left;
            for (i = 2; resistance > 0.0 && i <= 20; i += 2) {
                if ((double)i <= resistance) {
                    this.drawArmorOverlayRectangle(currentLeft - 1, top - 1, z - 10.0, 45.0, 0.0, 11.0, 11.0);
                } else if ((double)i > resistance && resistance >= (double)(i - 2)) {
                    int partial = MathHelper.func_76128_c((double)(resistance % 2.0 * 11.0 / 2.0));
                    this.drawArmorOverlayRectangle(currentLeft - 1, top - 1, z - 10.0, 45.0, 0.0, partial, 11.0);
                }
                currentLeft += 8;
            }
            mc.func_110434_K().func_110577_a(ARMOR_MAGIC_SHIELD);
            currentLeft = left;
            int glintWidth = Math.min(82, MathHelper.func_76128_c((double)(magicShield * 4.0 + 2.0)));
            if (glintWidth == 82) {
                glintWidth = 83;
            }
            if (glintWidth > 2) {
                this.drawEnchantmentGlint(currentLeft - 1, top - 1, z - 20.0, glintWidth, 11.0);
            }
            GuiIngameForge.left_height += 10;
            GlStateManager.func_179084_k();
            mc.func_110434_K().func_110577_a(GuiIngameForge.field_110324_m);
            mc.field_71424_I.func_76319_b();
        }
    }

    private void drawArmorOverlayRectangle(double x, double y, double z, double uStart, double vStart, double width, double height) {
        double uEnd = uStart + width;
        double vEnd = vStart + height;
        double uMult = 0.015625;
        double vMult = 0.0625;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_178970_b();
        worldrenderer.func_178985_a(x, y + height, z, uStart * uMult, vEnd * vMult);
        worldrenderer.func_178985_a(x + width, y + height, z, uEnd * uMult, vEnd * vMult);
        worldrenderer.func_178985_a(x + width, y, z, uEnd * uMult, vStart * vMult);
        worldrenderer.func_178985_a(x, y, z, uStart * uMult, vStart * vMult);
        tessellator.func_78381_a();
    }

    private void drawEnchantmentGlint(double x, double y, double z, double width, double height) {
        float scale = 8.0f;
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)516);
        GlStateManager.func_179112_b((int)768, (int)1);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179124_c((float)0.95f, (float)0.75f, (float)0.95f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.drawGlintRectangle(x, y, z, width, height);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.drawGlintRectangle(x, y, z, width, height);
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
    }

    private void drawGlintRectangle(double x, double y, double z, double width, double height) {
        double uWidth = width / 80.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_178970_b();
        worldrenderer.func_178985_a(x, y + height, z, 0.0, 1.0);
        worldrenderer.func_178985_a(x + width, y + height, z, uWidth, 1.0);
        worldrenderer.func_178985_a(x + width, y, z, uWidth, 0.0);
        worldrenderer.func_178985_a(x, y, z, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    @SubscribeEvent
    public void onFogRender(EntityViewRenderEvent.FogDensity event) {
        if (ConfigLoader.fixBlindness) {
            Minecraft mc = Minecraft.func_71410_x();
            if (event.entity == mc.field_71439_g && mc.field_71439_g.func_70644_a(Potion.field_76440_q)) {
                float f1 = 5.0f;
                int duration = mc.field_71439_g.func_70660_b(Potion.field_76440_q).func_76459_b();
                int amplifier = mc.field_71439_g.func_70660_b(Potion.field_76440_q).func_76458_c() + 1;
                if (duration < 20) {
                    f1 = 5.0f + ((float)(mc.field_71474_y.field_151451_c * 16) - 5.0f) * (1.0f - (float)duration / 20.0f);
                }
                float multiplier = 0.25f / (float)amplifier;
                GlStateManager.func_179093_d((int)9729);
                GlStateManager.func_179102_b((float)(f1 * multiplier));
                GlStateManager.func_179153_c((float)(f1 * multiplier * 4.0f));
                if (GLContext.getCapabilities().GL_NV_fog_distance) {
                    GL11.glFogi((int)34138, (int)34139);
                }
                event.density = 2.0f;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        KeyBinding temp;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        NBTTagCompound persisted = new NBTTagCompound();
        if (PotionCoreEffects.potionMap.get("reach") != null && PotionCoreEffects.potionMap.get((Object)"reach").enabled && mc.field_71442_b != null && !(mc.field_71442_b instanceof PotionCorePlayerController)) {
            NetHandlerPlayClient netHandler = (NetHandlerPlayClient)ObfuscationReflectionHelper.getPrivateValue(PlayerControllerMP.class, (Object)mc.field_71442_b, (String[])new String[]{"netClientHandler", "field_78774_b"});
            WorldSettings.GameType gameType = mc.field_71442_b.func_178889_l();
            mc.field_71442_b = new PotionCorePlayerController(mc, netHandler);
            mc.field_71442_b.func_78746_a(gameType);
        }
        if (player != null) {
            persisted = player.getEntityData().func_74775_l("PlayerPersisted");
            if (!player.getEntityData().func_74764_b("PlayerPersisted")) {
                player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persisted);
            }
        }
        if (mc.field_71441_e != null && player != null && PotionPerplexity.instance != null && player.func_70644_a((Potion)PotionPerplexity.instance)) {
            if (!inverted) {
                PotionCoreEventHandlerClient.saveInverted(true);
                temp = mc.field_71474_y.field_74351_w;
                mc.field_71474_y.field_74351_w = mc.field_71474_y.field_74368_y;
                mc.field_71474_y.field_74368_y = temp;
                temp = mc.field_71474_y.field_74370_x;
                mc.field_71474_y.field_74370_x = mc.field_71474_y.field_74366_z;
                mc.field_71474_y.field_74366_z = temp;
                temp = mc.field_71474_y.field_74311_E;
                mc.field_71474_y.field_74311_E = mc.field_71474_y.field_74314_A;
                mc.field_71474_y.field_74314_A = temp;
                mc.field_71474_y.field_74338_d = !mc.field_71474_y.field_74338_d;
                mc.field_71474_y.func_74303_b();
            }
        } else if (inverted) {
            PotionCoreEventHandlerClient.saveInverted(false);
            temp = mc.field_71474_y.field_74351_w;
            mc.field_71474_y.field_74351_w = mc.field_71474_y.field_74368_y;
            mc.field_71474_y.field_74368_y = temp;
            temp = mc.field_71474_y.field_74370_x;
            mc.field_71474_y.field_74370_x = mc.field_71474_y.field_74366_z;
            mc.field_71474_y.field_74366_z = temp;
            temp = mc.field_71474_y.field_74311_E;
            mc.field_71474_y.field_74311_E = mc.field_71474_y.field_74314_A;
            mc.field_71474_y.field_74314_A = temp;
            mc.field_71474_y.field_74338_d = !mc.field_71474_y.field_74338_d;
            mc.field_71474_y.func_74303_b();
        }
    }

    public static void loadInverted() {
        File options = (File)ObfuscationReflectionHelper.getPrivateValue(GameSettings.class, (Object)Minecraft.func_71410_x().field_71474_y, (String[])new String[]{"optionsFile", "field_74354_ai"});
        if (!options.exists()) {
            return;
        }
        try {
            BufferedReader bufferedreader = new BufferedReader(new FileReader(options));
            String s = "";
            while ((s = bufferedreader.readLine()) != null) {
                try {
                    String[] astring = s.split(":");
                    if (!astring[0].equals("inverted")) continue;
                    inverted = Boolean.valueOf(astring[1]);
                }
                catch (Exception var8) {
                    FMLLog.warning((String)("Skipping bad option: " + s), (Object[])new Object[0]);
                }
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            FMLLog.severe((String)"Failed to load options", (Object[])new Object[]{exception});
        }
    }

    public static void saveInverted(boolean toSave) {
        inverted = toSave;
        if (FMLClientHandler.instance().isLoading()) {
            return;
        }
        try {
            File options = (File)ObfuscationReflectionHelper.getPrivateValue(GameSettings.class, (Object)Minecraft.func_71410_x().field_71474_y, (String[])new String[]{"optionsFile", "field_74354_ai"});
            if (!options.exists()) {
                return;
            }
            PrintWriter printwriter = new PrintWriter(new FileWriter(options));
            printwriter.println("inverted:" + inverted);
            printwriter.close();
        }
        catch (Exception exception) {
            FMLLog.warning((String)"Failed to save options", (Object[])new Object[]{exception});
        }
    }
}

