/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.potioncore;

import java.util.EnumSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.network.play.server.S1FPacketSetExperience;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PotionCoreTeleporter
extends Teleporter {
    private WorldServer worldServer;
    private double x;
    private double y;
    private double z;
    private float pitch;
    private float yaw;
    private double motionX;
    private double motionY;
    private double motionZ;

    public PotionCoreTeleporter(WorldServer worldServerOld, double xToSet, double yToSet, double zToSet, float pitchToSet, float yawToSet, double motionXToSet, double motionYToSet, double motionZToSet) {
        super(worldServerOld);
        this.worldServer = worldServerOld;
        this.x = xToSet;
        this.y = yToSet;
        this.z = zToSet;
        this.pitch = pitchToSet;
        this.yaw = yawToSet;
        this.motionX = motionXToSet;
        this.motionY = motionYToSet;
        this.motionZ = motionZToSet;
    }

    public PotionCoreTeleporter(WorldServer worldServerOld, double xToSet, double yToSet, double zToSet, float pitchToSet, float yawToSet) {
        this(worldServerOld, xToSet, yToSet, zToSet, pitchToSet, yawToSet, 0.0, 0.0, 0.0);
    }

    public void func_180266_a(Entity entity, float par8) {
        entity.func_70012_b(this.x, this.y, this.z, this.yaw, this.pitch);
        entity.func_70034_d(this.yaw);
        entity.field_70159_w = this.motionX;
        entity.field_70181_x = this.motionY;
        entity.field_70179_y = this.motionZ;
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            player.field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity((Entity)player));
        }
    }

    public static void teleportEntity(Entity entity, World newWorld, double x, double y, double z) {
        PotionCoreTeleporter.teleportEntity(entity, newWorld, x, y, z, entity.field_70125_A, entity.field_70177_z, 0.0, 0.0, 0.0);
    }

    public static void teleportEntity(Entity entity, World newWorld, double x, double y, double z, float pitch, float yaw) {
        PotionCoreTeleporter.teleportEntity(entity, newWorld, x, y, z, pitch, yaw, 0.0, 0.0, 0.0);
    }

    public static Entity teleportEntity(Entity entity, World newWorld, double x, double y, double z, float pitch, float yaw, double motionX, double motionY, double motionZ) {
        int currentDimension;
        int dimension = newWorld.field_73011_w.func_177502_q();
        if (dimension != (currentDimension = entity.field_70170_p.field_73011_w.func_177502_q())) {
            return PotionCoreTeleporter.transferEntityToDimension(entity, dimension, x, y, z, pitch, yaw, motionX, motionY, motionZ);
        }
        entity.func_70012_b(x, y, z, yaw, pitch);
        entity.func_70034_d(yaw);
        entity.field_70159_w = motionX;
        entity.field_70181_x = motionY;
        entity.field_70179_y = motionZ;
        return entity;
    }

    public static void teleportPlayer(EntityPlayerMP player, EnumSet packetSet, World newWorld, double x, double y, double z) {
        PotionCoreTeleporter.teleportPlayer(player, packetSet, newWorld, x, y, z, player.field_70125_A, player.field_70177_z, 0.0, 0.0, 0.0);
    }

    public static void teleportPlayer(EntityPlayerMP player, EnumSet packetSet, World newWorld, double x, double y, double z, float pitch, float yaw) {
        PotionCoreTeleporter.teleportPlayer(player, packetSet, newWorld, x, y, z, pitch, yaw, 0.0, 0.0, 0.0);
    }

    public static void teleportPlayer(EntityPlayerMP player, EnumSet packetSet, World newWorld, double x, double y, double z, float pitch, float yaw, double motionX, double motionY, double motionZ) {
        int dimension = newWorld.field_73011_w.func_177502_q();
        int currentDimension = player.field_70170_p.field_73011_w.func_177502_q();
        if (currentDimension != dimension) {
            if (!newWorld.field_72995_K) {
                if (currentDimension != 1) {
                    player.field_71133_b.func_71203_ab().transferPlayerToDimension(player, dimension, (Teleporter)new PotionCoreTeleporter(player.field_71133_b.func_71218_a(dimension), x, y, z, pitch, yaw, motionX, motionY, motionZ));
                } else {
                    PotionCoreTeleporter.forceTeleportPlayerFromEnd(player, dimension, new PotionCoreTeleporter(player.field_71133_b.func_71218_a(dimension), x, y, z, pitch, yaw, motionX, motionY, motionZ));
                }
                player.field_71135_a.func_147359_a((Packet)new S1FPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
            }
        } else {
            if (packetSet != null) {
                player.field_71135_a.func_175089_a(x, y, z, yaw, pitch, (Set)packetSet);
            } else {
                player.field_71135_a.func_147364_a(x, y, z, yaw, pitch);
            }
            player.func_70034_d(yaw);
            player.field_70159_w = motionX;
            player.field_70181_x = motionY;
            player.field_70179_y = motionZ;
            player.field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity((Entity)player));
            newWorld.func_72866_a((Entity)player, false);
        }
    }

    private static void forceTeleportPlayerFromEnd(EntityPlayerMP player, int newDimension, Teleporter colourfulTeleporter) {
        int j = player.field_71093_bK;
        WorldServer worldServerOld = player.field_71133_b.func_71218_a(player.field_71093_bK);
        player.field_71093_bK = newDimension;
        WorldServer worldServerNew = player.field_71133_b.func_71218_a(player.field_71093_bK);
        player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, player.field_70170_p.func_175659_aa(), player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        worldServerOld.func_72973_f((Entity)player);
        player.field_70128_L = false;
        WorldProvider pOld = worldServerOld.field_73011_w;
        WorldProvider pNew = worldServerNew.field_73011_w;
        double moveFactor = pOld.getMovementFactor() / pNew.getMovementFactor();
        double d0 = player.field_70165_t * moveFactor;
        double d1 = player.field_70161_v * moveFactor;
        float f = player.field_70177_z;
        worldServerOld.field_72984_F.func_76320_a("placing");
        d0 = MathHelper.func_76125_a((int)((int)d0), (int)-29999872, (int)29999872);
        d1 = MathHelper.func_76125_a((int)((int)d1), (int)-29999872, (int)29999872);
        if (player.func_70089_S()) {
            player.func_70012_b(d0, player.field_70163_u, d1, player.field_70177_z, player.field_70125_A);
            colourfulTeleporter.func_180266_a((Entity)player, f);
            worldServerNew.func_72838_d((Entity)player);
            worldServerNew.func_72866_a((Entity)player, false);
        }
        worldServerOld.field_72984_F.func_76319_b();
        player.func_70029_a((World)worldServerNew);
        player.field_71133_b.func_71203_ab().func_72375_a(player, worldServerOld);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldServerNew);
        player.field_71133_b.func_71203_ab().func_72354_b(player, worldServerNew);
        player.field_71133_b.func_71203_ab().func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, j, newDimension);
    }

    private static Entity transferEntityToDimension(Entity toTeleport, int newDimension, double x, double y, double z, float pitch, float yaw, double motionX, double motionY, double motionZ) {
        if (!toTeleport.field_70128_L) {
            toTeleport.field_70170_p.field_72984_F.func_76320_a("changeDimension");
            MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
            int oldDimension = toTeleport.field_71093_bK;
            WorldServer worldServerOld = minecraftserver.func_71218_a(oldDimension);
            WorldServer worldServerNew = minecraftserver.func_71218_a(newDimension);
            toTeleport.field_71093_bK = newDimension;
            toTeleport.field_70170_p.func_72900_e(toTeleport);
            toTeleport.field_70128_L = false;
            toTeleport.field_70170_p.field_72984_F.func_76320_a("reposition");
            if (oldDimension == 1) {
                PotionCoreTeleporter.forceTeleportEntityFromEnd(toTeleport, newDimension, new PotionCoreTeleporter(worldServerOld, x, y, z, pitch, yaw, motionX, motionY, motionZ), worldServerNew);
            } else {
                minecraftserver.func_71203_ab().transferEntityToWorld(toTeleport, oldDimension, worldServerOld, worldServerNew, (Teleporter)new PotionCoreTeleporter(worldServerOld, x, y, z, pitch, yaw, motionX, motionY, motionZ));
            }
            toTeleport.field_70170_p.field_72984_F.func_76318_c("reloading");
            Entity entity = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)toTeleport), (World)worldServerNew);
            if (entity != null) {
                entity.func_180432_n(toTeleport);
                worldServerNew.func_72838_d(entity);
            }
            toTeleport.field_70128_L = true;
            toTeleport.field_70170_p.field_72984_F.func_76319_b();
            worldServerOld.func_82742_i();
            worldServerNew.func_82742_i();
            toTeleport.field_70170_p.field_72984_F.func_76319_b();
            return entity;
        }
        return toTeleport;
    }

    private static void forceTeleportEntityFromEnd(Entity entity, int newDimension, Teleporter teleporter, WorldServer worldServerNew) {
        worldServerNew.func_72838_d(entity);
        entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        worldServerNew.func_72866_a(entity, false);
        teleporter.func_180266_a(entity, 0.0f);
        entity.func_70029_a((World)worldServerNew);
    }
}

