/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.potioncore.network;

import com.tmtravlr.potioncore.network.CToSMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketHandlerServer
implements IMessageHandler<CToSMessage, IMessage> {
    public static final int CLIMB_FALL = 1;
    public static final int USE_ENTITY = 2;
    public static final int ATTACK_ENTITY = 3;
    public static final int INTERACT_ENTITY = 4;
    public static final int INTERACT_AT_ENTITY = 5;

    public IMessage onMessage(CToSMessage packet, MessageContext context) {
        ByteBuf buff = Unpooled.wrappedBuffer((byte[])packet.getData());
        int type = buff.readInt();
        switch (type) {
            case 1: {
                EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_177451_a(new UUID(buff.readLong(), buff.readLong()));
                if (player == null) break;
                player.field_70143_R = 0.0f;
                break;
            }
            case 2: {
                EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_177451_a(new UUID(buff.readLong(), buff.readLong()));
                if (player == null || !PacketHandlerServer.checkThreadAndEnqueueInteraction(player, buff, (IThreadListener)player.func_71121_q())) break;
                PacketHandlerServer.useEntity(player, buff);
                break;
            }
        }
        return null;
    }

    private static void useEntity(EntityPlayerMP player, ByteBuf buff) {
        WorldServer worldServer = MinecraftServer.func_71276_C().func_71218_a(player.field_71093_bK);
        player.func_143004_u();
        int targetId = buff.readInt();
        Entity entity = worldServer.func_73045_a(targetId);
        if (entity == null) {
            return;
        }
        int type = buff.readInt();
        switch (type) {
            case 3: {
                if (entity instanceof EntityItem || entity instanceof EntityXPOrb || entity instanceof EntityArrow || entity == player) {
                    player.field_71135_a.func_147360_c("Attempting to attack an invalid entity");
                    FMLLog.warning((String)("Player " + player.func_70005_c_() + " tried to attack an invalid entity"), (Object[])new Object[0]);
                    return;
                }
                player.func_71059_n(entity);
                break;
            }
            case 4: {
                player.func_70998_m(entity);
                break;
            }
            case 5: {
                entity.func_174825_a((EntityPlayer)player, new Vec3(buff.readDouble(), buff.readDouble(), buff.readDouble()));
                break;
            }
        }
    }

    public static boolean checkThreadAndEnqueueInteraction(final EntityPlayerMP player, final ByteBuf buff, IThreadListener threadListener) {
        if (!threadListener.func_152345_ab()) {
            threadListener.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    PacketHandlerServer.useEntity(player, buff);
                }
            });
            return false;
        }
        return true;
    }
}

