/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelFluid;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.b3d.B3DLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class ModelLoaderRegistry {
    private static final Set<ICustomModelLoader> loaders = new HashSet<ICustomModelLoader>();
    private static final Map<oa, IModel> cache = new HashMap<oa, IModel>();

    public static void registerLoader(ICustomModelLoader loader) {
        loaders.add(loader);
        ((cvi)bsu.z().O()).a(new cvl(){

            public void a(cvk manager) {
                for (ICustomModelLoader loader : loaders) {
                    loader.a(manager);
                }
            }
        });
    }

    public static boolean loaded(oa location) {
        return cache.containsKey(location);
    }

    public static oa getActualLocation(oa location) {
        if (location.a().startsWith("builtin/")) {
            return location;
        }
        return new oa(location.b(), "models/" + location.a());
    }

    public static IModel getModel(oa location) throws IOException {
        IModel model;
        if (cache.containsKey(location)) {
            return cache.get(location);
        }
        oa actual = ModelLoaderRegistry.getActualLocation(location);
        ICustomModelLoader accepted = null;
        for (ICustomModelLoader loader : loaders) {
            try {
                if (!loader.accepts(actual)) continue;
                if (accepted != null) {
                    FMLLog.severe("2 loaders (%s and %s) want to load the same model %s", accepted, loader, location);
                    throw new IllegalStateException("2 loaders want to load the same model");
                }
                accepted = loader;
            }
            catch (Exception e) {
                FMLLog.log(Level.ERROR, e, "Exception checking if model %s can be loaded with loader %s, skipping", location, loader);
            }
        }
        if (accepted == null && ModelLoader.VanillaLoader.instance.accepts(actual)) {
            accepted = ModelLoader.VanillaLoader.instance;
        }
        if (accepted == null) {
            FMLLog.severe("no suitable loader found for the model %s, skipping", location);
            model = ModelLoaderRegistry.getMissingModel();
        } else {
            try {
                model = accepted.loadModel(actual);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                FMLLog.log(Level.ERROR, e, "Exception loading model %s with loader %s, skipping", location, accepted);
                model = ModelLoaderRegistry.getMissingModel();
            }
        }
        cache.put(location, model);
        return model;
    }

    public static IModel getMissingModel() {
        return ModelLoader.VanillaLoader.instance.getLoader().getMissingModel();
    }

    public static void clearModelCache() {
        cache.clear();
        cache.put(new oa("minecraft:builtin/generated"), ModelLoader.VanillaLoader.instance.getLoader().getItemModel());
        cache.put(new oa("minecraft:block/builtin/generated"), ModelLoader.VanillaLoader.instance.getLoader().getItemModel());
        cache.put(new oa("minecraft:item/builtin/generated"), ModelLoader.VanillaLoader.instance.getLoader().getItemModel());
    }

    static {
        ModelLoaderRegistry.registerLoader(B3DLoader.instance);
        ModelLoaderRegistry.registerLoader(OBJLoader.instance);
        ModelLoaderRegistry.registerLoader(ModelFluid.FluidLoader.instance);
        ModelLoaderRegistry.registerLoader(ItemLayerModel.Loader.instance);
    }
}

