/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multiset;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class DimensionManager {
    private static Hashtable<Integer, Class<? extends bgd>> providers = new Hashtable();
    private static Hashtable<Integer, Boolean> spawnSettings = new Hashtable();
    private static Hashtable<Integer, qt> worlds = new Hashtable();
    private static boolean hasInit = false;
    private static Hashtable<Integer, Integer> dimensions = new Hashtable();
    private static ArrayList<Integer> unloadQueue = new ArrayList();
    private static BitSet dimensionMap = new BitSet(1024);
    private static ConcurrentMap<aqu, aqu> weakWorldMap = new MapMaker().weakKeys().weakValues().makeMap();
    private static Multiset<Integer> leakedWorlds = HashMultiset.create();

    public static boolean registerProviderType(int id, Class<? extends bgd> provider, boolean keepLoaded) {
        if (providers.containsKey(id)) {
            return false;
        }
        providers.put(id, provider);
        spawnSettings.put(id, keepLoaded);
        return true;
    }

    public static int[] unregisterProviderType(int id) {
        if (!providers.containsKey(id)) {
            return new int[0];
        }
        providers.remove(id);
        spawnSettings.remove(id);
        int[] ret = new int[dimensions.size()];
        int x2 = 0;
        for (Map.Entry<Integer, Integer> ent : dimensions.entrySet()) {
            if (ent.getValue() != id) continue;
            ret[x2++] = ent.getKey();
        }
        return Arrays.copyOf(ret, x2);
    }

    public static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        DimensionManager.registerProviderType(0, bgg.class, true);
        DimensionManager.registerProviderType(-1, bge.class, true);
        DimensionManager.registerProviderType(1, bgh.class, false);
        DimensionManager.registerDimension(0, 0);
        DimensionManager.registerDimension(-1, -1);
        DimensionManager.registerDimension(1, 1);
    }

    public static void registerDimension(int id, int providerType) {
        if (!providers.containsKey(providerType)) {
            throw new IllegalArgumentException(String.format("Failed to register dimension for id %d, provider type %d does not exist", id, providerType));
        }
        if (dimensions.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Failed to register dimension for id %d, One is already registered", id));
        }
        dimensions.put(id, providerType);
        if (id >= 0) {
            dimensionMap.set(id);
        }
    }

    public static void unregisterDimension(int id) {
        if (!dimensions.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Failed to unregister dimension for id %d; No provider registered", id));
        }
        dimensions.remove(id);
    }

    public static boolean isDimensionRegistered(int dim) {
        return dimensions.containsKey(dim);
    }

    public static int getProviderType(int dim) {
        if (!dimensions.containsKey(dim)) {
            throw new IllegalArgumentException(String.format("Could not get provider type for dimension %d, does not exist", dim));
        }
        return dimensions.get(dim);
    }

    public static bgd getProvider(int dim) {
        return DimensionManager.getWorld((int)dim).t;
    }

    public static Integer[] getIDs(boolean check) {
        if (check) {
            ArrayList allWorlds = Lists.newArrayList(weakWorldMap.keySet());
            allWorlds.removeAll(worlds.values());
            ListIterator li = allWorlds.listIterator();
            while (li.hasNext()) {
                aqu w2 = (aqu)li.next();
                leakedWorlds.add((Object)System.identityHashCode(w2));
            }
            for (aqu w2 : allWorlds) {
                int leakCount = leakedWorlds.count((Object)System.identityHashCode(w2));
                if (leakCount == 5) {
                    FMLLog.fine("The world %x (%s) may have leaked: first encounter (5 occurences).\n", System.identityHashCode(w2), w2.P().k());
                    continue;
                }
                if (leakCount % 5 != 0) continue;
                FMLLog.fine("The world %x (%s) may have leaked: seen %d times.\n", System.identityHashCode(w2), w2.P().k(), leakCount);
            }
        }
        return DimensionManager.getIDs();
    }

    public static Integer[] getIDs() {
        return worlds.keySet().toArray(new Integer[worlds.size()]);
    }

    public static void setWorld(int id, qt world) {
        if (world != null) {
            worlds.put(id, world);
            weakWorldMap.put((aqu)world, (aqu)world);
            MinecraftServer.M().worldTickTimes.put(id, new long[100]);
            FMLLog.info("Loading dimension %d (%s) (%s)", id, world.P().k(), world.r());
        } else {
            worlds.remove(id);
            MinecraftServer.M().worldTickTimes.remove(id);
            FMLLog.info("Unloading dimension %d", id);
        }
        ArrayList<qt> tmp = new ArrayList<qt>();
        if (worlds.get(0) != null) {
            tmp.add(worlds.get(0));
        }
        if (worlds.get(-1) != null) {
            tmp.add(worlds.get(-1));
        }
        if (worlds.get(1) != null) {
            tmp.add(worlds.get(1));
        }
        for (Map.Entry<Integer, qt> entry : worlds.entrySet()) {
            int dim = entry.getKey();
            if (dim >= -1 && dim <= 1) continue;
            tmp.add(entry.getValue());
        }
        MinecraftServer.M().c = tmp.toArray(new qt[tmp.size()]);
    }

    public static void initDimension(int dim) {
        qt overworld = DimensionManager.getWorld(0);
        if (overworld == null) {
            throw new RuntimeException("Cannot Hotload Dim: Overworld is not Loaded!");
        }
        try {
            DimensionManager.getProviderType(dim);
        }
        catch (Exception e) {
            System.err.println("Cannot Hotload Dim: " + e.getMessage());
            return;
        }
        MinecraftServer mcServer = overworld.r();
        bqy savehandler = overworld.O();
        arb worldSettings = new arb(overworld.P());
        qt world = dim == 0 ? overworld : (qt)new ql(mcServer, savehandler, dim, overworld, mcServer.b).b();
        world.a((ara)new qp(mcServer, world));
        MinecraftForge.EVENT_BUS.post(new WorldEvent.Load((aqu)world));
        if (!mcServer.S()) {
            world.P().a(mcServer.m());
        }
        mcServer.a(mcServer.n());
    }

    public static qt getWorld(int id) {
        return worlds.get(id);
    }

    public static qt[] getWorlds() {
        return worlds.values().toArray(new qt[worlds.size()]);
    }

    public static boolean shouldLoadSpawn(int dim) {
        int id = DimensionManager.getProviderType(dim);
        return spawnSettings.containsKey(id) && spawnSettings.get(id) != false;
    }

    public static Integer[] getStaticDimensionIDs() {
        return dimensions.keySet().toArray(new Integer[dimensions.keySet().size()]);
    }

    public static bgd createProviderFor(int dim) {
        try {
            if (dimensions.containsKey(dim)) {
                bgd provider = providers.get(DimensionManager.getProviderType(dim)).newInstance();
                provider.setDimension(dim);
                return provider;
            }
            throw new RuntimeException(String.format("No WorldProvider bound for dimension %d", dim));
        }
        catch (Exception e) {
            FMLCommonHandler.instance().getFMLLogger().log(Level.ERROR, String.format("An error occured trying to create an instance of WorldProvider %d (%s)", dim, providers.get(DimensionManager.getProviderType(dim)).getSimpleName()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void unloadWorld(int id) {
        unloadQueue.add(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadWorlds(Hashtable<Integer, long[]> worldTickTimes) {
        for (int id : unloadQueue) {
            qt w2 = worlds.get(id);
            try {
                if (w2 != null) {
                    w2.a(true, null);
                    continue;
                }
                FMLLog.warning("Unexpected world unload - world %d is already unloaded", id);
            }
            catch (aqz e) {
                e.printStackTrace();
            }
            finally {
                if (w2 == null) continue;
                MinecraftForge.EVENT_BUS.post(new WorldEvent.Unload((aqu)w2));
                w2.o();
                DimensionManager.setWorld(id, null);
            }
        }
        unloadQueue.clear();
    }

    public static int getNextFreeDimId() {
        int next = 0;
        while (dimensions.containsKey(next = dimensionMap.nextClearBit(next))) {
            dimensionMap.set(next);
        }
        return next;
    }

    public static fn saveDimensionDataMap() {
        int[] data = new int[(dimensionMap.length() + 32 - 1) / 32];
        fn dimMap = new fn();
        for (int i = 0; i < data.length; ++i) {
            int val = 0;
            for (int j2 = 0; j2 < 32; ++j2) {
                val |= dimensionMap.get(i * 32 + j2) ? 1 << j2 : 0;
            }
            data[i] = val;
        }
        dimMap.a("DimensionArray", data);
        return dimMap;
    }

    public static void loadDimensionDataMap(fn compoundTag) {
        dimensionMap.clear();
        if (compoundTag == null) {
            for (Integer id : dimensions.keySet()) {
                if (id < 0) continue;
                dimensionMap.set(id);
            }
        } else {
            int[] intArray = compoundTag.l("DimensionArray");
            for (int i = 0; i < intArray.length; ++i) {
                for (int j2 = 0; j2 < 32; ++j2) {
                    dimensionMap.set(i * 32 + j2, (intArray[i] & 1 << j2) != 0);
                }
            }
        }
    }

    public static File getCurrentSaveRootDirectory() {
        if (DimensionManager.getWorld(0) != null) {
            return ((bqm)DimensionManager.getWorld(0).O()).b();
        }
        if (MinecraftServer.M() != null) {
            MinecraftServer srv = MinecraftServer.M();
            bqm saveHandler = (bqm)srv.X().a(srv.T(), false);
            return saveHandler.b();
        }
        return null;
    }

    static {
        DimensionManager.init();
    }
}

