/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.potioncore;

import com.tmtravlr.potioncore.PotionCoreEffects;
import com.tmtravlr.potioncore.effects.PotionArchery;
import com.tmtravlr.potioncore.effects.PotionExplosion;
import com.tmtravlr.potioncore.effects.PotionExplosionSelf;
import com.tmtravlr.potioncore.effects.PotionFire;
import com.tmtravlr.potioncore.effects.PotionKlutz;
import com.tmtravlr.potioncore.effects.PotionLaunch;
import com.tmtravlr.potioncore.effects.PotionLevitate;
import com.tmtravlr.potioncore.effects.PotionMagicFocus;
import com.tmtravlr.potioncore.effects.PotionMagicInhibition;
import com.tmtravlr.potioncore.effects.PotionMagicShield;
import com.tmtravlr.potioncore.effects.PotionReach;
import com.tmtravlr.potioncore.effects.PotionRecoil;
import com.tmtravlr.potioncore.effects.PotionRepair;
import com.tmtravlr.potioncore.effects.PotionRevival;
import com.tmtravlr.potioncore.effects.PotionRust;
import com.tmtravlr.potioncore.effects.PotionSlowfall;
import com.tmtravlr.potioncore.effects.PotionSpin;
import com.tmtravlr.potioncore.effects.PotionStepup;
import com.tmtravlr.potioncore.effects.PotionTeleport;
import com.tmtravlr.potioncore.effects.PotionTeleportSpawn;
import com.tmtravlr.potioncore.effects.PotionVulnerable;
import com.tmtravlr.potioncore.effects.PotionWeight;
import net.minecraftforge.common.config.Configuration;

public class ConfigLoader {
    public static Configuration config;
    public static boolean fixInvisibility;
    public static boolean fixBlindness;
    public static boolean modifyHasteFatigue;
    public static boolean renderArmorOverlay;
    public static float hasteAttackIncrease;
    public static float fatigueAttackDecrease;

    public static void load() {
        config.load();
        ConfigLoader.loadPotionConfigs();
        fixInvisibility = config.getBoolean("Fix Invisibiliby", "_options", true, "Fixes Invisibiliby so mobs can't see you as close while you are invisible.\nThey can see you at 1-12 blocks away depending on how much armor you\nhave on and if you are holding a item or not.");
        fixBlindness = config.getBoolean("Fix Blindness", "_options", true, "Fixes Blindness so mobs can't see things to attack unless they are really\nclose.");
        modifyHasteFatigue = config.getBoolean("Add Haste/Mining Fatigue Attack Speed", "_options", true, "Modifies haste so it makes you attack faster, and mining fatigue so it\nmakes you attack slower.");
        renderArmorOverlay = config.getBoolean("Render Armor Bar Overlays", "_options", true, "Renders a few extra things on the armor bar, including damage resistance,\nmagic shielding, and armor values over 20.");
        hasteAttackIncrease = config.getFloat("Haste Attack Speed Increase", "_options", hasteAttackIncrease, 0.0f, Float.POSITIVE_INFINITY, "Increase percent for the haste potion if enabled.");
        fatigueAttackDecrease = config.getFloat("Mining Fatigue Attack Speed Decrease", "_options", fatigueAttackDecrease, Float.NEGATIVE_INFINITY, 0.0f, "Decrease percent for the mining fatigue potion if enabled.");
        for (String name : PotionCoreEffects.potionMap.keySet()) {
            PotionCoreEffects.PotionData data = PotionCoreEffects.potionMap.get(name);
            data.enabled = config.getBoolean("Enabled", name, data.enabled, "Is the " + name + " potion enabled?");
        }
        config.save();
    }

    private static void loadPotionConfigs() {
        PotionArchery.damageModifier = config.getFloat("Damage Modifier", "archery", (float)PotionArchery.damageModifier, 0.0f, Float.POSITIVE_INFINITY, "The projectile damage modifier applied by the archery potion per each amplifier level.\n");
        PotionExplosion.explosionSize = config.getFloat("Explosion Size", "explode", PotionExplosion.explosionSize, 0.0f, Float.POSITIVE_INFINITY, "The base explosion size for the explode potion.\n");
        PotionExplosionSelf.explosionSize = config.getFloat("Explosion Size", "burst", PotionExplosionSelf.explosionSize, 0.0f, Float.POSITIVE_INFINITY, "The base explosion size for the burst potion.\n");
        PotionFire.fireDuration = config.getFloat("Fire Duration", "fire", PotionFire.fireDuration, 0.0f, Float.POSITIVE_INFINITY, "The fire duration in seconds applied by the fire potion for each amplifier level.\n");
        PotionKlutz.damageModifier = config.getFloat("Damage Modifier", "klutz", (float)PotionKlutz.damageModifier, Float.NEGATIVE_INFINITY, 0.0f, "The projectile damage modifier applied by the klutz potion per each amplifier level.\n");
        PotionLaunch.launchSpeed = config.getFloat("Launch Speed", "launch", (float)PotionLaunch.launchSpeed, 0.0f, Float.POSITIVE_INFINITY, "The initial launch speed for the launch potion per each amplifier level.\n");
        PotionLevitate.floatSpeed = config.getFloat("Float Speed", "levitate", (float)PotionLevitate.floatSpeed, 0.0f, Float.POSITIVE_INFINITY, "The float speed for the levitate potion per each amplifier level.\n");
        PotionRecoil.reflectDamage = config.getFloat("Damage Reflection", "recoil", PotionRecoil.reflectDamage, 0.0f, 0.9f, "The percent of damage reflected for the recoil potion per each amplifier level.\n");
        PotionRepair.repairTime = config.getInt("Repair Time", "repair", PotionRepair.repairTime, 0, Integer.MAX_VALUE, "The ticks between each repair from the repair potion.\n");
        PotionRevival.reviveHealth = config.getFloat("Revive Health", "revival", PotionRevival.reviveHealth, 0.0f, Float.POSITIVE_INFINITY, "The amount of health recovered for each amplifier level when reviving from the revival\npotion per each amplifier level in half hearts.\n");
        PotionRust.damageTime = config.getInt("Damage Time", "rust", PotionRust.damageTime, 0, Integer.MAX_VALUE, "The ticks between each durability reduction from the rust potion.\n");
        PotionSlowfall.maxSpeed = config.getFloat("Max Fall Speed", "slowfall", (float)PotionSlowfall.maxSpeed, 0.0f, Float.POSITIVE_INFINITY, "The base maximum fall speed for the slowfall potion.\n");
        PotionSpin.rotationSpeed = config.getFloat("Rotation Speed", "spin", PotionSpin.rotationSpeed, 0.0f, Float.POSITIVE_INFINITY, "The base maximum random rotation speed change for the spin potion.\n");
        PotionStepup.increase = config.getFloat("Step Height Increase", "stepup", PotionStepup.increase, 0.0f, Float.POSITIVE_INFINITY, "The step height increase per level of the stepup potion.\n");
        PotionTeleport.teleportRange = config.getFloat("Teleport Radius", "teleport", (float)PotionTeleport.teleportRange, 1.0f, Float.POSITIVE_INFINITY, "The base maximum teleport radius for the teleport potion.\n");
        PotionTeleportSpawn.teleportDelay = config.getInt("Teleport Delay", "teleportspawn", PotionTeleportSpawn.teleportDelay, 0, Integer.MAX_VALUE, "The number of ticks the player must stay still before teleporting with the teleportspawn\npotion (with 20 ticks/second).\n");
        PotionVulnerable.damageMultiplier = config.getFloat("Damage Multiplier", "vulnerable", (float)PotionVulnerable.damageMultiplier, 0.0f, Float.POSITIVE_INFINITY, "The base damage multiplier for the vulnerable potion.\n");
        PotionWeight.speedReduction = config.getFloat("Jump Height Reduction", "weight", PotionWeight.speedReduction, 0.0f, Float.POSITIVE_INFINITY, "The base jump speed reduction for the weight potion,\nin 1/10ths of a block per tick.\n");
        PotionReach.rangeModifier = config.getFloat("Reach Increase", "reach", 1.0f, 0.0f, 2024.0f, "The block increase for how far you can reach per level with the reach potion.\n");
        PotionMagicFocus.damageModifier = config.getFloat("Damage Modifier", "magicfocus", (float)PotionMagicFocus.damageModifier, 0.0f, Float.POSITIVE_INFINITY, "The magic damage modifier applied by the magicfocus potion per each amplifier level.\n");
        PotionMagicInhibition.damageModifier = config.getFloat("Damage Modifier", "magicinhibition", (float)PotionMagicInhibition.damageModifier, Float.NEGATIVE_INFINITY, 0.0f, "The magic damage modifier applied by the magicinhibition potion per each amplifier level.\n");
        PotionMagicShield.damageModifier = config.getFloat("Damage Modifier", "magicshield", (float)PotionMagicShield.damageModifier, 0.0f, 20.0f, "The magic armor points applied by the magicshield potion per each amplifier level.\n");
    }

    static {
        hasteAttackIncrease = 0.15f;
        fatigueAttackDecrease = -0.15f;
    }
}

