/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.potioncore;

import com.tmtravlr.potioncore.CommonProxy;
import com.tmtravlr.potioncore.ConfigLoader;
import com.tmtravlr.potioncore.PotionCoreEffects;
import com.tmtravlr.potioncore.PotionCoreHelper;
import com.tmtravlr.potioncore.network.CToSMessage;
import com.tmtravlr.potioncore.network.PacketHandlerClient;
import com.tmtravlr.potioncore.network.PacketHandlerServer;
import com.tmtravlr.potioncore.network.SToCMessage;
import com.tmtravlr.potioncore.potion.EntityPotionCorePotion;
import com.tmtravlr.potioncore.potion.ItemPotionCorePotion;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="potioncore", version="1.3_for_1.8", name="Potion Core", acceptedMinecraftVersions="[1.8]")
public class PotionCore {
    public static final String MOD_ID = "potioncore";
    public static final String VERSION = "1.3_for_1.8";
    public static final String MOD_NAME = "Potion Core";
    @Mod.Instance(value="potioncore")
    public static PotionCore instance;
    @SidedProxy(clientSide="com.tmtravlr.potioncore.ClientProxy", serverSide="com.tmtravlr.potioncore.CommonProxy")
    public static CommonProxy proxy;
    public static SimpleNetworkWrapper networkWrapper;
    public static CreativeTabs tabPotionCore;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigLoader.config = new Configuration(event.getSuggestedConfigurationFile());
        ConfigLoader.load();
        PotionCoreHelper.increasePotionTypesSize();
        PotionCoreEffects.loadPotionEffects();
        proxy.loadInverted();
        ItemPotionCorePotion.instance = new ItemPotionCorePotion();
        GameRegistry.registerItem((Item)ItemPotionCorePotion.instance, (String)"custom_potion");
        proxy.registerEventHandlers();
        networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel(MOD_ID);
        networkWrapper.registerMessage(PacketHandlerServer.class, CToSMessage.class, 0, Side.SERVER);
        networkWrapper.registerMessage(PacketHandlerClient.class, SToCMessage.class, 1, Side.CLIENT);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerRenderers();
        EntityRegistry.registerModEntity(EntityPotionCorePotion.class, (String)"CustomPotion", (int)0, (Object)this, (int)32, (int)5, (boolean)true);
        if (PotionCoreEffects.potionMap.get("reach") != null && PotionCoreEffects.potionMap.get((Object)"reach").enabled) {
            proxy.replaceEntityRenderer();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (int i = 0; i < Potion.field_76425_a.length; ++i) {
            if (Potion.field_76425_a[i] == null) continue;
            if (PotionCoreHelper.isBadEffect(Potion.field_76425_a[i])) {
                PotionCoreHelper.badEffectList.add(Potion.field_76425_a[i]);
                continue;
            }
            PotionCoreHelper.goodEffectList.add(Potion.field_76425_a[i]);
        }
        PotionCoreHelper.loadInversions();
    }

    static {
        tabPotionCore = new CreativeTabs(MOD_ID){

            @SideOnly(value=Side.CLIENT)
            public Item func_78016_d() {
                return ItemPotionCorePotion.instance;
            }
        };
    }
}

