/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.potioncore;

import com.tmtravlr.potioncore.effects.PotionAntidote;
import com.tmtravlr.potioncore.effects.PotionArchery;
import com.tmtravlr.potioncore.effects.PotionBless;
import com.tmtravlr.potioncore.effects.PotionCure;
import com.tmtravlr.potioncore.effects.PotionCurse;
import com.tmtravlr.potioncore.effects.PotionDispel;
import com.tmtravlr.potioncore.effects.PotionDrown;
import com.tmtravlr.potioncore.effects.PotionFire;
import com.tmtravlr.potioncore.effects.PotionKlutz;
import com.tmtravlr.potioncore.effects.PotionLevitate;
import com.tmtravlr.potioncore.effects.PotionRepair;
import com.tmtravlr.potioncore.effects.PotionRust;
import com.tmtravlr.potioncore.effects.PotionSlowfall;
import com.tmtravlr.potioncore.effects.PotionVulnerable;
import com.tmtravlr.potioncore.effects.PotionWeight;
import com.tmtravlr.potioncore.potion.ItemPotionCorePotion;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class PotionCoreHelper {
    public static ArrayList<EntityLivingBase> cureEntities = new ArrayList();
    public static ArrayList<EntityLivingBase> dispelEntities = new ArrayList();
    public static ArrayList<EntityLivingBase> blessEntities = new ArrayList();
    public static ArrayList<EntityLivingBase> curseEntities = new ArrayList();
    public static ArrayList<EntityLivingBase> invertEntities = new ArrayList();
    public static HashMap<EntityLivingBase, Double> hurtEntities = new HashMap();
    public static ArrayList<Potion> goodEffectList = new ArrayList();
    public static ArrayList<Potion> badEffectList = new ArrayList();
    public static HashMap<Potion, Potion> oppositeEffects = new HashMap();
    public static final String HEAL_TAG = "Potion Core - Health Fix";
    public static final String HEAL_DELAY_TAG = "Potion Core - Health Fix Delay";
    public static ArrayList<EntityLivingBase> entitiesToHeal = new ArrayList();
    public static final RangedAttribute projectileDamage = new RangedAttribute((IAttribute)null, "potioncore.projectileDamage", 1.0, 0.0, 2048.0);
    public static final RangedAttribute magicDamage = new RangedAttribute((IAttribute)null, "potioncore.magicDamage", 1.0, 0.0, 2048.0);
    public static final RangedAttribute reach = new RangedAttribute((IAttribute)null, "potioncore.reach", 4.5, 0.0, 2048.0);
    public static final RangedAttribute attackSpeed = new RangedAttribute((IAttribute)null, "potioncore.attackSpeed", 1.0, 0.1, 2048.0);
    public static final RangedAttribute stepHeight = new RangedAttribute((IAttribute)null, "potioncore.stepHeight", 0.6, 0.0, 256.0);
    public static final RangedAttribute jumpHeight = new RangedAttribute((IAttribute)null, "potioncore.jumpHeight", 0.0, -2048.0, 2048.0);
    public static final RangedAttribute damageResistance = new RangedAttribute((IAttribute)null, "potioncore.damageResistance", 1.0, -2048.0, 2.0);
    public static final RangedAttribute magicShielding = new RangedAttribute((IAttribute)null, "potioncore.magicShielding", 0.0, 0.0, 20.0);
    public static final UUID tempUUID = UUID.fromString("a6684e4c-f9da-4c3d-9ec1-a07ff26da4ef");
    public static int nextId;

    public static double getPlayerReachDistance(EntityPlayer player) {
        return player != null ? player.func_110148_a((IAttribute)reach).func_111126_e() + (player.field_71075_bZ.field_75098_d ? 0.5 : 0.0) : 0.0;
    }

    public static double getJumpHeightAttribute(EntityLivingBase entity) {
        double jump = entity.func_110148_a((IAttribute)jumpHeight).func_111126_e();
        if (entity.func_70644_a(Potion.field_76430_j)) {
            jump -= (double)(entity.func_70660_b(Potion.field_76430_j).func_76458_c() + 1);
        }
        return jump;
    }

    public static double getDamageResistanceAttribute(EntityLivingBase entity) {
        double resistance = entity.func_110148_a((IAttribute)damageResistance).func_111126_e() - 1.0;
        if (entity.func_70644_a(Potion.field_76429_m)) {
            resistance -= (double)(entity.func_70660_b(Potion.field_76429_m).func_76458_c() + 1) * 0.2;
        }
        if (resistance > 1.0) {
            resistance = 1.0;
        }
        return resistance;
    }

    public static void increasePotionTypesSize() {
        Field potionTypes = null;
        FMLLog.info((String)"[Potion Core] Attempting to increase max number of potions.", (Object[])new Object[0]);
        try {
            potionTypes = Potion.class.getDeclaredField("field_76425_a");
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(potionTypes, potionTypes.getModifiers() & 0xFFFFFFEF);
        }
        catch (Exception e) {
            try {
                potionTypes = Potion.class.getDeclaredField("potionTypes");
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(potionTypes, potionTypes.getModifiers() & 0xFFFFFFEF);
            }
            catch (Exception e2) {
                FMLLog.warning((String)"[Potion Core] Couldn't increase the maximum number of potions!", (Object[])new Object[0]);
                e.printStackTrace();
                e2.printStackTrace();
            }
        }
        if (potionTypes != null) {
            try {
                Potion[] newPotionTypes = new Potion[256];
                for (int i = 0; i < newPotionTypes.length && i < Potion.field_76425_a.length; ++i) {
                    newPotionTypes[i] = Potion.field_76425_a[i];
                }
                potionTypes.set(null, newPotionTypes);
            }
            catch (Exception e) {
                FMLLog.warning((String)"[Potion Core] Couldn't increase the maximum number of potions!", (Object[])new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public static void loadInversions() {
        PotionCoreHelper.loadInversion(Potion.field_76440_q, Potion.field_76439_r);
        PotionCoreHelper.loadInversion(Potion.field_76420_g, Potion.field_76437_t);
        PotionCoreHelper.loadInversion(Potion.field_76422_e, Potion.field_76419_f);
        PotionCoreHelper.loadInversion(Potion.field_76426_n, PotionFire.instance);
        PotionCoreHelper.loadInversion(Potion.field_76433_i, Potion.field_76432_h);
        PotionCoreHelper.loadInversion(Potion.field_76438_s, Potion.field_76443_y);
        PotionCoreHelper.loadInversion(Potion.field_76430_j, PotionWeight.instance);
        PotionCoreHelper.loadInversion(Potion.field_76421_d, Potion.field_76424_c);
        PotionCoreHelper.loadInversion(Potion.field_76436_u, PotionAntidote.instance);
        PotionCoreHelper.loadInversion(Potion.field_76428_l, Potion.field_82731_v);
        PotionCoreHelper.loadInversion(Potion.field_76429_m, PotionVulnerable.instance);
        PotionCoreHelper.loadInversion(Potion.field_76427_o, PotionDrown.instance);
        PotionCoreHelper.loadInversion(PotionArchery.instance, PotionKlutz.instance);
        PotionCoreHelper.loadInversion(PotionBless.instance, PotionCurse.instance);
        PotionCoreHelper.loadInversion(PotionCure.instance, PotionDispel.instance);
        PotionCoreHelper.loadInversion(PotionLevitate.instance, PotionSlowfall.instance);
        PotionCoreHelper.loadInversion(PotionRepair.instance, PotionRust.instance);
    }

    public static void loadInversion(Potion potion1, Potion potion2) {
        if (potion1 != null && potion2 != null) {
            oppositeEffects.put(potion1, potion2);
            oppositeEffects.put(potion2, potion1);
        }
    }

    public static void clearPositiveEffects(EntityLivingBase entity) {
        Collection effects = entity.func_70651_bq();
        ArrayList<Integer> idsToRemove = new ArrayList<Integer>();
        for (PotionEffect effect : effects) {
            if (PotionCoreHelper.isBadEffect(Potion.field_76425_a[effect.func_76456_a()])) continue;
            idsToRemove.add(effect.func_76456_a());
        }
        Iterator iterator = idsToRemove.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            entity.func_82170_o(id);
        }
    }

    public static void clearNegativeEffects(EntityLivingBase entity) {
        Collection effects = entity.func_70651_bq();
        ArrayList<Integer> idsToRemove = new ArrayList<Integer>();
        for (PotionEffect effect : effects) {
            if (!PotionCoreHelper.isBadEffect(Potion.field_76425_a[effect.func_76456_a()])) continue;
            idsToRemove.add(effect.func_76456_a());
        }
        Iterator iterator = idsToRemove.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            entity.func_82170_o(id);
        }
    }

    public static void addPotionEffectPositive(EntityLivingBase entity) {
        int r = entity.func_70681_au().nextInt(goodEffectList.size());
        Potion potion = goodEffectList.get(r);
        if (potion.func_76403_b()) {
            entity.func_70690_d(new PotionEffect(potion.func_76396_c(), 1));
        } else {
            entity.func_70690_d(new PotionEffect(potion.func_76396_c(), 1200));
        }
    }

    public static void addPotionEffectNegative(EntityLivingBase entity) {
        int r = entity.func_70681_au().nextInt(badEffectList.size());
        Potion potion = badEffectList.get(r);
        if (potion.func_76403_b()) {
            entity.func_70690_d(new PotionEffect(potion.func_76396_c(), 1));
        } else {
            entity.func_70690_d(new PotionEffect(potion.func_76396_c(), 1200));
        }
    }

    public static void invertPotionEffects(EntityLivingBase entity) {
        PotionEffect[] effects = new PotionEffect[]{};
        effects = entity.func_70651_bq().toArray(effects);
        for (int i = 0; i < effects.length; ++i) {
            PotionEffect effect = effects[i];
            if (effect == null || Potion.field_76425_a[effect.func_76456_a()] == null || !oppositeEffects.containsKey(Potion.field_76425_a[effect.func_76456_a()])) continue;
            Potion potion = oppositeEffects.get(Potion.field_76425_a[effect.func_76456_a()]);
            int duration = effect.func_76459_b();
            if (potion.func_76403_b()) {
                duration = 1;
            }
            entity.func_82170_o(effect.func_76456_a());
            entity.func_70690_d(new PotionEffect(potion.func_76396_c(), duration, effect.func_76458_c(), effect.func_82720_e(), effect.func_180154_f()));
        }
    }

    public static boolean isBadEffect(Potion potion) {
        return (Boolean)ObfuscationReflectionHelper.getPrivateValue(Potion.class, (Object)potion, (String[])new String[]{"field_76418_K", "isBadEffect"});
    }

    public static int getNextId() {
        while (nextId < Potion.field_76425_a.length && Potion.field_76425_a[nextId] != null) {
            if (++nextId < Potion.field_76425_a.length) continue;
            FMLLog.bigWarning((String)"[Potion Core] Ran out of id values at %d; Could not create potion!", (Object[])new Object[]{nextId});
            return -1;
        }
        return nextId;
    }

    public static ItemStack getItemStack(Potion potion, int duration, int amplifier, boolean splash) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("CustomPotionEffects", (NBTBase)new NBTTagList());
        tag.func_150295_c("CustomPotionEffects", 0).func_74742_a((NBTBase)PotionCoreHelper.writePotionToTag(potion, duration, amplifier));
        ItemStack toAdd = new ItemStack((Item)ItemPotionCorePotion.instance);
        if (splash) {
            toAdd.func_77964_b(1);
        } else {
            toAdd.func_77964_b(0);
        }
        toAdd.func_77982_d(tag);
        return toAdd;
    }

    public static NBTTagCompound writePotionToTag(Potion potion, int duration, int amplifier) {
        NBTTagCompound tag = new NBTTagCompound();
        String[] names = Potion.func_180141_c();
        for (int i = 0; i < names.length; ++i) {
            if (Potion.func_180142_b((String)names[i]) != potion) continue;
            tag.func_74778_a("Id", names[i]);
        }
        tag.func_74768_a("Amplifier", amplifier);
        tag.func_74768_a("Duration", duration);
        return tag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PotionEffect readPotionEffectFromTag(NBTTagCompound tag) {
        int id = 0;
        if (tag.func_150297_b("Id", 8)) {
            String idString = tag.func_74779_i("Id");
            Potion potion = Potion.func_180142_b((String)idString);
            if (potion == null) return null;
            id = potion.func_76396_c();
        } else {
            id = tag.func_74771_c("Id") & 0xFF;
        }
        if (id < 0 || id >= Potion.field_76425_a.length || Potion.field_76425_a[id] == null) return null;
        byte j = tag.func_74771_c("Amplifier");
        int k = tag.func_74762_e("Duration");
        boolean flag = tag.func_74767_n("Ambient");
        boolean flag1 = true;
        if (!tag.func_150297_b("ShowParticles", 1)) return new PotionEffect(id, k, (int)j, flag, flag1);
        flag1 = tag.func_74767_n("ShowParticles");
        return new PotionEffect(id, k, (int)j, flag, flag1);
    }

    public static int getCustomPotionColor(Collection<PotionEffect> list) {
        int i = 3694022;
        if (list != null && !list.isEmpty()) {
            float red = -1.0f;
            float green = -1.0f;
            float blue = -1.0f;
            float count = 0.0f;
            for (PotionEffect potioneffect : list) {
                int currentPotionColor = Potion.field_76425_a[potioneffect.func_76456_a()].func_76401_j();
                float currentRed = (float)(currentPotionColor >> 16 & 0xFF) / 255.0f;
                float currentGreen = (float)(currentPotionColor >> 8 & 0xFF) / 255.0f;
                float currentBlue = (float)(currentPotionColor >> 0 & 0xFF) / 255.0f;
                for (int k = 0; k < potioneffect.func_76458_c() + 1; ++k) {
                    if (red < 0.0f) {
                        red = currentRed;
                        green = currentGreen;
                        blue = currentBlue;
                    } else {
                        red += currentRed;
                        green += currentGreen;
                        blue += currentBlue;
                    }
                    count += 1.0f;
                }
            }
            red = red / count * 255.0f;
            green = green / count * 255.0f;
            blue = blue / count * 255.0f;
            return (int)red << 16 | (int)green << 8 | (int)blue;
        }
        return i;
    }

    static {
        reach.func_111112_a(true);
        stepHeight.func_111112_a(true);
        jumpHeight.func_111112_a(true);
        damageResistance.func_111112_a(true);
        magicShielding.func_111112_a(true);
        nextId = 1;
    }
}

