/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.potioncore.potion;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.tmtravlr.potioncore.PotionCore;
import com.tmtravlr.potioncore.PotionCoreEffects;
import com.tmtravlr.potioncore.PotionCoreHelper;
import com.tmtravlr.potioncore.potion.EntityPotionCorePotion;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockDispenser;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPotionCorePotion
extends Item {
    public static final int NORMAL_META = 0;
    public static final int SPLASH_META = 1;
    public static ItemPotionCorePotion instance;

    public ItemPotionCorePotion() {
        this.func_77655_b("custom_potion");
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.registerDispenserBehaviour();
        this.func_77637_a(PotionCore.tabPotionCore);
    }

    public void registerDispenserBehaviour() {
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new IBehaviorDispenseItem(){
            private final BehaviorDefaultDispenseItem field_150843_b = new BehaviorDefaultDispenseItem();

            public ItemStack func_82482_a(IBlockSource source, final ItemStack stack) {
                return ItemPotionCorePotion.isSplash(stack.func_77960_j()) ? new BehaviorProjectileDispense(){

                    protected IProjectile func_82499_a(World worldIn, IPosition position) {
                        return new EntityPotionCorePotion(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), stack.func_77946_l());
                    }

                    protected float func_82498_a() {
                        return super.func_82498_a() * 0.5f;
                    }

                    protected float func_82500_b() {
                        return super.func_82500_b() * 1.25f;
                    }
                }.func_82482_a(source, stack) : this.field_150843_b.func_82482_a(source, stack);
            }
        });
    }

    public List<PotionEffect> getEffects(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("CustomPotionEffects", 9)) {
            ArrayList list1 = Lists.newArrayList();
            NBTTagList nbttaglist = stack.func_77978_p().func_150295_c("CustomPotionEffects", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                PotionEffect potioneffect = PotionCoreHelper.readPotionEffectFromTag(nbttagcompound);
                if (potioneffect == null) continue;
                list1.add(potioneffect);
            }
            return list1;
        }
        return Lists.newArrayList();
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        List<PotionEffect> list;
        if (!playerIn.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        if (!worldIn.field_72995_K && (list = this.getEffects(stack)) != null) {
            for (PotionEffect potioneffect : list) {
                playerIn.func_70690_d(new PotionEffect(potioneffect));
            }
        }
        playerIn.func_71029_a(StatList.field_75929_E[Item.func_150891_b((Item)this)]);
        if (!playerIn.field_71075_bZ.field_75098_d) {
            if (stack.field_77994_a <= 0) {
                return new ItemStack(Items.field_151069_bo);
            }
            playerIn.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        if (ItemPotionCorePotion.isSplash(itemStackIn.func_77960_j())) {
            ItemStack copy = itemStackIn.func_77946_l();
            copy.field_77994_a = 1;
            if (!playerIn.field_71075_bZ.field_75098_d) {
                --itemStackIn.field_77994_a;
            }
            worldIn.func_72956_a((Entity)playerIn, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!worldIn.field_72995_K) {
                EntityPotionCorePotion potionEntity = new EntityPotionCorePotion(worldIn, (EntityLivingBase)playerIn, copy);
                worldIn.func_72838_d((Entity)potionEntity);
            }
            playerIn.func_71029_a(StatList.field_75929_E[Item.func_150891_b((Item)this)]);
            return itemStackIn;
        }
        playerIn.func_71008_a(itemStackIn, this.func_77626_a(itemStackIn));
        return itemStackIn;
    }

    public static boolean isSplash(int meta) {
        return meta == 1;
    }

    public String func_77653_i(ItemStack stack) {
        List<PotionEffect> list;
        if (!stack.func_77942_o()) {
            return super.func_77653_i(stack);
        }
        String s = "";
        if (ItemPotionCorePotion.isSplash(stack.func_77960_j())) {
            s = StatCollector.func_74838_a((String)"potion.prefix.grenade").trim() + " ";
        }
        if ((list = this.getEffects(stack)) != null && !list.isEmpty()) {
            String s2 = list.get(0).func_76453_d();
            s2 = s2 + ".postfix";
            return s + StatCollector.func_74838_a((String)s2).trim();
        }
        String s1 = PotionHelper.func_77905_c((int)stack.func_77960_j());
        return StatCollector.func_74838_a((String)s1).trim() + " " + ("" + StatCollector.func_74838_a((String)(this.func_77657_g(stack) + ".name"))).trim();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isEffectInstant(ItemStack stack) {
        List<PotionEffect> list = this.getEffects(stack);
        if (list != null && !list.isEmpty()) {
            for (PotionEffect potioneffect : list) {
                if (!Potion.field_76425_a[potioneffect.func_76456_a()].func_76403_b()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List tooltip, boolean advanced) {
        List<PotionEffect> list = this.getEffects(stack);
        HashMultimap multimap = HashMultimap.create();
        if (list != null && !list.isEmpty()) {
            for (PotionEffect potioneffect : list) {
                String s1 = StatCollector.func_74838_a((String)potioneffect.func_76453_d()).trim();
                Potion potion = Potion.field_76425_a[potioneffect.func_76456_a()];
                Map map = potion.func_111186_k();
                if (map != null && map.size() > 0) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), potion.func_111183_a(potioneffect.func_76458_c(), attributemodifier), attributemodifier.func_111169_c());
                        multimap.put((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)attributemodifier1);
                    }
                }
                if (potioneffect.func_76458_c() > 0) {
                    s1 = s1 + " " + StatCollector.func_74838_a((String)("potion.potency." + potioneffect.func_76458_c())).trim();
                }
                if (potioneffect.func_76459_b() > 20) {
                    s1 = s1 + " (" + Potion.func_76389_a((PotionEffect)potioneffect) + ")";
                }
                if (potion.func_76398_f()) {
                    tooltip.add(EnumChatFormatting.RED + s1);
                    continue;
                }
                tooltip.add(EnumChatFormatting.GRAY + s1);
            }
        } else {
            String s = StatCollector.func_74838_a((String)"potion.empty").trim();
            tooltip.add(EnumChatFormatting.GRAY + s);
        }
        if (!multimap.isEmpty()) {
            tooltip.add("");
            tooltip.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"potion.effects.whenDrank"));
            for (Map.Entry entry1 : multimap.entries()) {
                AttributeModifier attributemodifier2 = (AttributeModifier)entry1.getValue();
                double d0 = attributemodifier2.func_111164_d();
                double d1 = attributemodifier2.func_111169_c() != 1 && attributemodifier2.func_111169_c() != 2 ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                if (d0 > 0.0) {
                    tooltip.add(EnumChatFormatting.BLUE + StatCollector.func_74837_a((String)("attribute.modifier.plus." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), StatCollector.func_74838_a((String)("attribute.name." + (String)entry1.getKey()))}));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                tooltip.add(EnumChatFormatting.RED + StatCollector.func_74837_a((String)("attribute.modifier.take." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), StatCollector.func_74838_a((String)("attribute.name." + (String)entry1.getKey()))}));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        List<PotionEffect> list = this.getEffects(stack);
        return list != null && !list.isEmpty();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        if (pass > 0) {
            return 0xFFFFFF;
        }
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("display");
            if (tag.func_74764_b("color")) {
                return tag.func_74762_e("color");
            }
            List<PotionEffect> list = this.getEffects(stack);
            if (list != null && !list.isEmpty()) {
                return PotionCoreHelper.getCustomPotionColor(list);
            }
        }
        return 13836799;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List tabList) {
        for (PotionCoreEffects.PotionData data : PotionCoreEffects.potionMap.values()) {
            if (data == null || data.potion == null) continue;
            data.potion.getCreativeItems(tabList);
        }
    }
}

