/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class ForgeHooksClient {
    static int renderPass = -1;
    static final ThreadLocal<aql> renderLayer = new ThreadLocal<aql>(){

        @Override
        protected aql initialValue() {
            return aql.a;
        }
    };
    private static int skyX;
    private static int skyZ;
    private static boolean skyInit;
    private static int skyRGBMultiplier;
    static int worldRenderPass;
    private static final FloatBuffer matrixBuf;
    private static Map<Pair<alq, Integer>, Class<? extends bcm>> tileItemMap;

    static cug engine() {
        return FMLClientHandler.instance().getClient().O;
    }

    public static String getArmorTexture(wv entity, amj armor, String _default, int slot, String type) {
        String result = armor.b().getArmorTexture(armor, entity, slot, type);
        return result != null ? result : _default;
    }

    public static void orientBedCamera(ard world, dt pos, bec state, wv entity) {
        atr block = state.c();
        if (block != null && block.isBed(world, pos, entity)) {
            GL11.glRotatef((float)(block.getBedDirection(world, pos).b() * 90), (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    public static boolean onDrawBlockHighlight(ckn context, ahd player, bru target, int subID, amj currentItem, float partialTicks) {
        return MinecraftForge.EVENT_BUS.post(new DrawBlockHighlightEvent(context, player, target, subID, currentItem, partialTicks));
    }

    public static void dispatchRenderLast(ckn context, float partialTicks) {
        MinecraftForge.EVENT_BUS.post(new RenderWorldLastEvent(context, partialTicks));
    }

    public static boolean renderFirstPersonHand(ckn context, float partialTicks, int renderPass) {
        return MinecraftForge.EVENT_BUS.post(new RenderHandEvent(context, partialTicks, renderPass));
    }

    public static void onTextureStitchedPre(cua map) {
        MinecraftForge.EVENT_BUS.post(new TextureStitchEvent.Pre(map));
        ModelLoader.White.instance.register(map);
        FluidRegistry.onTextureStitchedPre(map);
    }

    public static void onTextureStitchedPost(cua map) {
        MinecraftForge.EVENT_BUS.post(new TextureStitchEvent.Post(map));
    }

    public static void setRenderPass(int pass) {
        renderPass = pass;
    }

    public static void setRenderLayer(aql layer) {
        renderLayer.set(layer);
    }

    public static ccq getArmorModel(xm entityLiving, amj itemStack, int slotID, ccq _default) {
        ccl modelbase = itemStack.b().getArmorModel(entityLiving, itemStack, slotID);
        return modelbase == null ? _default : modelbase;
    }

    public static String fixDomain(String base, String complex) {
        int idx = complex.indexOf(58);
        if (idx == -1) {
            return base + complex;
        }
        String name = complex.substring(idx + 1, complex.length());
        if (idx > 1) {
            String domain = complex.substring(0, idx);
            return domain + ':' + base + name;
        }
        return base + name;
    }

    public static boolean postMouseEvent() {
        return MinecraftForge.EVENT_BUS.post(new MouseEvent());
    }

    public static float getOffsetFOV(ahd entity, float fov) {
        FOVUpdateEvent fovUpdateEvent = new FOVUpdateEvent(entity, fov);
        MinecraftForge.EVENT_BUS.post(fovUpdateEvent);
        return fovUpdateEvent.newfov;
    }

    public static int getSkyBlendColour(aqu world, dt center) {
        if (center.n() == skyX && center.p() == skyZ && skyInit) {
            return skyRGBMultiplier;
        }
        skyInit = true;
        bto settings = bsu.z().t;
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 0;
        if (settings.i && settings.c >= 0 && settings.c < ranges.length) {
            distance = ranges[settings.c];
        }
        int r = 0;
        int g = 0;
        int b = 0;
        int divider = 0;
        for (int x2 = -distance; x2 <= distance; ++x2) {
            for (int z = -distance; z <= distance; ++z) {
                dt pos = center.a(x2, 0, z);
                arm biome = world.b(pos);
                int colour = biome.a(biome.a(pos));
                r += (colour & 0xFF0000) >> 16;
                g += (colour & 0xFF00) >> 8;
                b += colour & 0xFF;
                ++divider;
            }
        }
        int multiplier = (r / divider & 0xFF) << 16 | (g / divider & 0xFF) << 8 | b / divider & 0xFF;
        skyX = center.n();
        skyZ = center.o();
        skyRGBMultiplier = multiplier;
        return skyRGBMultiplier;
    }

    public static void renderMainMenu(bxq gui, bty font, int width, int height) {
        String line;
        ForgeVersion.Status status = ForgeVersion.getStatus();
        if (status == ForgeVersion.Status.BETA || status == ForgeVersion.Status.BETA_OUTDATED) {
            line = cwc.a((String)"forge.update.beta.1", (Object[])new Object[]{a.m, a.v});
            gui.c(font, line, (width - font.a(line)) / 2, 4 + 0 * (font.a + 1), -1);
            line = cwc.a((String)"forge.update.beta.2", (Object[])new Object[0]);
            gui.c(font, line, (width - font.a(line)) / 2, 4 + 1 * (font.a + 1), -1);
        }
        line = null;
        switch (status) {
            case OUTDATED: 
            case BETA_OUTDATED: {
                line = cwc.a((String)"forge.update.newversion", (Object[])new Object[]{ForgeVersion.getTarget()});
                break;
            }
        }
        if (line != null) {
            gui.c(font, line, width - font.a(line) - 2, height - 2 * (font.a + 1), -1);
        }
    }

    public static cye playSound(cza manager, cye sound) {
        czg accessor = manager.c.a(sound.a());
        PlaySoundEvent e = new PlaySoundEvent(manager, sound, accessor == null ? null : accessor.d());
        MinecraftForge.EVENT_BUS.post(e);
        return e.result;
    }

    public static int getWorldRenderPass() {
        return worldRenderPass;
    }

    public static void drawScreen(bxf screen, int mouseX, int mouseY, float partialTicks) {
        if (!MinecraftForge.EVENT_BUS.post(new GuiScreenEvent.DrawScreenEvent.Pre(screen, mouseX, mouseY, partialTicks))) {
            screen.a(mouseX, mouseY, partialTicks);
        }
        MinecraftForge.EVENT_BUS.post(new GuiScreenEvent.DrawScreenEvent.Post(screen, mouseX, mouseY, partialTicks));
    }

    public static float getFogDensity(cji renderer, wv entity, atr block, float partial, float density) {
        EntityViewRenderEvent.FogDensity event = new EntityViewRenderEvent.FogDensity(renderer, entity, block, partial, density);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return event.density;
        }
        return -1.0f;
    }

    public static void onFogRender(cji renderer, wv entity, atr block, float partial, int mode, float distance) {
        MinecraftForge.EVENT_BUS.post(new EntityViewRenderEvent.RenderFogEvent(renderer, entity, block, partial, mode, distance));
    }

    public static void onModelBake(cxk modelManager, ez modelRegistry, cxh modelBakery) {
        ModelLoader loader = (ModelLoader)modelBakery;
        MinecraftForge.EVENT_BUS.post(new ModelBakeEvent(modelManager, modelRegistry, loader));
        loader.onPostBakeEvent(modelRegistry);
    }

    public static Matrix4f getMatrix(cmv transform) {
        Matrix4f m = new Matrix4f();
        Matrix4f t = new Matrix4f();
        m.setIdentity();
        m.setTranslation(transform.c);
        t.setIdentity();
        t.rotY(transform.b.y);
        m.mul(t);
        t.setIdentity();
        t.rotX(transform.b.x);
        m.mul(t);
        t.setIdentity();
        t.rotZ(transform.b.z);
        m.mul(t);
        t.setIdentity();
        t.m00 = transform.d.x;
        t.m11 = transform.d.y;
        t.m22 = transform.d.z;
        m.mul(t);
        return m;
    }

    public static cxe handleCameraTransforms(cxe model, cmz cameraTransformType) {
        if (model instanceof IPerspectiveAwareModel) {
            Pair<cxe, Matrix4f> pair = ((IPerspectiveAwareModel)model).handlePerspective(cameraTransformType);
            if (pair.getRight() != null) {
                ForgeHooksClient.multiplyCurrentGlMatrix((Matrix4f)pair.getRight());
            }
            return (cxe)pair.getLeft();
        }
        switch (cameraTransformType) {
            case c: {
                cqh.applyVanillaTransform((cmv)model.f().c);
                break;
            }
            case e: {
                cqh.applyVanillaTransform((cmv)model.f().e);
                break;
            }
            case d: {
                cqh.applyVanillaTransform((cmv)model.f().d);
                break;
            }
            case b: {
                cqh.applyVanillaTransform((cmv)model.f().b);
                break;
            }
        }
        return model;
    }

    public static void multiplyCurrentGlMatrix(Matrix4f matrix) {
        matrixBuf.clear();
        float[] t = new float[4];
        for (int i = 0; i < 4; ++i) {
            matrix.getColumn(i, t);
            matrixBuf.put(t);
        }
        matrixBuf.flip();
        GL11.glMultMatrix((FloatBuffer)matrixBuf);
    }

    public static void preDraw(cuw attrType, cuu attr, int stride, ByteBuffer buffer) {
        buffer.position(attr.a());
        switch (attrType) {
            case a: {
                GL11.glVertexPointer((int)attr.d(), (int)attr.b().c(), (int)stride, (ByteBuffer)buffer);
                GL11.glEnableClientState((int)32884);
                break;
            }
            case b: {
                if (attr.d() != 3) {
                    throw new IllegalArgumentException("Normal attribute should have the size 3: " + attr);
                }
                GL11.glNormalPointer((int)attr.b().c(), (int)stride, (ByteBuffer)buffer);
                GL11.glEnableClientState((int)32885);
                break;
            }
            case c: {
                GL11.glColorPointer((int)attr.d(), (int)attr.b().c(), (int)stride, (ByteBuffer)buffer);
                GL11.glEnableClientState((int)32886);
                break;
            }
            case d: {
                dax.l((int)(dax.p + attr.e()));
                GL11.glTexCoordPointer((int)attr.d(), (int)attr.b().c(), (int)stride, (ByteBuffer)buffer);
                GL11.glEnableClientState((int)32888);
                dax.l((int)dax.p);
                break;
            }
            case g: {
                break;
            }
            case GENERIC: {
                GL20.glEnableVertexAttribArray((int)attr.e());
                GL20.glVertexAttribPointer((int)attr.e(), (int)attr.d(), (int)attr.b().c(), (boolean)false, (int)stride, (ByteBuffer)buffer);
            }
            default: {
                FMLLog.severe("Unimplemented vanilla attribute upload: %s", attrType.a());
            }
        }
    }

    public static void postDraw(cuw attrType, cuu attr, int stride, ByteBuffer buffer) {
        switch (attrType) {
            case a: {
                GL11.glDisableClientState((int)32884);
                break;
            }
            case b: {
                GL11.glDisableClientState((int)32885);
                break;
            }
            case c: {
                GL11.glDisableClientState((int)32886);
                cjm.G();
                break;
            }
            case d: {
                dax.l((int)(dax.p + attr.e()));
                GL11.glDisableClientState((int)32888);
                dax.l((int)dax.p);
                break;
            }
            case g: {
                break;
            }
            case GENERIC: {
                GL20.glDisableVertexAttribArray((int)attr.e());
            }
            default: {
                FMLLog.severe("Unimplemented vanilla attribute upload: %s", attrType.a());
            }
        }
    }

    public static void transform(Vector3d vec, Matrix4f m) {
        Vector4f tmp = new Vector4f((float)vec.x, (float)vec.y, (float)vec.z, 1.0f);
        m.transform((Tuple4f)tmp);
        if ((double)Math.abs(tmp.w - 1.0f) > 1.0E-5) {
            tmp.scale(1.0f / tmp.w);
        }
        vec.set((double)tmp.x, (double)tmp.y, (double)tmp.z);
    }

    public static Matrix4f getMatrix(cxf modelRotation) {
        Matrix4f ret = new Matrix4f(modelRotation.a());
        Matrix4f tmp = new Matrix4f();
        tmp.setIdentity();
        tmp.m23 = 0.5f;
        tmp.m13 = 0.5f;
        tmp.m03 = 0.5f;
        ret.mul(tmp, ret);
        tmp.invert();
        ret.mul(tmp);
        return ret;
    }

    public static void putQuadColor(civ renderer, clt quad, int color) {
        float cr = color & 0xFF;
        float cg = color >>> 8 & 0xFF;
        float cb = color >>> 16 & 0xFF;
        float ca = color >>> 24 & 0xFF;
        for (int i = 0; i < 4; ++i) {
            int vc = quad.a()[3 + 7 * i];
            float vcr = vc & 0xFF;
            float vcg = vc >>> 8 & 0xFF;
            float vcb = vc >>> 16 & 0xFF;
            float vca = vc >>> 24 & 0xFF;
            int ncr = Math.min(255, (int)(cr * vcr / 255.0f));
            int ncg = Math.min(255, (int)(cg * vcg / 255.0f));
            int ncb = Math.min(255, (int)(cb * vcb / 255.0f));
            int nca = Math.min(255, (int)(ca * vca / 255.0f));
            renderer.a(renderer.f(4 - i), ncr, ncg, ncb, nca);
        }
    }

    public static void renderTileItem(alq item, int metadata) {
        cnp r;
        Class<? extends bcm> tileClass = tileItemMap.get(Pair.of((Object)item, (Object)metadata));
        if (tileClass != null && (r = cno.a.a(tileClass)) != null) {
            r.a(null, 0.0, 0.0, 0.0, 0.0f, -1);
        }
    }

    @Deprecated
    public static void registerTESRItemStack(alq item, int metadata, Class<? extends bcm> TileClass) {
        tileItemMap.put((Pair<alq, Integer>)Pair.of((Object)item, (Object)metadata), TileClass);
    }

    public static void fillNormal(int[] faceData, ej facing) {
        Vector3f v1 = new Vector3f((float)faceData[21], (float)faceData[22], (float)faceData[23]);
        Vector3f t = new Vector3f((float)faceData[7], (float)faceData[8], (float)faceData[9]);
        Vector3f v2 = new Vector3f((float)faceData[14], (float)faceData[15], (float)faceData[16]);
        v1.sub((Tuple3f)t);
        t.set((float)faceData[0], (float)faceData[1], (float)faceData[2]);
        v2.sub((Tuple3f)t);
        v1.cross(v2, v1);
        v1.normalize();
        int x2 = (byte)(v1.x * 127.0f) & 0xFF;
        int y = (byte)(v1.y * 127.0f) & 0xFF;
        int z = (byte)(v1.z * 127.0f) & 0xFF;
        for (int i = 0; i < 4; ++i) {
            faceData[i * 7 + 6] = x2 | y << 8 | z << 16;
        }
    }

    static {
        matrixBuf = BufferUtils.createFloatBuffer((int)16);
        tileItemMap = Maps.newHashMap();
    }
}

