/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModelPart;
import net.minecraftforge.client.model.IPerspectiveState;
import net.minecraftforge.client.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public interface IPerspectiveAwareModel
extends cxe {
    public Pair<cxe, Matrix4f> handlePerspective(cmz var1);

    public static class MapWrapper
    implements IFlexibleBakedModel,
    IPerspectiveAwareModel {
        private final IFlexibleBakedModel parent;
        private final ImmutableMap<cmz, TRSRTransformation> transforms;

        public MapWrapper(IFlexibleBakedModel parent, ImmutableMap<cmz, TRSRTransformation> transforms) {
            this.parent = parent;
            this.transforms = transforms;
        }

        public MapWrapper(IFlexibleBakedModel parent, IPerspectiveState state, IModelPart part) {
            this(parent, MapWrapper.getTransforms(state, part));
        }

        public static ImmutableMap<cmz, TRSRTransformation> getTransforms(IPerspectiveState state, IModelPart part) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (cmz type : cmz.values()) {
                builder.put((Object)type, (Object)state.forPerspective(type).apply(part));
            }
            return builder.build();
        }

        public boolean b() {
            return this.parent.b();
        }

        public boolean c() {
            return this.parent.c();
        }

        public boolean d() {
            return this.parent.d();
        }

        public cue e() {
            return this.parent.e();
        }

        public cmx f() {
            return this.parent.f();
        }

        @Override
        public List<clt> a(ej side) {
            return this.parent.a(side);
        }

        @Override
        public List<clt> a() {
            return this.parent.a();
        }

        @Override
        public cus getFormat() {
            return this.parent.getFormat();
        }

        @Override
        public Pair<cxe, Matrix4f> handlePerspective(cmz cameraTransformType) {
            TRSRTransformation tr = (TRSRTransformation)this.transforms.get((Object)cameraTransformType);
            Matrix4f mat = null;
            if (tr != null && tr != TRSRTransformation.identity()) {
                mat = TRSRTransformation.blockCornerToCenter(tr).getMatrix();
            }
            return Pair.of((Object)this, mat);
        }
    }
}

