/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.brewing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.brewing.BrewingOreRecipe;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;

public class BrewingRecipeRegistry {
    private static List<IBrewingRecipe> recipes = new ArrayList<IBrewingRecipe>();

    public static boolean addRecipe(amj input, amj ingredient, amj output) {
        return BrewingRecipeRegistry.addRecipe(new BrewingRecipe(input, ingredient, output));
    }

    public static boolean addRecipe(amj input, String ingredient, amj output) {
        return BrewingRecipeRegistry.addRecipe(new BrewingOreRecipe(input, ingredient, output));
    }

    public static boolean addRecipe(IBrewingRecipe recipe) {
        return recipes.add(recipe);
    }

    public static amj getOutput(amj input, amj ingredient) {
        if (input == null || input.c() != 1 || input.b != 1) {
            return null;
        }
        if (ingredient == null || ingredient.b <= 0) {
            return null;
        }
        for (IBrewingRecipe recipe : recipes) {
            amj output = recipe.getOutput(input, ingredient);
            if (output == null) continue;
            return output;
        }
        return null;
    }

    public static boolean hasOuput(amj input, amj ingredient) {
        return BrewingRecipeRegistry.getOutput(input, ingredient) != null;
    }

    public static boolean canBrew(amj[] inputs, amj ingredient, int[] inputIndexes) {
        if (ingredient == null || ingredient.b <= 0) {
            return false;
        }
        for (int i : inputIndexes) {
            if (!BrewingRecipeRegistry.hasOuput(inputs[i], ingredient)) continue;
            return true;
        }
        return false;
    }

    public static void brewPotions(amj[] inputs, amj ingredient, int[] inputIndexes) {
        for (int i : inputIndexes) {
            amj output = BrewingRecipeRegistry.getOutput(inputs[i], ingredient);
            if (output == null) continue;
            inputs[i] = output;
        }
    }

    public static boolean isValidIngredient(amj stack) {
        if (stack == null || stack.b <= 0) {
            return false;
        }
        for (IBrewingRecipe recipe : recipes) {
            if (!recipe.isIngredient(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidInput(amj stack) {
        if (stack == null || stack.c() != 1 || stack.b != 1) {
            return false;
        }
        for (IBrewingRecipe recipe : recipes) {
            if (!recipe.isInput(stack)) continue;
            return true;
        }
        return false;
    }

    public static List<IBrewingRecipe> getRecipes() {
        return Collections.unmodifiableList(recipes);
    }

    static {
        BrewingRecipeRegistry.addRecipe(new VanillaBrewingRecipe());
    }
}

