/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus;

import com.tmtravlr.lootplusplus.LootPPHelper;
import com.tmtravlr.lootplusplus.LootPPItems;
import com.tmtravlr.lootplusplus.LootPPNotifier;
import com.tmtravlr.lootplusplus.LootPPTickHandlerServer;
import com.tmtravlr.lootplusplus.LootPlusPlusMod;
import com.tmtravlr.lootplusplus.additions.BlockAddedCrops;
import com.tmtravlr.lootplusplus.additions.ItemAddedBow;
import com.tmtravlr.lootplusplus.additions.ItemAddedGun;
import com.tmtravlr.lootplusplus.additions.ItemAddedThrowable;
import com.tmtravlr.lootplusplus.commands.CommandSenderGeneric;
import com.tmtravlr.lootplusplus.effects.GiveEffects;
import com.tmtravlr.lootplusplus.network.PacketHelper;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class LootPPEventHandler {
    private Random rand = new Random();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDrops(LivingDropsEvent event) {
        if (!event.entityLiving.field_70170_p.field_72995_K) {
            if ((!LootPPHelper.creepersDropRecords || LootPPHelper.creepersDropAllRecords) && event.entityLiving instanceof EntityCreeper && event.source.func_76346_g() instanceof EntitySkeleton) {
                event.entityLiving.captureDrops = true;
                LootPPTickHandlerServer.creepersToDropRecordsFrom.add((EntityCreeper)event.entityLiving);
            }
            String entityName = (String)EntityList.field_75626_c.get(event.entity.getClass());
            if (event.entity instanceof EntityPlayer) {
                entityName = "Player";
            }
            NBTTagCompound entityTag = new NBTTagCompound();
            event.entity.func_70109_d(entityTag);
            if (entityName != null && !entityName.equals("")) {
                entityTag.func_74778_a("id", entityName);
            }
            for (NBTTagCompound entryTag : LootPPHelper.entityDropRemovals.keySet()) {
                Set<ItemStack> itemsToRemove;
                if (entryTag.func_74764_b("id") && !entryTag.func_74779_i("id").equals(entityName) || !LootPPHelper.hasAllTags((NBTBase)entryTag, (NBTBase)entityTag, true) || (itemsToRemove = LootPPHelper.entityDropRemovals.get(entryTag)) == null || itemsToRemove.isEmpty()) continue;
                boolean removeAll = false;
                Iterator it = event.drops.iterator();
                block1: while (it.hasNext() && !removeAll) {
                    EntityItem current = (EntityItem)it.next();
                    for (ItemStack stack : itemsToRemove) {
                        if (stack.func_77973_b() == LootPPItems.generalDummyIcon) {
                            removeAll = true;
                            continue block1;
                        }
                        if (current.func_92059_d() == null || stack.func_77973_b() != current.func_92059_d().func_77973_b() || stack.func_77952_i() != Short.MAX_VALUE && stack.func_77952_i() != current.func_92059_d().func_77952_i() || stack.func_77978_p() != null && !stack.func_77978_p().func_82582_d() && !stack.func_77978_p().equals((Object)current.func_92059_d().func_77978_p())) continue;
                        if (LootPlusPlusMod.debug) {
                            System.out.println("[Loot++] Removed Drop '" + Item.field_150901_e.func_177774_c((Object)current.func_92059_d().func_77973_b()) + "' from entity " + EntityList.func_75621_b((Entity)event.entity));
                        }
                        it.remove();
                    }
                }
                if (!removeAll) continue;
                if (LootPlusPlusMod.debug) {
                    System.out.println("[Loot++] Removed all drops from entity " + EntityList.func_75621_b((Entity)event.entity));
                }
                event.drops.clear();
            }
            if (event.entity.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                for (NBTTagCompound entryTag : LootPPHelper.entityDropAdditions.keySet()) {
                    if (entryTag.func_74764_b("id") && !entryTag.func_74779_i("id").equals(entityName) || !LootPPHelper.hasAllTags((NBTBase)entryTag, (NBTBase)entityTag, true)) continue;
                    for (LootPPHelper.EntityDropInfo drop : LootPPHelper.entityDropAdditions.get(entryTag)) {
                        LootPPHelper.dropEntityDropAdditions(event, drop, this.rand);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockDrop(BlockEvent.HarvestDropsEvent event) {
        if (!event.world.field_72995_K && event.state != null) {
            LootPPHelper.BlockMeta blockMeta = new LootPPHelper.BlockMeta(event.state);
            LootPPHelper.BlockMeta blockMetaWild = new LootPPHelper.BlockMeta(event.state.func_177230_c(), Short.MAX_VALUE);
            if (LootPPHelper.blockDropRemovals.containsKey(blockMeta) || LootPPHelper.blockDropRemovals.containsKey(blockMetaWild)) {
                boolean removeAll = false;
                Iterator<Object> it = event.drops.iterator();
                block0: while (it.hasNext() && !removeAll) {
                    ItemStack current = (ItemStack)it.next();
                    Set<ItemStack> stackSet = LootPPHelper.blockDropRemovals.get(blockMeta);
                    if (stackSet != null && !stackSet.isEmpty()) {
                        for (ItemStack stack : stackSet) {
                            if (stack.func_77973_b() == LootPPItems.generalDummyIcon) {
                                removeAll = true;
                                break;
                            }
                            LootPPHelper.removeBlockDrop(event, it, stack, current);
                        }
                    }
                    if ((stackSet = LootPPHelper.blockDropRemovals.get(blockMetaWild)) == null || stackSet.isEmpty()) continue;
                    for (ItemStack stack : LootPPHelper.blockDropRemovals.get(blockMetaWild)) {
                        if (stack.func_77973_b() == LootPPItems.generalDummyIcon) {
                            removeAll = true;
                            continue block0;
                        }
                        LootPPHelper.removeBlockDrop(event, it, stack, current);
                    }
                }
                if (removeAll) {
                    if (LootPlusPlusMod.debug) {
                        System.out.println("[Loot++] Removed all drops from block " + event.state);
                    }
                    event.drops.clear();
                }
            }
            if (event.world.func_82736_K().func_82766_b("doTileDrops") && (LootPPHelper.blockDropAdditions.containsKey(blockMeta) || LootPPHelper.blockDropAdditions.containsKey(blockMetaWild))) {
                ArrayList<LootPPHelper.BlockDropInfo> additionsList = LootPPHelper.blockDropAdditions.get(blockMeta);
                if (additionsList != null && !additionsList.isEmpty()) {
                    for (LootPPHelper.BlockDropInfo drop : LootPPHelper.blockDropAdditions.get(blockMeta)) {
                        LootPPHelper.dropBlockDropAdditions(event, drop, this.rand);
                    }
                }
                if ((additionsList = LootPPHelper.blockDropAdditions.get(blockMetaWild)) != null && !additionsList.isEmpty()) {
                    for (LootPPHelper.BlockDropInfo drop : LootPPHelper.blockDropAdditions.get(blockMetaWild)) {
                        LootPPHelper.dropBlockDropAdditions(event, drop, this.rand);
                    }
                }
            }
            if (event.state.func_177230_c() instanceof BlockAddedCrops && BlockAddedCrops.rightClickHarvesting) {
                Iterator it = event.drops.iterator();
                while (it.hasNext()) {
                    ItemStack drop = (ItemStack)it.next();
                    if (drop == null || drop.func_77973_b() == null || drop.func_77973_b() != ((BlockAddedCrops)event.state.func_177230_c()).func_149866_i()) continue;
                    if (LootPlusPlusMod.debug) {
                        System.out.println("[Loot++] Removed extra seed while right click harvesting block " + Block.field_149771_c.func_177774_c((Object)event.state.func_177230_c()));
                    }
                    if (drop.field_77994_a > 1) {
                        --drop.field_77994_a;
                        break;
                    }
                    it.remove();
                    break;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingHitWithArrow(LivingAttackEvent event) {
        if (event.source.field_76373_n.equals("arrow") && event.entityLiving != null && event.entity == event.source.func_76346_g() && event.entityLiving.func_70694_bm() != null && event.entityLiving.func_70694_bm().func_77973_b() instanceof ItemBow && event.source instanceof EntityDamageSource && ((EntityDamageSource)event.source).func_76364_f().field_70173_aa < 100) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onDigBlock(PlayerEvent.BreakSpeed event) {
        if (!(event.entityLiving.field_70170_p.field_72995_K || GiveEffects.onItemBlockDigMap.isEmpty() && GiveEffects.onBlockBlockDigMap.isEmpty())) {
            GiveEffects.giveDigEffects(event.entityLiving, event.state);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!(event.getPlayer().field_70170_p.field_72995_K || GiveEffects.onItemBlockBrokeMap.isEmpty() && GiveEffects.onBlockBlockBrokeMap.isEmpty())) {
            GiveEffects.giveBreakEffects((EntityLivingBase)event.getPlayer(), event.state);
        }
    }

    @SubscribeEvent
    public void onItemRightClick(PlayerInteractEvent event) {
        if (!(event.entityPlayer.field_70170_p.field_72995_K || event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.action != PlayerInteractEvent.Action.RIGHT_CLICK_AIR || event.entityPlayer.func_70694_bm() == null || GiveEffects.onRightClickMap.isEmpty())) {
            GiveEffects.giveRightClickEffects((EntityLivingBase)event.entityPlayer);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        NBTTagCompound tag;
        NBTTagList commandList;
        EntityLivingBase entityHitting;
        if (!(event.entityLiving.field_70170_p.field_72995_K || !(event.source.func_76346_g() instanceof EntityLivingBase) || (entityHitting = (EntityLivingBase)event.source.func_76346_g()).func_70694_bm() == null || GiveEffects.entityOnHitEntityMap.isEmpty() && GiveEffects.youOnHitEntityMap.isEmpty())) {
            GiveEffects.giveEntityHitEffects(entityHitting, event.entityLiving);
        }
        if (event.entity.getEntityData().func_150297_b("LootPPCommands", 10) && (commandList = (tag = event.entity.getEntityData().func_74775_l("LootPPCommands")).func_150295_c("CommandListOnHurt", 8)) != null && !commandList.func_82582_d()) {
            for (int i = 0; i < commandList.func_74745_c(); ++i) {
                if (LootPlusPlusMod.debug) {
                    System.out.println("[Loot++] Running command on hurt " + commandList.func_150307_f(i));
                }
                MinecraftServer.func_71276_C().func_71187_D().func_71556_a((ICommandSender)new CommandSenderGeneric(event.entity.func_70005_c_(), event.entity.field_70170_p, new Vec3(event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v)), commandList.func_150307_f(i));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRangedUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity.field_70173_aa % 11 == 0 && event.entityLiving instanceof IRangedAttackMob && event.entityLiving instanceof EntityLiving && !event.entityLiving.field_70128_L) {
            EntityLiving ranged = (EntityLiving)event.entityLiving;
            if (!event.entityLiving.field_70128_L && ranged.func_70694_bm() != null && ranged.func_70694_bm().func_77973_b() != null && (ranged.func_70694_bm().func_77973_b() instanceof ItemAddedBow || ranged.func_70694_bm().func_77973_b() instanceof ItemAddedGun || ranged.func_70694_bm().func_77973_b() instanceof ItemAddedThrowable)) {
                if (!LootPPHelper.rangedAIs.containsKey(ranged) && !LootPPHelper.delayedAIs.contains(ranged)) {
                    LootPPHelper.delayedAIs.add(ranged);
                }
            } else if (LootPPHelper.rangedAIs.containsKey(ranged)) {
                LootPPHelper.removeAddedBowAIFromMob(ranged);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        NBTTagCompound tag;
        if (!(event.entityLiving.field_70170_p.field_72995_K || GiveEffects.onHeldMap.isEmpty() && GiveEffects.onPassiveMap.isEmpty() && GiveEffects.onWornMap.isEmpty())) {
            GiveEffects.givePassiveEffects(event.entityLiving);
        }
        if (event.entity.getEntityData().func_150297_b("LootPPCommands", 10) && !(tag = event.entity.getEntityData().func_74775_l("LootPPCommands")).func_74767_n("Done") && tag.func_150297_b("CommandList", 9)) {
            NBTTagList commandList = tag.func_150295_c("CommandList", 8);
            int[] delays = tag.func_74759_k("Delays");
            int time = tag.func_74762_e("Time");
            boolean repeat = tag.func_74767_n("Repeat");
            boolean done = true;
            if (commandList != null && !commandList.func_82582_d()) {
                for (int i = 0; i < commandList.func_74745_c(); ++i) {
                    int delay = 0;
                    if (delays == null) {
                        delays = new int[]{};
                    }
                    if (i < delays.length && (delay = delays[i]) > time) {
                        done = false;
                    }
                    if (delay != time) continue;
                    if (LootPlusPlusMod.debug) {
                        System.out.println("[Loot++] Running command " + commandList.func_150307_f(i));
                    }
                    MinecraftServer.func_71276_C().func_71187_D().func_71556_a((ICommandSender)new CommandSenderGeneric(event.entity.func_70005_c_(), event.entity.field_70170_p, new Vec3(event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v)), commandList.func_150307_f(i));
                }
                if (done) {
                    tag.func_74768_a("Time", 0);
                } else {
                    tag.func_74768_a("Time", time + 1);
                }
            }
            if (done && !repeat) {
                if (LootPlusPlusMod.debug) {
                    System.out.println("[Loot++] Done running commands!");
                }
                tag.func_74757_a("Done", true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        NBTTagCompound tag;
        NBTTagList commandList;
        if (event.entity.getEntityData().func_150297_b("LootPPCommands", 10) && (commandList = (tag = event.entity.getEntityData().func_74775_l("LootPPCommands")).func_150295_c("CommandListOnDeath", 8)) != null && !commandList.func_82582_d()) {
            for (int i = 0; i < commandList.func_74745_c(); ++i) {
                if (LootPlusPlusMod.debug) {
                    System.out.println("[Loot++] Running command on death " + commandList.func_150307_f(i));
                }
                MinecraftServer.func_71276_C().func_71187_D().func_71556_a((ICommandSender)new CommandSenderGeneric(event.entity.func_70005_c_(), event.entity.field_70170_p, new Vec3(event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v)), commandList.func_150307_f(i));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!event.world.field_72995_K && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer != null && event.entityPlayer.func_70694_bm() != null && BlockAddedCrops.itemToCrop.keySet().contains(event.entityPlayer.func_70694_bm())) {
            BlockAddedCrops cropBlock = BlockAddedCrops.itemToCrop.get(event.entityPlayer.func_70694_bm());
            if (cropBlock == null || event.face != EnumFacing.UP || !event.entityPlayer.func_175151_a(event.pos.func_177972_a(event.face), event.face, event.entityPlayer.func_70694_bm())) {
                return;
            }
            if (event.world.func_180495_p(event.pos).func_177230_c().canSustainPlant((IBlockAccess)event.world, event.pos, EnumFacing.UP, (IPlantable)cropBlock) && event.world.func_175623_d(event.pos.func_177984_a())) {
                event.world.func_175656_a(event.pos.func_177984_a(), cropBlock.func_176223_P());
                if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
                    --event.entityPlayer.func_70694_bm().field_77994_a;
                }
            }
        }
    }

    @SubscribeEvent
    public void onCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (Block.func_149634_a((Item)event.crafting.func_77973_b()) instanceof BlockWorkbench) {
            event.player.func_71064_a((StatBase)AchievementList.field_76017_h, 1);
        }
        if (Block.func_149634_a((Item)event.crafting.func_77973_b()) instanceof BlockFurnace) {
            event.player.func_71064_a((StatBase)AchievementList.field_76015_j, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            EntityPlayerMP player = LootPPHelper.getPlayerByUsername(event.player.func_70005_c_());
            for (String string : LootPPHelper.chestTypes) {
                PacketHelper.addChestType(string, player);
            }
        }
        if (!LootPPNotifier.notificationList.isEmpty()) {
            File problemFile = new File(LootPPHelper.configFolder, "Problems.txt");
            PrintStream writeStream = null;
            try {
                writeStream = new PrintStream(problemFile);
                event.player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "[Loot++] Encountered problems loading the config files! =("));
                writeStream.println("The following problems were encountered while loading the config files:");
                for (String notification : LootPPNotifier.notificationList) {
                    event.player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "[Loot++]" + EnumChatFormatting.RESET + " - " + notification));
                    event.player.func_145747_a((IChatComponent)new ChatComponentText(""));
                    writeStream.println(notification);
                    writeStream.println();
                }
                event.player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "[Loot++] The problem messages were saved to file 'config/Loot++/Problems.txt'."));
            }
            catch (IOException iOException) {
                System.err.format("IOException: %s%n", iOException);
            }
            finally {
                if (writeStream != null) {
                    writeStream.close();
                }
            }
            LootPPNotifier.notificationList.clear();
        }
    }
}

